/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.query.plan.HeuristicPlanner;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.ConstraintsMap;
import com.apple.foundationdb.record.query.plan.cascades.Correlated;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.ExpressionPartition;
import com.apple.foundationdb.record.query.plan.cascades.ExpressionPartitions;
import com.apple.foundationdb.record.query.plan.cascades.ExpressionPropertiesMap;
import com.apple.foundationdb.record.query.plan.cascades.ExpressionProperty;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentitySet;
import com.apple.foundationdb.record.query.plan.cascades.MatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.Memoizer;
import com.apple.foundationdb.record.query.plan.cascades.PartialMatch;
import com.apple.foundationdb.record.query.plan.cascades.PlanPartition;
import com.apple.foundationdb.record.query.plan.cascades.PlanPartitions;
import com.apple.foundationdb.record.query.plan.cascades.PlanPropertiesMap;
import com.apple.foundationdb.record.query.plan.cascades.PlannerConstraint;
import com.apple.foundationdb.record.query.plan.cascades.PlannerStage;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifiers;
import com.apple.foundationdb.record.query.plan.cascades.References;
import com.apple.foundationdb.record.query.plan.cascades.SimpleExpressionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraphVisitor;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpressionWithChildren;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.typing.Typed;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class Reference
implements Correlated<Reference>,
Typed {
    @Nonnull
    private PlannerStage plannerStage;
    @Nonnull
    private final Members exploratoryMembers;
    @Nonnull
    private final Members finalMembers;
    @Nonnull
    private final SetMultimap<MatchCandidate, PartialMatch> partialMatchMap;
    @Nonnull
    private final ConstraintsMap constraintsMap;
    @Nonnull
    private ExpressionPropertiesMap<? extends RelationalExpression> propertiesMap;
    @Nonnull
    private final Collection<RelationalExpression> allMembersView;

    private Reference() {
        this(PlannerStage.INITIAL, new LinkedIdentitySet<RelationalExpression>(), new LinkedIdentitySet<RelationalExpression>());
    }

    private Reference(@Nonnull PlannerStage plannerStage, @Nonnull LinkedIdentitySet<RelationalExpression> exploratoryExpressions, @Nonnull LinkedIdentitySet<RelationalExpression> finalExpressions) {
        Debugger.sanityCheck(() -> Verify.verify(plannerStage == PlannerStage.PLANNED || exploratoryExpressions.stream().noneMatch(member -> member instanceof RecordQueryPlan) && finalExpressions.stream().noneMatch(member -> member instanceof RecordQueryPlan)));
        this.plannerStage = plannerStage;
        this.exploratoryMembers = new Members(exploratoryExpressions);
        this.finalMembers = new Members(finalExpressions);
        this.partialMatchMap = LinkedHashMultimap.create();
        this.constraintsMap = new ConstraintsMap();
        this.propertiesMap = plannerStage.createPropertiesMap();
        finalExpressions.forEach(finalExpression -> this.propertiesMap.add((RelationalExpression)finalExpression));
        this.allMembersView = this.exploratoryMembers.concatExpressions(this.finalMembers);
        Debugger.registerReference(this);
    }

    @Nonnull
    public PlannerStage getPlannerStage() {
        return this.plannerStage;
    }

    @Nonnull
    public ConstraintsMap getConstraintsMap() {
        return this.constraintsMap;
    }

    @Nonnull
    public ExpressionPropertiesMap<? extends RelationalExpression> getPropertiesMap() {
        return this.propertiesMap;
    }

    public void advancePlannerStage(@Nonnull PlannerStage newStage) {
        Verify.verify(this.plannerStage.directlyPrecedes(newStage));
        Verify.verify(this.finalMembers.size() == 1);
        this.advancePlannerStageUnchecked(newStage);
    }

    @VisibleForTesting
    void advancePlannerStageUnchecked(@Nonnull PlannerStage newStage) {
        this.plannerStage = newStage;
        this.constraintsMap.advancePlannerStage();
        this.propertiesMap = newStage.createPropertiesMap();
        this.exploratoryMembers.clear();
        this.exploratoryMembers.addAll(this.finalMembers);
        this.finalMembers.clear();
    }

    @Nonnull
    public RecordQueryPlan getOnlyElementAsPlan() {
        Verify.verify(this.exploratoryMembers.isEmpty(), "exploratory members must be empty", new Object[0]);
        return this.finalMembers.getOnlyElementAsPlan();
    }

    public int getTotalMembersSize() {
        return this.exploratoryMembers.size() + this.finalMembers.size();
    }

    @Nonnull
    public RelationalExpression get() {
        int totalMembersSize = this.getTotalMembersSize();
        if (totalMembersSize != 1) {
            throw new UngettableReferenceException("tried to dereference reference with " + totalMembersSize + " members");
        }
        return this.exploratoryMembers.isEmpty() ? this.finalMembers.getOnlyElement() : this.exploratoryMembers.getOnlyElement();
    }

    @HeuristicPlanner
    public synchronized void replace(@Nonnull RecordQueryPlan plan) {
        Debugger.verifyHeuristicPlanner();
        this.pruneWithUnchecked(plan);
    }

    public void pruneWith(@Nonnull RelationalExpression expression) {
        Verify.verify(this.isFinal(expression));
        this.pruneWithUnchecked(expression);
    }

    private void pruneWithUnchecked(@Nonnull RelationalExpression expression) {
        Map<ExpressionProperty<?>, ?> properties = this.propertiesMap.getCurrentProperties(expression);
        this.clearFinalExpressions();
        this.insertUnchecked(expression, true, properties);
    }

    public boolean insertExploratoryExpression(@Nonnull RelationalExpression newValue) {
        return this.insert(newValue, false, null);
    }

    public boolean insertFinalExpression(@Nonnull RelationalExpression newValue) {
        return this.insert(newValue, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insert(@Nonnull RelationalExpression newExpression, boolean isFinal, @Nullable Map<ExpressionProperty<?>, ?> precomputedPropertiesMap) {
        Debugger.withDebugger(debugger -> debugger.onEvent(Debugger.InsertIntoMemoEvent.begin()));
        try {
            boolean containsInMemo = this.containsInMemo(newExpression, isFinal);
            Debugger.withDebugger(debugger -> {
                if (containsInMemo) {
                    debugger.onEvent(Debugger.InsertIntoMemoEvent.reusedExpWithReferences(newExpression, ImmutableList.of(this)));
                } else {
                    debugger.onEvent(Debugger.InsertIntoMemoEvent.newExp(newExpression));
                }
            });
            if (!containsInMemo) {
                this.insertUnchecked(newExpression, isFinal, precomputedPropertiesMap);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            Debugger.withDebugger(debugger -> debugger.onEvent(Debugger.InsertIntoMemoEvent.end()));
        }
    }

    private void insertUnchecked(@Nonnull RelationalExpression newExpression, boolean isFinal, @Nullable Map<ExpressionProperty<?>, ?> precomputedPropertiesMap) {
        Debugger.registerExpression(newExpression);
        Debugger.sanityCheck(() -> Verify.verify(this.getTotalMembersSize() == 0 || this.getResultType().equals(newExpression.getResultType())));
        Debugger.sanityCheck(() -> Verify.verify(this.getTotalMembersSize() == 0 || this.getCorrelatedTo().containsAll(newExpression.getCorrelatedTo())));
        if (isFinal) {
            this.finalMembers.add(newExpression);
            if (precomputedPropertiesMap != null) {
                this.propertiesMap.add(newExpression, precomputedPropertiesMap);
            } else {
                this.propertiesMap.add(newExpression);
            }
        } else {
            this.exploratoryMembers.add(newExpression);
        }
    }

    public boolean containsExactly(@Nonnull RelationalExpression expression) {
        return this.exploratoryMembers.containsExactly(expression) || this.finalMembers.containsExactly(expression);
    }

    public boolean isExploratory(@Nonnull RelationalExpression expression) {
        if (this.exploratoryMembers.containsExactly(expression)) {
            return true;
        }
        if (this.finalMembers.containsExactly(expression)) {
            return false;
        }
        throw new RecordCoreException("expression has to be a member of this reference", new Object[0]);
    }

    public boolean isFinal(@Nonnull RelationalExpression expression) {
        if (this.finalMembers.containsExactly(expression)) {
            return true;
        }
        if (this.exploratoryMembers.containsExactly(expression)) {
            return false;
        }
        throw new RecordCoreException("expression has to be a member of this reference", new Object[0]);
    }

    @VisibleForTesting
    boolean containsAllInMemo(@Nonnull Reference otherRef, @Nonnull AliasMap equivalenceMap) {
        if (this == otherRef) {
            return true;
        }
        return this.containsAllInMemo(otherRef.getExploratoryExpressions(), equivalenceMap, false) && this.containsAllInMemo(otherRef.getFinalExpressions(), equivalenceMap, true);
    }

    @API(value=API.Status.INTERNAL)
    boolean containsAllInMemo(@Nonnull Collection<? extends RelationalExpression> expressions, @Nonnull AliasMap equivalenceMap, boolean isFinal) {
        Members members = isFinal ? this.finalMembers : this.exploratoryMembers;
        for (RelationalExpression relationalExpression : expressions) {
            if (members.containsInMemo(relationalExpression, equivalenceMap)) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    boolean containsInMemo(@Nonnull RelationalExpression expression, boolean isFinal) {
        return isFinal ? this.finalMembers.containsInMemo(expression, AliasMap.emptyMap()) : this.exploratoryMembers.containsInMemo(expression, AliasMap.emptyMap());
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> getCorrelatedTo() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (RelationalExpression member : this.getAllMemberExpressions()) {
            builder.addAll(member.getCorrelatedTo());
        }
        return builder.build();
    }

    @Override
    @Nonnull
    public Reference rebase(@Nonnull AliasMap translationMap) {
        throw new UnsupportedOperationException("rebase unsupported for reference");
    }

    @Nonnull
    public Reference translateGraph(@Nonnull Memoizer memoizer, @Nonnull TranslationMap translationMap, boolean shouldSimplifyValues) {
        List<? extends Reference> translatedRefs = References.translateCorrelationsInGraphs(ImmutableList.of(this), memoizer, translationMap, shouldSimplifyValues);
        return Iterables.getOnlyElement(translatedRefs);
    }

    @Override
    @Nonnull
    public Type getResultType() {
        return this.getAllMemberExpressions().stream().map(RelationalExpression::getResultType).reduce((left, right) -> {
            Verify.verify(left.equals(right));
            return left;
        }).orElseThrow(() -> new RecordCoreException("unable to resolve result values", new Object[0]));
    }

    public void clearExploratoryExpressions() {
        this.exploratoryMembers.clear();
    }

    public void clearFinalExpressions() {
        this.propertiesMap.clear();
        this.finalMembers.clear();
    }

    public void startExploration() {
        this.constraintsMap.startExploration();
    }

    public void commitExploration() {
        this.constraintsMap.commitExploration();
    }

    public boolean needsExploration() {
        return !this.constraintsMap.isExploring() && !this.constraintsMap.isExplored();
    }

    public boolean isExploring() {
        return this.constraintsMap.isExploring();
    }

    public boolean hasNeverBeenExplored() {
        return this.constraintsMap.hasNeverBeenExplored();
    }

    public boolean isFullyExploring() {
        return this.constraintsMap.isFullyExploring();
    }

    public boolean isExploredForAttributes(@Nonnull Set<PlannerConstraint<?>> dependencies) {
        return this.constraintsMap.isExploredForAttributes(dependencies);
    }

    public boolean isExplored() {
        return this.constraintsMap.isExplored();
    }

    public void setExplored() {
        this.constraintsMap.setExplored();
    }

    public void inheritConstraintsFromOther(@Nonnull Reference otherReference) {
        this.constraintsMap.inheritFromOther(otherReference.getConstraintsMap());
    }

    @Nonnull
    public Set<RelationalExpression> getExploratoryExpressions() {
        return this.exploratoryMembers.getExpressions();
    }

    @Nonnull
    public Set<RelationalExpression> getFinalExpressions() {
        return this.finalMembers.getExpressions();
    }

    @Nonnull
    public Collection<RelationalExpression> getAllMemberExpressions() {
        return this.allMembersView;
    }

    @Nonnull
    public Reference newReferenceFromFinalMembers(@Nonnull Collection<? extends RelationalExpression> expressions) {
        Verify.verify(!this.needsExploration());
        Verify.verify(this.getFinalExpressions().containsAll(expressions));
        Reference newRef = Reference.of(this.getPlannerStage(), ImmutableList.of(), expressions);
        newRef.setExplored();
        return newRef;
    }

    @Nonnull
    public <A> Map<? extends RelationalExpression, A> getPropertyForExpressions(@Nonnull ExpressionProperty<A> expressionProperty) {
        return this.propertiesMap.propertyValueForExpressions(expressionProperty);
    }

    @Nonnull
    public <A> Map<RecordQueryPlan, A> getPropertyForPlans(@Nonnull ExpressionProperty<A> expressionProperty) {
        return this.propertiesMap.propertyValueForPlans(expressionProperty);
    }

    @Nonnull
    public List<? extends ExpressionPartition<? extends RelationalExpression>> toExpressionPartitions() {
        return ExpressionPartitions.toPartitions(this.propertiesMap);
    }

    @Nonnull
    public List<PlanPartition> toPlanPartitions() {
        return PlanPartitions.toPartitions((PlanPropertiesMap)this.propertiesMap);
    }

    @Nullable
    public <U> U acceptVisitor(@Nonnull SimpleExpressionVisitor<U> simpleExpressionVisitor) {
        if (simpleExpressionVisitor.shouldVisit(this)) {
            ArrayList<Object> memberResults = new ArrayList<Object>(this.getAllMemberExpressions().size());
            for (RelationalExpression member : this.getAllMemberExpressions()) {
                Object result;
                Object e = result = simpleExpressionVisitor.shouldVisit(member) ? (Object)simpleExpressionVisitor.visit(member) : null;
                if (result == null) {
                    return null;
                }
                memberResults.add(result);
            }
            return simpleExpressionVisitor.evaluateAtRef(this, memberResults);
        }
        return null;
    }

    public String toString() {
        return Debugger.mapDebugger(debugger -> debugger.nameForObject(this) + "[" + this.getAllMemberExpressions().stream().map(debugger::nameForObject).collect(Collectors.joining(",")) + "]").orElse("Reference@" + this.hashCode() + "(isExplored=" + this.constraintsMap.isExplored() + ")");
    }

    @Override
    public boolean semanticEquals(@Nullable Object other, @Nonnull AliasMap aliasMap) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Reference otherReference = (Reference)other;
        return this.exploratoryMembers.semanticEquals(otherReference.exploratoryMembers, aliasMap) && this.finalMembers.semanticEquals(otherReference.finalMembers, aliasMap);
    }

    @Override
    public int semanticHashCode() {
        return Objects.hash(this.exploratoryMembers.semanticHashCode(), this.finalMembers.semanticHashCode());
    }

    @Nonnull
    public Set<MatchCandidate> getMatchCandidates() {
        return this.partialMatchMap.keySet();
    }

    @Nonnull
    public Collection<PartialMatch> getPartialMatchesForExpression(@Nonnull RelationalExpression expression) {
        return this.partialMatchMap.values().stream().filter(partialMatch -> partialMatch.getQueryExpression() == expression).collect(ImmutableSet.toImmutableSet());
    }

    @Nonnull
    public Set<PartialMatch> getPartialMatchesForCandidate(MatchCandidate candidate) {
        return this.partialMatchMap.get((Object)candidate);
    }

    public boolean addPartialMatchForCandidate(MatchCandidate candidate, PartialMatch partialMatch) {
        return this.partialMatchMap.put(candidate, partialMatch);
    }

    @Nonnull
    public String show(boolean renderSingleGroups) {
        return PlannerGraphVisitor.show(renderSingleGroups, this);
    }

    @Nonnull
    public String showExploratory() {
        return PlannerGraphVisitor.show(6, this);
    }

    private static boolean isMemoizedExpression(@Nonnull RelationalExpression member, @Nonnull RelationalExpression otherExpression, @Nonnull AliasMap equivalenceMap) {
        Iterable<AliasMap> aliasMapIterable;
        Set translatedCorrelatedTo;
        if (member == otherExpression) {
            return true;
        }
        if (member.getClass() != otherExpression.getClass()) {
            return false;
        }
        Set originalCorrelatedTo = member.getCorrelatedTo();
        Set set = translatedCorrelatedTo = equivalenceMap.definesOnlyIdentities() ? originalCorrelatedTo : (Set)originalCorrelatedTo.stream().map(alias -> equivalenceMap.getTargetOrDefault((CorrelationIdentifier)alias, (CorrelationIdentifier)alias)).collect(ImmutableSet.toImmutableSet());
        if (!translatedCorrelatedTo.equals(otherExpression.getCorrelatedTo())) {
            return false;
        }
        List<? extends Quantifier> quantifiers = member.getQuantifiers();
        List<? extends Quantifier> otherQuantifiers = otherExpression.getQuantifiers();
        if (member.getQuantifiers().size() != otherQuantifiers.size()) {
            return false;
        }
        if (member.hashCodeWithoutChildren() != otherExpression.hashCodeWithoutChildren()) {
            return false;
        }
        Verify.verify(member.canCorrelate() == otherExpression.canCorrelate());
        AliasMap identitiesMap = member.bindIdentities(otherExpression, equivalenceMap);
        AliasMap combinedEquivalenceMap = equivalenceMap.combine(identitiesMap);
        if (member instanceof RelationalExpressionWithChildren.ChildrenAsSet) {
            aliasMapIterable = Quantifiers.findMatches(combinedEquivalenceMap, member.getQuantifiers(), otherExpression.getQuantifiers(), (quantifier, otherQuantifier, nestedEquivalencesMap) -> {
                Reference rangesOver = quantifier.getRangesOver();
                Reference otherRangesOver = otherQuantifier.getRangesOver();
                return rangesOver.containsAllInMemo(otherRangesOver, nestedEquivalencesMap);
            });
        } else {
            AliasMap.Builder aliasMapBuilder = combinedEquivalenceMap.toBuilder(quantifiers.size());
            for (int i = 0; i < quantifiers.size(); ++i) {
                Quantifier quantifier2 = Objects.requireNonNull(quantifiers.get(i));
                Quantifier otherQuantifier2 = Objects.requireNonNull(otherQuantifiers.get(i));
                if (!quantifier2.getRangesOver().containsAllInMemo(otherQuantifier2.getRangesOver(), aliasMapBuilder.build())) {
                    return false;
                }
                aliasMapBuilder.put(quantifier2.getAlias(), otherQuantifier2.getAlias());
            }
            aliasMapIterable = ImmutableList.of(aliasMapBuilder.build());
        }
        return StreamSupport.stream(aliasMapIterable.spliterator(), false).anyMatch(aliasMap -> member.equalsWithoutChildren(otherExpression, (AliasMap)aliasMap));
    }

    @Nonnull
    public static Reference empty() {
        return new Reference();
    }

    @Nonnull
    public static Reference initialOf(@Nonnull RelationalExpression expression) {
        return Reference.ofFinalExpression(PlannerStage.INITIAL, expression);
    }

    @Nonnull
    public static Reference initialOf(RelationalExpression ... expressions) {
        return Reference.initialOf(Arrays.asList(expressions));
    }

    @Nonnull
    public static Reference initialOf(@Nonnull Collection<? extends RelationalExpression> expressions) {
        return Reference.ofFinalExpressions(PlannerStage.INITIAL, expressions);
    }

    @Nonnull
    public static Reference plannedOf(@Nonnull RecordQueryPlan plan) {
        return Reference.ofFinalExpression(PlannerStage.PLANNED, plan);
    }

    @Nonnull
    public static Reference ofExploratoryExpression(@Nonnull PlannerStage plannerStage, @Nonnull RelationalExpression expression) {
        return Reference.of(plannerStage, ImmutableList.of(expression), ImmutableList.of());
    }

    @Nonnull
    public static Reference ofFinalExpression(@Nonnull PlannerStage plannerStage, @Nonnull RelationalExpression expression) {
        return Reference.of(plannerStage, ImmutableList.of(), ImmutableList.of(expression));
    }

    @Nonnull
    public static Reference of(@Nonnull PlannerStage plannerStage, @Nonnull Collection<? extends RelationalExpression> exploratoryExpressions, @Nonnull Collection<? extends RelationalExpression> finalExpressions) {
        exploratoryExpressions.forEach(Debugger::registerExpression);
        finalExpressions.forEach(Debugger::registerExpression);
        return new Reference(plannerStage, new LinkedIdentitySet<RelationalExpression>(exploratoryExpressions), new LinkedIdentitySet<RelationalExpression>(finalExpressions));
    }

    @Nonnull
    public static Reference ofExploratoryExpressions(@Nonnull PlannerStage plannerStage, @Nonnull Collection<? extends RelationalExpression> expressions) {
        return Reference.of(plannerStage, expressions, new LinkedIdentitySet());
    }

    @Nonnull
    public static Reference ofFinalExpressions(@Nonnull PlannerStage plannerStage, @Nonnull Collection<? extends RelationalExpression> expressions) {
        return Reference.of(plannerStage, new LinkedIdentitySet(), expressions);
    }

    @Nonnull
    private static <T> Collection<T> concatSetsView(final @Nonnull Set<T> first, final @Nonnull Set<T> second) {
        return new AbstractCollection<T>(){

            @Override
            @Nonnull
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    private final Iterator<T> it1;
                    private final Iterator<T> it2;
                    {
                        this.it1 = first.iterator();
                        this.it2 = second.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it1.hasNext() || this.it2.hasNext();
                    }

                    @Override
                    public T next() {
                        if (this.it1.hasNext()) {
                            return this.it1.next();
                        }
                        return this.it2.next();
                    }
                };
            }

            @Override
            public int size() {
                return first.size() + second.size();
            }
        };
    }

    private static class Members {
        @Nonnull
        private final Set<RelationalExpression> expressions;

        public Members(@Nonnull LinkedIdentitySet<RelationalExpression> expressions) {
            this.expressions = expressions;
        }

        @Nonnull
        public Set<RelationalExpression> getExpressions() {
            return this.expressions;
        }

        public boolean isEmpty() {
            return this.expressions.isEmpty();
        }

        public int size() {
            return this.expressions.size();
        }

        public boolean containsExactly(@Nonnull RelationalExpression expression) {
            return this.expressions.contains(expression);
        }

        @Nonnull
        public RelationalExpression getOnlyElement() {
            return Iterables.getOnlyElement(this.expressions);
        }

        @Nonnull
        public RecordQueryPlan getOnlyElementAsPlan() {
            return (RecordQueryPlan)Iterables.getOnlyElement(this.expressions);
        }

        @Nonnull
        public Collection<RelationalExpression> concatExpressions(@Nonnull Members other) {
            return Reference.concatSetsView(this.expressions, other.getExpressions());
        }

        private void clear() {
            this.expressions.clear();
        }

        public int semanticHashCode() {
            Iterator<RelationalExpression> iterator = this.expressions.iterator();
            ImmutableSet.Builder builder = ImmutableSet.builder();
            while (iterator.hasNext()) {
                RelationalExpression next = iterator.next();
                builder.add((Object)next.semanticHashCode());
            }
            return Objects.hash(builder.build());
        }

        public boolean semanticEquals(@Nullable Object other, @Nonnull AliasMap aliasMap) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Members otherMembers = (Members)other;
            Iterator<RelationalExpression> iterator = this.expressions.iterator();
            ImmutableMultimap.Builder<Integer, RelationalExpression> expressionsMapBuilder = ImmutableMultimap.builder();
            while (iterator.hasNext()) {
                RelationalExpression next = iterator.next();
                expressionsMapBuilder.put(next.semanticHashCode(), next);
            }
            ImmutableMultimap expressionsMap = expressionsMapBuilder.build();
            for (RelationalExpression otherExpression : otherMembers.getExpressions()) {
                if (!expressionsMap.get((Object)otherExpression.semanticHashCode()).stream().noneMatch(member -> member.semanticEquals(otherExpression, aliasMap))) continue;
                return false;
            }
            return true;
        }

        @CanIgnoreReturnValue
        public boolean add(@Nonnull RelationalExpression expression) {
            return this.expressions.add(expression);
        }

        @CanIgnoreReturnValue
        public boolean addAll(@Nonnull Members members) {
            return this.expressions.addAll(members.getExpressions());
        }

        @CanIgnoreReturnValue
        public boolean addAll(@Nonnull Collection<? extends RelationalExpression> newExpressions) {
            return this.expressions.addAll(newExpressions);
        }

        public boolean containsInMemo(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap equivalenceMap) {
            if (this.expressions.contains(otherExpression)) {
                Set<CorrelationIdentifier> otherCorrelatedTo = otherExpression.getCorrelatedTo();
                if (equivalenceMap.definesOnlyIdentities() || Collections.disjoint(equivalenceMap.targets(), otherCorrelatedTo) && Collections.disjoint(equivalenceMap.sources(), otherCorrelatedTo)) {
                    return true;
                }
            }
            for (RelationalExpression member : this.expressions) {
                if (!Reference.isMemoizedExpression(member, otherExpression, equivalenceMap)) continue;
                return true;
            }
            return false;
        }
    }

    public static class UngettableReferenceException
    extends RecordCoreException {
        private static final long serialVersionUID = 1L;

        public UngettableReferenceException(String message) {
            super(message, new Object[0]);
        }
    }
}

