/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.query.plan.cascades.PlannerConstraint;
import com.apple.foundationdb.record.query.plan.cascades.values.FieldValue;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;

public class ReferencedFieldsConstraint
implements PlannerConstraint<ReferencedFields> {
    public static final PlannerConstraint<ReferencedFields> REFERENCED_FIELDS = new ReferencedFieldsConstraint();

    @Override
    @Nonnull
    public Optional<ReferencedFields> combine(@Nonnull ReferencedFields currentConstraint, @Nonnull ReferencedFields newConstraint) {
        ImmutableCollection referencedFields = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(currentConstraint.getReferencedFieldValues())).addAll(newConstraint.getReferencedFieldValues())).build();
        if (referencedFields.size() > currentConstraint.getReferencedFieldValues().size()) {
            return Optional.of(new ReferencedFields((Set<FieldValue>)((Object)referencedFields)));
        }
        return Optional.empty();
    }

    public static class ReferencedFields {
        @Nonnull
        private final Set<FieldValue> referencedFieldValues;

        public ReferencedFields(@Nonnull Set<FieldValue> referencedFieldValues) {
            this.referencedFieldValues = referencedFieldValues;
        }

        @Nonnull
        public Set<FieldValue> getReferencedFieldValues() {
            return this.referencedFieldValues;
        }
    }
}

