/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.query.combinatorics.PartiallyOrderedSet;
import com.apple.foundationdb.record.query.combinatorics.TopologicalSort;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Memoizer;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpressionWithChildren;
import com.apple.foundationdb.record.query.plan.cascades.properties.ReferencesAndDependenciesProperty;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class References {
    private References() {
    }

    @Nonnull
    public static List<? extends Reference> translateCorrelationsInGraphs(@Nonnull List<? extends Reference> refs, @Nonnull Memoizer memoizer, @Nonnull TranslationMap translationMap, boolean shouldSimplifyValues) {
        if (refs.isEmpty()) {
            return ImmutableList.of();
        }
        PartiallyOrderedSet<Reference> partialOrder = ReferencesAndDependenciesProperty.referencesAndDependencies().evaluate(refs);
        List<Reference> references = TopologicalSort.anyTopologicalOrderPermutation(partialOrder).orElseThrow(() -> new RecordCoreException("graph has cycles", new Object[0]));
        IdentityHashMap<Reference, Reference> translationsCache = Maps.newIdentityHashMap();
        for (Reference reference : references) {
            if (reference.getCorrelatedTo().stream().anyMatch(translationMap::containsSourceAlias)) {
                References.rebaseGraph(memoizer, translationMap, shouldSimplifyValues, reference, translationsCache, alias -> {
                    Verify.verify(!translationMap.containsSourceAlias((CorrelationIdentifier)alias), "internal quantifiers cannot be re-aliased", new Object[0]);
                    return alias;
                });
                continue;
            }
            translationsCache.put(reference, reference);
        }
        return refs.stream().map(ref -> Objects.requireNonNull((Reference)translationsCache.get(ref))).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public static List<? extends Reference> rebaseGraphs(@Nonnull List<? extends Reference> refs, @Nonnull Memoizer memoizer, @Nonnull TranslationMap translationMap, boolean shouldSimplifyValues) {
        if (refs.isEmpty()) {
            return ImmutableList.of();
        }
        PartiallyOrderedSet<Reference> partialOrder = ReferencesAndDependenciesProperty.referencesAndDependencies().evaluate(refs);
        List<Reference> references = TopologicalSort.anyTopologicalOrderPermutation(partialOrder).orElseThrow(() -> new RecordCoreException("graph has cycles", new Object[0]));
        IdentityHashMap<Reference, Reference> translationsCache = Maps.newIdentityHashMap();
        for (Reference reference : references) {
            References.rebaseGraph(memoizer, translationMap, shouldSimplifyValues, reference, translationsCache, sourceAlias -> translationMap.getTargetOrDefault((CorrelationIdentifier)sourceAlias, (CorrelationIdentifier)sourceAlias));
        }
        return refs.stream().map(ref -> translationsCache.getOrDefault(ref, (Reference)ref)).collect(ImmutableList.toImmutableList());
    }

    /*
     * WARNING - void declaration
     */
    private static void rebaseGraph(@Nonnull Memoizer memoizer, @Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull Reference reference, @Nonnull IdentityHashMap<Reference, Reference> translationsCache, @Nonnull Function<CorrelationIdentifier, CorrelationIdentifier> quantifierAliasMapper) {
        Verify.verify(!reference.isExploring());
        boolean allMembersSame = true;
        ImmutableList.Builder translatedExploratoryExpressionsBuilder = ImmutableList.builder();
        ImmutableList.Builder translatedFinalExpressionsBuilder = ImmutableList.builder();
        for (RelationalExpression expression : reference.getAllMemberExpressions()) {
            void var14_15;
            boolean allChildTranslationsSame = true;
            ImmutableList.Builder translatedQuantifiersBuilder = ImmutableList.builder();
            for (Quantifier quantifier : expression.getQuantifiers()) {
                Reference childReference = quantifier.getRangesOver();
                Reference translatedChildReference = translationsCache.getOrDefault(childReference, childReference);
                CorrelationIdentifier alias = quantifier.getAlias();
                if (translatedChildReference == childReference && !translationMap.containsSourceAlias(alias)) {
                    translatedQuantifiersBuilder.add(quantifier);
                    continue;
                }
                translatedQuantifiersBuilder.add(quantifier.overNewReference(translatedChildReference, quantifierAliasMapper.apply(alias)));
                allChildTranslationsSame = false;
            }
            ImmutableCollection translatedQuantifiers = translatedQuantifiersBuilder.build();
            if (allChildTranslationsSame) {
                Set<CorrelationIdentifier> memberCorrelatedTo = expression instanceof RelationalExpressionWithChildren ? ((RelationalExpressionWithChildren)expression).getCorrelatedToWithoutChildren() : expression.getCorrelatedTo();
                if (memberCorrelatedTo.stream().noneMatch(translationMap::containsSourceAlias)) {
                    RelationalExpression relationalExpression = expression;
                } else {
                    RelationalExpression relationalExpression = expression.translateCorrelations(translationMap, shouldSimplifyValues, (List<? extends Quantifier>)((Object)translatedQuantifiers));
                    Debugger.withDebugger(debugger -> debugger.onEvent(new Debugger.TranslateCorrelationsEvent(translatedExpression, Debugger.Location.COUNT)));
                    allMembersSame = false;
                }
            } else {
                RelationalExpression relationalExpression = expression.translateCorrelations(translationMap, shouldSimplifyValues, (List<? extends Quantifier>)((Object)translatedQuantifiers));
                Debugger.withDebugger(debugger -> debugger.onEvent(new Debugger.TranslateCorrelationsEvent(translatedExpression, Debugger.Location.COUNT)));
                allMembersSame = false;
            }
            if (reference.isFinal(expression)) {
                translatedFinalExpressionsBuilder.add((Object)var14_15);
            }
            if (!reference.isExploratory(expression)) continue;
            translatedExploratoryExpressionsBuilder.add((Object)var14_15);
        }
        if (!allMembersSame) {
            ImmutableCollection translatedExploratoryExpressions = translatedExploratoryExpressionsBuilder.build();
            ImmutableCollection translatedFinalExpressions = translatedFinalExpressionsBuilder.build();
            Reference translatedReference = translatedExploratoryExpressions.isEmpty() ? memoizer.memoizeFinalExpressions(translatedFinalExpressions) : (translatedFinalExpressions.isEmpty() ? memoizer.memoizeExploratoryExpressions(translatedExploratoryExpressions) : memoizer.memoizeExpressions(translatedExploratoryExpressions, translatedFinalExpressions));
            translatedReference.inheritConstraintsFromOther(reference);
            translationsCache.put(reference, translatedReference);
        }
    }
}

