/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.OrderingPart;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.Values;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.OrderingValueComputationRuleSet;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.RequestedOrderingValueSimplificationRuleSet;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class RequestedOrdering {
    @Nonnull
    private final List<OrderingPart.RequestedOrderingPart> orderingParts;
    @Nonnull
    private final Distinctness distinctness;
    private final boolean isExhaustive;
    @Nonnull
    private final Supplier<Map<Value, OrderingPart.RequestedSortOrder>> valueRequestedSortOrderMapSupplier;

    private RequestedOrdering(@Nonnull List<OrderingPart.RequestedOrderingPart> orderingParts, @Nonnull Distinctness distinctness, boolean isExhaustive) {
        this.orderingParts = ImmutableList.copyOf(orderingParts);
        this.distinctness = distinctness;
        this.isExhaustive = isExhaustive;
        this.valueRequestedSortOrderMapSupplier = Suppliers.memoize(this::computeValueSortOrderMap);
    }

    @Nonnull
    public Distinctness getDistinctness() {
        return this.distinctness;
    }

    public boolean isDistinct() {
        return this.distinctness == Distinctness.DISTINCT;
    }

    public boolean isExhaustive() {
        return this.isExhaustive;
    }

    public boolean isPreserve() {
        return this.orderingParts.isEmpty();
    }

    @Nonnull
    public List<OrderingPart.RequestedOrderingPart> getOrderingParts() {
        return this.orderingParts;
    }

    @Nonnull
    public Map<Value, OrderingPart.RequestedSortOrder> getValueRequestedSortOrderMap() {
        return this.valueRequestedSortOrderMapSupplier.get();
    }

    public int size() {
        return this.orderingParts.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RequestedOrdering)) {
            return false;
        }
        RequestedOrdering ordering = (RequestedOrdering)o;
        return this.getOrderingParts().equals(ordering.getOrderingParts()) && this.getDistinctness() == ordering.getDistinctness();
    }

    public int hashCode() {
        return Objects.hash(this.getOrderingParts(), this.getDistinctness().name());
    }

    public String toString() {
        return this.orderingParts.stream().map(Object::toString).collect(Collectors.joining(", "));
    }

    @Nonnull
    public RequestedOrdering pushDown(@Nonnull Value value, @Nonnull CorrelationIdentifier lowerBaseAlias, @Nonnull EvaluationContext evaluationContext, @Nonnull AliasMap aliasMap, @Nonnull Set<CorrelationIdentifier> constantAliases) {
        ImmutableList orderingKeyValues = this.orderingParts.stream().map(OrderingPart::getValue).collect(ImmutableList.toImmutableList());
        List<Value> pushedDownOrderingValues = value.pushDown(orderingKeyValues, RequestedOrderingValueSimplificationRuleSet.ofRequestedOrderSimplificationRules(), evaluationContext, aliasMap, constantAliases, Quantifier.current());
        AliasMap translationMap = AliasMap.ofAliases(lowerBaseAlias, Quantifier.current());
        ImmutableList.Builder pushedDownOrderingPartsBuilder = ImmutableList.builder();
        for (int i = 0; i < this.orderingParts.size(); ++i) {
            OrderingPart.RequestedOrderingPart orderingPart = this.orderingParts.get(i);
            Value orderingValue = Objects.requireNonNull(pushedDownOrderingValues.get(i));
            Value rebasedOrderingValue = orderingValue.rebase(translationMap);
            pushedDownOrderingPartsBuilder.add(new OrderingPart.RequestedOrderingPart(rebasedOrderingValue, (OrderingPart.RequestedSortOrder)orderingPart.getSortOrder()));
        }
        return new RequestedOrdering((List<OrderingPart.RequestedOrderingPart>)((Object)pushedDownOrderingPartsBuilder.build()), Distinctness.PRESERVE_DISTINCTNESS, this.isExhaustive());
    }

    @Nonnull
    public RequestedOrdering translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplify) {
        ImmutableList.Builder pushedDownOrderingPartsBuilder = ImmutableList.builder();
        for (OrderingPart.RequestedOrderingPart orderingPart : this.orderingParts) {
            Value orderingValue = orderingPart.getValue();
            Value translatedOrderingValue = orderingValue.translateCorrelations(translationMap, shouldSimplify);
            pushedDownOrderingPartsBuilder.add(new OrderingPart.RequestedOrderingPart(translatedOrderingValue, (OrderingPart.RequestedSortOrder)orderingPart.getSortOrder()));
        }
        return new RequestedOrdering((List<OrderingPart.RequestedOrderingPart>)((Object)pushedDownOrderingPartsBuilder.build()), Distinctness.PRESERVE_DISTINCTNESS, this.isExhaustive());
    }

    @Nonnull
    private Map<Value, OrderingPart.RequestedSortOrder> computeValueSortOrderMap() {
        return this.getOrderingParts().stream().collect(Collectors.toMap(OrderingPart::getValue, OrderingPart::getSortOrder, (left, right) -> {
            if (left == right) {
                return left;
            }
            return OrderingPart.RequestedSortOrder.ANY;
        }, LinkedHashMap::new));
    }

    @Nonnull
    public RequestedOrdering withDistinctness(@Nonnull Distinctness distinctness) {
        if (this.distinctness == distinctness) {
            return this;
        }
        return new RequestedOrdering(this.getOrderingParts(), distinctness, this.isExhaustive());
    }

    @Nonnull
    public RequestedOrdering exhaustive() {
        if (this.isExhaustive()) {
            return this;
        }
        return new RequestedOrdering(this.getOrderingParts(), this.getDistinctness(), true);
    }

    @Nonnull
    public static RequestedOrdering preserve() {
        return new RequestedOrdering(ImmutableList.of(), Distinctness.PRESERVE_DISTINCTNESS, false);
    }

    @Nonnull
    public static RequestedOrdering ofParts(@Nonnull List<OrderingPart.RequestedOrderingPart> requestedOrderingParts, @Nonnull Distinctness distinctness, boolean isExhaustive, @Nonnull Set<CorrelationIdentifier> constantAliases) {
        ImmutableList.Builder primitiveRequestedOrderingParts = ImmutableList.builder();
        for (OrderingPart.RequestedOrderingPart requestedOrderingPart : requestedOrderingParts) {
            Value partValue = requestedOrderingPart.getValue();
            List<Value> primitivesValues = Values.primitiveAccessorsForType(partValue.getResultType(), () -> partValue);
            for (Value primitiveValue : primitivesValues) {
                OrderingPart.RequestedOrderingPart simplifiedRequestedOrderingPart = primitiveValue.deriveOrderingPart(EvaluationContext.empty(), AliasMap.emptyMap(), constantAliases, OrderingPart.RequestedOrderingPart::new, OrderingValueComputationRuleSet.usingRequestedOrderingParts((OrderingPart.RequestedSortOrder)requestedOrderingPart.getSortOrder()));
                primitiveRequestedOrderingParts.add(simplifiedRequestedOrderingPart);
            }
        }
        return RequestedOrdering.ofPrimitiveParts((List<OrderingPart.RequestedOrderingPart>)((Object)primitiveRequestedOrderingParts.build()), distinctness, isExhaustive);
    }

    @Nonnull
    public static RequestedOrdering ofPrimitiveParts(@Nonnull List<OrderingPart.RequestedOrderingPart> requestedOrderingParts, @Nonnull Distinctness distinctness, boolean isExhaustive) {
        Debugger.sanityCheck(() -> Verify.verify(requestedOrderingParts.stream().allMatch(requestedOrderingPart -> requestedOrderingPart.getValue().getResultType().isPrimitive())));
        return new RequestedOrdering(requestedOrderingParts, distinctness, isExhaustive);
    }

    public static enum Distinctness {
        DISTINCT,
        NOT_DISTINCT,
        PRESERVE_DISTINCTNESS;

    }
}

