/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.query.plan.cascades.OrderingPart;
import com.apple.foundationdb.record.query.plan.cascades.PlannerConstraint;
import com.apple.foundationdb.record.query.plan.cascades.RequestedOrdering;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;

public class RequestedOrderingConstraint
implements PlannerConstraint<Set<RequestedOrdering>> {
    public static final PlannerConstraint<Set<RequestedOrdering>> REQUESTED_ORDERING = new RequestedOrderingConstraint();

    @Override
    @Nonnull
    public Optional<Set<RequestedOrdering>> combine(@Nonnull Set<RequestedOrdering> currentConstraint, @Nonnull Set<RequestedOrdering> newConstraint) {
        LinkedHashSet<RequestedOrdering> newRequestedOrderings = Sets.newLinkedHashSet(newConstraint);
        for (RequestedOrdering newRequestedOrdering : newConstraint) {
            for (RequestedOrdering currentRequestedOrdering : currentConstraint) {
                if (newRequestedOrdering.isDistinct() != currentRequestedOrdering.isDistinct()) continue;
                List<OrderingPart.RequestedOrderingPart> newOrderingParts = newRequestedOrdering.getOrderingParts();
                List<OrderingPart.RequestedOrderingPart> currentOrderingParts = currentRequestedOrdering.getOrderingParts();
                if (!currentRequestedOrdering.isExhaustive() && newRequestedOrdering.isExhaustive()) continue;
                if (currentRequestedOrdering.isExhaustive() && newOrderingParts.size() >= currentOrderingParts.size()) {
                    if (!newOrderingParts.subList(0, currentOrderingParts.size()).equals(currentOrderingParts)) continue;
                    newRequestedOrderings.remove(newRequestedOrdering);
                    continue;
                }
                if (!newOrderingParts.equals(currentOrderingParts)) continue;
                newRequestedOrderings.remove(newRequestedOrdering);
            }
        }
        if (newRequestedOrderings.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(currentConstraint)).addAll(newRequestedOrderings)).build());
    }
}

