/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.query.plan.RecordQueryPlannerConfiguration;
import com.apple.foundationdb.record.query.plan.cascades.CascadesCostModel;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.properties.ExpressionCountProperty;
import com.apple.foundationdb.record.query.plan.cascades.properties.PredicateComplexityProperty;
import com.apple.foundationdb.record.query.plan.cascades.properties.PredicateHeightProperty;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
@SpotBugsSuppressWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"})
public class RewritingCostModel
implements CascadesCostModel {
    @Nonnull
    private final RecordQueryPlannerConfiguration configuration;

    public RewritingCostModel(@Nonnull RecordQueryPlannerConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    @Nonnull
    public RecordQueryPlannerConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public int compare(RelationalExpression a, RelationalExpression b) {
        int bPredicateComplexity;
        int bPredicateHeight;
        int bTableFunctions;
        int bSelects;
        int aSelects = ExpressionCountProperty.selectCount().evaluate(a);
        if (aSelects != (bSelects = ExpressionCountProperty.selectCount().evaluate(b))) {
            return Integer.compare(aSelects, bSelects);
        }
        int aTableFunctions = ExpressionCountProperty.tableFunctionCount().evaluate(a);
        if (aTableFunctions != (bTableFunctions = ExpressionCountProperty.tableFunctionCount().evaluate(b))) {
            return Integer.compare(aTableFunctions, bTableFunctions);
        }
        int aPredicateHeight = PredicateHeightProperty.predicateHeight().evaluate(a);
        if (aPredicateHeight != (bPredicateHeight = PredicateHeightProperty.predicateHeight().evaluate(b))) {
            return Integer.compare(aPredicateHeight, bPredicateHeight);
        }
        int aPredicateComplexity = PredicateComplexityProperty.predicateComplexity().evaluate(a);
        if (aPredicateComplexity != (bPredicateComplexity = PredicateComplexityProperty.predicateComplexity().evaluate(b))) {
            return Integer.compare(aPredicateComplexity, bPredicateComplexity);
        }
        return Integer.compare(a.semanticHashCode(), b.semanticHashCode());
    }
}

