/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.query.plan.cascades.CascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.CascadesRuleSet;
import com.apple.foundationdb.record.query.plan.cascades.ExplorationCascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.ImplementationCascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.rules.DecorrelateValuesRule;
import com.apple.foundationdb.record.query.plan.cascades.rules.FinalizeExpressionsRule;
import com.apple.foundationdb.record.query.plan.cascades.rules.PredicatePushDownRule;
import com.apple.foundationdb.record.query.plan.cascades.rules.QueryPredicateSimplificationRule;
import com.apple.foundationdb.record.query.plan.cascades.rules.SelectMergeRule;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class RewritingRuleSet
extends CascadesRuleSet {
    private static final Set<ExplorationCascadesRule<? extends RelationalExpression>> EXPLORATION_RULES = ImmutableSet.of(new QueryPredicateSimplificationRule(), new PredicatePushDownRule(), new DecorrelateValuesRule());
    private static final Set<CascadesRule<? extends RelationalExpression>> PREORDER_RULES = ImmutableSet.of();
    private static final Set<ImplementationCascadesRule<? extends RelationalExpression>> IMPLEMENTATION_RULES = ImmutableSet.of(new SelectMergeRule(), new FinalizeExpressionsRule());
    @Nonnull
    private static final Set<CascadesRule<? extends RelationalExpression>> ALL_EXPRESSION_RULES = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(PREORDER_RULES)).addAll(EXPLORATION_RULES)).addAll(IMPLEMENTATION_RULES)).build();
    @Nonnull
    public static final Set<CascadesRule<? extends RelationalExpression>> OPTIONAL_RULES = ALL_EXPRESSION_RULES.stream().filter(rule -> !(rule instanceof FinalizeExpressionsRule)).collect(ImmutableSet.toImmutableSet());
    @Nonnull
    public static final RewritingRuleSet DEFAULT = new RewritingRuleSet();

    @VisibleForTesting
    @SpotBugsSuppressWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    RewritingRuleSet() {
        super(ALL_EXPRESSION_RULES);
    }

    @Nonnull
    public static RewritingRuleSet getDefault() {
        return DEFAULT;
    }
}

