/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.metadata.expressions.EmptyKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.FieldKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.FunctionKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpressionWithValue;
import com.apple.foundationdb.record.metadata.expressions.KeyWithValueExpression;
import com.apple.foundationdb.record.metadata.expressions.ListKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.NestingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.ThenKeyExpression;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.KeyExpressionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.EmptyValue;
import com.apple.foundationdb.record.query.plan.cascades.values.FieldValue;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ScalarTranslationVisitor
implements KeyExpressionVisitor<ScalarVisitorState, Value> {
    @Nonnull
    private final KeyExpression keyExpression;
    private final Deque<ScalarVisitorState> states;

    public ScalarTranslationVisitor(@Nonnull KeyExpression keyExpression) {
        this.keyExpression = keyExpression;
        this.states = new ArrayDeque<ScalarVisitorState>();
    }

    @Override
    public ScalarVisitorState getCurrentState() {
        return this.states.peek();
    }

    public ScalarTranslationVisitor push(ScalarVisitorState newState) {
        this.states.push(newState);
        return this;
    }

    public ScalarVisitorState pop() {
        return this.states.pop();
    }

    public <T> T pop(T t2) {
        this.pop();
        return t2;
    }

    @Override
    @Nonnull
    public final Value visitExpression(@Nonnull KeyExpression keyExpression) {
        throw new UnsupportedOperationException("visitor method for this key expression is not implemented");
    }

    @Override
    @Nonnull
    public Value visitExpression(@Nonnull EmptyKeyExpression emptyKeyExpression) {
        return EmptyValue.empty();
    }

    @Override
    @Nonnull
    public Value visitExpression(@Nonnull FieldKeyExpression fieldKeyExpression) {
        KeyExpression.FanType fanType = fieldKeyExpression.getFanType();
        if (fanType != KeyExpression.FanType.None) {
            throw new RecordCoreException("cannot expand fan outs in scalar expansion", new Object[0]);
        }
        ScalarVisitorState state = this.getCurrentState();
        String fieldName = fieldKeyExpression.getFieldName();
        List<String> fieldNamePrefix = state.getFieldNamePrefix();
        ImmutableCollection fieldNames = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(fieldNamePrefix)).add(fieldName)).build();
        return FieldValue.ofFieldNames(QuantifiedObjectValue.of(state.baseAlias, state.inputType), (List<String>)((Object)fieldNames));
    }

    @Override
    @Nonnull
    public Value visitExpression(@Nonnull KeyExpressionWithValue keyExpressionWithValue) {
        ScalarVisitorState state = this.getCurrentState();
        return keyExpressionWithValue.toValue(state.getBaseAlias(), state.inputType);
    }

    @Override
    @Nonnull
    public Value visitExpression(@Nonnull FunctionKeyExpression functionKeyExpression) {
        ImmutableList.Builder argumentValuesBuilder = ImmutableList.builder();
        KeyExpression arguments = functionKeyExpression.getArguments();
        for (KeyExpression expression : arguments.normalizeKeyForPositions()) {
            argumentValuesBuilder.add(expression.expand(this));
        }
        return functionKeyExpression.toValue((List<? extends Value>)((Object)argumentValuesBuilder.build()));
    }

    @Override
    @Nonnull
    public Value visitExpression(@Nonnull KeyWithValueExpression keyWithValueExpression) {
        throw new RecordCoreException("cannot expand this expression in scalar expansion", new Object[0]);
    }

    @Override
    @Nonnull
    public Value visitExpression(@Nonnull NestingKeyExpression nestingKeyExpression) {
        FieldKeyExpression parent = nestingKeyExpression.getParent();
        KeyExpression.FanType fanType = parent.getFanType();
        if (fanType != KeyExpression.FanType.None) {
            throw new RecordCoreException("cannot expand fan outs in scalar expansion", new Object[0]);
        }
        ScalarVisitorState state = this.getCurrentState();
        List<String> fieldNamePrefix = state.getFieldNamePrefix();
        KeyExpression child = nestingKeyExpression.getChild();
        ImmutableCollection newPrefix = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(fieldNamePrefix)).add(parent.getFieldName())).build();
        return this.pop(child.expand(this.push(state.withFieldNamePrefix((List<String>)((Object)newPrefix)))));
    }

    @Override
    @Nonnull
    public Value visitExpression(@Nonnull ThenKeyExpression thenKeyExpression) {
        if (thenKeyExpression.getColumnSize() > 1) {
            throw new RecordCoreException("cannot expand ThenKeyExpression in scalar expansion", new Object[0]);
        }
        ScalarVisitorState state = this.getCurrentState();
        KeyExpression child = Iterables.getOnlyElement(thenKeyExpression.getChildren());
        return this.pop(child.expand(this.push(state)));
    }

    @Override
    @Nonnull
    public Value visitExpression(@Nonnull ListKeyExpression listKeyExpression) {
        throw new UnsupportedOperationException("visitor method for this key expression is not implemented");
    }

    @Nonnull
    public Value toResultValue(@Nonnull CorrelationIdentifier alias, @Nonnull Type inputType) {
        return this.toResultValue(alias, inputType, ImmutableList.of());
    }

    @Nonnull
    public Value toResultValue(@Nonnull CorrelationIdentifier alias, @Nonnull Type inputType, @Nonnull List<String> fieldNamePrefix) {
        return this.pop(this.keyExpression.expand(this.push(ScalarVisitorState.of(alias, inputType, fieldNamePrefix))));
    }

    @Nonnull
    public static List<Value> translateKeyExpression(@Nullable KeyExpression keyExpression, @Nonnull Type flowedType) {
        if (keyExpression == null) {
            return ImmutableList.of();
        }
        List<KeyExpression> primaryKeyComponents = keyExpression.normalizeKeyForPositions();
        return primaryKeyComponents.stream().map(primaryKeyComponent -> new ScalarTranslationVisitor((KeyExpression)primaryKeyComponent).toResultValue(Quantifier.current(), flowedType)).collect(ImmutableList.toImmutableList());
    }

    public static class ScalarVisitorState
    implements KeyExpressionVisitor.State {
        @Nonnull
        private final CorrelationIdentifier baseAlias;
        @Nonnull
        private final Type inputType;
        @Nonnull
        private final List<String> fieldNamePrefix;

        private ScalarVisitorState(@Nonnull CorrelationIdentifier baseAlias, @Nonnull Type inputType, @Nonnull List<String> fieldNamePrefix) {
            this.baseAlias = baseAlias;
            this.inputType = inputType;
            this.fieldNamePrefix = fieldNamePrefix;
        }

        @Nonnull
        public CorrelationIdentifier getBaseAlias() {
            return this.baseAlias;
        }

        @Nonnull
        public List<String> getFieldNamePrefix() {
            return this.fieldNamePrefix;
        }

        public ScalarVisitorState withBaseAlias(@Nonnull CorrelationIdentifier baseAlias) {
            return ScalarVisitorState.of(baseAlias, this.inputType, this.fieldNamePrefix);
        }

        public ScalarVisitorState withFieldNamePrefix(@Nonnull List<String> fieldNamePrefix) {
            return ScalarVisitorState.of(this.baseAlias, this.inputType, fieldNamePrefix);
        }

        public static ScalarVisitorState of(@Nonnull CorrelationIdentifier baseAlias, @Nonnull Type inputType, @Nonnull List<String> fieldNamePrefix) {
            return new ScalarVisitorState(baseAlias, inputType, fieldNamePrefix);
        }
    }
}

