/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.query.plan.AvailableFields;
import com.apple.foundationdb.record.query.plan.IndexKeyValueToPartialRecord;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.WithPrimaryKeyMatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.FieldValue;
import com.apple.foundationdb.record.query.plan.cascades.values.IndexEntryObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.RecordConstructorValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.primitives.ImmutableIntArray;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

public interface ScanWithFetchMatchCandidate
extends WithPrimaryKeyMatchCandidate {
    @Nonnull
    public Optional<Value> pushValueThroughFetch(@Nonnull Value var1, @Nonnull CorrelationIdentifier var2, @Nonnull CorrelationIdentifier var3);

    @Nonnull
    public static Optional<Value> pushValueThroughFetch(@Nonnull Value toBePushedValue, @Nonnull CorrelationIdentifier baseAlias, @Nonnull CorrelationIdentifier sourceAlias, @Nonnull CorrelationIdentifier targetAlias, @Nonnull Iterable<? extends Value> providedValuesFromIndex) {
        if (!ScanWithFetchMatchCandidate.isOfPushableTypesOrConstant(toBePushedValue, sourceAlias)) {
            return Optional.empty();
        }
        AliasMap equivalenceMap = AliasMap.ofAliases(sourceAlias, baseAlias);
        AliasMap toTargetAliasMap = AliasMap.ofAliases(sourceAlias, targetAlias);
        Optional<Value> translatedValueOptional = toBePushedValue.mapMaybe((value, mappedChildren) -> {
            for (Value providedValue : providedValuesFromIndex) {
                if (!value.semanticEquals((Object)providedValue, equivalenceMap)) continue;
                return ((Value)value.withChildren(mappedChildren)).rebase(toTargetAliasMap);
            }
            return (Value)value.withChildren(mappedChildren);
        });
        return translatedValueOptional.filter(translatedValue -> !translatedValue.getCorrelatedTo().contains(sourceAlias));
    }

    private static boolean isOfPushableTypesOrConstant(@Nonnull Value toBePushedValue, @Nonnull CorrelationIdentifier sourceAlias) {
        if (!toBePushedValue.getCorrelatedTo().contains(sourceAlias)) {
            return true;
        }
        if (toBePushedValue instanceof FieldValue) {
            return true;
        }
        if (toBePushedValue instanceof RecordConstructorValue) {
            return ((RecordConstructorValue)toBePushedValue).getColumns().stream().allMatch(column -> ScanWithFetchMatchCandidate.isOfPushableTypesOrConstant(column.getValue(), sourceAlias));
        }
        return false;
    }

    public static boolean addCoveringField(@Nonnull IndexKeyValueToPartialRecord.Builder builder, @Nonnull FieldValue fieldValue, @Nonnull Value extractFromIndexEntryValue) {
        Optional<IndexKeyValueToPartialRecord.Builder> parentBuilderForFieldOptional = ScanWithFetchMatchCandidate.getParentBuilderForFieldMaybe(builder, fieldValue);
        if (parentBuilderForFieldOptional.isEmpty()) {
            return false;
        }
        IndexKeyValueToPartialRecord.Builder parentBuilderForField = parentBuilderForFieldOptional.get();
        Optional<String> maybeFieldName = fieldValue.getLastFieldName();
        if (maybeFieldName.isEmpty()) {
            return false;
        }
        String fieldName = maybeFieldName.get();
        if (!parentBuilderForField.hasField(fieldName)) {
            parentBuilderForField.addField(fieldName, extractFromIndexEntryValue);
        }
        return true;
    }

    private static boolean addCoveringField(@Nonnull IndexKeyValueToPartialRecord.Builder builder, @Nonnull FieldValue fieldValue, @Nonnull AvailableFields.FieldData fieldData) {
        for (Optional<String> maybeFieldName : fieldValue.getFieldPrefix().getOptionalFieldNames()) {
            if (maybeFieldName.isEmpty()) {
                return false;
            }
            builder = builder.getFieldBuilder(maybeFieldName.get());
        }
        Optional<String> maybeFieldName = fieldValue.getLastFieldName();
        if (maybeFieldName.isEmpty()) {
            return false;
        }
        String fieldName = maybeFieldName.get();
        if (!builder.hasField(fieldName)) {
            builder.addField(fieldName, fieldData.getSource(), fieldData.getCopyIfPredicate(), fieldData.getOrdinalPath(), fieldData.getInvertibleFunction());
        }
        return true;
    }

    @Nonnull
    private static Optional<IndexKeyValueToPartialRecord.Builder> getParentBuilderForFieldMaybe(@Nonnull IndexKeyValueToPartialRecord.Builder builder, @Nonnull FieldValue fieldValue) {
        for (Optional<String> maybeFieldName : fieldValue.getFieldPrefix().getOptionalFieldNames()) {
            if (maybeFieldName.isEmpty()) {
                return Optional.empty();
            }
            builder = builder.getFieldBuilder(maybeFieldName.get());
        }
        return Optional.of(builder);
    }

    @Nonnull
    public static Optional<IndexEntryToLogicalRecord> computeIndexEntryToLogicalRecord(@Nonnull Collection<RecordType> queriedRecordTypes, @Nonnull CorrelationIdentifier baseAlias, @Nonnull Type baseType, @Nonnull List<Value> indexKeyValues, @Nonnull List<Value> indexValueValues) {
        if (queriedRecordTypes.size() > 1) {
            return Optional.empty();
        }
        RecordType queriedRecordType = Iterables.getOnlyElement(queriedRecordTypes);
        IndexKeyValueToPartialRecord.Builder builder = IndexKeyValueToPartialRecord.newBuilder(queriedRecordType);
        QuantifiedObjectValue baseObjectValue = QuantifiedObjectValue.of(baseAlias, baseType);
        ImmutableList.Builder logicalKeyValuesBuilder = ImmutableList.builder();
        for (int i = 0; i < indexKeyValues.size(); ++i) {
            Value keyValue = indexKeyValues.get(i);
            Optional<NonnullPair<FieldValue, Value>> extractFromIndexEntryPairOptional = keyValue.extractFromIndexEntryMaybe(baseObjectValue, EvaluationContext.empty(), AliasMap.emptyMap(), ImmutableSet.of(), IndexKeyValueToPartialRecord.TupleSource.KEY, ImmutableIntArray.of(i));
            if (!extractFromIndexEntryPairOptional.isPresent()) continue;
            NonnullPair<FieldValue, Value> extractFromIndexEntryPair = extractFromIndexEntryPairOptional.get();
            if (extractFromIndexEntryPair.getValue() instanceof IndexEntryObjectValue) {
                AvailableFields.FieldData fieldData = AvailableFields.FieldData.ofUnconditional(IndexKeyValueToPartialRecord.TupleSource.KEY, ImmutableIntArray.of(i));
                if (!ScanWithFetchMatchCandidate.addCoveringField(builder, (FieldValue)extractFromIndexEntryPair.getKey(), fieldData)) {
                    return Optional.empty();
                }
                logicalKeyValuesBuilder.add(extractFromIndexEntryPair.getLeft());
                continue;
            }
            if (!ScanWithFetchMatchCandidate.addCoveringField(builder, (FieldValue)extractFromIndexEntryPair.getKey(), (Value)extractFromIndexEntryPair.getValue())) {
                return Optional.empty();
            }
            logicalKeyValuesBuilder.add(extractFromIndexEntryPair.getLeft());
        }
        ImmutableList.Builder logicalValueValuesBuilder = ImmutableList.builder();
        for (int i = 0; i < indexValueValues.size(); ++i) {
            Value valueValue = indexValueValues.get(i);
            Optional<NonnullPair<FieldValue, Value>> extractFromIndexEntryPairOptional = valueValue.extractFromIndexEntryMaybe(baseObjectValue, EvaluationContext.empty(), AliasMap.emptyMap(), ImmutableSet.of(), IndexKeyValueToPartialRecord.TupleSource.VALUE, ImmutableIntArray.of(i));
            if (!extractFromIndexEntryPairOptional.isPresent()) continue;
            NonnullPair<FieldValue, Value> extractFromIndexEntryPair = extractFromIndexEntryPairOptional.get();
            if (extractFromIndexEntryPair.getValue() instanceof IndexEntryObjectValue) {
                AvailableFields.FieldData fieldData = AvailableFields.FieldData.ofUnconditional(IndexKeyValueToPartialRecord.TupleSource.VALUE, ImmutableIntArray.of(i));
                if (!ScanWithFetchMatchCandidate.addCoveringField(builder, (FieldValue)extractFromIndexEntryPair.getKey(), fieldData)) {
                    return Optional.empty();
                }
                logicalValueValuesBuilder.add(extractFromIndexEntryPair.getLeft());
                continue;
            }
            if (!ScanWithFetchMatchCandidate.addCoveringField(builder, (FieldValue)extractFromIndexEntryPair.getKey(), (Value)extractFromIndexEntryPair.getValue())) {
                return Optional.empty();
            }
            logicalValueValuesBuilder.add(extractFromIndexEntryPair.getLeft());
        }
        if (!builder.isValid()) {
            return Optional.empty();
        }
        return Optional.of(new IndexEntryToLogicalRecord(queriedRecordType, builder.build(), (List<Value>)((Object)logicalKeyValuesBuilder.build()), (List<Value>)((Object)logicalValueValuesBuilder.build())));
    }

    public static class IndexEntryToLogicalRecord {
        @Nonnull
        private final RecordType queriedRecordType;
        @Nonnull
        private final IndexKeyValueToPartialRecord indexKeyValueToPartialRecord;
        @Nonnull
        private final List<Value> logicalKeyValues;
        @Nonnull
        private final List<Value> logicalValueValues;

        public IndexEntryToLogicalRecord(@Nonnull RecordType queriedRecordType, @Nonnull IndexKeyValueToPartialRecord indexKeyValueToPartialRecord, @Nonnull List<Value> logicalKeyValues, @Nonnull List<Value> logicalValueValues) {
            this.queriedRecordType = queriedRecordType;
            this.indexKeyValueToPartialRecord = indexKeyValueToPartialRecord;
            this.logicalKeyValues = logicalKeyValues;
            this.logicalValueValues = logicalValueValues;
        }

        @Nonnull
        public RecordType getQueriedRecordType() {
            return this.queriedRecordType;
        }

        @Nonnull
        public IndexKeyValueToPartialRecord getIndexKeyValueToPartialRecord() {
            return this.indexKeyValueToPartialRecord;
        }

        @Nonnull
        public List<Value> getLogicalKeyValues() {
            return this.logicalKeyValues;
        }

        @Nonnull
        public List<Value> getLogicalValueValues() {
            return this.logicalValueValues;
        }
    }
}

