/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpressionVisitorWithDefaults;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public interface SimpleExpressionVisitor<T>
extends RelationalExpressionVisitorWithDefaults<T> {
    default public boolean shouldVisit(@Nonnull RelationalExpression expression) {
        return true;
    }

    default public boolean shouldVisit(@Nonnull Reference ref) {
        return true;
    }

    default public boolean shouldVisit(@Nonnull Quantifier quantifier) {
        return true;
    }

    @Nonnull
    public T evaluateAtExpression(@Nonnull RelationalExpression var1, @Nonnull List<T> var2);

    @Nonnull
    public T evaluateAtRef(@Nonnull Reference var1, @Nonnull List<T> var2);

    @Nonnull
    @SpotBugsSuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
    default public T evaluateAtQuantifier(@Nonnull Quantifier quantifier, @Nullable T rangesOverResult) {
        return Objects.requireNonNull(rangesOverResult);
    }

    @Override
    @Nonnull
    default public T visitDefault(@Nonnull RelationalExpression relationalExpression) {
        List<T> quantifierResults = this.visitQuantifiers(relationalExpression);
        return this.evaluateAtExpression(relationalExpression, quantifierResults);
    }

    @Nonnull
    default public List<T> visitQuantifiers(@Nonnull RelationalExpression relationalExpression) {
        List<? extends Quantifier> quantifiers = relationalExpression.getQuantifiers();
        ArrayList quantifierResults = Lists.newArrayListWithCapacity(quantifiers.size());
        for (Quantifier quantifier : quantifiers) {
            quantifierResults.add(quantifier.acceptVisitor(this));
        }
        return quantifierResults;
    }
}

