/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.ProtoSerializable;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.planprotos.PQueryResult;
import com.apple.foundationdb.record.planprotos.PTempTable;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.ZeroCopyByteString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TempTable
implements ProtoSerializable {
    @Nonnull
    private final List<QueryResult> underlyingBuffer;
    @Nonnull
    private final PTempTable.Builder protoBuilder;
    @Nullable
    private PTempTable cachedProto;

    private TempTable() {
        this(Collections.synchronizedList(new ArrayList()), PTempTable.newBuilder());
    }

    private TempTable(@Nonnull List<QueryResult> buffer, @Nonnull PTempTable.Builder protoBuilder) {
        this.underlyingBuffer = buffer;
        this.protoBuilder = protoBuilder;
        this.cachedProto = null;
    }

    public void add(@Nonnull QueryResult element) {
        this.underlyingBuffer.add(element);
        this.protoBuilder.addBufferItems(element.toProto());
        this.cachedProto = null;
    }

    public void clear() {
        this.underlyingBuffer.clear();
        this.protoBuilder.clearBufferItems();
        this.cachedProto = null;
    }

    public boolean isEmpty() {
        return this.underlyingBuffer.isEmpty();
    }

    @Nonnull
    public Iterator<QueryResult> getIterator() {
        return this.underlyingBuffer.iterator();
    }

    @Nonnull
    public List<QueryResult> getList() {
        return this.underlyingBuffer;
    }

    @Override
    @Nonnull
    public PTempTable toProto() {
        if (this.cachedProto == null) {
            this.cachedProto = this.protoBuilder.build();
        }
        return this.cachedProto;
    }

    @Nonnull
    public static TempTable from(@Nonnull byte[] bytes, @Nullable Descriptors.Descriptor descriptor) {
        return TempTable.from(ZeroCopyByteString.wrap(bytes), descriptor);
    }

    @Nonnull
    public static TempTable from(@Nonnull ByteString byteString, @Nullable Descriptors.Descriptor descriptor) {
        PTempTable tempTableProto;
        try {
            tempTableProto = PTempTable.parseFrom(byteString);
        }
        catch (InvalidProtocolBufferException ex) {
            throw new RecordCoreException("invalid bytes", ex).addLogInfo(new Object[]{LogMessageKeys.RAW_BYTES, ByteArrayUtil2.loggable(byteString.toByteArray())});
        }
        return TempTable.from(tempTableProto, descriptor);
    }

    @Nonnull
    public static TempTable from(@Nonnull PTempTable tempTableProto, @Nullable Descriptors.Descriptor descriptor) {
        LinkedList<QueryResult> underlyingBuffer = new LinkedList<QueryResult>();
        for (PQueryResult element : tempTableProto.getBufferItemsList()) {
            underlyingBuffer.add(QueryResult.from(descriptor, element));
        }
        return new TempTable(underlyingBuffer, tempTableProto.toBuilder());
    }

    @Nonnull
    private static TempTable newInstance() {
        return new TempTable();
    }

    public static class Factory {
        @VisibleForTesting
        @SpotBugsSuppressWarnings(value={"SING_SINGLETON_HAS_NONPRIVATE_CONSTRUCTOR"}, justification="This is made non-private for testing through dependency injection")
        protected Factory() {
        }

        @Nonnull
        public TempTable createTempTable() {
            return TempTable.newInstance();
        }

        @Nonnull
        public static Factory instance() {
            return new Factory();
        }
    }
}

