/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentityMap;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentitySet;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.NetworkBuilder;
import com.google.common.graph.StableStandardMutableNetwork;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class Traversal {
    @Nonnull
    private final Reference rootReference;
    @Nonnull
    private final MutableNetwork<Reference, ReferencePath> network;
    @Nonnull
    private final SetMultimap<RelationalExpression, Reference> containedInMultiMap;
    @Nonnull
    private final Set<Reference> leafReferences;

    private Traversal(@Nonnull Reference rootReference, @Nonnull MutableNetwork<Reference, ReferencePath> network, @Nonnull SetMultimap<RelationalExpression, Reference> containedInMultiMap, @Nonnull Set<Reference> leafReferences) {
        this.rootReference = rootReference;
        this.network = network;
        this.containedInMultiMap = containedInMultiMap;
        this.leafReferences = leafReferences;
    }

    @Nonnull
    public Reference getRootReference() {
        return this.rootReference;
    }

    @Nonnull
    public Set<Reference> getRefs() {
        return this.network.nodes();
    }

    @Nonnull
    public Set<Reference> getLeafReferences() {
        return this.leafReferences;
    }

    public Set<Reference> getRefsContaining(RelationalExpression expression) {
        Collection result = this.containedInMultiMap.get((Object)expression);
        Debugger.sanityCheck(() -> Traversal.lambda$getRefsContaining$2((Set)result, expression));
        return result;
    }

    @Nonnull
    public Set<Reference> getParentRefs(@Nonnull Reference reference) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.forEachParentExpression(reference, (ref, expression) -> builder.add(ref));
        return builder.build();
    }

    @Nonnull
    public Set<RelationalExpression> getParentExpressions(@Nonnull Reference reference) {
        Set<RelationalExpression> result = Sets.newIdentityHashSet();
        this.forEachParentExpression(reference, (ref, expression) -> result.add((RelationalExpression)expression));
        return result;
    }

    @Nonnull
    public Set<ReferencePath> getParentRefPaths(@Nonnull Reference reference) {
        return this.network.outEdges(reference);
    }

    public void forEachParentExpression(@Nonnull Reference reference, @Nonnull BiConsumer<Reference, RelationalExpression> biConsumer) {
        Set referencePaths = this.network.outEdges(reference);
        for (ReferencePath referencePath : referencePaths) {
            EndpointPair incidentNodes = this.network.incidentNodes(referencePath);
            biConsumer.accept((Reference)incidentNodes.target(), referencePath.getExpression());
        }
    }

    public void addExpression(@Nonnull Reference reference, @Nonnull RelationalExpression expression) {
        Traversal.descendAndAddExpressions(this.network, this.containedInMultiMap, this.leafReferences, reference, expression);
        Debugger.sanityCheck(() -> Verify.verify(reference.containsExactly(expression)));
        this.containedInMultiMap.put(expression, reference);
        if (expression.getQuantifiers().isEmpty()) {
            this.leafReferences.add(reference);
        }
    }

    public void removeExpression(@Nonnull Reference reference, @Nonnull RelationalExpression expression) {
        ImmutableSet<ReferencePath> referencePaths = ImmutableSet.copyOf(this.network.inEdges(reference));
        LinkedIdentitySet<Reference> childrenReferences = new LinkedIdentitySet<Reference>();
        for (ReferencePath referencePath : referencePaths) {
            if (referencePath.expression == expression) {
                this.network.removeEdge(referencePath);
            }
            childrenReferences.add(referencePath.getQuantifier().getRangesOver());
        }
        this.pruneUnreferencedRefs(childrenReferences);
        this.containedInMultiMap.remove(expression, reference);
        if (this.leafReferences.contains(reference)) {
            boolean stillHasLeaf = false;
            for (RelationalExpression otherRefExpression : reference.getAllMemberExpressions()) {
                if (!this.containedInMultiMap.containsEntry(otherRefExpression, reference) || !otherRefExpression.getQuantifiers().isEmpty()) continue;
                stillHasLeaf = true;
                break;
            }
            if (!stillHasLeaf) {
                this.leafReferences.remove(reference);
            }
        }
    }

    public void pruneUnreferencedRefs(@Nonnull Collection<? extends Reference> childrenReferences) {
        for (Reference reference : childrenReferences) {
            if (this.network.outDegree(reference) != 0) continue;
            for (RelationalExpression memberExpression : reference.getAllMemberExpressions()) {
                this.removeExpression(reference, memberExpression);
            }
            this.network.removeNode(reference);
        }
    }

    public static Traversal withRoot(Reference rootRef) {
        StableStandardMutableNetwork<Reference, ReferencePath> network = new StableStandardMutableNetwork<Reference, ReferencePath>(NetworkBuilder.directed().allowsParallelEdges(true).allowsSelfLoops(true).edgeOrder(ElementOrder.insertion()).nodeOrder(ElementOrder.insertion()));
        SetMultimap<RelationalExpression, Reference> containedInMap = Multimaps.newSetMultimap(new LinkedIdentityMap(), LinkedIdentitySet::new);
        LinkedIdentitySet<Reference> leafRefs = new LinkedIdentitySet<Reference>();
        Traversal.collectNetwork(network, containedInMap, leafRefs, rootRef);
        return new Traversal(rootRef, network, containedInMap, leafRefs);
    }

    private static void collectNetwork(@Nonnull MutableNetwork<Reference, ReferencePath> network, @Nonnull SetMultimap<RelationalExpression, Reference> containedInMultiMap, @Nonnull Set<Reference> leafReferences, @Nonnull Reference reference) {
        if (network.addNode(reference)) {
            boolean anyLeafExpressions = false;
            for (RelationalExpression expression : reference.getAllMemberExpressions()) {
                if (expression.getQuantifiers().isEmpty()) {
                    anyLeafExpressions = true;
                } else {
                    Traversal.descendAndAddExpressions(network, containedInMultiMap, leafReferences, reference, expression);
                }
                containedInMultiMap.put(expression, reference);
            }
            if (anyLeafExpressions) {
                leafReferences.add(reference);
            }
        }
    }

    private static void descendAndAddExpressions(@Nonnull MutableNetwork<Reference, ReferencePath> network, @Nonnull SetMultimap<RelationalExpression, Reference> containedInMultiMap, @Nonnull Set<Reference> leafReferences, @Nonnull Reference reference, RelationalExpression expression) {
        network.addNode(reference);
        for (Quantifier quantifier : expression.getQuantifiers()) {
            Reference rangesOverRef = quantifier.getRangesOver();
            Traversal.collectNetwork(network, containedInMultiMap, leafReferences, rangesOverRef);
            network.addEdge(rangesOverRef, reference, new ReferencePath(reference, expression, quantifier));
        }
    }

    public void verifyIntegrity() {
        Traversal secondTraversal = Traversal.withRoot(this.rootReference);
        Set missingNodes = secondTraversal.network.nodes().stream().filter(ref -> !this.network.nodes().contains(ref)).collect(LinkedIdentitySet.toLinkedIdentitySet());
        Verify.verify(missingNodes.isEmpty(), "graph is missing %d nodes", missingNodes.size());
        Set missingLeafNodes = secondTraversal.leafReferences.stream().filter(ref -> !this.leafReferences.contains(ref)).collect(LinkedIdentitySet.toLinkedIdentitySet());
        Verify.verify(missingLeafNodes.isEmpty(), "graph is missing %s leaf nodes", missingLeafNodes.size());
        Set missingContainedIns = secondTraversal.containedInMultiMap.entries().stream().filter(entry -> !this.containedInMultiMap.containsEntry(entry.getKey(), entry.getValue())).collect(LinkedIdentitySet.toLinkedIdentitySet());
        Verify.verify(missingContainedIns.isEmpty(), "traversal is missing %s containedIn entries", missingContainedIns.size());
        for (Reference ref2 : secondTraversal.network.nodes()) {
            Set expectedOut = secondTraversal.network.outEdges(ref2);
            Set edgesOut = this.network.outEdges(ref2);
            Set missingEdges = expectedOut.stream().filter(path -> !edgesOut.contains(path)).collect(LinkedIdentitySet.toLinkedIdentitySet());
            Verify.verify(missingEdges.isEmpty(), "missing %s expected edges for reference %s", missingEdges.size(), (Object)ref2);
        }
        Set extraNodes = this.network.nodes().stream().filter(ref -> !secondTraversal.network.nodes().contains(ref)).collect(LinkedIdentitySet.toLinkedIdentitySet());
        Verify.verify(extraNodes.isEmpty(), "network contains %s extra nodes", extraNodes.size());
        Set extraLeafs = this.leafReferences.stream().filter(ref -> !secondTraversal.leafReferences.contains(ref)).collect(LinkedIdentitySet.toLinkedIdentitySet());
        Verify.verify(extraLeafs.isEmpty(), "network contains %s extra leaf nodes", extraLeafs.size());
        Set extraContainedIn = this.containedInMultiMap.entries().stream().filter(entry -> !secondTraversal.containedInMultiMap.containsEntry(entry.getKey(), entry.getValue())).collect(LinkedIdentitySet.toLinkedIdentitySet());
        Verify.verify(extraContainedIn.isEmpty(), "contained in map contains %s extra entries", extraContainedIn.size());
        for (Reference ref3 : this.network.nodes()) {
            Set edgesOut = this.network.outEdges(ref3);
            Set expectedOut = secondTraversal.network.outEdges(ref3);
            Set extraEdges = edgesOut.stream().filter(path -> !expectedOut.contains(path)).collect(LinkedIdentitySet.toLinkedIdentitySet());
            Verify.verify(extraEdges.isEmpty(), "network contained %s expected edges for reference %s", extraEdges.size(), (Object)ref3);
        }
    }

    private static /* synthetic */ void lambda$getRefsContaining$2(Set result, RelationalExpression expression) {
        Verify.verify(result.stream().allMatch(ref -> ref.getAllMemberExpressions().stream().anyMatch(e -> e == expression)));
    }

    public static class ReferencePath {
        @Nonnull
        private final Reference reference;
        @Nonnull
        private final RelationalExpression expression;
        @Nonnull
        private final Quantifier quantifier;

        public ReferencePath(@Nonnull Reference reference, @Nonnull RelationalExpression expression, @Nonnull Quantifier quantifier) {
            this.reference = reference;
            this.expression = expression;
            this.quantifier = quantifier;
        }

        @Nonnull
        public Reference getReference() {
            return this.reference;
        }

        @Nonnull
        public RelationalExpression getExpression() {
            return this.expression;
        }

        @Nonnull
        public Quantifier getQuantifier() {
            return this.quantifier;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ReferencePath that = (ReferencePath)object;
            return this.reference == that.reference && this.expression == that.expression && this.quantifier == that.quantifier;
        }

        public int hashCode() {
            return Objects.hash(System.identityHashCode(this.reference), System.identityHashCode(this.expression), System.identityHashCode(this.quantifier));
        }
    }
}

