/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.query.plan.cascades.PreOrderIterator;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface TreeLike<T extends TreeLike<T>> {
    @Nonnull
    public T getThis();

    @Nonnull
    public Iterable<? extends T> getChildren();

    @Nonnull
    public T withChildren(Iterable<? extends T> var1);

    @Nonnull
    default public PreOrderIterator<T> preOrderIterator() {
        return PreOrderIterator.over(this.getThis());
    }

    default public Iterator<T> preOrderIterator(@Nonnull Predicate<T> descendInChildren) {
        return PreOrderIterator.over(this.getThis()).descendOnlyIf(descendInChildren);
    }

    @Nonnull
    default public Stream<T> preOrderStream() {
        return Streams.stream(this.preOrderIterator());
    }

    @Nonnull
    default public Iterable<? extends T> preOrderIterable() {
        return this.preOrderIterable(treeLike -> true);
    }

    @Nonnull
    default public Iterable<? extends T> preOrderIterable(@Nonnull Predicate<T> descentIntoPredicate) {
        return () -> this.preOrderIterator(descentIntoPredicate);
    }

    @Nonnull
    default public Stream<T> postOrderStream() {
        return Streams.stream(this.postOrderIterable());
    }

    @Nonnull
    default public Iterable<T> postOrderIterable() {
        ImmutableList.Builder iterablesBuilder = ImmutableList.builder();
        for (TreeLike child : this.getChildren()) {
            iterablesBuilder.add(child.postOrderIterable());
        }
        iterablesBuilder.add(ImmutableList.of(this.getThis()));
        return Iterables.concat(iterablesBuilder.build());
    }

    @Nonnull
    default public <M, F> F fold(@Nonnull NonnullFunction<T, M> mapFunction, @Nonnull NonnullBiFunction<M, Iterable<? extends F>, F> foldFunction) {
        M mappedThis = mapFunction.apply(this.getThis());
        ImmutableList.Builder foldedChildrenBuilder = ImmutableList.builder();
        for (TreeLike child : this.getChildren()) {
            foldedChildrenBuilder.add(child.fold(mapFunction, foldFunction));
        }
        return foldFunction.apply(mappedThis, foldedChildrenBuilder.build());
    }

    @Nullable
    default public <M, F> F foldNullable(@Nonnull Function<T, M> mapFunction, @Nonnull BiFunction<M, Iterable<? extends F>, F> foldFunction) {
        M mappedThis = mapFunction.apply(this.getThis());
        ArrayList<F> foldedChildren = Lists.newArrayList();
        for (TreeLike child : this.getChildren()) {
            foldedChildren.add(child.foldNullable(mapFunction, foldFunction));
        }
        return foldFunction.apply(mappedThis, foldedChildren);
    }

    @Nonnull
    default public <V extends TreeLike<V>> Optional<V> mapMaybe(@Nonnull BiFunction<T, Iterable<? extends V>, V> foldFunction) {
        return Optional.ofNullable((TreeLike)this.foldNullable(Function.identity(), foldFunction));
    }

    @Nonnull
    default public Optional<T> replaceLeavesMaybe(@Nonnull UnaryOperator<T> replaceOperator) {
        return this.replaceLeavesMaybe(replaceOperator, false);
    }

    @Nonnull
    default public Optional<T> replaceLeavesMaybe(@Nonnull UnaryOperator<T> replaceOperator, boolean visitNewLeaves) {
        if (visitNewLeaves) {
            return Optional.ofNullable(this.replace(node -> {
                if (Iterables.isEmpty(node.getChildren())) {
                    return (TreeLike)replaceOperator.apply(node);
                }
                return node;
            }));
        }
        Set newLeaves = Sets.newIdentityHashSet();
        return Optional.ofNullable(this.replace(node -> {
            if (!newLeaves.contains(node) && Iterables.isEmpty(node.getChildren())) {
                TreeLike result = (TreeLike)replaceOperator.apply(node);
                if (result != null) {
                    result.preOrderStream().filter(n -> Iterables.isEmpty(n.getChildren())).forEach(newLeaves::add);
                }
                return result;
            }
            return node;
        }));
    }

    @Nullable
    default public T replace(@Nonnull UnaryOperator<T> replacementOperator) {
        T self = this.getThis();
        TreeLike maybeReplaced = (TreeLike)replacementOperator.apply(self);
        if (maybeReplaced == null) {
            return null;
        }
        if (Iterables.isEmpty(maybeReplaced.getChildren())) {
            return (T)maybeReplaced;
        }
        Iterable<T> children = maybeReplaced.getChildren();
        int childrenCount = Iterables.size(children);
        boolean isAdding = false;
        ImmutableList.Builder replacedChildren = null;
        for (int i = 0; i < childrenCount; ++i) {
            TreeLike child = (TreeLike)Iterables.get(children, i);
            T maybeReplacedChild = child.replace(replacementOperator);
            if (maybeReplacedChild == null) {
                return null;
            }
            if (isAdding) {
                Verify.verifyNotNull(replacedChildren);
                replacedChildren.add(maybeReplacedChild);
                continue;
            }
            if (maybeReplacedChild == child) continue;
            replacedChildren = ImmutableList.builder();
            for (int j = 0; j < i; ++j) {
                replacedChildren.add((TreeLike)Iterables.get(children, j));
            }
            replacedChildren.add(maybeReplacedChild);
            isAdding = true;
        }
        return (T)(replacedChildren != null ? maybeReplaced.withChildren(replacedChildren.build()) : maybeReplaced);
    }

    default public int height() {
        if (Iterables.isEmpty(this.getChildren())) {
            return 0;
        }
        return 1 + Streams.stream(this.getChildren()).mapToInt(TreeLike::height).max().orElseThrow();
    }

    default public int diameter() {
        return this.diameterWithConnectingEdgeFunction(current -> Math.min(Iterables.size(current.getChildren()), 2));
    }

    default public int diameterWithLevelCounting() {
        return this.diameterWithConnectingEdgeFunction(current -> Iterables.size(current.getChildren()));
    }

    default public int diameterWithConnectingEdgeFunction(Function<TreeLike<T>, Integer> customConnectingEdgeFunc) {
        if (Iterables.isEmpty(this.getChildren())) {
            return 0;
        }
        int maxChildDiameter = 0;
        int maxChildHeight = 0;
        int secondMaxChildHeight = 0;
        int connectingEdgesCount = customConnectingEdgeFunc.apply(this);
        for (TreeLike child : this.getChildren()) {
            int height;
            int diameter = child.diameterWithConnectingEdgeFunction(customConnectingEdgeFunc);
            if (diameter > maxChildDiameter) {
                maxChildDiameter = diameter;
            }
            if ((height = child.height()) > maxChildHeight) {
                secondMaxChildHeight = maxChildHeight;
                maxChildHeight = height;
                continue;
            }
            if (height <= secondMaxChildHeight) continue;
            secondMaxChildHeight = height;
        }
        return Math.max(connectingEdgesCount + maxChildHeight + secondMaxChildHeight, maxChildDiameter);
    }

    @FunctionalInterface
    public static interface NonnullFunction<T, R> {
        @Nonnull
        public R apply(@Nonnull T var1);
    }

    @FunctionalInterface
    public static interface NonnullBiFunction<T, U, R> {
        @Nonnull
        public R apply(@Nonnull T var1, @Nonnull U var2);
    }
}

