/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.query.plan.cascades.ConstrainedBoolean;
import com.apple.foundationdb.record.query.plan.cascades.ValueEquivalence;
import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.google.common.base.Verify;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface UsesValueEquivalence<T extends UsesValueEquivalence<T>> {
    @Nonnull
    default public ConstrainedBoolean semanticEquals(@Nullable Object other, @Nonnull ValueEquivalence valueEquivalence) {
        if (this == other) {
            return ConstrainedBoolean.alwaysTrue();
        }
        Class<?> thisClass = this.getClass();
        if (other == null || thisClass != other.getClass()) {
            return ConstrainedBoolean.falseValue();
        }
        ConstrainedBoolean thisOther = this.semanticEqualsTyped((UsesValueEquivalence)other, valueEquivalence);
        Debugger.sanityCheck(() -> {
            Optional<ValueEquivalence> inverseValueEquivalenceMaybe = valueEquivalence.inverseMaybe();
            Verify.verify(inverseValueEquivalenceMaybe.isPresent());
            ConstrainedBoolean otherThis = ((UsesValueEquivalence)other).semanticEqualsTyped(this, inverseValueEquivalenceMaybe.get());
            Verify.verify(thisOther.isTrue() == otherThis.isTrue());
        });
        return thisOther;
    }

    @Nonnull
    public ConstrainedBoolean semanticEqualsTyped(@Nonnull T var1, @Nonnull ValueEquivalence var2);
}

