/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.QueryPlanConstraint;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.ConstrainedBoolean;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.UsesValueEquivalence;
import com.apple.foundationdb.record.query.plan.cascades.predicates.ValuePredicate;
import com.apple.foundationdb.record.query.plan.cascades.values.ConstantObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.LiteralValue;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public abstract class ValueEquivalence {
    @Nonnull
    private final Supplier<Optional<ValueEquivalence>> inverseOptionalSupplier = Suppliers.memoize(this::computeInverseMaybe);
    static final ValueEquivalence EMPTY_EQUIVALENCE = new ValueEquivalence(){

        @Override
        @Nonnull
        public ConstrainedBoolean isDefinedEqual(@Nonnull Value left, @Nonnull Value right) {
            return ConstrainedBoolean.falseValue();
        }

        @Override
        @Nonnull
        public ConstrainedBoolean isDefinedEqual(@Nonnull CorrelationIdentifier left, @Nonnull CorrelationIdentifier right) {
            return ConstrainedBoolean.falseValue();
        }

        @Override
        @Nonnull
        protected Optional<ValueEquivalence> computeInverseMaybe() {
            return Optional.of(this);
        }
    };

    protected ValueEquivalence() {
    }

    @Nonnull
    public abstract ConstrainedBoolean isDefinedEqual(@Nonnull Value var1, @Nonnull Value var2);

    @Nonnull
    public abstract ConstrainedBoolean isDefinedEqual(@Nonnull CorrelationIdentifier var1, @Nonnull CorrelationIdentifier var2);

    @Nonnull
    public Optional<ValueEquivalence> inverseMaybe() {
        return this.inverseOptionalSupplier.get();
    }

    @Nonnull
    protected abstract Optional<ValueEquivalence> computeInverseMaybe();

    @Nonnull
    public <T extends UsesValueEquivalence<T>> ConstrainedBoolean semanticEquals(@Nonnull Set<T> left, @Nonnull Set<T> right) {
        if (left.size() != right.size()) {
            return ConstrainedBoolean.falseValue();
        }
        ConstrainedBoolean booleanWithConstraint = ConstrainedBoolean.alwaysTrue();
        for (UsesValueEquivalence l : left) {
            boolean found = false;
            for (UsesValueEquivalence r : right) {
                ConstrainedBoolean semanticEquals = l.semanticEquals(r, this);
                if (!semanticEquals.isTrue()) continue;
                found = true;
                booleanWithConstraint = booleanWithConstraint.composeWithOther(semanticEquals);
                break;
            }
            if (found) continue;
            return ConstrainedBoolean.falseValue();
        }
        return booleanWithConstraint;
    }

    @Nonnull
    public static ValueEquivalence empty() {
        return EMPTY_EQUIVALENCE;
    }

    @Nonnull
    public ValueEquivalence then(@Nonnull ValueEquivalence thenEquivalence) {
        return new ThenEquivalence(this, thenEquivalence);
    }

    @Nonnull
    public static ValueMap.Builder valueMapBuilder() {
        return new ValueMap.Builder();
    }

    @Nonnull
    public static ValueEquivalence fromAliasMap(@Nonnull AliasMap aliasMap) {
        return new AliasMapBackedValueEquivalence(aliasMap);
    }

    @Nonnull
    public static ValueEquivalence constantEquivalenceWithEvaluationContext(@Nonnull EvaluationContext evaluationContext) {
        return new ConstantValueEquivalence(evaluationContext);
    }

    public static final class ThenEquivalence
    extends ValueEquivalence {
        @Nonnull
        private final ValueEquivalence first;
        @Nonnull
        private final ValueEquivalence then;

        public ThenEquivalence(@Nonnull ValueEquivalence first, @Nonnull ValueEquivalence then) {
            this.first = first;
            this.then = then;
        }

        @Override
        @Nonnull
        public ConstrainedBoolean isDefinedEqual(@Nonnull Value left, @Nonnull Value right) {
            ConstrainedBoolean firstEquivalence = this.first.isDefinedEqual(left, right);
            if (firstEquivalence.isTrue()) {
                return firstEquivalence;
            }
            return this.then.isDefinedEqual(left, right);
        }

        @Override
        @Nonnull
        public ConstrainedBoolean isDefinedEqual(@Nonnull CorrelationIdentifier left, @Nonnull CorrelationIdentifier right) {
            ConstrainedBoolean firstEquivalence = this.first.isDefinedEqual(left, right);
            if (firstEquivalence.isTrue()) {
                return firstEquivalence;
            }
            return this.then.isDefinedEqual(left, right);
        }

        @Override
        @Nonnull
        protected Optional<ValueEquivalence> computeInverseMaybe() {
            return this.first.inverseMaybe().flatMap(inverseFirst -> {
                Optional<ValueEquivalence> inverseThenOptional = this.then.inverseMaybe();
                if (inverseThenOptional.isEmpty()) {
                    return Optional.empty();
                }
                return Optional.of(new ThenEquivalence((ValueEquivalence)inverseFirst, inverseThenOptional.get()));
            });
        }
    }

    public static final class ValueMap
    extends ValueEquivalence {
        @Nonnull
        private final Map<Value, Value> valueEquivalenceMap;
        @Nonnull
        private final Map<Value, Supplier<QueryPlanConstraint>> valueConstraintSupplierMap;

        private ValueMap(@Nonnull Map<Value, Value> valueEquivalenceMap, @Nonnull Map<Value, Supplier<QueryPlanConstraint>> valueConstraintSupplierMap) {
            this.valueEquivalenceMap = ImmutableMap.copyOf(valueEquivalenceMap);
            this.valueConstraintSupplierMap = ImmutableMap.copyOf(valueConstraintSupplierMap);
        }

        @Override
        @Nonnull
        @SpotBugsSuppressWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
        public ConstrainedBoolean isDefinedEqual(@Nonnull Value left, @Nonnull Value right) {
            Value rightFromMap = this.valueEquivalenceMap.get(left);
            if (rightFromMap == null || !rightFromMap.equals(right)) {
                return ConstrainedBoolean.falseValue();
            }
            return ConstrainedBoolean.trueWithConstraint(Objects.requireNonNull(Objects.requireNonNull(this.valueConstraintSupplierMap.get(left)).get()));
        }

        @Override
        @Nonnull
        public ConstrainedBoolean isDefinedEqual(@Nonnull CorrelationIdentifier left, @Nonnull CorrelationIdentifier right) {
            return ConstrainedBoolean.falseValue();
        }

        @Override
        @Nonnull
        protected Optional<ValueEquivalence> computeInverseMaybe() {
            LinkedHashMap<Value, Value> inverseValueEquivalenceMap = new LinkedHashMap<Value, Value>();
            LinkedHashMap<Value, Supplier<QueryPlanConstraint>> inverseValueConstraintSupplierMap = new LinkedHashMap<Value, Supplier<QueryPlanConstraint>>();
            for (Map.Entry<Value, Value> entry : this.valueEquivalenceMap.entrySet()) {
                if (inverseValueEquivalenceMap.put(entry.getValue(), entry.getKey()) != null) {
                    return Optional.empty();
                }
                inverseValueConstraintSupplierMap.put(entry.getValue(), this.valueConstraintSupplierMap.get(entry.getKey()));
            }
            return Optional.of(new ValueMap(inverseValueEquivalenceMap, inverseValueConstraintSupplierMap));
        }

        public static class Builder {
            @Nonnull
            private final Map<Value, Value> valueEquivalenceMap;
            @Nonnull
            private final Map<Value, Supplier<QueryPlanConstraint>> valueConstraintSupplierMap;

            private Builder() {
                this(new LinkedHashMap<Value, Value>(), new LinkedHashMap<Value, Supplier<QueryPlanConstraint>>());
            }

            private Builder(@Nonnull Map<Value, Value> valueEquivalenceMap, @Nonnull Map<Value, Supplier<QueryPlanConstraint>> valueConstraintSupplierMap) {
                this.valueEquivalenceMap = valueEquivalenceMap;
                this.valueConstraintSupplierMap = valueConstraintSupplierMap;
            }

            @Nonnull
            public Builder add(@Nonnull Value left, @Nonnull Value right, @Nonnull Supplier<QueryPlanConstraint> planConstraintSupplier) {
                if (this.valueEquivalenceMap.put(left, right) != null) {
                    throw new RecordCoreException("duplicate mapping", new Object[0]);
                }
                if (this.valueConstraintSupplierMap.put(left, planConstraintSupplier) != null) {
                    throw new RecordCoreException("duplicate constraint mapping", new Object[0]);
                }
                return this;
            }

            @Nonnull
            public ValueMap build() {
                return new ValueMap(this.valueEquivalenceMap, this.valueConstraintSupplierMap);
            }
        }
    }

    public static final class AliasMapBackedValueEquivalence
    extends ValueEquivalence {
        @Nonnull
        private final AliasMap aliasMap;

        public AliasMapBackedValueEquivalence(@Nonnull AliasMap aliasMap) {
            this.aliasMap = aliasMap;
        }

        @Override
        @Nonnull
        public ConstrainedBoolean isDefinedEqual(@Nonnull Value left, @Nonnull Value right) {
            CorrelationIdentifier rightAlias;
            if (!(left instanceof QuantifiedValue) || !(right instanceof QuantifiedValue)) {
                return ConstrainedBoolean.falseValue();
            }
            if (left.getClass() != right.getClass()) {
                return ConstrainedBoolean.falseValue();
            }
            CorrelationIdentifier leftAlias = ((QuantifiedValue)left).getAlias();
            if (this.aliasMap.containsMapping(leftAlias, rightAlias = ((QuantifiedValue)right).getAlias())) {
                return ConstrainedBoolean.alwaysTrue();
            }
            return ConstrainedBoolean.falseValue();
        }

        @Override
        @Nonnull
        public ConstrainedBoolean isDefinedEqual(@Nonnull CorrelationIdentifier left, @Nonnull CorrelationIdentifier right) {
            return this.aliasMap.containsMapping(left, right) ? ConstrainedBoolean.alwaysTrue() : ConstrainedBoolean.falseValue();
        }

        @Override
        @Nonnull
        protected Optional<ValueEquivalence> computeInverseMaybe() {
            return Optional.of(new AliasMapBackedValueEquivalence(this.aliasMap.inverse()));
        }
    }

    public static class ConstantValueEquivalence
    extends ValueEquivalence {
        @Nonnull
        private final EvaluationContext evaluationContext;

        public ConstantValueEquivalence(@Nonnull EvaluationContext evaluationContext) {
            this.evaluationContext = evaluationContext;
        }

        @Override
        @Nonnull
        public ConstrainedBoolean isDefinedEqual(@Nonnull Value left, @Nonnull Value right) {
            if (left instanceof ConstantObjectValue && right instanceof LiteralValue) {
                return this.isDefinedEqual((ConstantObjectValue)left, (LiteralValue)right);
            }
            if (right instanceof ConstantObjectValue && left instanceof LiteralValue) {
                return this.isDefinedEqual((ConstantObjectValue)right, (LiteralValue)left);
            }
            return ConstrainedBoolean.falseValue();
        }

        @Nonnull
        @SpotBugsSuppressWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="evalWithoutStore can return nullable")
        public ConstrainedBoolean isDefinedEqual(@Nonnull ConstantObjectValue constantObjectValue, @Nonnull LiteralValue<?> literalValue) {
            Object constantObject = constantObjectValue.evalWithoutStore(this.evaluationContext);
            Object literalObject = literalValue.getLiteralValue();
            if (constantObject == null && literalObject == null) {
                return ConstrainedBoolean.trueWithConstraint(QueryPlanConstraint.ofPredicate(new ValuePredicate(constantObjectValue, new Comparisons.NullComparison(Comparisons.Type.IS_NULL))));
            }
            if (constantObject == null || literalObject == null) {
                return ConstrainedBoolean.falseValue();
            }
            boolean comparisonResult = Objects.requireNonNull(Comparisons.evalComparison(Comparisons.Type.EQUALS, constantObject, literalValue.getLiteralValue()));
            if (comparisonResult) {
                return ConstrainedBoolean.trueWithConstraint(QueryPlanConstraint.ofPredicate(new ValuePredicate(constantObjectValue, new Comparisons.SimpleComparison(Comparisons.Type.EQUALS, literalObject))));
            }
            return ConstrainedBoolean.falseValue();
        }

        @Override
        @Nonnull
        public ConstrainedBoolean isDefinedEqual(@Nonnull CorrelationIdentifier left, @Nonnull CorrelationIdentifier right) {
            return ConstrainedBoolean.falseValue();
        }

        @Override
        @Nonnull
        protected Optional<ValueEquivalence> computeInverseMaybe() {
            return Optional.of(this);
        }
    }
}

