/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyWithValueExpression;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.ExpansionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.GraphExpansion;
import com.apple.foundationdb.record.query.plan.cascades.IndexPredicateExpansion;
import com.apple.foundationdb.record.query.plan.cascades.KeyExpressionExpansionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.MatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.Traversal;
import com.apple.foundationdb.record.query.plan.cascades.ValueIndexScanMatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.apple.foundationdb.record.query.plan.cascades.expressions.MatchableSortExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.predicates.Placeholder;
import com.apple.foundationdb.record.query.plan.cascades.predicates.PredicateWithValueAndRanges;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.RangeConstraints;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ValueIndexExpansionVisitor
extends KeyExpressionExpansionVisitor
implements ExpansionVisitor<KeyExpressionExpansionVisitor.VisitorState> {
    @Nonnull
    private static final Set<String> GROUPED_INDEX_TYPES = Set.of("rank", "permuted_max", "permuted_min");
    @Nonnull
    private final Index index;
    @Nonnull
    private final List<RecordType> queriedRecordTypes;

    public ValueIndexExpansionVisitor(@Nonnull Index index, @Nonnull Collection<RecordType> queriedRecordTypes) {
        this.index = index;
        this.queriedRecordTypes = ImmutableList.copyOf(queriedRecordTypes);
    }

    @Override
    @Nonnull
    @SpotBugsSuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
    public MatchCandidate expand(@Nonnull Supplier<Quantifier.ForEach> baseQuantifierSupplier, @Nullable KeyExpression primaryKey, boolean isReverse) {
        int keyValueSplitPoint;
        Debugger.updateIndex(PredicateWithValueAndRanges.class, old -> 0);
        Quantifier.ForEach baseQuantifier = baseQuantifierSupplier.get();
        ImmutableList.Builder allExpansionsBuilder = ImmutableList.builder();
        allExpansionsBuilder.add(GraphExpansion.ofQuantifier(baseQuantifier));
        KeyExpression rootExpression = this.index.getRootExpression();
        if (rootExpression instanceof GroupingKeyExpression) {
            if (GROUPED_INDEX_TYPES.contains(this.index.getType())) {
                rootExpression = ((GroupingKeyExpression)rootExpression).getWholeKey();
            } else {
                throw new UnsupportedOperationException("cannot create match candidate on grouping expression for unknown index type");
            }
        }
        if (rootExpression instanceof KeyWithValueExpression) {
            KeyWithValueExpression keyWithValueExpression = (KeyWithValueExpression)rootExpression;
            keyValueSplitPoint = keyWithValueExpression.getSplitPoint();
            rootExpression = keyWithValueExpression.getInnerKey();
        } else {
            keyValueSplitPoint = -1;
        }
        ArrayList<Value> keyValues = Lists.newArrayList();
        ArrayList<Value> valueValues = Lists.newArrayList();
        KeyExpressionExpansionVisitor.VisitorState initialState = KeyExpressionExpansionVisitor.VisitorState.of(keyValues, valueValues, baseQuantifier, ImmutableList.of(), keyValueSplitPoint, 0, false, true);
        GraphExpansion keyValueExpansion = this.pop(rootExpression.expand(this.push(initialState))).toBuilder().removeAllResultColumns().build();
        allExpansionsBuilder.add(keyValueExpansion);
        if (this.index.hasPredicate()) {
            QueryPredicate filteredIndexPredicate = Objects.requireNonNull(this.index.getPredicate()).toPredicate(baseQuantifier.getFlowedObjectValue());
            Optional<Multimap<Value, RangeConstraints>> valueRangesMaybe = IndexPredicateExpansion.dnfPredicateToRanges(filteredIndexPredicate);
            GraphExpansion.Builder predicateExpansionBuilder = GraphExpansion.builder();
            if (valueRangesMaybe.isEmpty()) {
                allExpansionsBuilder.add(GraphExpansion.ofPredicate(filteredIndexPredicate));
            } else {
                Multimap<Value, RangeConstraints> valueRanges = valueRangesMaybe.get();
                for (Value value : valueRanges.keySet()) {
                    Optional<Placeholder> maybePlaceholder = keyValueExpansion.getPlaceholders().stream().filter(existingPlaceholder -> existingPlaceholder.getValue().semanticEquals((Object)value, AliasMap.emptyMap())).findFirst();
                    if (maybePlaceholder.isEmpty()) {
                        predicateExpansionBuilder.addPredicate(PredicateWithValueAndRanges.ofRanges(value, ImmutableSet.copyOf(valueRanges.get(value))));
                        continue;
                    }
                    predicateExpansionBuilder.addPlaceholder(maybePlaceholder.get().withExtraRanges(ImmutableSet.copyOf(valueRanges.get(value))));
                }
            }
            allExpansionsBuilder.add(predicateExpansionBuilder.build());
        }
        int keySize = keyValues.size();
        if (primaryKey != null) {
            ArrayList<KeyExpression> trimmedPrimaryKeys = Lists.newArrayList(primaryKey.normalizeKeyForPositions());
            this.index.trimPrimaryKey(trimmedPrimaryKeys);
            for (int i = 0; i < trimmedPrimaryKeys.size(); ++i) {
                KeyExpression primaryKeyPart = trimmedPrimaryKeys.get(i);
                KeyExpressionExpansionVisitor.VisitorState initialStateForKeyPart = KeyExpressionExpansionVisitor.VisitorState.of(keyValues, Lists.newArrayList(), baseQuantifier, ImmutableList.of(), -1, keySize + i, false, true);
                GraphExpansion primaryKeyPartExpansion = this.pop(primaryKeyPart.expand(this.push(initialStateForKeyPart))).toBuilder().removeAllResultColumns().build();
                allExpansionsBuilder.add(primaryKeyPartExpansion);
            }
        }
        GraphExpansion completeExpansion = GraphExpansion.ofOthers((List<GraphExpansion>)((Object)allExpansionsBuilder.build()));
        GraphExpansion.Sealed sealedExpansion = completeExpansion.seal();
        ImmutableList<CorrelationIdentifier> parameters = sealedExpansion.getPlaceholders().stream().map(Placeholder::getParameterAlias).collect(ImmutableList.toImmutableList());
        MatchableSortExpression matchableSortExpression = new MatchableSortExpression(parameters, isReverse, sealedExpansion.buildSelectWithResultValue(baseQuantifier.getFlowedObjectValue()));
        return new ValueIndexScanMatchCandidate(this.index, this.queriedRecordTypes, Traversal.withRoot(Reference.initialOf((RelationalExpression)matchableSortExpression)), parameters, baseQuantifier.getFlowedObjectType(), baseQuantifier.getAlias(), keyValues, valueValues, ValueIndexExpansionVisitor.fullKey(this.index, primaryKey), primaryKey);
    }

    @Nonnull
    public static KeyExpression fullKey(@Nonnull Index index, @Nullable KeyExpression primaryKey) {
        KeyExpression rootExpression;
        KeyExpression keyExpression = rootExpression = index.getRootExpression() instanceof KeyWithValueExpression ? ((KeyWithValueExpression)index.getRootExpression()).getKeyExpression() : index.getRootExpression();
        if (primaryKey == null) {
            return rootExpression;
        }
        ArrayList<KeyExpression> trimmedPrimaryKeyComponents = new ArrayList<KeyExpression>(primaryKey.normalizeKeyForPositions());
        index.trimPrimaryKey(trimmedPrimaryKeyComponents);
        if (trimmedPrimaryKeyComponents.isEmpty()) {
            return rootExpression;
        }
        ImmutableList.Builder fullKeyListBuilder = ImmutableList.builder();
        fullKeyListBuilder.add(rootExpression);
        fullKeyListBuilder.addAll(trimmedPrimaryKeyComponents);
        return Key.Expressions.concat((List<KeyExpression>)((Object)fullKeyListBuilder.build()));
    }
}

