/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.ComparisonRange;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.MatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.MatchInfo;
import com.apple.foundationdb.record.query.plan.cascades.Ordering;
import com.apple.foundationdb.record.query.plan.cascades.OrderingPart;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.ScalarTranslationVisitor;
import com.apple.foundationdb.record.query.plan.cascades.WithBaseQuantifierMatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.OrderingValueComputationRuleSet;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public interface ValueIndexLikeMatchCandidate
extends MatchCandidate,
WithBaseQuantifierMatchCandidate {
    @Override
    @Nonnull
    default public List<OrderingPart.MatchedOrderingPart> computeMatchedOrderingParts(@Nonnull MatchInfo matchInfo, @Nonnull List<CorrelationIdentifier> sortParameterIds, boolean isReverse) {
        Map<CorrelationIdentifier, ComparisonRange> parameterBindingMap = matchInfo.getRegularMatchInfo().getParameterBindingMap();
        List<KeyExpression> normalizedKeyExpressions = this.getFullKeyExpression().normalizeKeyForPositions();
        ImmutableList.Builder builder = ImmutableList.builder();
        List<CorrelationIdentifier> candidateParameterIds = this.getOrderingAliases();
        HashSet<Value> normalizedValues = Sets.newHashSetWithExpectedSize(normalizedKeyExpressions.size());
        for (CorrelationIdentifier parameterId : sortParameterIds) {
            int ordinalInCandidate = candidateParameterIds.indexOf(parameterId);
            Verify.verify(ordinalInCandidate >= 0);
            KeyExpression normalizedKeyExpression = normalizedKeyExpressions.get(ordinalInCandidate);
            Objects.requireNonNull(parameterId);
            Objects.requireNonNull(normalizedKeyExpression);
            ComparisonRange comparisonRange = parameterBindingMap.get(parameterId);
            if (normalizedKeyExpression.createsDuplicates()) {
                if (comparisonRange == null || comparisonRange.getRangeType() != ComparisonRange.Type.EQUALITY) break;
                continue;
            }
            Value value = new ScalarTranslationVisitor(normalizedKeyExpression).toResultValue(Quantifier.current(), this.getBaseType());
            if (!normalizedValues.add(value)) continue;
            OrderingPart.MatchedOrderingPart matchedOrderingPart = value.deriveOrderingPart(EvaluationContext.empty(), AliasMap.emptyMap(), ImmutableSet.of(), (v, sortOrder) -> OrderingPart.MatchedOrderingPart.of(parameterId, v, comparisonRange, sortOrder), OrderingValueComputationRuleSet.usingMatchedOrderingParts());
            builder.add(matchedOrderingPart);
        }
        return builder.build();
    }

    @Override
    @Nonnull
    default public Ordering computeOrderingFromScanComparisons(@Nonnull ScanComparisons scanComparisons, boolean isReverse, boolean isDistinct) {
        KeyExpression normalizedKeyExpression;
        Value normalizedValue;
        ImmutableSetMultimap.Builder bindingMapBuilder = ImmutableSetMultimap.builder();
        List<KeyExpression> normalizedKeyExpressions = this.getFullKeyExpression().normalizeKeyForPositions();
        List<Comparisons.Comparison> equalityComparisons = scanComparisons.getEqualityComparisons();
        HashSet<Value> seenValues = Sets.newHashSetWithExpectedSize(normalizedKeyExpressions.size());
        for (int i = 0; i < equalityComparisons.size(); ++i) {
            Optional<NonnullPair<Value, Comparisons.Comparison>> simplifiedComparisonPairOptional;
            KeyExpression normalizedKeyExpression2 = normalizedKeyExpressions.get(i);
            Comparisons.Comparison comparison = equalityComparisons.get(i);
            if (normalizedKeyExpression2.createsDuplicates() || (simplifiedComparisonPairOptional = MatchCandidate.simplifyComparisonMaybe(normalizedValue = new ScalarTranslationVisitor(normalizedKeyExpression2).toResultValue(Quantifier.current(), this.getBaseType()), comparison)).isEmpty()) continue;
            NonnullPair<Value, Comparisons.Comparison> simplifiedComparisonPair = simplifiedComparisonPairOptional.get();
            bindingMapBuilder.put(simplifiedComparisonPair.getLeft(), Ordering.Binding.fixed(simplifiedComparisonPair.getRight()));
            seenValues.add(simplifiedComparisonPair.getLeft());
        }
        ImmutableList.Builder orderingSequenceBuilder = ImmutableList.builder();
        for (int i = scanComparisons.getEqualitySize(); i < normalizedKeyExpressions.size() && !(normalizedKeyExpression = normalizedKeyExpressions.get(i)).createsDuplicates(); ++i) {
            normalizedValue = new ScalarTranslationVisitor(normalizedKeyExpression).toResultValue(Quantifier.current(), this.getBaseType());
            OrderingPart.ProvidedOrderingPart providedOrderingPart = normalizedValue.deriveOrderingPart(EvaluationContext.empty(), AliasMap.emptyMap(), ImmutableSet.of(), OrderingPart.ProvidedOrderingPart::new, OrderingValueComputationRuleSet.usingProvidedOrderingParts());
            Value providedOrderingValue = providedOrderingPart.getValue();
            if (seenValues.contains(providedOrderingValue)) continue;
            seenValues.add(providedOrderingValue);
            bindingMapBuilder.put(providedOrderingValue, Ordering.Binding.sorted(((OrderingPart.ProvidedSortOrder)providedOrderingPart.getSortOrder()).flipIfReverse(isReverse)));
            orderingSequenceBuilder.add(providedOrderingValue);
        }
        return Ordering.ofOrderingSequence((SetMultimap<Value, Ordering.Binding>)((Object)bindingMapBuilder.build()), (List<? extends Value>)((Object)orderingSequenceBuilder.build()), isDistinct);
    }
}

