/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanComparisons;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanParameters;
import com.apple.foundationdb.record.query.plan.AvailableFields;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.query.plan.cascades.ComparisonRange;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.MatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.MatchInfo;
import com.apple.foundationdb.record.query.plan.cascades.Memoizer;
import com.apple.foundationdb.record.query.plan.cascades.PartialMatch;
import com.apple.foundationdb.record.query.plan.cascades.PlanContext;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.ScanWithFetchMatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.Traversal;
import com.apple.foundationdb.record.query.plan.cascades.ValueIndexLikeMatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryCoveringIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFetchFromPartialRecordPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ValueIndexScanMatchCandidate
implements ScanWithFetchMatchCandidate,
ValueIndexLikeMatchCandidate {
    @Nonnull
    private final Index index;
    private final List<RecordType> queriedRecordTypes;
    @Nonnull
    private final List<CorrelationIdentifier> parameters;
    @Nonnull
    private final Type baseType;
    @Nonnull
    private final CorrelationIdentifier baseAlias;
    @Nonnull
    private final List<Value> indexKeyValues;
    @Nonnull
    private final List<Value> indexValueValues;
    @Nonnull
    private final Traversal traversal;
    @Nonnull
    private final KeyExpression fullKeyExpression;
    @Nullable
    private final KeyExpression primaryKey;
    @Nonnull
    private final Supplier<Optional<List<Value>>> primaryKeyValuesOptionalSupplier;
    @Nonnull
    private final Supplier<Optional<ScanWithFetchMatchCandidate.IndexEntryToLogicalRecord>> indexEntryToLogicalRecordOptionalSupplier;

    public ValueIndexScanMatchCandidate(@Nonnull Index index, @Nonnull Collection<RecordType> queriedRecordTypes, @Nonnull Traversal traversal, @Nonnull List<CorrelationIdentifier> parameters, @Nonnull Type baseType, @Nonnull CorrelationIdentifier baseAlias, @Nonnull List<Value> indexKeyValues, @Nonnull List<Value> indexValueValues, @Nonnull KeyExpression fullKeyExpression, @Nullable KeyExpression primaryKey) {
        this.index = index;
        this.queriedRecordTypes = ImmutableList.copyOf(queriedRecordTypes);
        this.traversal = traversal;
        this.parameters = ImmutableList.copyOf(parameters);
        this.baseType = baseType;
        this.baseAlias = baseAlias;
        this.indexKeyValues = ImmutableList.copyOf(indexKeyValues);
        this.indexValueValues = ImmutableList.copyOf(indexValueValues);
        this.fullKeyExpression = fullKeyExpression;
        this.primaryKey = primaryKey;
        this.primaryKeyValuesOptionalSupplier = Suppliers.memoize(() -> MatchCandidate.computePrimaryKeyValuesMaybe(primaryKey, baseType));
        this.indexEntryToLogicalRecordOptionalSupplier = Suppliers.memoize(() -> ScanWithFetchMatchCandidate.computeIndexEntryToLogicalRecord(queriedRecordTypes, baseAlias, baseType, indexKeyValues, indexValueValues));
    }

    @Override
    public int getColumnSize() {
        return this.index.getColumnSize();
    }

    @Override
    public boolean isUnique() {
        return this.index.isUnique();
    }

    @Override
    @Nonnull
    public String getName() {
        return this.index.getName();
    }

    @Override
    @Nonnull
    public List<RecordType> getQueriedRecordTypes() {
        return this.queriedRecordTypes;
    }

    @Override
    @Nonnull
    public Traversal getTraversal() {
        return this.traversal;
    }

    @Override
    @Nonnull
    public List<CorrelationIdentifier> getSargableAliases() {
        return this.parameters;
    }

    @Override
    @Nonnull
    public List<CorrelationIdentifier> getOrderingAliases() {
        return this.getSargableAliases();
    }

    @Override
    @Nonnull
    public Type getBaseType() {
        return this.baseType;
    }

    @Nonnull
    public CorrelationIdentifier getBaseAlias() {
        return this.baseAlias;
    }

    @Nonnull
    public List<Value> getIndexKeyValues() {
        return this.indexKeyValues;
    }

    @Nonnull
    public List<Value> getIndexValueValues() {
        return this.indexValueValues;
    }

    @Override
    @Nonnull
    public KeyExpression getFullKeyExpression() {
        return this.fullKeyExpression;
    }

    public String toString() {
        return "value[" + this.getName() + "]";
    }

    @Override
    public boolean createsDuplicates() {
        return this.index.getRootExpression().createsDuplicates();
    }

    @Override
    @Nonnull
    public Optional<List<Value>> getPrimaryKeyValuesMaybe() {
        return this.primaryKeyValuesOptionalSupplier.get();
    }

    @Nonnull
    private Optional<ScanWithFetchMatchCandidate.IndexEntryToLogicalRecord> getIndexEntryToLogicalRecordMaybe() {
        return this.indexEntryToLogicalRecordOptionalSupplier.get();
    }

    @Override
    @Nonnull
    public RecordQueryPlan toEquivalentPlan(@Nonnull PartialMatch partialMatch, @Nonnull PlanContext planContext, @Nonnull Memoizer memoizer, @Nonnull List<ComparisonRange> comparisonRanges, boolean reverseScanOrder) {
        MatchInfo.RegularMatchInfo matchInfo = partialMatch.getRegularMatchInfo();
        Type.Record baseRecordType = Type.Record.fromFieldDescriptorsMap(RecordMetaData.getFieldDescriptorMapFromTypes(this.queriedRecordTypes));
        return this.tryFetchCoveringIndexScan(partialMatch, planContext, memoizer, comparisonRanges, reverseScanOrder, baseRecordType).orElseGet(() -> new RecordQueryIndexPlan(this.index.getName(), this.primaryKey, (IndexScanParameters)IndexScanComparisons.byValue(ValueIndexScanMatchCandidate.toScanComparisons(comparisonRanges)), planContext.getPlannerConfiguration().getIndexFetchMethod(), RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords.PRIMARY_KEY, reverseScanOrder, false, partialMatch.getMatchCandidate(), baseRecordType, matchInfo.getConstraint()));
    }

    @Nonnull
    private Optional<RecordQueryPlan> tryFetchCoveringIndexScan(@Nonnull PartialMatch partialMatch, @Nonnull PlanContext planContext, @Nonnull Memoizer memoizer, @Nonnull List<ComparisonRange> comparisonRanges, boolean isReverse, @Nonnull Type.Record baseRecordType) {
        Optional<ScanWithFetchMatchCandidate.IndexEntryToLogicalRecord> indexEntryToLogicalRecordOptional = this.getIndexEntryToLogicalRecordMaybe();
        if (indexEntryToLogicalRecordOptional.isEmpty()) {
            return Optional.empty();
        }
        ScanWithFetchMatchCandidate.IndexEntryToLogicalRecord indexEntryToLogicalRecord = indexEntryToLogicalRecordOptional.get();
        IndexScanComparisons scanParameters = IndexScanComparisons.byValue(ValueIndexScanMatchCandidate.toScanComparisons(comparisonRanges));
        RecordQueryIndexPlan indexPlan = new RecordQueryIndexPlan(this.index.getName(), this.primaryKey, (IndexScanParameters)scanParameters, planContext.getPlannerConfiguration().getIndexFetchMethod(), RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords.PRIMARY_KEY, isReverse, false, partialMatch.getMatchCandidate(), baseRecordType, partialMatch.getRegularMatchInfo().getConstraint());
        RecordQueryCoveringIndexPlan coveringIndexPlan = new RecordQueryCoveringIndexPlan(indexPlan, indexEntryToLogicalRecord.getQueriedRecordType().getName(), AvailableFields.NO_FIELDS, indexEntryToLogicalRecord.getIndexKeyValueToPartialRecord());
        return Optional.of(new RecordQueryFetchFromPartialRecordPlan(Quantifier.physical(memoizer.memoizePlan(coveringIndexPlan)), coveringIndexPlan::pushValueThroughFetch, (Type)baseRecordType, RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords.PRIMARY_KEY));
    }

    @Override
    @Nonnull
    public Optional<Value> pushValueThroughFetch(@Nonnull Value toBePushedValue, @Nonnull CorrelationIdentifier sourceAlias, @Nonnull CorrelationIdentifier targetAlias) {
        ScanWithFetchMatchCandidate.IndexEntryToLogicalRecord indexEntryToLogicalRecord = this.getIndexEntryToLogicalRecordMaybe().orElseThrow(() -> new RecordCoreException("need index entry to logical record", new Object[0]));
        return ScanWithFetchMatchCandidate.pushValueThroughFetch(toBePushedValue, this.baseAlias, sourceAlias, targetAlias, Iterables.concat(indexEntryToLogicalRecord.getLogicalKeyValues(), indexEntryToLogicalRecord.getLogicalValueValues()));
    }

    @Nonnull
    private static ScanComparisons toScanComparisons(@Nonnull List<ComparisonRange> comparisonRanges) {
        ScanComparisons.Builder builder = new ScanComparisons.Builder();
        for (ComparisonRange comparisonRange : comparisonRanges) {
            builder.addComparisonRange(comparisonRange);
        }
        return builder.build();
    }
}

