/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.ExpansionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.GraphExpansion;
import com.apple.foundationdb.record.query.plan.cascades.KeyExpressionExpansionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.MatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.Traversal;
import com.apple.foundationdb.record.query.plan.cascades.ValueIndexExpansionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.WindowedIndexScanMatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.apple.foundationdb.record.query.plan.cascades.expressions.MatchableSortExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.SelectExpression;
import com.apple.foundationdb.record.query.plan.cascades.predicates.Placeholder;
import com.apple.foundationdb.record.query.plan.cascades.predicates.PredicateWithValueAndRanges;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.ValuePredicate;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.RankValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WindowedIndexExpansionVisitor
extends KeyExpressionExpansionVisitor
implements ExpansionVisitor<KeyExpressionExpansionVisitor.VisitorState> {
    @Nonnull
    private final Index index;
    @Nonnull
    private final List<RecordType> recordTypes;

    public WindowedIndexExpansionVisitor(@Nonnull Index index, @Nonnull Collection<RecordType> recordTypes) {
        Preconditions.checkArgument("rank".equals(index.getType()));
        this.index = index;
        this.recordTypes = ImmutableList.copyOf(recordTypes);
    }

    @Override
    @Nonnull
    public MatchCandidate expand(@Nonnull Supplier<Quantifier.ForEach> baseQuantifierSupplier, @Nullable KeyExpression primaryKey, boolean isReverse) {
        KeyExpression rootExpression = this.index.getRootExpression();
        Verify.verify(rootExpression instanceof GroupingKeyExpression);
        Debugger.updateIndex(PredicateWithValueAndRanges.class, old -> 0);
        ImmutableList.Builder allExpansionsBuilder = ImmutableList.builder();
        Quantifier.ForEach baseQuantifier = baseQuantifierSupplier.get();
        GraphExpansion baseExpansion = GraphExpansion.builder().pullUpQuantifier(baseQuantifier).build();
        allExpansionsBuilder.add(baseExpansion);
        CorrelationIdentifier baseAlias = baseQuantifier.getAlias();
        ArrayList<Value> groupingAndArgumentValues = Lists.newArrayList();
        GroupingKeyExpression groupingKeyExpression = (GroupingKeyExpression)rootExpression;
        Verify.verify(groupingKeyExpression.getGroupedCount() == 1);
        Quantifier.ForEach innerBaseQuantifier = baseQuantifierSupplier.get();
        CorrelationIdentifier innerBaseAlias = innerBaseQuantifier.getAlias();
        ExpandGroupingsAndArgumentsResults expandGroupingsAndArgumentsResult = this.expandGroupingsAndArguments(baseQuantifier, innerBaseQuantifier, groupingKeyExpression, groupingAndArgumentValues);
        SelectExpression rankSelectExpression = expandGroupingsAndArgumentsResult.getExpansion().buildSelect();
        CorrelationIdentifier rankAlias = expandGroupingsAndArgumentsResult.getRankAlias();
        Quantifier.ForEach rankQuantifier = Quantifier.forEach(Reference.initialOf((RelationalExpression)rankSelectExpression));
        allExpansionsBuilder.add(GraphExpansion.ofQuantifier(rankQuantifier));
        GraphExpansion duplicatedPlaceholders = this.duplicateSimpleGroupingPlaceholders(baseAlias, innerBaseAlias, groupingKeyExpression, expandGroupingsAndArgumentsResult.getGroupingsAndArgumentsPlaceholders(), rankSelectExpression);
        allExpansionsBuilder.add(duplicatedPlaceholders);
        ImmutableList.Builder primaryKeyAliasesBuilder = ImmutableList.builder();
        ArrayList<Value> primaryKeyValues = Lists.newArrayList();
        if (primaryKey != null) {
            ArrayList<KeyExpression> trimmedPrimaryKeys = Lists.newArrayList(primaryKey.normalizeKeyForPositions());
            this.index.trimPrimaryKey(trimmedPrimaryKeys);
            for (KeyExpression primaryKeyPart : trimmedPrimaryKeys) {
                KeyExpressionExpansionVisitor.VisitorState initialStateForKeyPart = KeyExpressionExpansionVisitor.VisitorState.of(primaryKeyValues, Lists.newArrayList(), baseQuantifier, ImmutableList.of(), -1, 0, false, false);
                GraphExpansion primaryKeyPartExpansion = this.pop(primaryKeyPart.expand(this.push(initialStateForKeyPart))).toBuilder().removeAllResultColumns().build();
                allExpansionsBuilder.add(primaryKeyPartExpansion);
                primaryKeyAliasesBuilder.addAll(primaryKeyPartExpansion.getPlaceholderAliases());
            }
        }
        ImmutableCollection primaryKeyAliases = primaryKeyAliasesBuilder.build();
        List<Value> indexKeyValues = this.computeIndexKeyValues(baseAlias, innerBaseAlias, groupingAndArgumentValues, primaryKeyValues);
        GraphExpansion completeExpansion = GraphExpansion.ofOthers((List<GraphExpansion>)((Object)allExpansionsBuilder.build()));
        List<CorrelationIdentifier> groupingAndArgumentAliases = expandGroupingsAndArgumentsResult.getGroupingsAndArgumentsAliases();
        List<CorrelationIdentifier> groupingAliases = groupingAndArgumentAliases.subList(0, groupingKeyExpression.getGroupingCount());
        CorrelationIdentifier scoreAlias = groupingAndArgumentAliases.get(groupingAndArgumentAliases.size() - 1);
        MatchableSortExpression matchableSortExpression = new MatchableSortExpression(WindowedIndexScanMatchCandidate.orderingAliases(groupingAliases, scoreAlias, (List<CorrelationIdentifier>)((Object)primaryKeyAliases)), isReverse, completeExpansion.buildSelect());
        return new WindowedIndexScanMatchCandidate(this.index, this.recordTypes, Traversal.withRoot(Reference.initialOf((RelationalExpression)matchableSortExpression)), baseQuantifier.getFlowedObjectType(), baseAlias, groupingAliases, scoreAlias, rankAlias, (List<CorrelationIdentifier>)((Object)primaryKeyAliases), indexKeyValues, ValueIndexExpansionVisitor.fullKey(this.index, primaryKey), primaryKey);
    }

    @Nonnull
    private List<Value> computeIndexKeyValues(@Nonnull CorrelationIdentifier baseAlias, @Nonnull CorrelationIdentifier innerBaseAlias, @Nonnull List<Value> groupingAndArgumentValues, @Nonnull List<Value> primaryKeyValues) {
        ImmutableList rebasedGroupingAndArgumentValues = groupingAndArgumentValues.stream().map(value -> value.rebase(AliasMap.ofAliases(innerBaseAlias, baseAlias))).collect(ImmutableList.toImmutableList());
        return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll((Iterable)rebasedGroupingAndArgumentValues)).addAll(primaryKeyValues)).build();
    }

    @Nonnull
    private GraphExpansion duplicateSimpleGroupingPlaceholders(@Nonnull CorrelationIdentifier baseAlias, @Nonnull CorrelationIdentifier innerBaseAlias, @Nonnull GroupingKeyExpression groupingKeyExpression, @Nonnull List<Placeholder> groupingsAndArgumentsPlaceholders, @Nonnull SelectExpression rankSelectExpression) {
        ArrayList<GraphExpansion> expansions = Lists.newArrayList();
        ImmutableSet<Placeholder> groupingPlaceholders = ImmutableSet.copyOf(groupingsAndArgumentsPlaceholders.subList(0, groupingKeyExpression.getGroupingCount()));
        ImmutableSet rankOtherLocalAliases = rankSelectExpression.getQuantifiers().stream().map(Quantifier::getAlias).filter(alias -> !alias.equals(innerBaseAlias)).collect(ImmutableSet.toImmutableSet());
        for (QueryPredicate queryPredicate : rankSelectExpression.getPredicates()) {
            Set<CorrelationIdentifier> placeHolderCorrelatedTo;
            PredicateWithValueAndRanges placeholder;
            if (!(queryPredicate instanceof Placeholder) || !groupingPlaceholders.contains(placeholder = (PredicateWithValueAndRanges)queryPredicate) || !(placeHolderCorrelatedTo = placeholder.getCorrelatedTo()).contains(innerBaseAlias) || !Sets.intersection(placeHolderCorrelatedTo, rankOtherLocalAliases).isEmpty()) continue;
            Placeholder rebasedPlaceholder = (Placeholder)placeholder.rebase(AliasMap.ofAliases(innerBaseAlias, baseAlias));
            expansions.add(GraphExpansion.ofPlaceholder(rebasedPlaceholder));
        }
        return GraphExpansion.ofOthers(expansions);
    }

    @Nonnull
    private ExpandGroupingsAndArgumentsResults expandGroupingsAndArguments(@Nonnull Quantifier.ForEach baseQuantifier, @Nonnull Quantifier.ForEach innerBaseQuantifier, @Nonnull GroupingKeyExpression groupingKeyExpression, @Nonnull List<Value> groupingAndArgumentValues) {
        KeyExpression wholeKeyExpression = groupingKeyExpression.getWholeKey();
        KeyExpressionExpansionVisitor.VisitorState initialState = KeyExpressionExpansionVisitor.VisitorState.of(groupingAndArgumentValues, Lists.newArrayList(), innerBaseQuantifier, ImmutableList.of(), -1, 0, false, false);
        GraphExpansion partitioningAndArgumentExpansion = this.pop(wholeKeyExpression.expand(this.push(initialState)));
        GraphExpansion.Sealed sealedPartitioningAndArgumentExpansion = partitioningAndArgumentExpansion.seal();
        int partitioningSize = groupingKeyExpression.getGroupingCount();
        List<Value> partitioningExpressions = sealedPartitioningAndArgumentExpansion.getResultValues().subList(0, partitioningSize);
        List<Value> argumentExpressions = sealedPartitioningAndArgumentExpansion.getResultValues().subList(partitioningSize, groupingKeyExpression.getColumnSize());
        RankValue rankValue = new RankValue(partitioningExpressions, argumentExpressions);
        CorrelationIdentifier rankAlias = WindowedIndexExpansionVisitor.newParameterAlias();
        Placeholder rankPlaceholder = Placeholder.newInstanceWithoutRanges(rankValue, rankAlias);
        ValuePredicate selfJoinPredicate = innerBaseQuantifier.getFlowedObjectValue().withComparison(new Comparisons.ValueComparison(Comparisons.Type.EQUALS, QuantifiedObjectValue.of(baseQuantifier.getAlias(), baseQuantifier.getFlowedObjectType())));
        GraphExpansion.Builder expansionBuilder = partitioningAndArgumentExpansion.toBuilder().addPredicate(rankPlaceholder).addPredicate(selfJoinPredicate).addPlaceholder(rankPlaceholder).removeAllResultColumns();
        expansionBuilder.pullUpQuantifier(innerBaseQuantifier);
        partitioningAndArgumentExpansion.getQuantifiers().forEach(quantifier -> expansionBuilder.addAllResultColumns(quantifier.getFlowedColumns()));
        return new ExpandGroupingsAndArgumentsResults(expansionBuilder.build(), rankAlias, partitioningAndArgumentExpansion.getPlaceholderAliases(), partitioningAndArgumentExpansion.getPlaceholders());
    }

    private static class ExpandGroupingsAndArgumentsResults {
        @Nonnull
        private final GraphExpansion expansion;
        @Nonnull
        private final CorrelationIdentifier rankAlias;
        @Nonnull
        private final List<CorrelationIdentifier> groupingsAndArgumentsAliases;
        @Nonnull
        private final List<Placeholder> groupingsAndArgumentsPlaceholders;

        public ExpandGroupingsAndArgumentsResults(@Nonnull GraphExpansion expansion, @Nonnull CorrelationIdentifier rankAlias, @Nonnull List<CorrelationIdentifier> groupingsAndArgumentsAliases, @Nonnull List<Placeholder> groupingsAndArgumentsPlaceholders) {
            this.expansion = expansion;
            this.rankAlias = rankAlias;
            this.groupingsAndArgumentsAliases = groupingsAndArgumentsAliases;
            this.groupingsAndArgumentsPlaceholders = groupingsAndArgumentsPlaceholders;
        }

        @Nonnull
        public GraphExpansion getExpansion() {
            return this.expansion;
        }

        @Nonnull
        public CorrelationIdentifier getRankAlias() {
            return this.rankAlias;
        }

        @Nonnull
        public List<CorrelationIdentifier> getGroupingsAndArgumentsAliases() {
            return this.groupingsAndArgumentsAliases;
        }

        @Nonnull
        public List<Placeholder> getGroupingsAndArgumentsPlaceholders() {
            return this.groupingsAndArgumentsPlaceholders;
        }
    }
}

