/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades;

import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.IndexScanType;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanComparisons;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanParameters;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.AvailableFields;
import com.apple.foundationdb.record.query.plan.QueryPlanConstraint;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.ComparisonRange;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.MatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.MatchInfo;
import com.apple.foundationdb.record.query.plan.cascades.Memoizer;
import com.apple.foundationdb.record.query.plan.cascades.Ordering;
import com.apple.foundationdb.record.query.plan.cascades.OrderingPart;
import com.apple.foundationdb.record.query.plan.cascades.PartialMatch;
import com.apple.foundationdb.record.query.plan.cascades.PlanContext;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.ScalarTranslationVisitor;
import com.apple.foundationdb.record.query.plan.cascades.ScanWithFetchMatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.Traversal;
import com.apple.foundationdb.record.query.plan.cascades.WithBaseQuantifierMatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.simplification.OrderingValueComputationRuleSet;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryCoveringIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFetchFromPartialRecordPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WindowedIndexScanMatchCandidate
implements ScanWithFetchMatchCandidate,
WithBaseQuantifierMatchCandidate {
    @Nonnull
    private final Index index;
    private final List<RecordType> queriedRecordTypes;
    @Nonnull
    private final Type baseType;
    @Nonnull
    private final CorrelationIdentifier baseAlias;
    @Nonnull
    private final List<CorrelationIdentifier> groupingAliases;
    @Nonnull
    private final CorrelationIdentifier scoreAlias;
    @Nonnull
    private final CorrelationIdentifier rankAlias;
    @Nonnull
    private final List<CorrelationIdentifier> primaryKeyAliases;
    @Nonnull
    private final List<Value> indexKeyValues;
    @Nonnull
    private final Traversal traversal;
    @Nonnull
    private final KeyExpression fullKeyExpression;
    @Nullable
    private final KeyExpression primaryKey;
    @Nonnull
    private final Supplier<Optional<List<Value>>> primaryKeyValuesSupplier;
    @Nonnull
    private final Supplier<Optional<ScanWithFetchMatchCandidate.IndexEntryToLogicalRecord>> indexEntryToLogicalRecordOptionalSupplier;

    public WindowedIndexScanMatchCandidate(@Nonnull Index index, @Nonnull Collection<RecordType> queriedRecordTypes, @Nonnull Traversal traversal, @Nonnull Type baseType, @Nonnull CorrelationIdentifier baseAlias, @Nonnull List<CorrelationIdentifier> groupingAliases, @Nonnull CorrelationIdentifier scoreAlias, @Nonnull CorrelationIdentifier rankAlias, @Nonnull List<CorrelationIdentifier> primaryKeyAliases, @Nonnull List<Value> indexKeyValues, @Nonnull KeyExpression fullKeyExpression, @Nullable KeyExpression primaryKey) {
        this.index = index;
        this.queriedRecordTypes = ImmutableList.copyOf(queriedRecordTypes);
        this.traversal = traversal;
        this.baseType = baseType;
        this.baseAlias = baseAlias;
        this.groupingAliases = ImmutableList.copyOf(groupingAliases);
        this.scoreAlias = scoreAlias;
        this.rankAlias = rankAlias;
        this.primaryKeyAliases = ImmutableList.copyOf(primaryKeyAliases);
        this.indexKeyValues = ImmutableList.copyOf(indexKeyValues);
        this.fullKeyExpression = fullKeyExpression;
        this.primaryKey = primaryKey;
        this.primaryKeyValuesSupplier = Suppliers.memoize(() -> MatchCandidate.computePrimaryKeyValuesMaybe(primaryKey, baseType));
        this.indexEntryToLogicalRecordOptionalSupplier = Suppliers.memoize(() -> ScanWithFetchMatchCandidate.computeIndexEntryToLogicalRecord(queriedRecordTypes, baseAlias, baseType, indexKeyValues, ImmutableList.of()));
    }

    @Override
    public int getColumnSize() {
        return this.index.getColumnSize();
    }

    @Override
    public boolean isUnique() {
        return this.index.isUnique();
    }

    @Override
    @Nonnull
    public String getName() {
        return this.index.getName();
    }

    @Override
    @Nonnull
    public List<RecordType> getQueriedRecordTypes() {
        return this.queriedRecordTypes;
    }

    @Override
    @Nonnull
    public Traversal getTraversal() {
        return this.traversal;
    }

    @Override
    @Nonnull
    public List<CorrelationIdentifier> getSargableAliases() {
        return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.groupingAliases)).add(this.rankAlias)).build();
    }

    @Override
    @Nonnull
    public List<CorrelationIdentifier> getOrderingAliases() {
        return WindowedIndexScanMatchCandidate.orderingAliases(this.groupingAliases, this.scoreAlias, this.primaryKeyAliases);
    }

    @Override
    @Nonnull
    public Type getBaseType() {
        return this.baseType;
    }

    @Nonnull
    public List<Value> getIndexKeyValues() {
        return this.indexKeyValues;
    }

    @Override
    @Nonnull
    public KeyExpression getFullKeyExpression() {
        return this.fullKeyExpression;
    }

    public String toString() {
        return "Windowed[" + this.getName() + "]";
    }

    @Override
    public boolean createsDuplicates() {
        return this.index.getRootExpression().createsDuplicates();
    }

    @Override
    @Nonnull
    public Optional<List<Value>> getPrimaryKeyValuesMaybe() {
        return this.primaryKeyValuesSupplier.get();
    }

    @Nonnull
    private Optional<ScanWithFetchMatchCandidate.IndexEntryToLogicalRecord> getIndexEntryToLogicalRecordMaybe() {
        return this.indexEntryToLogicalRecordOptionalSupplier.get();
    }

    @Override
    @Nonnull
    public List<OrderingPart.MatchedOrderingPart> computeMatchedOrderingParts(@Nonnull MatchInfo matchInfo, @Nonnull List<CorrelationIdentifier> sortParameterIds, boolean isReverse) {
        Map<CorrelationIdentifier, ComparisonRange> parameterBindingMap = matchInfo.getRegularMatchInfo().getParameterBindingMap();
        List<KeyExpression> normalizedKeyExpressions = this.getFullKeyExpression().normalizeKeyForPositions();
        ImmutableList.Builder builder = ImmutableList.builder();
        List<CorrelationIdentifier> candidateParameterIds = this.getOrderingAliases();
        HashSet<Value> normalizedValues = Sets.newHashSetWithExpectedSize(normalizedKeyExpressions.size());
        for (CorrelationIdentifier parameterId : sortParameterIds) {
            int ordinalInCandidate = candidateParameterIds.indexOf(parameterId);
            Verify.verify(ordinalInCandidate >= 0);
            KeyExpression normalizedKeyExpression = normalizedKeyExpressions.get(ordinalInCandidate);
            Objects.requireNonNull(normalizedKeyExpression);
            Objects.requireNonNull(parameterId);
            ComparisonRange comparisonRange = parameterBindingMap.get(parameterId);
            if (normalizedKeyExpression.createsDuplicates()) {
                if (comparisonRange == null || comparisonRange.getRangeType() != ComparisonRange.Type.EQUALITY) break;
                continue;
            }
            Value normalizedValue = new ScalarTranslationVisitor(normalizedKeyExpression).toResultValue(Quantifier.current(), this.getBaseType());
            if (!normalizedValues.add(normalizedValue)) continue;
            if (parameterId.equals(this.scoreAlias)) {
                ComparisonRange rankComparisonRange = parameterBindingMap.get(this.rankAlias);
                OrderingPart.MatchedOrderingPart matchedOrderingPart = normalizedValue.deriveOrderingPart(EvaluationContext.empty(), AliasMap.emptyMap(), ImmutableSet.of(), (v, sortOrder) -> OrderingPart.MatchedOrderingPart.of(this.rankAlias, v, rankComparisonRange, sortOrder), OrderingValueComputationRuleSet.usingMatchedOrderingParts());
                builder.add(matchedOrderingPart);
                continue;
            }
            OrderingPart.MatchedOrderingPart matchedOrderingPart = normalizedValue.deriveOrderingPart(EvaluationContext.empty(), AliasMap.emptyMap(), ImmutableSet.of(), (v, sortOrder) -> OrderingPart.MatchedOrderingPart.of(parameterId, v, comparisonRange, sortOrder), OrderingValueComputationRuleSet.usingMatchedOrderingParts());
            builder.add(matchedOrderingPart);
        }
        return builder.build();
    }

    @Override
    @Nonnull
    public Ordering computeOrderingFromScanComparisons(@Nonnull ScanComparisons scanComparisons, boolean isReverse, boolean isDistinct) {
        KeyExpression normalizedKeyExpression;
        Value normalizedValue;
        ImmutableSetMultimap.Builder bindingMapBuilder = ImmutableSetMultimap.builder();
        List<KeyExpression> normalizedKeyExpressions = this.getFullKeyExpression().normalizeKeyForPositions();
        List<Comparisons.Comparison> equalityComparisons = scanComparisons.getEqualityComparisons();
        GroupingKeyExpression groupingExpression = (GroupingKeyExpression)this.index.getRootExpression();
        int scoreOrdinal = groupingExpression.getGroupingCount();
        HashSet<Value> seenValues = Sets.newHashSetWithExpectedSize(normalizedKeyExpressions.size());
        for (int i = 0; i < equalityComparisons.size(); ++i) {
            KeyExpression normalizedKeyExpression2 = normalizedKeyExpressions.get(i);
            Comparisons.Comparison comparison = equalityComparisons.get(i);
            if (normalizedKeyExpression2.createsDuplicates()) continue;
            normalizedValue = new ScalarTranslationVisitor(normalizedKeyExpression2).toResultValue(Quantifier.current(), this.getBaseType());
            seenValues.add(normalizedValue);
            if (i == scoreOrdinal) {
                bindingMapBuilder.put(normalizedValue, Ordering.Binding.fixed(new Comparisons.OpaqueEqualityComparison()));
                seenValues.add(normalizedValue);
                continue;
            }
            Optional<NonnullPair<Value, Comparisons.Comparison>> simplifiedComparisonPairOptional = MatchCandidate.simplifyComparisonMaybe(normalizedValue, comparison);
            if (simplifiedComparisonPairOptional.isEmpty()) continue;
            NonnullPair<Value, Comparisons.Comparison> simplifiedComparisonPair = simplifiedComparisonPairOptional.get();
            bindingMapBuilder.put(simplifiedComparisonPair.getLeft(), Ordering.Binding.fixed(simplifiedComparisonPair.getRight()));
            seenValues.add(simplifiedComparisonPair.getLeft());
        }
        ImmutableList.Builder orderingSequenceBuilder = ImmutableList.builder();
        for (int i = scanComparisons.getEqualitySize(); i < normalizedKeyExpressions.size() && !(normalizedKeyExpression = normalizedKeyExpressions.get(i)).createsDuplicates(); ++i) {
            normalizedValue = new ScalarTranslationVisitor(normalizedKeyExpression).toResultValue(Quantifier.current(), this.getBaseType());
            OrderingPart.ProvidedOrderingPart providedOrderingPart = normalizedValue.deriveOrderingPart(EvaluationContext.empty(), AliasMap.emptyMap(), ImmutableSet.of(), OrderingPart.ProvidedOrderingPart::new, OrderingValueComputationRuleSet.usingProvidedOrderingParts());
            Value providedOrderingValue = providedOrderingPart.getValue();
            if (seenValues.contains(providedOrderingValue)) continue;
            seenValues.add(providedOrderingValue);
            bindingMapBuilder.put(providedOrderingValue, Ordering.Binding.sorted(((OrderingPart.ProvidedSortOrder)providedOrderingPart.getSortOrder()).flipIfReverse(isReverse)));
            orderingSequenceBuilder.add(providedOrderingValue);
        }
        return Ordering.ofOrderingSequence((SetMultimap<Value, Ordering.Binding>)((Object)bindingMapBuilder.build()), (List<? extends Value>)((Object)orderingSequenceBuilder.build()), isDistinct);
    }

    @Override
    @Nonnull
    public RecordQueryPlan toEquivalentPlan(@Nonnull PartialMatch partialMatch, @Nonnull PlanContext planContext, @Nonnull Memoizer memoizer, @Nonnull List<ComparisonRange> comparisonRanges, boolean reverseScanOrder) {
        Type.Record baseRecordType = Type.Record.fromFieldDescriptorsMap(RecordMetaData.getFieldDescriptorMapFromTypes(this.queriedRecordTypes));
        return this.tryFetchCoveringIndexScan(partialMatch, planContext, memoizer, comparisonRanges, reverseScanOrder, baseRecordType).orElseGet(() -> new RecordQueryIndexPlan(this.index.getName(), this.primaryKey, (IndexScanParameters)new IndexScanComparisons(IndexScanType.BY_RANK, WindowedIndexScanMatchCandidate.toScanComparisons(comparisonRanges)), planContext.getPlannerConfiguration().getIndexFetchMethod(), RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords.PRIMARY_KEY, reverseScanOrder, false, partialMatch.getMatchCandidate(), baseRecordType, QueryPlanConstraint.noConstraint()));
    }

    @Nonnull
    private Optional<RecordQueryPlan> tryFetchCoveringIndexScan(@Nonnull PartialMatch partialMatch, @Nonnull PlanContext planContext, @Nonnull Memoizer memoizer, @Nonnull List<ComparisonRange> comparisonRanges, boolean isReverse, @Nonnull Type.Record baseRecordType) {
        Optional<ScanWithFetchMatchCandidate.IndexEntryToLogicalRecord> indexEntryToLogicalRecordOptional = this.getIndexEntryToLogicalRecordMaybe();
        if (indexEntryToLogicalRecordOptional.isEmpty()) {
            return Optional.empty();
        }
        ScanWithFetchMatchCandidate.IndexEntryToLogicalRecord indexEntryToLogicalRecord = indexEntryToLogicalRecordOptional.get();
        IndexScanComparisons scanParameters = new IndexScanComparisons(IndexScanType.BY_RANK, WindowedIndexScanMatchCandidate.toScanComparisons(comparisonRanges));
        RecordQueryIndexPlan indexPlan = new RecordQueryIndexPlan(this.index.getName(), this.primaryKey, (IndexScanParameters)scanParameters, planContext.getPlannerConfiguration().getIndexFetchMethod(), RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords.PRIMARY_KEY, isReverse, false, partialMatch.getMatchCandidate(), baseRecordType, QueryPlanConstraint.noConstraint());
        RecordQueryCoveringIndexPlan coveringIndexPlan = new RecordQueryCoveringIndexPlan(indexPlan, indexEntryToLogicalRecord.getQueriedRecordType().getName(), AvailableFields.NO_FIELDS, indexEntryToLogicalRecord.getIndexKeyValueToPartialRecord());
        return Optional.of(new RecordQueryFetchFromPartialRecordPlan(Quantifier.physical(memoizer.memoizePlan(coveringIndexPlan)), coveringIndexPlan::pushValueThroughFetch, (Type)baseRecordType, RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords.PRIMARY_KEY));
    }

    @Override
    @Nonnull
    public Optional<Value> pushValueThroughFetch(@Nonnull Value toBePushedValue, @Nonnull CorrelationIdentifier sourceAlias, @Nonnull CorrelationIdentifier targetAlias) {
        ScanWithFetchMatchCandidate.IndexEntryToLogicalRecord indexEntryToLogicalRecord = this.getIndexEntryToLogicalRecordMaybe().orElseThrow(() -> new RecordCoreException("need index entry to logical record", new Object[0]));
        return ScanWithFetchMatchCandidate.pushValueThroughFetch(toBePushedValue, this.baseAlias, sourceAlias, targetAlias, indexEntryToLogicalRecord.getLogicalKeyValues());
    }

    @Nonnull
    private static ScanComparisons toScanComparisons(@Nonnull List<ComparisonRange> comparisonRanges) {
        ScanComparisons.Builder builder = new ScanComparisons.Builder();
        for (ComparisonRange comparisonRange : comparisonRanges) {
            builder.addComparisonRange(comparisonRange);
        }
        return builder.build();
    }

    @Nonnull
    public static List<CorrelationIdentifier> orderingAliases(@Nonnull List<CorrelationIdentifier> groupingAliases, @Nonnull CorrelationIdentifier scoreAlias, @Nonnull List<CorrelationIdentifier> primaryKeyAliases) {
        return ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(groupingAliases)).add(scoreAlias)).addAll(primaryKeyAliases)).build();
    }
}

