/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.debug;

import com.google.common.base.Throwables;
import com.google.common.io.CharStreams;
import java.awt.Desktop;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class BrowserHelper {
    private BrowserHelper() {
    }

    @Nonnull
    private static URI createHtmlLauncher(@Nonnull String htmlAsResource, @Nonnull Map<String, String> insertMap) throws Exception {
        String launcherHtmlString;
        try (InputStream launcherHtmlInputStream = BrowserHelper.class.getResourceAsStream(htmlAsResource);){
            launcherHtmlString = CharStreams.toString(new InputStreamReader(Objects.requireNonNull(launcherHtmlInputStream), StandardCharsets.UTF_8));
            for (Map.Entry<String, String> entry : insertMap.entrySet()) {
                launcherHtmlString = launcherHtmlString.replace(entry.getKey(), entry.getValue());
            }
        }
        File launcherTempFile = File.createTempFile("local_launcher-", ".html", new File(System.getProperty("java.io.tmpdir")));
        String launcherTempFileName = launcherTempFile.toString();
        try (PrintWriter writer = new PrintWriter(launcherTempFile, StandardCharsets.UTF_8);){
            writer.print(launcherHtmlString);
        }
        catch (Exception e) {
            throw new Exception("Error writing file: " + launcherTempFile.getAbsolutePath() + " : " + e.getMessage(), e);
        }
        return new URI("file:///" + launcherTempFileName.replace("\\", "/"));
    }

    @Nonnull
    public static String browse(@Nonnull String htmlAsResource, @Nonnull Map<String, String> insertMap) {
        try {
            URI uri = BrowserHelper.createHtmlLauncher(htmlAsResource, insertMap);
            Desktop.getDesktop().browse(uri);
            return "done";
        }
        catch (Exception ex) {
            Throwables.throwIfUnchecked(ex);
            throw new RuntimeException(ex);
        }
    }
}

