/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.debug;

import com.apple.foundationdb.record.query.plan.cascades.CascadesPlanner;
import com.apple.foundationdb.record.query.plan.cascades.CascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.CascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.MatchPartition;
import com.apple.foundationdb.record.query.plan.cascades.PartialMatch;
import com.apple.foundationdb.record.query.plan.cascades.PlanContext;
import com.apple.foundationdb.record.query.plan.cascades.PlannerPhase;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.debug.StatsMaps;
import com.apple.foundationdb.record.query.plan.cascades.debug.eventprotos.PAbstractEventWithState;
import com.apple.foundationdb.record.query.plan.cascades.debug.eventprotos.PAdjustMatchEvent;
import com.apple.foundationdb.record.query.plan.cascades.debug.eventprotos.PBindable;
import com.apple.foundationdb.record.query.plan.cascades.debug.eventprotos.PEvent;
import com.apple.foundationdb.record.query.plan.cascades.debug.eventprotos.PExecutingTaskEvent;
import com.apple.foundationdb.record.query.plan.cascades.debug.eventprotos.PExploreExpressionEvent;
import com.apple.foundationdb.record.query.plan.cascades.debug.eventprotos.PExploreGroupEvent;
import com.apple.foundationdb.record.query.plan.cascades.debug.eventprotos.PInitiatePlannerPhaseEvent;
import com.apple.foundationdb.record.query.plan.cascades.debug.eventprotos.PInsertIntoMemoEvent;
import com.apple.foundationdb.record.query.plan.cascades.debug.eventprotos.PMatchPartition;
import com.apple.foundationdb.record.query.plan.cascades.debug.eventprotos.POptimizeGroupEvent;
import com.apple.foundationdb.record.query.plan.cascades.debug.eventprotos.POptimizeInputsEvent;
import com.apple.foundationdb.record.query.plan.cascades.debug.eventprotos.PPartialMatch;
import com.apple.foundationdb.record.query.plan.cascades.debug.eventprotos.PRegisteredReference;
import com.apple.foundationdb.record.query.plan.cascades.debug.eventprotos.PRegisteredRelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.debug.eventprotos.PTransformEvent;
import com.apple.foundationdb.record.query.plan.cascades.debug.eventprotos.PTransformRuleCallEvent;
import com.apple.foundationdb.record.query.plan.cascades.debug.eventprotos.PTranslateCorrelationsEvent;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface Debugger {
    public static final ThreadLocal<Debugger> THREAD_LOCAL = new ThreadLocal();

    public static void setDebugger(Debugger debugger) {
        THREAD_LOCAL.set(debugger);
    }

    @Nullable
    public static Debugger getDebugger() {
        return THREAD_LOCAL.get();
    }

    @Nonnull
    public static Optional<Debugger> getDebuggerMaybe() {
        Debugger debugger = Debugger.getDebugger();
        return Optional.ofNullable(debugger);
    }

    public static void withDebugger(@Nonnull Consumer<Debugger> action) {
        Debugger debugger = Debugger.getDebugger();
        if (debugger != null) {
            action.accept(debugger);
        }
    }

    public static void verifyHeuristicPlanner() {
        Verify.verify(!Debugger.isCascades());
    }

    @Nonnull
    public static <T> T verifyHeuristicPlanner(@Nonnull T in) {
        Verify.verify(!Debugger.isCascades());
        return in;
    }

    public static boolean isCascades() {
        return Debugger.mapDebugger(debugger -> debugger.getPlanContext() != null).orElse(false);
    }

    public static void sanityCheck(@Nonnull Runnable runnable) {
        Debugger.withDebugger(debugger -> {
            if (!debugger.isSane()) {
                runnable.run();
            }
        });
    }

    @Nonnull
    public static <T> Optional<T> mapDebugger(@Nonnull Function<Debugger, T> function) {
        Debugger debugger = Debugger.getDebugger();
        if (debugger != null) {
            return Optional.ofNullable(function.apply(debugger));
        }
        return Optional.empty();
    }

    public static void install() {
        Debugger.withDebugger(Debugger::onInstall);
    }

    public static void setup() {
        Debugger.withDebugger(Debugger::onSetup);
    }

    public static void show(@Nonnull Reference ref) {
        Debugger.withDebugger(debugger -> debugger.onShow(ref));
    }

    public static Optional<Integer> getIndexOptional(Class<?> clazz) {
        return Debugger.mapDebugger(debugger -> debugger.onGetIndex(clazz));
    }

    @Nonnull
    @CanIgnoreReturnValue
    public static Optional<Integer> updateIndex(Class<?> clazz, IntUnaryOperator updateFn) {
        return Debugger.mapDebugger(debugger -> debugger.onUpdateIndex(clazz, updateFn));
    }

    public static void registerExpression(RelationalExpression expression) {
        Debugger.withDebugger(debugger -> debugger.onRegisterExpression(expression));
    }

    public static void registerReference(Reference reference) {
        Debugger.withDebugger(debugger -> debugger.onRegisterReference(reference));
    }

    public static void registerQuantifier(Quantifier quantifier) {
        Debugger.withDebugger(debugger -> debugger.onRegisterQuantifier(quantifier));
    }

    public static Optional<Integer> getOrRegisterSingleton(Object singleton) {
        return Debugger.mapDebugger(debugger -> debugger.onGetOrRegisterSingleton(singleton));
    }

    @Nullable
    public String nameForObject(@Nonnull Object var1);

    @Nullable
    public PlanContext getPlanContext();

    public boolean isSane();

    public void onEvent(Event var1);

    public void onDone();

    public int onGetIndex(@Nonnull Class<?> var1);

    public int onUpdateIndex(@Nonnull Class<?> var1, @Nonnull IntUnaryOperator var2);

    public void onRegisterExpression(@Nonnull RelationalExpression var1);

    public void onRegisterReference(@Nonnull Reference var1);

    public void onRegisterQuantifier(@Nonnull Quantifier var1);

    public int onGetOrRegisterSingleton(@Nonnull Object var1);

    public void onInstall();

    public void onSetup();

    public void onShow(@Nonnull Reference var1);

    public void onQuery(String var1, PlanContext var2);

    public String showStats();

    @Nonnull
    public Optional<StatsMaps> getStatsMaps();

    public static class TranslateCorrelationsEvent
    implements Event {
        @Nonnull
        private final RelationalExpression expression;
        @Nonnull
        private final Location location;

        public TranslateCorrelationsEvent(@Nonnull RelationalExpression expression, @Nonnull Location location) {
            this.expression = expression;
            this.location = location;
        }

        @Override
        @Nonnull
        public String getDescription() {
            return "translate correlations";
        }

        @Override
        @Nonnull
        public Shorthand getShorthand() {
            return Shorthand.TRANSLATE_CORRELATIONS;
        }

        @Nonnull
        public RelationalExpression getExpression() {
            return this.expression;
        }

        @Override
        @Nonnull
        public Location getLocation() {
            return this.location;
        }

        @Override
        @Nonnull
        public PTranslateCorrelationsEvent toProto() {
            return PTranslateCorrelationsEvent.newBuilder().setExpression(Event.toExpressionProto(this.expression)).setLocation(this.location.name()).build();
        }

        @Override
        @Nonnull
        public PEvent.Builder toEventBuilder() {
            return PEvent.newBuilder().setTranslateCorrelationsEvent(this.toProto());
        }
    }

    public static class InsertIntoMemoEvent
    implements Event {
        @Nullable
        private final RelationalExpression expression;
        @Nonnull
        private final Location location;
        @Nonnull
        private final List<Reference> reusedExpressionReferences;

        private InsertIntoMemoEvent(@Nonnull Location location, @Nullable RelationalExpression expression, @Nonnull Collection<Reference> reusedExpressionReferences) {
            if (expression != null) {
                Debugger.registerExpression(expression);
            }
            this.expression = expression;
            this.location = location;
            this.reusedExpressionReferences = ImmutableList.copyOf(reusedExpressionReferences);
            this.reusedExpressionReferences.forEach(Debugger::registerReference);
        }

        @Override
        @Nonnull
        public String getDescription() {
            return "insert into memo";
        }

        @Override
        @Nonnull
        public Shorthand getShorthand() {
            return Shorthand.INSERT_INTO_MEMO;
        }

        @Nullable
        public RelationalExpression getExpression() {
            return this.expression;
        }

        @Nonnull
        public Collection<Reference> getReusedExpressionReferences() {
            return this.reusedExpressionReferences;
        }

        @Override
        @Nonnull
        public Location getLocation() {
            return this.location;
        }

        @Override
        @Nonnull
        public PInsertIntoMemoEvent toProto() {
            PInsertIntoMemoEvent.Builder builder = PInsertIntoMemoEvent.newBuilder().setLocation(this.getLocation().name()).addAllReusedExpressionReferences(this.getReusedExpressionReferences().stream().map(Event::toReferenceProto).collect(ImmutableList.toImmutableList()));
            if (this.expression != null) {
                builder.setExpression(Event.toExpressionProto(this.expression));
            }
            return builder.build();
        }

        @Override
        @Nonnull
        public PEvent.Builder toEventBuilder() {
            return PEvent.newBuilder().setInsertIntoMemoEvent(this.toProto());
        }

        @Nonnull
        public static InsertIntoMemoEvent begin() {
            return new InsertIntoMemoEvent(Location.BEGIN, null, ImmutableList.of());
        }

        @Nonnull
        public static InsertIntoMemoEvent end() {
            return new InsertIntoMemoEvent(Location.END, null, ImmutableList.of());
        }

        @Nonnull
        public static InsertIntoMemoEvent newExp(@Nonnull RelationalExpression expression) {
            return new InsertIntoMemoEvent(Location.NEW, expression, ImmutableList.of());
        }

        @Nonnull
        public static InsertIntoMemoEvent reusedExp(@Nonnull RelationalExpression expression) {
            return new InsertIntoMemoEvent(Location.REUSED, expression, ImmutableList.of());
        }

        @Nonnull
        public static InsertIntoMemoEvent reusedExpWithReferences(@Nonnull RelationalExpression expression, @Nonnull List<Reference> references) {
            return new InsertIntoMemoEvent(Location.REUSED, expression, references);
        }
    }

    public static class OptimizeInputsEvent
    extends AbstractEventWithState
    implements EventWithCurrentGroupReference {
        @Nonnull
        private final Reference currentGroupReference;
        @Nonnull
        private final RelationalExpression expression;

        public OptimizeInputsEvent(@Nonnull PlannerPhase plannerPhase, @Nonnull Reference rootReference, @Nonnull Deque<CascadesPlanner.Task> taskStack, @Nonnull Location location, @Nonnull Reference currentGroupReference, @Nonnull RelationalExpression expression) {
            super(plannerPhase, rootReference, taskStack, location);
            this.currentGroupReference = currentGroupReference;
            this.expression = expression;
        }

        @Override
        @Nonnull
        public String getDescription() {
            return "optimize inputs";
        }

        @Override
        @Nonnull
        public Shorthand getShorthand() {
            return Shorthand.OPTINPUTS;
        }

        @Override
        @Nonnull
        public Reference getCurrentReference() {
            return this.currentGroupReference;
        }

        @Nonnull
        public RelationalExpression getExpression() {
            return this.expression;
        }

        @Override
        @Nonnull
        public POptimizeInputsEvent toProto() {
            return POptimizeInputsEvent.newBuilder().setSuper(this.toAbstractEventWithStateProto()).setCurrentGroupReference(Event.toReferenceProto(this.currentGroupReference)).setExpression(Event.toExpressionProto(this.expression)).build();
        }

        @Override
        @Nonnull
        public PEvent.Builder toEventBuilder() {
            return PEvent.newBuilder().setOptimizeInputsEvent(this.toProto());
        }
    }

    public static class AdjustMatchEvent
    extends AbstractEventWithState
    implements EventWithCurrentGroupReference {
        @Nonnull
        private final Reference currentGroupReference;
        @Nonnull
        private final RelationalExpression expression;

        public AdjustMatchEvent(@Nonnull PlannerPhase plannerPhase, @Nonnull Reference rootReference, @Nonnull Deque<CascadesPlanner.Task> taskStack, @Nonnull Location location, @Nonnull Reference currentGroupReference, @Nonnull RelationalExpression expression) {
            super(plannerPhase, rootReference, taskStack, location);
            this.currentGroupReference = currentGroupReference;
            this.expression = expression;
        }

        @Override
        @Nonnull
        public String getDescription() {
            return "adjust match";
        }

        @Override
        @Nonnull
        public Shorthand getShorthand() {
            return Shorthand.ADJUSTMATCH;
        }

        @Override
        @Nonnull
        public Reference getCurrentReference() {
            return this.currentGroupReference;
        }

        @Nonnull
        public RelationalExpression getExpression() {
            return this.expression;
        }

        @Override
        @Nonnull
        public PAdjustMatchEvent toProto() {
            return PAdjustMatchEvent.newBuilder().setSuper(this.toAbstractEventWithStateProto()).setCurrentGroupReference(Event.toReferenceProto(this.currentGroupReference)).setExpression(Event.toExpressionProto(this.expression)).build();
        }

        @Override
        @Nonnull
        public PEvent.Builder toEventBuilder() {
            return PEvent.newBuilder().setAdjustMatchEvent(this.toProto());
        }
    }

    public static class TransformRuleCallEvent
    extends AbstractEventWithState
    implements EventWithCurrentGroupReference,
    EventWithRule {
        @Nonnull
        private final Reference currentGroupReference;
        @Nonnull
        private final Object bindable;
        @Nonnull
        private final CascadesRule<?> rule;
        @Nonnull
        private final CascadesRuleCall ruleCall;

        public TransformRuleCallEvent(@Nonnull PlannerPhase plannerPhase, @Nonnull Reference rootReference, @Nonnull Deque<CascadesPlanner.Task> taskStack, @Nonnull Location location, @Nonnull Reference currentGroupReference, @Nonnull Object bindable, @Nonnull CascadesRule<?> rule, @Nonnull CascadesRuleCall ruleCall) {
            super(plannerPhase, rootReference, taskStack, location);
            this.currentGroupReference = currentGroupReference;
            this.bindable = bindable;
            this.rule = rule;
            this.ruleCall = ruleCall;
        }

        @Override
        @Nonnull
        public String getDescription() {
            return "transform rule call";
        }

        @Override
        @Nonnull
        public Shorthand getShorthand() {
            return Shorthand.RULECALL;
        }

        @Override
        @Nonnull
        public Reference getCurrentReference() {
            return this.currentGroupReference;
        }

        @Nonnull
        public Object getBindable() {
            return this.bindable;
        }

        @Override
        @Nonnull
        public CascadesRule<?> getRule() {
            return this.rule;
        }

        @Nonnull
        public CascadesRuleCall getRuleCall() {
            return this.ruleCall;
        }

        @Override
        @Nonnull
        public PTransformRuleCallEvent toProto() {
            return PTransformRuleCallEvent.newBuilder().setSuper(this.toAbstractEventWithStateProto()).setCurrentGroupReference(Event.toReferenceProto(this.currentGroupReference)).setBindable(Event.toBindableProto(this.bindable)).setRule(this.rule.toString()).build();
        }

        @Override
        @Nonnull
        public PEvent.Builder toEventBuilder() {
            return PEvent.newBuilder().setTransformRuleCallEvent(this.toProto());
        }
    }

    public static class TransformEvent
    extends AbstractEventWithState
    implements EventWithCurrentGroupReference,
    EventWithRule {
        @Nonnull
        private final Reference currentGroupReference;
        @Nonnull
        private final Object bindable;
        @Nonnull
        private final CascadesRule<?> rule;

        public TransformEvent(@Nonnull PlannerPhase plannerPhase, @Nonnull Reference rootReference, @Nonnull Deque<CascadesPlanner.Task> taskStack, @Nonnull Location location, @Nonnull Reference currentGroupReference, @Nonnull Object bindable, @Nonnull CascadesRule<?> rule) {
            super(plannerPhase, rootReference, taskStack, location);
            this.currentGroupReference = currentGroupReference;
            this.bindable = bindable;
            this.rule = rule;
        }

        @Override
        @Nonnull
        public String getDescription() {
            return "transform";
        }

        @Override
        @Nonnull
        public Shorthand getShorthand() {
            return Shorthand.TRANSFORM;
        }

        @Override
        @Nonnull
        public Reference getCurrentReference() {
            return this.currentGroupReference;
        }

        @Nonnull
        public Object getBindable() {
            return this.bindable;
        }

        @Override
        @Nonnull
        public CascadesRule<?> getRule() {
            return this.rule;
        }

        @Override
        @Nonnull
        public PTransformEvent toProto() {
            return PTransformEvent.newBuilder().setSuper(this.toAbstractEventWithStateProto()).setCurrentGroupReference(Event.toReferenceProto(this.currentGroupReference)).setBindable(Event.toBindableProto(this.bindable)).setRule(this.rule.toString()).build();
        }

        @Override
        @Nonnull
        public PEvent.Builder toEventBuilder() {
            return PEvent.newBuilder().setTransformEvent(this.toProto());
        }
    }

    public static class ExploreGroupEvent
    extends AbstractEventWithState
    implements EventWithCurrentGroupReference {
        @Nonnull
        private final Reference currentGroupReference;

        public ExploreGroupEvent(@Nonnull PlannerPhase plannerPhase, @Nonnull Reference rootReference, @Nonnull Deque<CascadesPlanner.Task> taskStack, @Nonnull Location location, @Nonnull Reference currentGroupReference) {
            super(plannerPhase, rootReference, taskStack, location);
            this.currentGroupReference = currentGroupReference;
        }

        @Override
        @Nonnull
        public String getDescription() {
            return "explore group";
        }

        @Override
        @Nonnull
        public Shorthand getShorthand() {
            return Shorthand.EXPGROUP;
        }

        @Override
        @Nonnull
        public Reference getCurrentReference() {
            return this.currentGroupReference;
        }

        @Override
        @Nonnull
        public PExploreGroupEvent toProto() {
            return PExploreGroupEvent.newBuilder().setSuper(this.toAbstractEventWithStateProto()).setCurrentGroupReference(Event.toReferenceProto(this.currentGroupReference)).build();
        }

        @Override
        @Nonnull
        public PEvent.Builder toEventBuilder() {
            return PEvent.newBuilder().setExploreGroupEvent(this.toProto());
        }
    }

    public static class ExploreExpressionEvent
    extends AbstractEventWithState
    implements EventWithCurrentGroupReference {
        @Nonnull
        private final Reference currentGroupReference;
        @Nonnull
        private final RelationalExpression expression;

        public ExploreExpressionEvent(@Nonnull PlannerPhase plannerPhase, @Nonnull Reference rootReference, @Nonnull Deque<CascadesPlanner.Task> taskStack, @Nonnull Location location, @Nonnull Reference currentGroupReference, @Nonnull RelationalExpression expression) {
            super(plannerPhase, rootReference, taskStack, location);
            this.currentGroupReference = currentGroupReference;
            this.expression = expression;
        }

        @Override
        @Nonnull
        public String getDescription() {
            return "explore expression";
        }

        @Override
        @Nonnull
        public Shorthand getShorthand() {
            return Shorthand.EXPEXP;
        }

        @Override
        @Nonnull
        public Reference getCurrentReference() {
            return this.currentGroupReference;
        }

        @Nonnull
        public RelationalExpression getExpression() {
            return this.expression;
        }

        @Override
        @Nonnull
        public PExploreExpressionEvent toProto() {
            return PExploreExpressionEvent.newBuilder().setSuper(this.toAbstractEventWithStateProto()).setCurrentGroupReference(Event.toReferenceProto(this.currentGroupReference)).setExpression(Event.toExpressionProto(this.expression)).build();
        }

        @Override
        @Nonnull
        public PEvent.Builder toEventBuilder() {
            return PEvent.newBuilder().setExploreExpressionEvent(this.toProto());
        }
    }

    public static class OptimizeGroupEvent
    extends AbstractEventWithState
    implements EventWithCurrentGroupReference {
        @Nonnull
        private final Reference currentGroupReference;

        public OptimizeGroupEvent(@Nonnull PlannerPhase plannerPhase, @Nonnull Reference rootReference, @Nonnull Deque<CascadesPlanner.Task> taskStack, @Nonnull Location location, @Nonnull Reference currentGroupReference) {
            super(plannerPhase, rootReference, taskStack, location);
            this.currentGroupReference = currentGroupReference;
        }

        @Override
        @Nonnull
        public String getDescription() {
            return "optimizing group";
        }

        @Override
        @Nonnull
        public Shorthand getShorthand() {
            return Shorthand.OPTGROUP;
        }

        @Override
        @Nonnull
        public Reference getCurrentReference() {
            return this.currentGroupReference;
        }

        @Override
        @Nonnull
        public POptimizeGroupEvent toProto() {
            return POptimizeGroupEvent.newBuilder().setSuper(this.toAbstractEventWithStateProto()).setCurrentGroupReference(Event.toReferenceProto(this.currentGroupReference)).build();
        }

        @Override
        @Nonnull
        public PEvent.Builder toEventBuilder() {
            return PEvent.newBuilder().setOptimizeGroupEvent(this.toProto());
        }
    }

    public static class InitiatePlannerPhaseEvent
    extends AbstractEventWithState {
        public InitiatePlannerPhaseEvent(@Nonnull PlannerPhase plannerPhase, @Nonnull Reference rootReference, @Nonnull Deque<CascadesPlanner.Task> taskStack, @Nonnull Location location) {
            super(plannerPhase, rootReference, taskStack, location);
        }

        @Override
        @Nonnull
        public String getDescription() {
            return "initiating planner phase " + this.getPlannerPhase().name();
        }

        @Override
        @Nonnull
        public Shorthand getShorthand() {
            return Shorthand.INITPHASE;
        }

        @Override
        @Nonnull
        public PInitiatePlannerPhaseEvent toProto() {
            return PInitiatePlannerPhaseEvent.newBuilder().setSuper(this.toAbstractEventWithStateProto()).build();
        }

        @Override
        @Nonnull
        public PEvent.Builder toEventBuilder() {
            return PEvent.newBuilder().setInitiatePlannerPhaseEvent(this.toProto());
        }
    }

    public static class ExecutingTaskEvent
    extends AbstractEventWithState {
        @Nonnull
        private final CascadesPlanner.Task task;

        public ExecutingTaskEvent(@Nonnull Reference rootReference, @Nonnull Deque<CascadesPlanner.Task> taskStack, @Nonnull Location location, @Nonnull CascadesPlanner.Task task) {
            super(task.getPlannerPhase(), rootReference, taskStack, location);
            this.task = task;
        }

        @Override
        @Nonnull
        public String getDescription() {
            return "executing task";
        }

        @Override
        @Nonnull
        public Shorthand getShorthand() {
            return Shorthand.TASK;
        }

        @Nonnull
        public CascadesPlanner.Task getTask() {
            return this.task;
        }

        @Override
        @Nonnull
        public PExecutingTaskEvent toProto() {
            return PExecutingTaskEvent.newBuilder().setSuper(this.toAbstractEventWithStateProto()).build();
        }

        @Override
        @Nonnull
        public PEvent.Builder toEventBuilder() {
            return PEvent.newBuilder().setExecutingTaskEvent(this.toProto());
        }
    }

    public static abstract class AbstractEventWithState
    implements EventWithState {
        @Nonnull
        private final PlannerPhase plannerPhase;
        @Nonnull
        private final Reference rootReference;
        @Nonnull
        private final Deque<CascadesPlanner.Task> taskStack;
        @Nonnull
        private final Location location;

        protected AbstractEventWithState(@Nonnull PlannerPhase plannerPhase, @Nonnull Reference rootReference, @Nonnull Deque<CascadesPlanner.Task> taskStack, @Nonnull Location location) {
            this.plannerPhase = plannerPhase;
            this.rootReference = rootReference;
            this.taskStack = taskStack;
            this.location = location;
        }

        @Override
        @Nonnull
        public PlannerPhase getPlannerPhase() {
            return this.plannerPhase;
        }

        @Override
        @Nonnull
        public Reference getRootReference() {
            return this.rootReference;
        }

        @Override
        @Nonnull
        public Deque<CascadesPlanner.Task> getTaskStack() {
            return this.taskStack;
        }

        @Override
        @Nonnull
        public Location getLocation() {
            return this.location;
        }

        @Nonnull
        public PAbstractEventWithState toAbstractEventWithStateProto() {
            return PAbstractEventWithState.newBuilder().setPlannerPhase(this.plannerPhase.toProto()).setRootReference(Event.toReferenceProto(this.rootReference)).setLocation(this.getLocation().name()).build();
        }
    }

    public static interface EventWithRule {
        @Nonnull
        public CascadesRule<?> getRule();
    }

    public static interface EventWithCurrentGroupReference
    extends EventWithState {
        @Nonnull
        public Reference getCurrentReference();
    }

    public static interface EventWithState
    extends Event {
        @Nonnull
        public PlannerPhase getPlannerPhase();

        @Nonnull
        public Reference getRootReference();

        @Nonnull
        public Deque<CascadesPlanner.Task> getTaskStack();
    }

    public static interface Event {
        @Nonnull
        public String getDescription();

        @Nonnull
        public Shorthand getShorthand();

        @Nonnull
        public Location getLocation();

        @Nonnull
        public Message toProto();

        @Nonnull
        default public PEvent toEventProto() {
            return this.toEventBuilder().setDescription(this.getDescription()).setShorthand(this.getShorthand().name()).build();
        }

        @Nonnull
        public PEvent.Builder toEventBuilder();

        @Nonnull
        public static PRegisteredRelationalExpression toExpressionProto(@Nonnull RelationalExpression expression) {
            return PRegisteredRelationalExpression.newBuilder().setName(Debugger.mapDebugger(debugger -> debugger.nameForObject(expression)).orElseThrow()).setSemanticHashCode(expression.semanticHashCode()).build();
        }

        @Nonnull
        public static PRegisteredReference toReferenceProto(@Nonnull Reference reference) {
            PRegisteredReference.Builder builder = PRegisteredReference.newBuilder().setName(Debugger.mapDebugger(debugger -> debugger.nameForObject(reference)).orElseThrow());
            for (RelationalExpression member : reference.getAllMemberExpressions()) {
                builder.addExpressions(Event.toExpressionProto(member));
            }
            return builder.build();
        }

        @Nonnull
        public static PBindable toBindableProto(@Nonnull Object bindable) {
            PBindable.Builder builder = PBindable.newBuilder();
            if (bindable instanceof RelationalExpression) {
                builder.setExpression(Event.toExpressionProto((RelationalExpression)bindable));
            } else if (bindable instanceof PartialMatch) {
                builder.setPartialMatch(Event.toPartialMatchProto((PartialMatch)bindable));
            } else if (bindable instanceof MatchPartition) {
                builder.setMatchPartition(Event.toMatchPartitionProto((MatchPartition)bindable));
            }
            return builder.build();
        }

        @Nonnull
        public static PPartialMatch toPartialMatchProto(@Nonnull PartialMatch partialMatch) {
            return PPartialMatch.newBuilder().setMatchCandidate(partialMatch.toString()).setQueryRef(Event.toReferenceProto(partialMatch.getQueryRef())).setQueryExpression(Event.toExpressionProto(partialMatch.getQueryExpression())).setCandidateRef(Event.toReferenceProto(partialMatch.getCandidateRef())).build();
        }

        @Nonnull
        public static PMatchPartition toMatchPartitionProto(@Nonnull MatchPartition matchPartition) {
            PMatchPartition.Builder builder = PMatchPartition.newBuilder();
            for (PartialMatch partialMatch : matchPartition.getPartialMatches()) {
                builder.addPartialMatches(Event.toPartialMatchProto(partialMatch));
            }
            return builder.build();
        }
    }

    public static enum Location {
        ANY,
        BEGIN,
        END,
        MATCH_PRE,
        YIELD,
        FAILURE,
        COUNT,
        NEW,
        REUSED,
        DISCARDED_INTERSECTION_COMBINATIONS,
        ALL_INTERSECTION_COMBINATIONS;

    }

    public static enum Shorthand {
        TASK,
        OPTGROUP,
        EXPEXP,
        EXPGROUP,
        ADJUSTMATCH,
        MATCHEXPCAND,
        OPTINPUTS,
        RULECALL,
        TRANSFORM,
        INSERT_INTO_MEMO,
        TRANSLATE_CORRELATIONS,
        INITPHASE;

    }
}

