/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.debug;

import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.query.combinatorics.PartiallyOrderedSet;
import com.apple.foundationdb.record.query.combinatorics.TopologicalSort;
import com.apple.foundationdb.record.query.plan.cascades.CascadesRuleCall;
import com.apple.foundationdb.record.query.plan.cascades.PlanContext;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.apple.foundationdb.record.query.plan.cascades.debug.RestartException;
import com.apple.foundationdb.record.query.plan.cascades.debug.State;
import com.apple.foundationdb.record.query.plan.cascades.debug.StatsMaps;
import com.apple.foundationdb.record.query.plan.cascades.debug.eventprotos.PEvent;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.properties.ReferencesAndDependenciesProperty;
import com.google.common.base.Verify;
import com.google.common.cache.Cache;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebuggerWithSymbolTables
implements Debugger {
    private static final Logger logger = LoggerFactory.getLogger(DebuggerWithSymbolTables.class);
    private final boolean isSane;
    private final boolean isRecordEvents;
    private final Iterable<PEvent> prerecordedEventProtoIterable;
    private final Deque<State> stateStack;
    @Nullable
    private String queryAsString;
    @Nullable
    private PlanContext planContext;
    @Nonnull
    private final Map<Object, Integer> singletonToIndexMap;

    private DebuggerWithSymbolTables(boolean isSane, boolean isRecordEvents, @Nullable String prerecordedEventsFileName) {
        this.isSane = isSane;
        this.isRecordEvents = isRecordEvents;
        this.prerecordedEventProtoIterable = prerecordedEventsFileName == null ? null : DebuggerWithSymbolTables.eventProtosFromFile(prerecordedEventsFileName);
        this.stateStack = new ArrayDeque<State>();
        this.planContext = null;
        this.singletonToIndexMap = Maps.newHashMap();
    }

    @Nonnull
    State getCurrentState() {
        return Objects.requireNonNull(this.stateStack.peek());
    }

    @Override
    @Nullable
    public PlanContext getPlanContext() {
        return this.planContext;
    }

    @Override
    public boolean isSane() {
        return this.isSane;
    }

    @Override
    public int onGetIndex(@Nonnull Class<?> clazz) {
        return this.getCurrentState().getIndex(clazz);
    }

    @Override
    public int onUpdateIndex(@Nonnull Class<?> clazz, @Nonnull IntUnaryOperator updateFn) {
        return this.getCurrentState().updateIndex(clazz, updateFn);
    }

    @Override
    public void onRegisterExpression(@Nonnull RelationalExpression expression) {
        this.getCurrentState().registerExpression(expression);
    }

    @Override
    public void onRegisterReference(@Nonnull Reference reference) {
        this.getCurrentState().registerReference(reference);
    }

    @Override
    public void onRegisterQuantifier(@Nonnull Quantifier quantifier) {
        this.getCurrentState().registerQuantifier(quantifier);
    }

    @Override
    public int onGetOrRegisterSingleton(@Nonnull Object singleton) {
        int size = this.singletonToIndexMap.size();
        return this.singletonToIndexMap.computeIfAbsent(singleton, s2 -> size);
    }

    @Override
    public void onInstall() {
    }

    @Override
    public void onSetup() {
        this.reset();
    }

    @Override
    public void onShow(@Nonnull Reference ref) {
    }

    @Override
    public void onQuery(@Nonnull String recordQuery, @Nonnull PlanContext planContext) {
        this.stateStack.push(State.copyOf(this.getCurrentState()));
        this.queryAsString = recordQuery;
        this.planContext = planContext;
        this.logQuery();
    }

    void restartState() {
        this.stateStack.pop();
        this.stateStack.push(State.copyOf(this.getCurrentState()));
    }

    @Override
    public void onEvent(Debugger.Event event) {
        Debugger.TransformRuleCallEvent transformRuleCallEvent;
        CascadesRuleCall ruleCall;
        Iterable<RelationalExpression> newExpressions;
        if (this.queryAsString == null || this.planContext == null || this.stateStack.isEmpty()) {
            return;
        }
        this.getCurrentState().addCurrentEvent(event);
        if (logger.isTraceEnabled() && event.getLocation() == Debugger.Location.END && event instanceof Debugger.TransformRuleCallEvent && !Iterables.isEmpty(newExpressions = Iterables.concat((ruleCall = (transformRuleCallEvent = (Debugger.TransformRuleCallEvent)event).getRuleCall()).getNewFinalExpressions(), ruleCall.getNewExploratoryExpressions()))) {
            KeyValueLogMessage logMessage = KeyValueLogMessage.build("rule yielded new expression(s)", "rule", transformRuleCallEvent.getRule().getClass().getSimpleName());
            String name = this.nameForObject(transformRuleCallEvent.getBindable());
            if (name != null) {
                logMessage.addKeyAndValue("name", name);
            }
            logMessage.addKeyAndValue("expressions", Streams.stream(newExpressions).map(this::nameForObject).collect(Collectors.joining(", ")));
            logger.trace(logMessage.toString());
        }
    }

    @Nullable
    static <T> T lookupInCache(Cache<Integer, T> cache, String identifier, String prefix) {
        Integer refId = DebuggerWithSymbolTables.getIdFromIdentifier(identifier, prefix);
        if (refId == null) {
            return null;
        }
        return cache.getIfPresent(refId);
    }

    @Nullable
    static Integer getIdFromIdentifier(String identifier, String prefix) {
        String idAsString = identifier.substring(prefix.length());
        try {
            return Integer.valueOf(idAsString);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    @Nonnull
    String nameForObjectOrNotInCache(@Nonnull Object object) {
        return Optional.ofNullable(this.nameForObject(object)).orElse("not in cache");
    }

    boolean isValidEntityName(@Nonnull String identifier) {
        String lowerCase = identifier.toLowerCase(Locale.ROOT);
        if (!(lowerCase.startsWith("exp") || lowerCase.startsWith("ref") || lowerCase.startsWith("qun"))) {
            return false;
        }
        return DebuggerWithSymbolTables.getIdFromIdentifier(identifier, identifier.substring(0, 3)) != null;
    }

    @Override
    @Nullable
    public String nameForObject(@Nonnull Object object) {
        State state = this.getCurrentState();
        if (object instanceof RelationalExpression) {
            Integer id = state.getInvertedExpressionsCache().getIfPresent(object);
            return id == null ? null : "exp" + id;
        }
        if (object instanceof Reference) {
            Integer id = state.getInvertedReferenceCache().getIfPresent(object);
            return id == null ? null : "ref" + id;
        }
        if (object instanceof Quantifier) {
            Integer id = state.getInvertedQuantifierCache().getIfPresent(object);
            return id == null ? null : "qun" + id;
        }
        return null;
    }

    @Override
    public void onDone() {
        if (!this.stateStack.isEmpty() && this.queryAsString != null) {
            Iterator<PEvent> prerecordedEventProtoIterator;
            List<PEvent> eventProtos;
            State state = Objects.requireNonNull(this.stateStack.peek());
            if (logger.isInfoEnabled()) {
                logger.info(KeyValueLogMessage.of("planning done", "query", Objects.requireNonNull(this.queryAsString).substring(0, Math.min(this.queryAsString.length(), 30)), "duration-in-ms", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - state.getStartTs()), "ticks", state.getCurrentTick()));
            }
            if ((eventProtos = state.getEventProtos()) != null) {
                DebuggerWithSymbolTables.writeEventsDelimitedToFile(eventProtos);
            }
            if ((prerecordedEventProtoIterator = state.getPrerecordedEventProtoIterator()) != null) {
                Verify.verify(!prerecordedEventProtoIterator.hasNext(), "There are more prerecorded events, there are only " + state.getCurrentTick() + " actual events.", new Object[0]);
            }
        }
        this.reset();
    }

    private static void writeEventsDelimitedToFile(List<PEvent> eventProtos) {
        try {
            File tempFile = File.createTempFile("events-", ".bin");
            try (FileOutputStream fos = new FileOutputStream(tempFile);){
                for (PEvent eventProto : eventProtos) {
                    eventProto.writeDelimitedTo(fos);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    private static Iterable<PEvent> eventProtosFromFile(@Nonnull String fileName) {
        return () -> DebuggerWithSymbolTables.readEventsDelimitedFromFile(fileName);
    }

    @Nonnull
    private static Iterator<PEvent> readEventsDelimitedFromFile(@Nonnull String fileName) {
        FileInputStream fis;
        File file = new File(fileName);
        try {
            fis = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        return new AbstractIterator<PEvent>(){

            @Override
            @Nullable
            protected PEvent computeNext() {
                try {
                    PEvent event = PEvent.parseDelimitedFrom(fis);
                    if (event == null) {
                        fis.close();
                        return (PEvent)this.endOfData();
                    }
                    return event;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    @Override
    public String showStats() {
        State currentState = this.stateStack.peek();
        if (currentState != null) {
            return currentState.showStats();
        }
        return "no stats";
    }

    @Override
    @Nonnull
    public Optional<StatsMaps> getStatsMaps() {
        State currentState = this.stateStack.peek();
        if (currentState != null) {
            return Optional.of(currentState.getStatsMaps());
        }
        return Optional.empty();
    }

    private void reset() {
        this.stateStack.clear();
        this.stateStack.push(State.initial(this.isRecordEvents, this.isRecordEvents, this.prerecordedEventProtoIterable));
        this.planContext = null;
        this.queryAsString = null;
    }

    void logQuery() {
        if (logger.isDebugEnabled()) {
            logger.debug(KeyValueLogMessage.of("planning started", "query", this.queryAsString));
        }
    }

    @Nonnull
    private <T> Optional<T> getSilently(@Nonnull String actionName, @Nonnull SupplierWithException<T> supplier) {
        try {
            return Optional.ofNullable(supplier.get());
        }
        catch (RestartException rE) {
            throw rE;
        }
        catch (Exception e) {
            if (logger.isWarnEnabled()) {
                logger.warn("unable to get {}: {}", (Object)actionName, (Object)e.getMessage());
            }
            e.printStackTrace();
            return Optional.empty();
        }
    }

    @Nonnull
    public static DebuggerWithSymbolTables withoutSanityChecks() {
        return new DebuggerWithSymbolTables(true, false, null);
    }

    @Nonnull
    public static DebuggerWithSymbolTables withSanityChecks() {
        return new DebuggerWithSymbolTables(false, false, null);
    }

    @Nonnull
    public static DebuggerWithSymbolTables withEventRecording() {
        return new DebuggerWithSymbolTables(true, false, null);
    }

    @Nonnull
    public static DebuggerWithSymbolTables withRerecordEvents() {
        return new DebuggerWithSymbolTables(true, true, null);
    }

    @Nonnull
    public static DebuggerWithSymbolTables withPrerecordedEvents(@Nonnull String fileName) {
        return new DebuggerWithSymbolTables(true, true, fileName);
    }

    public static void printForEachExpression(@Nonnull Reference root) {
        DebuggerWithSymbolTables.forEachExpression(root, expression -> System.out.println("expression: " + Debugger.mapDebugger(debugger -> debugger.nameForObject(expression)).orElseThrow() + "; hashCodeWithoutChildren: " + expression.hashCodeWithoutChildren() + "explain: " + String.valueOf(expression)));
    }

    public static void forEachExpression(@Nonnull Reference root, @Nonnull Consumer<RelationalExpression> consumer) {
        PartiallyOrderedSet<Reference> references = ReferencesAndDependenciesProperty.referencesAndDependencies().evaluate(root);
        List<Reference> referenceList = TopologicalSort.anyTopologicalOrderPermutation(references).orElseThrow();
        for (Reference reference : referenceList) {
            for (RelationalExpression member : reference.getAllMemberExpressions()) {
                consumer.accept(member);
            }
        }
    }

    @FunctionalInterface
    private static interface SupplierWithException<T> {
        public T get() throws Exception;
    }
}

