/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.debug;

import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.query.plan.cascades.CascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.debug.BrowserHelper;
import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.apple.foundationdb.record.query.plan.cascades.debug.Stats;
import com.apple.foundationdb.record.query.plan.cascades.debug.StatsMaps;
import com.apple.foundationdb.record.query.plan.cascades.debug.eventprotos.PEvent;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.util.pair.Pair;
import com.google.common.base.Verify;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.IntUnaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class State {
    @Nonnull
    private static final Logger logger = LoggerFactory.getLogger(State.class);
    @Nonnull
    private final Map<Class<?>, Integer> classToIndexMap;
    @Nonnull
    private final Cache<Integer, RelationalExpression> expressionCache;
    @Nonnull
    private final Cache<RelationalExpression, Integer> invertedExpressionsCache;
    @Nonnull
    private final Cache<Integer, Reference> referenceCache;
    @Nonnull
    private final Cache<Reference, Integer> invertedReferenceCache;
    @Nonnull
    private final Cache<Integer, Quantifier> quantifierCache;
    @Nonnull
    private final Cache<Quantifier, Integer> invertedQuantifierCache;
    @Nullable
    private final List<Debugger.Event> events;
    @Nullable
    private final List<PEvent> eventProtos;
    @Nullable
    private final Iterable<PEvent> prerecordedEventProtoIterable;
    @Nullable
    private Iterator<PEvent> prerecordedEventProtoIterator;
    @Nonnull
    private final Map<Class<? extends Debugger.Event>, MutableStats> eventClassStatsMap;
    @Nonnull
    private final Map<Class<? extends CascadesRule<?>>, MutableStats> plannerRuleClassStatsMap;
    @Nonnull
    private final Deque<Pair<Class<? extends Debugger.Event>, EventDurations>> eventProfilingStack;
    private int currentTick;
    private final long startTs;

    public static State initial(boolean isRecordEvents, boolean isRecordEventProtos, @Nullable Iterable<PEvent> prerecordedEventProtoIterable) {
        return new State(isRecordEvents, isRecordEventProtos, prerecordedEventProtoIterable);
    }

    public static State copyOf(State source) {
        Cache<Integer, RelationalExpression> copyExpressionCache = CacheBuilder.newBuilder().weakValues().build();
        source.getExpressionCache().asMap().forEach(copyExpressionCache::put);
        Cache<RelationalExpression, Integer> copyInvertedExpressionsCache = CacheBuilder.newBuilder().weakKeys().build();
        source.getInvertedExpressionsCache().asMap().forEach(copyInvertedExpressionsCache::put);
        Cache<Integer, Reference> copyReferenceCache = CacheBuilder.newBuilder().weakValues().build();
        source.getReferenceCache().asMap().forEach(copyReferenceCache::put);
        Cache<Reference, Integer> copyInvertedReferenceCache = CacheBuilder.newBuilder().weakKeys().build();
        source.getInvertedReferenceCache().asMap().forEach(copyInvertedReferenceCache::put);
        Cache<Integer, Quantifier> copyQuantifierCache = CacheBuilder.newBuilder().weakValues().build();
        source.getQuantifierCache().asMap().forEach(copyQuantifierCache::put);
        Cache<Quantifier, Integer> copyInvertedQuantifierCache = CacheBuilder.newBuilder().weakKeys().build();
        source.getInvertedQuantifierCache().asMap().forEach(copyInvertedQuantifierCache::put);
        return new State(source.getClassToIndexMap(), copyExpressionCache, copyInvertedExpressionsCache, copyReferenceCache, copyInvertedReferenceCache, copyQuantifierCache, copyInvertedQuantifierCache, source.events == null ? null : Lists.newArrayList(source.events), source.eventProtos == null ? null : Lists.newArrayList(source.eventProtos), source.prerecordedEventProtoIterable, Maps.newLinkedHashMap(source.eventClassStatsMap), Maps.newLinkedHashMap(source.plannerRuleClassStatsMap), new ArrayDeque<Pair<Class<? extends Debugger.Event>, EventDurations>>(source.eventProfilingStack), source.getCurrentTick(), source.getStartTs());
    }

    private State(boolean isRecordEvents, boolean isRecordEventProtos, @Nullable Iterable<PEvent> prerecordedEventProtoIterable) {
        this(Maps.newHashMap(), CacheBuilder.newBuilder().weakValues().build(), CacheBuilder.newBuilder().weakKeys().build(), CacheBuilder.newBuilder().weakValues().build(), CacheBuilder.newBuilder().weakKeys().build(), CacheBuilder.newBuilder().weakValues().build(), CacheBuilder.newBuilder().weakKeys().build(), isRecordEventProtos ? Lists.newArrayList() : null, isRecordEvents ? Lists.newArrayList() : null, prerecordedEventProtoIterable, Maps.newLinkedHashMap(), Maps.newLinkedHashMap(), new ArrayDeque<Pair<Class<? extends Debugger.Event>, EventDurations>>(), -1, System.nanoTime());
    }

    private State(@Nonnull Map<Class<?>, Integer> classToIndexMap, @Nonnull Cache<Integer, RelationalExpression> expressionCache, @Nonnull Cache<RelationalExpression, Integer> invertedExpressionsCache, @Nonnull Cache<Integer, Reference> referenceCache, @Nonnull Cache<Reference, Integer> invertedReferenceCache, @Nonnull Cache<Integer, Quantifier> quantifierCache, @Nonnull Cache<Quantifier, Integer> invertedQuantifierCache, @Nullable List<Debugger.Event> events, @Nullable List<PEvent> eventProtos, @Nullable Iterable<PEvent> prerecordedEventProtoIterable, @Nonnull Map<Class<? extends Debugger.Event>, MutableStats> eventClassStatsMap, @Nonnull Map<Class<? extends CascadesRule<?>>, MutableStats> plannerRuleClassStatsMap, @Nonnull Deque<Pair<Class<? extends Debugger.Event>, EventDurations>> eventProfilingStack, int currentTick, long startTs) {
        this.classToIndexMap = Maps.newHashMap(classToIndexMap);
        this.expressionCache = expressionCache;
        this.invertedExpressionsCache = invertedExpressionsCache;
        this.referenceCache = referenceCache;
        this.invertedReferenceCache = invertedReferenceCache;
        this.quantifierCache = quantifierCache;
        this.invertedQuantifierCache = invertedQuantifierCache;
        this.events = events;
        this.eventProtos = eventProtos;
        this.prerecordedEventProtoIterable = prerecordedEventProtoIterable;
        this.prerecordedEventProtoIterator = prerecordedEventProtoIterable == null ? null : prerecordedEventProtoIterable.iterator();
        this.eventClassStatsMap = eventClassStatsMap;
        this.plannerRuleClassStatsMap = plannerRuleClassStatsMap;
        this.eventProfilingStack = eventProfilingStack;
        this.currentTick = currentTick;
        this.startTs = startTs;
    }

    @Nonnull
    private Map<Class<?>, Integer> getClassToIndexMap() {
        return this.classToIndexMap;
    }

    @Nonnull
    public Cache<Integer, RelationalExpression> getExpressionCache() {
        return this.expressionCache;
    }

    @Nonnull
    public Cache<RelationalExpression, Integer> getInvertedExpressionsCache() {
        return this.invertedExpressionsCache;
    }

    @Nonnull
    public Cache<Integer, Reference> getReferenceCache() {
        return this.referenceCache;
    }

    @Nonnull
    public Cache<Reference, Integer> getInvertedReferenceCache() {
        return this.invertedReferenceCache;
    }

    @Nonnull
    public Cache<Integer, Quantifier> getQuantifierCache() {
        return this.quantifierCache;
    }

    @Nonnull
    public Cache<Quantifier, Integer> getInvertedQuantifierCache() {
        return this.invertedQuantifierCache;
    }

    @Nullable
    public List<Debugger.Event> getEvents() {
        return this.events;
    }

    @Nullable
    public List<PEvent> getEventProtos() {
        return this.eventProtos;
    }

    @Nullable
    public Iterator<PEvent> getPrerecordedEventProtoIterator() {
        return this.prerecordedEventProtoIterator;
    }

    public int getCurrentTick() {
        return this.currentTick;
    }

    public long getStartTs() {
        return this.startTs;
    }

    public int getIndex(Class<?> clazz) {
        return this.classToIndexMap.getOrDefault(clazz, 0);
    }

    @CanIgnoreReturnValue
    public int updateIndex(Class<?> clazz, IntUnaryOperator computeFn) {
        return this.classToIndexMap.compute(clazz, (c, value) -> value == null ? computeFn.applyAsInt(0) : computeFn.applyAsInt((int)value));
    }

    public void registerExpression(RelationalExpression expression) {
        if (this.invertedExpressionsCache.getIfPresent(expression) == null) {
            int index = this.getIndex(RelationalExpression.class);
            this.expressionCache.put(index, expression);
            this.invertedExpressionsCache.put(expression, index);
            this.updateIndex(RelationalExpression.class, i -> i + 1);
        }
    }

    public void registerReference(Reference reference) {
        if (this.invertedReferenceCache.getIfPresent(reference) == null) {
            int index = this.getIndex(Reference.class);
            this.referenceCache.put(index, reference);
            this.invertedReferenceCache.put(reference, index);
            this.updateIndex(Reference.class, i -> i + 1);
        }
    }

    public void registerQuantifier(Quantifier quantifier) {
        if (this.invertedQuantifierCache.getIfPresent(quantifier) == null) {
            int index = this.getIndex(Quantifier.class);
            this.quantifierCache.put(index, quantifier);
            this.invertedQuantifierCache.put(quantifier, index);
            this.updateIndex(Quantifier.class, i -> i + 1);
        }
    }

    public void addCurrentEvent(@Nonnull Debugger.Event event) {
        if (this.events != null) {
            this.events.add(event);
        }
        if (this.eventProtos != null || this.prerecordedEventProtoIterator != null) {
            PEvent currentEventProto = event.toEventProto();
            if (this.prerecordedEventProtoIterator != null) {
                this.verifyCurrentEventProto(currentEventProto);
            }
            if (this.eventProtos != null) {
                this.eventProtos.add(currentEventProto);
            }
        }
        ++this.currentTick;
        long currentTsInNs = System.nanoTime();
        Class<?> currentEventClass = event.getClass();
        switch (event.getLocation()) {
            case BEGIN: {
                this.eventProfilingStack.push(Pair.of(currentEventClass, new EventDurations(currentTsInNs)));
                this.updateCounts(event);
                break;
            }
            case END: {
                Pair<Class<? extends Debugger.Event>, EventDurations> profilingPair = this.eventProfilingStack.pop();
                Class<? extends Debugger.Event> eventClass = profilingPair.getKey();
                EventDurations eventDurations = profilingPair.getValue();
                if (logger.isWarnEnabled() && currentEventClass != eventClass) {
                    logger.warn(KeyValueLogMessage.of("unable to unwind stack properly", "expected event class", eventClass.getSimpleName(), "current event class", currentEventClass.getSimpleName()));
                }
                long totalTime = currentTsInNs - eventDurations.getStartTsInNs();
                long ownTime = totalTime - eventDurations.getAdjustmentForOwnTimeInNs();
                MutableStats forEventClass = this.getEventStatsForEventClass(currentEventClass);
                forEventClass.increaseTotalTimeInNs(totalTime);
                forEventClass.increaseOwnTimeInNs(ownTime);
                if (event instanceof Debugger.TransformRuleCallEvent) {
                    CascadesRule<?> rule = ((Debugger.TransformRuleCallEvent)event).getRule();
                    Class<?> ruleClass = rule.getClass();
                    MutableStats forPlannerRuleClass = this.getEventStatsForPlannerRuleClass(ruleClass);
                    forPlannerRuleClass.increaseTotalTimeInNs(totalTime);
                    forPlannerRuleClass.increaseOwnTimeInNs(ownTime);
                }
                if ((profilingPair = this.eventProfilingStack.peek()) == null) break;
                eventDurations = profilingPair.getValue();
                eventDurations.increaseAdjustmentForOwnTimeInNs(totalTime);
                break;
            }
            default: {
                this.updateCounts(event);
            }
        }
    }

    private void verifyCurrentEventProto(PEvent currentEventProto) {
        Objects.requireNonNull(this.prerecordedEventProtoIterator);
        Verify.verify(this.prerecordedEventProtoIterator.hasNext(), "ran out of prerecorded events", new Object[0]);
        PEvent expectedProto = this.prerecordedEventProtoIterator.next();
        if (!currentEventProto.equals(expectedProto)) {
            System.err.println("Mismatch found between prerecorded event and this event!");
            System.err.println("The following events prior to this event did match:");
            if (this.eventProtos != null) {
                for (int i = 0; i < this.eventProtos.size(); ++i) {
                    PEvent oldEventProto = this.eventProtos.get(i);
                    System.err.println(i + ": " + oldEventProto.getDescription() + "; " + oldEventProto.getShorthand());
                }
            }
            System.err.println();
            System.err.println("The following event did not match:");
            System.err.println("Expected: " + String.valueOf(expectedProto));
            System.err.println("Actual: " + String.valueOf(currentEventProto));
            this.prerecordedEventProtoIterator = null;
            throw new RecordCoreException("Planning event does not match prerecorded event", new Object[0]);
        }
    }

    private void updateCounts(@Nonnull Debugger.Event event) {
        MutableStats forEventClass = this.getEventStatsForEventClass(event.getClass());
        forEventClass.increaseCount(event.getLocation(), 1L);
        if (event instanceof Debugger.EventWithRule) {
            CascadesRule<?> rule = ((Debugger.EventWithRule)((Object)event)).getRule();
            Class<?> ruleClass = rule.getClass();
            MutableStats forPlannerRuleClass = this.getEventStatsForPlannerRuleClass(ruleClass);
            forPlannerRuleClass.increaseCount(event.getLocation(), 1L);
        }
    }

    private MutableStats getEventStatsForEventClass(@Nonnull Class<? extends Debugger.Event> eventClass) {
        return this.eventClassStatsMap.compute(eventClass, (eC, mutableStats) -> mutableStats != null ? mutableStats : new MutableStats());
    }

    private MutableStats getEventStatsForPlannerRuleClass(@Nonnull Class<? extends CascadesRule<?>> plannerRuleClass) {
        return this.plannerRuleClassStatsMap.compute(plannerRuleClass, (eC, mutableStats) -> mutableStats != null ? mutableStats : new MutableStats());
    }

    @Nonnull
    StatsMaps getStatsMaps() {
        return new StatsMaps(this.eventClassStatsMap, this.plannerRuleClassStatsMap);
    }

    public String showStats() {
        StringBuilder tableBuilder = new StringBuilder();
        tableBuilder.append("<table class=\"table\">");
        this.tableHeader(tableBuilder, "Event");
        ImmutableMap<String, MutableStats> eventStatsMap = this.eventClassStatsMap.entrySet().stream().map(entry -> Pair.of(((Class)entry.getKey()).getSimpleName(), (MutableStats)entry.getValue())).sorted(Map.Entry.comparingByKey()).collect(ImmutableMap.toImmutableMap(Pair::getKey, Pair::getValue));
        this.tableBody(tableBuilder, eventStatsMap);
        tableBuilder.append("</table>");
        String eventProfilingString = tableBuilder.toString();
        tableBuilder = new StringBuilder();
        tableBuilder.append("<table class=\"table\">");
        this.tableHeader(tableBuilder, "Planner Rule");
        ImmutableMap<String, MutableStats> plannerRuleStatsMap = this.plannerRuleClassStatsMap.entrySet().stream().map(entry -> Pair.of(((Class)entry.getKey()).getSimpleName(), (MutableStats)entry.getValue())).sorted(Map.Entry.comparingByKey()).collect(ImmutableMap.toImmutableMap(Pair::getKey, Pair::getValue));
        this.tableBody(tableBuilder, plannerRuleStatsMap);
        tableBuilder.append("</table>");
        String plannerRuleProfilingString = tableBuilder.toString();
        return BrowserHelper.browse("/showProfilingReport.html", ImmutableMap.of("$EVENT_PROFILING", eventProfilingString, "$PLANNER_RULE_PROFILING", plannerRuleProfilingString));
    }

    private void tableHeader(@Nonnull StringBuilder stringBuilder, @Nonnull String category) {
        stringBuilder.append("<thead>");
        stringBuilder.append("<tr>");
        stringBuilder.append("<th scope=\"col\">").append(category).append("</th>");
        stringBuilder.append("<th scope=\"col\">Location</th>");
        stringBuilder.append("<th scope=\"col\">Count</th>");
        stringBuilder.append("<th scope=\"col\">Total Time (micros)</th>");
        stringBuilder.append("<th scope=\"col\">Average Time (micros)</th>");
        stringBuilder.append("<th scope=\"col\">Total Own Time (micros)</th>");
        stringBuilder.append("<th scope=\"col\">Average Own Time (micros)</th>");
        stringBuilder.append("</tr>");
        stringBuilder.append("</thead>");
    }

    private void tableBody(@Nonnull StringBuilder stringBuilder, @Nonnull Map<String, MutableStats> statsMap) {
        stringBuilder.append("<tbody class=\"table-group-divider\">");
        for (Map.Entry<String, MutableStats> entry : statsMap.entrySet()) {
            MutableStats mutableStats = entry.getValue();
            for (Map.Entry<Debugger.Location, Long> locationEntry : mutableStats.getLocationCountMap().entrySet()) {
                stringBuilder.append("<tr>");
                stringBuilder.append("<td>").append(entry.getKey()).append("</td>");
                if (locationEntry.getKey() == Debugger.Location.BEGIN) {
                    stringBuilder.append("<td></td>");
                } else {
                    stringBuilder.append("<td>").append(locationEntry.getKey().name()).append("</td>");
                }
                stringBuilder.append("<td class=\"text-end\">").append(locationEntry.getValue()).append("</td>");
                if (locationEntry.getKey() == Debugger.Location.BEGIN) {
                    stringBuilder.append("<td class=\"text-end\">").append(this.formatNsInMicros(mutableStats.getTotalTimeInNs())).append("</td>");
                    stringBuilder.append("<td class=\"text-end\">").append(this.formatNsInMicros(mutableStats.getTotalTimeInNs() / mutableStats.getCount(Debugger.Location.BEGIN))).append("</td>");
                    stringBuilder.append("<td class=\"text-end\">").append(this.formatNsInMicros(mutableStats.getOwnTimeInNs())).append("</td>");
                    stringBuilder.append("<td class=\"text-end\">").append(this.formatNsInMicros(mutableStats.getOwnTimeInNs() / mutableStats.getCount(Debugger.Location.BEGIN))).append("</td>");
                } else {
                    stringBuilder.append("<td></td>");
                    stringBuilder.append("<td></td>");
                }
                stringBuilder.append("</tr>");
            }
        }
        stringBuilder.append("</tbody>");
    }

    @Nonnull
    private String formatNsInMicros(long ns) {
        long micros = TimeUnit.NANOSECONDS.toMicros(ns);
        return String.format(Locale.ROOT, "%,d", micros);
    }

    private static class EventDurations {
        private final long startTsInNs;
        private long adjustmentForOwnTimeInNs;

        public EventDurations(long startTsInNs) {
            this.startTsInNs = startTsInNs;
        }

        public long getStartTsInNs() {
            return this.startTsInNs;
        }

        public long getAdjustmentForOwnTimeInNs() {
            return this.adjustmentForOwnTimeInNs;
        }

        public void setAdjustmentForOwnTimeInNs(long adjustmentForOwnTimeInNs) {
            this.adjustmentForOwnTimeInNs = adjustmentForOwnTimeInNs;
        }

        public void increaseAdjustmentForOwnTimeInNs(long increaseInNs) {
            this.setAdjustmentForOwnTimeInNs(this.getAdjustmentForOwnTimeInNs() + increaseInNs);
        }
    }

    private static class MutableStats
    extends Stats {
        public MutableStats() {
            super(Maps.newLinkedHashMap(), 0L, 0L);
        }

        public void setCount(@Nonnull Debugger.Location location, long count) {
            this.locationCountMap.put(location, count);
        }

        public void increaseCount(@Nonnull Debugger.Location location, long increase) {
            this.setCount(location, this.getCount(location) + increase);
        }

        public void setTotalTimeInNs(long totalTimeInNs) {
            this.totalTimeInNs = totalTimeInNs;
        }

        public void increaseTotalTimeInNs(long increaseInNs) {
            this.setTotalTimeInNs(this.getTotalTimeInNs() + increaseInNs);
        }

        public void setOwnTimeInNs(long ownTimeInNs) {
            this.ownTimeInNs = ownTimeInNs;
        }

        public void increaseOwnTimeInNs(long increaseInNs) {
            this.setOwnTimeInNs(this.getOwnTimeInNs() + increaseInNs);
        }
    }
}

