/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.debug;

import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class Stats {
    @Nonnull
    protected final Map<Debugger.Location, Long> locationCountMap;
    protected long totalTimeInNs;
    protected long ownTimeInNs;

    protected Stats(@Nonnull Map<Debugger.Location, Long> locationCountMap, long totalTimeInNs, long ownTimeInNs) {
        this.locationCountMap = locationCountMap;
        this.totalTimeInNs = totalTimeInNs;
        this.ownTimeInNs = ownTimeInNs;
    }

    @Nonnull
    public Map<Debugger.Location, Long> getLocationCountMap() {
        return this.locationCountMap;
    }

    public long getCount(@Nonnull Debugger.Location location) {
        return this.locationCountMap.getOrDefault((Object)location, 0L);
    }

    public long getTotalTimeInNs() {
        return this.totalTimeInNs;
    }

    public long getOwnTimeInNs() {
        return this.ownTimeInNs;
    }

    @Nonnull
    public Stats toImmutable() {
        return new Stats(ImmutableMap.copyOf(this.locationCountMap), this.totalTimeInNs, this.ownTimeInNs);
    }
}

