/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.debug;

import com.apple.foundationdb.record.query.plan.cascades.CascadesRule;
import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.apple.foundationdb.record.query.plan.cascades.debug.Stats;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class StatsMaps {
    @Nonnull
    private final Map<Class<? extends Debugger.Event>, ? extends Stats> eventClassStatsMap;
    @Nonnull
    private final Map<Class<? extends CascadesRule<?>>, ? extends Stats> plannerRuleClassStatsMap;
    @Nonnull
    private final Supplier<Map<Class<? extends Debugger.Event>, Stats>> immutableEventClassStatsMapSupplier;
    @Nonnull
    private final Supplier<Map<Class<? extends CascadesRule<?>>, Stats>> immutablePlannerRuleClassStatsMapSupplier;

    public StatsMaps(@Nonnull Map<Class<? extends Debugger.Event>, ? extends Stats> eventClassStatsMap, @Nonnull Map<Class<? extends CascadesRule<?>>, ? extends Stats> plannerRuleClassStatsMap) {
        this.eventClassStatsMap = eventClassStatsMap;
        this.plannerRuleClassStatsMap = plannerRuleClassStatsMap;
        this.immutableEventClassStatsMapSupplier = Suppliers.memoize(this::computeImmutableEventClassStatsMap);
        this.immutablePlannerRuleClassStatsMapSupplier = Suppliers.memoize(this::computeImmutablePlannerRuleClassStatsMap);
    }

    @Nonnull
    public Map<Class<? extends Debugger.Event>, Stats> getEventClassStatsMap() {
        return this.immutableEventClassStatsMapSupplier.get();
    }

    @Nonnull
    public Map<Class<? extends CascadesRule<?>>, Stats> getPlannerRuleClassStatsMap() {
        return this.immutablePlannerRuleClassStatsMapSupplier.get();
    }

    @Nonnull
    private Map<Class<? extends Debugger.Event>, Stats> computeImmutableEventClassStatsMap() {
        ImmutableMap.Builder<Class<? extends Debugger.Event>, Stats> eventClassStatsMapBuilder = ImmutableMap.builder();
        for (Map.Entry<Class<? extends Debugger.Event>, ? extends Stats> entry : this.eventClassStatsMap.entrySet()) {
            eventClassStatsMapBuilder.put(entry.getKey(), entry.getValue().toImmutable());
        }
        return eventClassStatsMapBuilder.build();
    }

    @Nonnull
    private Map<Class<? extends CascadesRule<?>>, Stats> computeImmutablePlannerRuleClassStatsMap() {
        ImmutableMap.Builder<Class<? extends CascadesRule<?>>, Stats> plannerRuleClassStatsMapBuilder = ImmutableMap.builder();
        for (Map.Entry<Class<CascadesRule<?>>, Stats> entry : this.plannerRuleClassStatsMap.entrySet()) {
            plannerRuleClassStatsMapBuilder.put(entry.getKey(), entry.getValue().toImmutable());
        }
        return plannerRuleClassStatsMapBuilder.build();
    }
}

