/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.explain;

import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graphs;
import com.google.common.graph.ImmutableNetwork;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import java.util.ArrayDeque;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AbstractPlannerGraph<N extends AbstractNode, E extends AbstractEdge> {
    @Nonnull
    private final N root;
    @Nonnull
    private final ImmutableNetwork<N, E> network;
    private final Supplier<Map<Object, N>> reverseMapSupplier;

    protected AbstractPlannerGraph(@Nonnull N root, @Nonnull Network<N, E> network) {
        this.root = root;
        MutableNetwork mutableNetwork = NetworkBuilder.directed().allowsParallelEdges(true).allowsSelfLoops(true).build();
        mutableNetwork.addNode(root);
        this.network = ImmutableNetwork.copyOf(network);
        this.reverseMapSupplier = Suppliers.memoize(() -> {
            IdentityHashMap reverseMap = new IdentityHashMap();
            network.nodes().forEach(node -> reverseMap.put(node.getIdentity(), node));
            return reverseMap;
        });
    }

    @Nonnull
    public N getRoot() {
        return this.root;
    }

    @Nonnull
    public ImmutableNetwork<N, E> getNetwork() {
        return this.network;
    }

    @Nullable
    public N getNodeForIdentity(Object identity) {
        return (N)((AbstractNode)this.reverseMapSupplier.get().get(identity));
    }

    public static abstract class AbstractNode {
        @Nonnull
        final Object identity;
        @Nonnull
        final String name;
        @Nullable
        final List<String> details;

        protected AbstractNode(@Nonnull Object identity, @Nonnull String name) {
            this(identity, name, null);
        }

        protected AbstractNode(@Nonnull Object identity, @Nonnull String name, @Nullable List<String> details) {
            this.identity = identity;
            this.name = name;
            this.details = details == null ? null : ImmutableList.copyOf(details);
        }

        @Nonnull
        public Object getIdentity() {
            return this.identity;
        }

        @Nonnull
        public String getName() {
            return this.name;
        }

        @Nullable
        public List<String> getDetails() {
            return this.details;
        }

        @Nonnull
        public abstract Map<String, Attribute> getAttributes();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AbstractNode)) {
                return false;
            }
            AbstractNode that = (AbstractNode)o;
            return this.getIdentity() == that.getIdentity();
        }

        public int hashCode() {
            return System.identityHashCode(this.getIdentity());
        }
    }

    public static abstract class AbstractEdge {
        @Nullable
        private final String label;
        @Nonnull
        private final ImmutableSet<? extends AbstractEdge> dependsOn;

        protected AbstractEdge(@Nonnull Set<? extends AbstractEdge> dependsOn) {
            this(null, dependsOn);
        }

        protected AbstractEdge(@Nullable String label, @Nonnull Set<? extends AbstractEdge> dependsOn) {
            this.label = label;
            this.dependsOn = ImmutableSet.copyOf(dependsOn);
        }

        @Nullable
        public String getLabel() {
            return this.label;
        }

        @Nonnull
        public Set<? extends AbstractEdge> getDependsOn() {
            return this.dependsOn;
        }

        @Nonnull
        public abstract Map<String, Attribute> getAttributes();
    }

    public static abstract class PlannerGraphBuilder<N extends AbstractNode, E extends AbstractEdge, B extends AbstractPlannerGraph<N, E>> {
        @Nonnull
        final N root;
        @Nonnull
        final MutableNetwork<N, E> network;

        protected PlannerGraphBuilder(@Nonnull N root) {
            this.root = root;
            this.network = NetworkBuilder.directed().allowsParallelEdges(true).allowsSelfLoops(true).build();
            this.addNode(root);
        }

        protected PlannerGraphBuilder(@Nonnull AbstractPlannerGraph<N, E> original) {
            this.root = original.getRoot();
            this.network = Graphs.copyOf(original.getNetwork());
        }

        @Nonnull
        public N getRoot() {
            return this.root;
        }

        @Nonnull
        public MutableNetwork<N, E> getNetwork() {
            return this.network;
        }

        @Nonnull
        public PlannerGraphBuilder<N, E, B> addNode(@Nonnull N node) {
            this.network.addNode(node);
            return this;
        }

        @Nonnull
        public PlannerGraphBuilder<N, E, B> addEdge(@Nonnull N source, @Nonnull N target, @Nonnull E edge) {
            this.network.addEdge(source, target, edge);
            return this;
        }

        @Nonnull
        public PlannerGraphBuilder<N, E, B> addGraph(@Nonnull AbstractPlannerGraph<N, E> other) {
            ImmutableNetwork otherNetwork = other.network;
            ArrayDeque<Object> queue = new ArrayDeque<Object>();
            if (!this.network.nodes().contains(other.root)) {
                this.addNode(other.root);
                queue.add(other.root);
            }
            while (!queue.isEmpty()) {
                AbstractNode currentNode = (AbstractNode)queue.remove();
                for (AbstractEdge edge : otherNetwork.inEdges(currentNode)) {
                    EndpointPair endpointPair = otherNetwork.incidentNodes(edge);
                    AbstractNode nodeU = (AbstractNode)endpointPair.nodeU();
                    if (!this.network.nodes().contains(nodeU)) {
                        this.addNode(nodeU);
                        queue.add(nodeU);
                    }
                    this.addEdge(nodeU, (AbstractNode)endpointPair.nodeV(), edge);
                }
            }
            return this;
        }

        @Nonnull
        public abstract B build();
    }
}

