/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.explain;

import com.apple.foundationdb.record.query.combinatorics.TopologicalSort;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.cascades.explain.GraphExporter;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.common.escape.Escaper;
import com.google.common.escape.Escapers;
import com.google.common.graph.ImmutableNetwork;
import java.io.PrintWriter;
import java.util.AbstractSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DotExporter<N extends PlannerGraph.Node, E extends PlannerGraph.Edge>
extends GraphExporter<N, E> {
    private static final String UNDIRECTED_GRAPH_EDGE_OP = "--";
    private static final String DIRECTED_GRAPH_EDGE_OP = "->";
    private static final String UNDIRECTED_GRAPH_KEYWORD = "graph";
    private static final String DIRECTED_GRAPH_KEYWORD = "digraph";
    private static final String DONT_ALLOW_MULTIPLE_EDGES_KEYWORD = "strict";
    private static final Pattern ALPHA_DIG = Pattern.compile("[a-zA-Z_][\\w]*");
    private static final Pattern DOUBLE_QUOTE = Pattern.compile("\".*\"");
    private static final Pattern DOT_NUMBER = Pattern.compile("[-]?([.][0-9]+|[0-9]+([.][0-9]*)?)");
    private static final Pattern HTML = Pattern.compile("<.*>");
    private static final Pattern VARIABLE = Pattern.compile("\\{\\{(.+?)}}");
    public static final String DEFAULT_GRAPH_ID = "G";
    private static final String INDENT = "  ";
    private static final Escaper escaper = Escapers.builder().addEscape('\"', "&quot;").addEscape('\'', "&#39;").addEscape('&', "&amp;").addEscape('<', "&lt;").addEscape('>', "&gt;").addEscape('\\', "&#92;").build();

    public DotExporter(@Nonnull GraphExporter.ComponentIdProvider<N> vertexIDProvider, @Nonnull GraphExporter.ComponentAttributeProvider<N> vertexAttributeProvider, @Nonnull GraphExporter.ComponentAttributeProvider<E> edgeAttributeProvider, @Nonnull Map<String, Attribute> graphAttributes, @Nonnull GraphExporter.ClusterProvider<N, E> clusterProvider) {
        super(vertexIDProvider, vertexAttributeProvider, ignored -> null, edgeAttributeProvider, graphAttributes, clusterProvider);
    }

    @Override
    protected boolean isValidId(@Nonnull String idCandidate) {
        return ALPHA_DIG.matcher(idCandidate).matches() || DOUBLE_QUOTE.matcher(idCandidate).matches() || DOT_NUMBER.matcher(idCandidate).matches() || HTML.matcher(idCandidate).matches();
    }

    @Override
    protected void renderHeader(@Nonnull GraphExporter.ExporterContext context, @Nonnull ImmutableNetwork<N, E> graph) {
        PrintWriter out = context.getPrintWriter();
        if (!graph.allowsParallelEdges()) {
            out.print(DONT_ALLOW_MULTIPLE_EDGES_KEYWORD);
            out.print(" ");
        }
        if (graph.isDirected()) {
            out.print(DIRECTED_GRAPH_KEYWORD);
        } else {
            out.print(UNDIRECTED_GRAPH_KEYWORD);
        }
        out.print(" ");
        out.print(DEFAULT_GRAPH_ID);
        out.println(" {");
    }

    @Override
    protected void renderGraphAttributes(@Nonnull GraphExporter.ExporterContext context, @Nonnull Map<String, Attribute> attributes) {
        PrintWriter out = context.getPrintWriter();
        for (Map.Entry<String, Attribute> attr : attributes.entrySet()) {
            Attribute value = attr.getValue();
            if (!value.isVisible(context)) continue;
            out.print(INDENT);
            out.print(attr.getKey());
            out.print('=');
            out.print(value);
            out.println(";");
        }
    }

    private void renderInvisibleEdges(@Nonnull GraphExporter.ExporterContext context, N n, String indentation) {
        ImmutableNetwork network = context.getNetwork();
        PrintWriter out = context.getPrintWriter();
        Set childrenEdges = network.inEdges((Object)n);
        if (childrenEdges.stream().allMatch(edge -> edge.getDependsOn().isEmpty())) {
            return;
        }
        if (this.hasCommonSubexpressions(network, childrenEdges)) {
            return;
        }
        Optional<List<PlannerGraph.Edge>> orderedChildrenEdgesOptional = TopologicalSort.anyTopologicalOrderPermutation(childrenEdges, edge -> edge.getDependsOn());
        Verify.verify(orderedChildrenEdgesOptional.isPresent());
        List<PlannerGraph.Edge> orderedChildrenEdges = orderedChildrenEdgesOptional.get();
        ArrayList<PlannerGraph.Node> childrenOperatorList = new ArrayList<PlannerGraph.Node>();
        for (PlannerGraph.Edge currentEdge : orderedChildrenEdges) {
            PlannerGraph.Node currentChildNode = (PlannerGraph.Node)network.incidentNodes(currentEdge).nodeU();
            if (currentChildNode instanceof PlannerGraph.ReferenceHeadNode) {
                Set refMembers = network.predecessors(currentChildNode);
                for (PlannerGraph.Node refMember2 : Sets.filter(refMembers, refMember -> refMember instanceof PlannerGraph.ReferenceMemberNode)) {
                    childrenOperatorList.addAll(network.predecessors(refMember2));
                }
                continue;
            }
            childrenOperatorList.add(currentChildNode);
        }
        for (int index = 0; index < childrenOperatorList.size() - 1; ++index) {
            PlannerGraph.Node currentChildNode = (PlannerGraph.Node)childrenOperatorList.get(index);
            PlannerGraph.Node nextChildNode = (PlannerGraph.Node)childrenOperatorList.get(index + 1);
            out.println(indentation + "{");
            out.println(indentation + "  rank=same;");
            out.println(indentation + "  rankDir=LR;");
            out.print(indentation);
            this.renderEdge(context, true, currentChildNode, nextChildNode, ImmutableMap.of("color", Attribute.dot("red"), "style", Attribute.dot("invis")));
            out.println(indentation + "}");
        }
    }

    private boolean hasCommonSubexpressions(ImmutableNetwork<N, E> network, Set<E> childrenEdges) {
        HashSet nodesReachable = Sets.newHashSet();
        for (PlannerGraph.Edge childrenEdge : childrenEdges) {
            PlannerGraph.Node child = (PlannerGraph.Node)network.incidentNodes(childrenEdge).nodeU();
            ArrayDeque<PlannerGraph.Node> queue = new ArrayDeque<PlannerGraph.Node>();
            queue.push(child);
            HashSet<PlannerGraph.Node> nodesReachableForChild = Sets.newHashSet();
            while (queue.peek() != null) {
                PlannerGraph.Node currentNode = (PlannerGraph.Node)queue.poll();
                Set predecessors = network.predecessors(currentNode);
                for (PlannerGraph.Node predecessor : predecessors) {
                    if (!nodesReachableForChild.add(predecessor)) continue;
                    queue.push(predecessor);
                }
            }
            if (Sets.intersection(nodesReachable, nodesReachableForChild).isEmpty()) {
                nodesReachable.addAll(nodesReachableForChild);
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    protected void renderNode(@Nonnull GraphExporter.ExporterContext context, @Nonnull N node, @Nonnull Map<String, Attribute> attributes) {
        String htmlLabel;
        PrintWriter out = context.getPrintWriter();
        out.print(INDENT);
        out.print(this.getVertexID(node));
        out.print(" [ ");
        if (attributes.get("label") == null) {
            Attribute name = attributes.get("name");
            Attribute details = attributes.get("details");
            htmlLabel = name == null ? null : this.getNodeLabel(name, details, attributes);
        } else {
            htmlLabel = this.getNodeLabel(attributes.get("label"), null, ImmutableMap.of());
        }
        if (htmlLabel != null) {
            out.print("label=");
            out.print(htmlLabel);
            out.print(" ");
        }
        this.renderAttributes(context, attributes);
        out.print("]");
        out.println(";");
    }

    @Override
    protected void renderEdge(@Nonnull GraphExporter.ExporterContext context, boolean isDirected, @Nonnull N source, @Nonnull N target, @Nonnull Map<String, Attribute> attributes) {
        String htmlLabel;
        PrintWriter out = context.getPrintWriter();
        out.print(INDENT);
        out.print(this.getVertexID(source));
        out.print(" ");
        if (isDirected) {
            out.print(DIRECTED_GRAPH_EDGE_OP);
        } else {
            out.print(UNDIRECTED_GRAPH_EDGE_OP);
        }
        out.print(" ");
        out.print(this.getVertexID(target));
        out.print(" [ ");
        String string = attributes.containsKey("label") ? this.getEdgeLabel(attributes.get("label")) : (htmlLabel = attributes.containsKey("name") ? this.getEdgeLabel(attributes.get("name")) : null);
        if (htmlLabel != null) {
            out.print("label=");
            out.print(htmlLabel);
            out.print(" ");
        }
        this.renderAttributes(context, attributes);
        out.print("]");
        out.println(";");
    }

    @Override
    protected void renderClusters(@Nonnull GraphExporter.ExporterContext context, @Nonnull Collection<GraphExporter.Cluster<N, E>> clusters) {
        this.renderClusters(context, context.getNetwork().nodes(), clusters, "cluster", INDENT);
    }

    protected void renderClusters(@Nonnull GraphExporter.ExporterContext context, @NonNull Set<N> currentNodes, @Nonnull Collection<GraphExporter.Cluster<N, E>> nestedClusters, @Nonnull String prefix, @Nonnull String indentation) {
        AbstractSet remainingNodes = Sets.newHashSet(currentNodes);
        int i = 1;
        for (GraphExporter.Cluster<N, E> nestedCluster : nestedClusters) {
            GraphExporter.ComponentAttributeProvider<GraphExporter.Cluster<N, E>> clusterAttributeProvider = nestedCluster.getClusterAttributeProvider();
            this.renderCluster(context, prefix + "_" + i, nestedCluster, (Map)clusterAttributeProvider.apply(nestedCluster), indentation);
            remainingNodes = Sets.difference(remainingNodes, nestedCluster.getNodes());
            ++i;
        }
        for (PlannerGraph.Node remainingNode : remainingNodes) {
            this.renderInvisibleEdges(context, remainingNode, indentation);
        }
    }

    protected void renderCluster(@Nonnull GraphExporter.ExporterContext context, @Nonnull String clusterId, @Nonnull GraphExporter.Cluster<N, E> cluster, @Nonnull Map<String, Attribute> attributes, @Nonnull String indentation) {
        PrintWriter out = context.getPrintWriter();
        out.print(indentation);
        out.print("subgraph " + clusterId + " { ");
        this.renderClusterAttributes(context, attributes);
        for (PlannerGraph.Node n : cluster.getNodes()) {
            out.print(this.getVertexID(n) + "; ");
        }
        GraphExporter.ClusterProvider<N, E> nestedClusterProvider = cluster.getNestedClusterProvider();
        Collection nestedClusters = (Collection)nestedClusterProvider.apply(context.getNetwork(), cluster.getNodes());
        if (!nestedClusters.isEmpty()) {
            out.println();
            this.renderClusters(context, cluster.getNodes(), nestedClusters, clusterId, indentation + INDENT);
            out.print(indentation);
        }
        out.println("}");
    }

    @Override
    protected void renderFooter(@Nonnull GraphExporter.ExporterContext context) {
        context.getPrintWriter().print("}");
    }

    private void renderAttributes(@Nonnull GraphExporter.ExporterContext context, @Nonnull Map<String, Attribute> attributes) {
        for (Map.Entry<String, Attribute> entry : attributes.entrySet()) {
            Attribute value = entry.getValue();
            if (!value.isVisible(context)) continue;
            this.renderAttribute(context, entry.getKey(), value, " ");
        }
    }

    @Nonnull
    public String getNodeLabel(@Nonnull Attribute name, @Nullable Attribute details, @Nonnull Map<String, Attribute> nodeAttributes) {
        if (details == null || ((List)details.getReference()).isEmpty()) {
            return "<<table border=\"0\" cellborder=\"1\" cellspacing=\"0\" cellpadding=\"8\"><tr><td align=\"left\">" + escaper.escape(name.getReference().toString()) + "</td></tr></table>>";
        }
        String detailsString = ((List)details.getReference()).stream().map(Object::toString).map(escaper::escape).map(detail -> this.substituteVariables((String)detail, nodeAttributes, attribute -> attribute == null ? "<b>undefined</b>" : (attribute.getReference() instanceof Collection ? this.escapeCollection((Collection)attribute.getReference()) : escaper.escape(attribute.getReference().toString())))).map(detail -> "<tr><td align=\"left\">" + detail + "</td></tr>").collect(Collectors.joining());
        return "<<table border=\"0\" cellborder=\"1\" cellspacing=\"0\" cellpadding=\"8\"><tr><td align=\"left\">" + escaper.escape(name.getReference().toString()) + "</td></tr>" + detailsString + "</table>>";
    }

    @Nonnull
    private String escapeCollection(@Nonnull Collection<Attribute> attributes) {
        return "[" + attributes.stream().map(a -> escaper.escape(a.toString())).collect(Collectors.joining(", ")) + "]";
    }

    @Nonnull
    private String substituteVariables(@Nonnull String detail, @Nonnull Map<String, Attribute> nodeAttributes, @Nonnull Function<Attribute, String> toStringFn) {
        Matcher matcher = VARIABLE.matcher(detail);
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (matcher.find()) {
            Attribute referredAttribute = nodeAttributes.get(matcher.group(1));
            String replacement = toStringFn.apply(referredAttribute);
            builder.append(detail, i, matcher.start());
            builder.append(replacement);
            i = matcher.end();
        }
        builder.append(detail.substring(i));
        return builder.toString();
    }

    @Nonnull
    public String getEdgeLabel(@Nonnull Attribute label) {
        return "<&nbsp;" + escaper.escape(label.getReference().toString()) + ">";
    }

    private void renderClusterAttributes(@Nonnull GraphExporter.ExporterContext context, @Nonnull Map<String, Attribute> attributes) {
        for (Map.Entry<String, Attribute> entry : attributes.entrySet()) {
            Attribute value = entry.getValue();
            if (!value.isVisible(context)) continue;
            this.renderAttribute(context, entry.getKey(), value, "; ");
        }
    }

    private void renderAttribute(@Nonnull GraphExporter.ExporterContext context, @Nonnull String attrName, @Nullable Attribute attribute, @Nonnull String suffix) {
        if (attribute != null) {
            PrintWriter out = context.getPrintWriter();
            out.print(attrName + "=");
            out.print("\"" + escaper.escape(attribute.getReference().toString()) + "\"");
            out.print(suffix);
        }
    }
}

