/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.explain;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.Bindings;
import com.apple.foundationdb.record.IndexScanType;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.TupleRange;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanParameters;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.query.plan.TextScan;
import com.apple.foundationdb.record.query.plan.bitmap.ComposedBitmapIndexQueryPlan;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.explain.DefaultExplainFormatter;
import com.apple.foundationdb.record.query.plan.explain.DefaultExplainSymbolMap;
import com.apple.foundationdb.record.query.plan.explain.ExplainSelfContainedSymbolMap;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.PrettyExplainFormatter;
import com.apple.foundationdb.record.query.plan.plans.InSource;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryAggregateIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryComparatorPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryCoveringIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryDefaultOnEmptyPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryDeletePlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryExplodePlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFetchFromPartialRecordPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFilterPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFirstOrDefaultPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFlatMapPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInComparandJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInParameterJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInUnionOnKeyExpressionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInUnionOnValuesPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInUnionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInValuesJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryInsertPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIntersectionOnKeyExpressionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIntersectionOnValuesPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryIntersectionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryLoadByKeysPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryMapPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryMultiIntersectionOnValuesPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanVisitor;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithExplain;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithIndex;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPredicatesFilterPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryRangePlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryRecursiveDfsJoinPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryRecursiveLevelUnionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryScanPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryScoreForRankPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQuerySelectorPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryStreamingAggregationPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryTableFunctionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryTextIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryTypeFilterPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnionOnKeyExpressionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnionOnValuesPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnorderedDistinctPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnorderedPrimaryKeyDistinctPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnorderedUnionPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUpdatePlan;
import com.apple.foundationdb.record.query.plan.plans.TempTableInsertPlan;
import com.apple.foundationdb.record.query.plan.plans.TempTableScanPlan;
import com.apple.foundationdb.record.query.plan.sorting.RecordQueryDamPlan;
import com.apple.foundationdb.record.query.plan.sorting.RecordQuerySortPlan;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class ExplainPlanVisitor
extends ExplainTokens
implements RecordQueryPlanVisitor<ExplainTokens> {
    private final int maxSize;
    private boolean done;

    public ExplainPlanVisitor(int maxSize) {
        this.maxSize = maxSize;
        this.done = false;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public boolean isDone() {
        return this.done;
    }

    @Override
    @Nonnull
    public ExplainTokens add(@Nonnull ExplainTokens.Token toAppend) {
        if (this.done) {
            return this;
        }
        super.add(toAppend);
        if (Arrays.stream(this.getMinLengths()).allMatch(minLength -> minLength > this.maxSize)) {
            this.done = true;
        }
        return this;
    }

    @Nonnull
    private ExplainTokens pipe() {
        this.addLinebreakOrWhitespace().addToString("|").addWhitespace();
        return this;
    }

    private ExplainPlanVisitor visitAndJoin(@Nonnull Supplier<ExplainTokens> delimiterExplainTokensSupplier, @Nonnull Iterable<? extends RecordQueryPlan> plans) {
        Iterator<? extends RecordQueryPlan> iterator = plans.iterator();
        while (iterator.hasNext()) {
            RecordQueryPlan plan = iterator.next();
            this.visit(plan);
            if (!iterator.hasNext()) continue;
            this.addAll(delimiterExplainTokensSupplier.get().getTokens());
        }
        return this;
    }

    @Override
    @Nonnull
    public ExplainTokens visitComposedBitmapIndexQueryPlan(@Nonnull ComposedBitmapIndexQueryPlan element) {
        return this.addToString(element.toString());
    }

    @Override
    @Nonnull
    public ExplainTokens visitAggregateIndexPlan(@Nonnull RecordQueryAggregateIndexPlan element) {
        this.addKeyword("AISCAN").addOptionalWhitespace().addOpeningParen().addOptionalWhitespace();
        this.addNested(ExplainPlanVisitor.indexDetails(element.getIndexPlan()));
        return this.addWhitespace().addToString("->").addWhitespace().addToString(element.getToRecord()).addOptionalWhitespace().addClosingParen();
    }

    @Override
    @Nonnull
    public ExplainTokens visitComparatorPlan(@Nonnull RecordQueryComparatorPlan comparatorPlan) {
        this.addKeyword("COMPARATOR").addWhitespace().addKeyword("OF").addWhitespace();
        return this.visitAndJoin(() -> new ExplainTokens().addCommaAndWhiteSpace(), comparatorPlan.getChildren());
    }

    @Override
    @Nonnull
    public ExplainTokens visitCoveringIndexPlan(@Nonnull RecordQueryCoveringIndexPlan coveringIndexPlan) {
        this.addKeyword("COVERING").addOptionalWhitespace().addOpeningParen().addOptionalWhitespace();
        RecordQueryPlanWithIndex underlyingWithIndex = coveringIndexPlan.getIndexPlan();
        if (underlyingWithIndex instanceof RecordQueryIndexPlan) {
            this.addNested(ExplainPlanVisitor.indexDetails((RecordQueryIndexPlan)underlyingWithIndex));
        } else if (underlyingWithIndex instanceof RecordQueryTextIndexPlan) {
            this.textIndexDetails((RecordQueryTextIndexPlan)underlyingWithIndex);
        } else {
            this.addIdentifier(underlyingWithIndex.getIndexName());
        }
        return this.addNested(0, new ExplainTokens().addWhitespace().addToString("->").addWhitespace().addToString(coveringIndexPlan.getToRecord())).addOptionalWhitespace().addClosingParen();
    }

    @Override
    @Nonnull
    public ExplainTokens visitDeletePlan(@Nonnull RecordQueryDeletePlan deletePlan) {
        this.visit(deletePlan.getChild());
        return this.pipe().addKeyword("DELETE");
    }

    @Override
    @Nonnull
    public ExplainTokens visitExplodePlan(@Nonnull RecordQueryExplodePlan explodePlan) {
        return this.addKeyword("EXPLODE").addWhitespace().addNested(explodePlan.getCollectionValue().explain().getExplainTokens());
    }

    @Override
    @Nonnull
    public ExplainTokens visitFetchFromPartialRecordPlan(@Nonnull RecordQueryFetchFromPartialRecordPlan fromPartialRecordPlan) {
        this.visit(fromPartialRecordPlan.getChild());
        return this.pipe().addKeyword("FETCH");
    }

    @Override
    @Nonnull
    public ExplainTokens visitFilterPlan(@Nonnull RecordQueryFilterPlan filterPlan) {
        this.visit(filterPlan.getChild());
        return this.pipe().addKeyword("QCFILTER").addWhitespace().addToString(filterPlan.getConjunctedFilter());
    }

    @Override
    @Nonnull
    public ExplainTokens visitFirstOrDefaultPlan(@Nonnull RecordQueryFirstOrDefaultPlan firstOrDefaultPlan) {
        this.visit(firstOrDefaultPlan.getChild());
        return this.pipe().addKeyword("DEFAULT").addWhitespace().addNested(firstOrDefaultPlan.getOnEmptyResultValue().explain().getExplainTokens());
    }

    @Override
    @Nonnull
    public ExplainTokens visitDefaultOnEmptyPlan(@Nonnull RecordQueryDefaultOnEmptyPlan defaultOnEmptyPlan) {
        this.visit(defaultOnEmptyPlan.getChild());
        return this.pipe().addKeyword("ON").addWhitespace().addKeyword("EMPTY").addWhitespace().addNested(defaultOnEmptyPlan.getOnEmptyResultValue().explain().getExplainTokens());
    }

    @Override
    @Nonnull
    public ExplainTokens visitFlatMapPlan(@Nonnull RecordQueryFlatMapPlan flatMapPlan) {
        Quantifier.Physical outerQuantifier = flatMapPlan.getOuterQuantifier();
        this.visit(outerQuantifier.getRangesOverPlan());
        this.pipe().addKeyword("FLATMAP").addWhitespace().addAliasDefinition(outerQuantifier.getAlias()).addWhitespace().addToString("->").addWhitespace().addOpeningBrace().addLinebreakOrWhitespace();
        Quantifier.Physical innerQuantifier = flatMapPlan.getInnerQuantifier();
        return this.visit(innerQuantifier.getRangesOverPlan()).addWhitespace().addKeyword("AS").addWhitespace().addAliasDefinition(innerQuantifier.getAlias()).addLinebreakOrWhitespace().addKeyword("RETURN").addWhitespace().addNested(flatMapPlan.getResultValue().explain().getExplainTokens()).addWhitespace().addClosingBrace();
    }

    @Nonnull
    private ExplainTokens visitInJoinPlan(@Nonnull RecordQueryInJoinPlan inJoinPlan) {
        InSource inSource = inJoinPlan.getInSource();
        boolean isCorrelation = Bindings.Internal.CORRELATION.isOfType(inSource.getBindingName());
        String bindingName = isCorrelation ? Bindings.Internal.CORRELATION.identifier(inSource.getBindingName()) : inSource.getBindingName();
        this.addOpeningSquareBracket().addOptionalWhitespace().addNested(inSource.explain().getExplainTokens()).addOptionalWhitespace().addClosingSquareBracket();
        this.pipe().addKeyword("INJOIN").addWhitespace();
        if (isCorrelation) {
            this.addAliasDefinition(CorrelationIdentifier.of(bindingName));
        } else {
            this.addToString(bindingName);
        }
        this.addWhitespace().addToString("->").addWhitespace().addOpeningBrace().addWhitespace();
        return this.visit(inJoinPlan.getChild()).addWhitespace().addClosingBrace();
    }

    @Override
    @Nonnull
    public ExplainTokens visitInComparandJoinPlan(@Nonnull RecordQueryInComparandJoinPlan inComparandJoinPlan) {
        return this.visitInJoinPlan(inComparandJoinPlan);
    }

    @Override
    @Nonnull
    public ExplainTokens visitMultiIntersectionOnValuesPlan(@Nonnull RecordQueryMultiIntersectionOnValuesPlan multiIntersectionOnValuesPlan) {
        this.visitAndJoin(() -> new ExplainTokens().addWhitespace().addToString("\u2229").addWhitespace(), multiIntersectionOnValuesPlan.getChildren());
        ExplainTokens compareByExplainTokens = new ExplainTokens().addWhitespace().addKeyword("COMPARE").addWhitespace().addKeyword("BY").addWhitespace().addNested(multiIntersectionOnValuesPlan.getComparisonKeyFunction().explain().getExplainTokens());
        this.addNested(1, compareByExplainTokens);
        List<? extends Quantifier> quantifiers = multiIntersectionOnValuesPlan.getQuantifiers();
        ExplainTokens withExplainTokens = new ExplainTokens().addWhitespace().addKeyword("WITH").addWhitespace().addSequence(() -> new ExplainTokens().addCommaAndWhiteSpace(), () -> quantifiers.stream().map(quantifier -> new ExplainTokens().addAliasDefinition(quantifier.getAlias())).iterator());
        this.addNested(1, withExplainTokens);
        ExplainTokens returnExplainTokens = new ExplainTokens().addWhitespace().addKeyword("RETURN").addWhitespace().addNested(multiIntersectionOnValuesPlan.getResultValue().explain().getExplainTokens());
        return this.addNested(1, returnExplainTokens);
    }

    @Override
    @Nonnull
    public ExplainTokens visitInParameterJoinPlan(@Nonnull RecordQueryInParameterJoinPlan inParameterJoinPlan) {
        return this.visitInJoinPlan(inParameterJoinPlan);
    }

    @Nonnull
    private ExplainTokens visitInUnionPlan(@Nonnull RecordQueryInUnionPlan inUnionPlan) {
        ImmutableList.Builder inSourcesBuilder = ImmutableList.builder();
        ImmutableList.Builder bindingsBuilder = ImmutableList.builder();
        for (InSource inSource : inUnionPlan.getInSources()) {
            inSourcesBuilder.add(inSource.explain().getExplainTokens());
            boolean isCorrelation = Bindings.Internal.CORRELATION.isOfType(inSource.getBindingName());
            String bindingName = isCorrelation ? Bindings.Internal.CORRELATION.identifier(inSource.getBindingName()) : inSource.getBindingName();
            bindingsBuilder.add(new ExplainTokens().addAliasDefinition(CorrelationIdentifier.of(bindingName)));
        }
        this.addOpeningSquareBracket().addOptionalWhitespace().addSequence(() -> new ExplainTokens().addWhitespace().addToString("\u22c8").addWhitespace(), inSourcesBuilder.build()).addOptionalWhitespace().addClosingSquareBracket().addWhitespace().addKeyword("INUNION").addWhitespace().addSequence(() -> new ExplainTokens().addCommaAndWhiteSpace(), bindingsBuilder.build()).addWhitespace().addToString("->").addWhitespace().addOpeningBrace().addWhitespace();
        this.visit(inUnionPlan.getChild()).addWhitespace().addClosingBrace();
        return this.addWhitespace().addKeyword("COMPARE").addWhitespace().addKeyword("BY").addWhitespace().addNested(1, inUnionPlan.getComparisonKeyFunction().explain().getExplainTokens());
    }

    @Override
    @Nonnull
    public ExplainTokens visitInUnionOnKeyExpressionPlan(@Nonnull RecordQueryInUnionOnKeyExpressionPlan inUnionOnKeyExpressionPlan) {
        return this.visitInUnionPlan(inUnionOnKeyExpressionPlan);
    }

    @Override
    @Nonnull
    public ExplainTokens visitInUnionOnValuesPlan(@Nonnull RecordQueryInUnionOnValuesPlan inUnionOnValuesPlan) {
        return this.visitInUnionPlan(inUnionOnValuesPlan);
    }

    @Override
    @Nonnull
    public ExplainTokens visitInValuesJoinPlan(@Nonnull RecordQueryInValuesJoinPlan inValuesJoinPlan) {
        return this.visitInJoinPlan(inValuesJoinPlan);
    }

    @Override
    @Nonnull
    public ExplainTokens visitIndexPlan(@Nonnull RecordQueryIndexPlan indexPlan) {
        this.addKeyword("ISCAN").addOptionalWhitespace().addOpeningParen().addOptionalWhitespace();
        return this.addNested(ExplainPlanVisitor.indexDetails(indexPlan)).addOptionalWhitespace().addClosingParen();
    }

    @Override
    @Nonnull
    public ExplainTokens visitRecursiveLevelUnionPlan(@Nonnull RecordQueryRecursiveLevelUnionPlan recursiveUnionPlan) {
        Verify.verify(recursiveUnionPlan.getChildren().size() == 2);
        this.addKeyword("RUNION").addWhitespace().addSequence(() -> new ExplainTokens().addCommaAndWhiteSpace(), new ExplainTokens().addAliasDefinition(recursiveUnionPlan.getTempTableScanAlias()), new ExplainTokens().addAliasDefinition(recursiveUnionPlan.getTempTableInsertAlias()).addWhitespace().addOpeningBrace().addLinebreakOrWhitespace().addKeyword("INITIAL").addWhitespace().addOpeningBrace().addLinebreakOrWhitespace());
        this.visit(recursiveUnionPlan.getChildren().get(0)).addWhitespace().addClosingBrace().addLinebreakOrWhitespace();
        this.addKeyword("RECURSIVE").addWhitespace().addWhitespace().addOpeningBrace().addLinebreakOrWhitespace();
        return this.visit(recursiveUnionPlan.getChildren().get(1)).addWhitespace().addClosingBrace().addOptionalWhitespace().addClosingBrace();
    }

    @Override
    @Nonnull
    public ExplainTokens visitInsertPlan(@Nonnull RecordQueryInsertPlan insertPlan) {
        this.visit(insertPlan.getChild());
        return this.pipe().addKeyword("INSERT").addWhitespace().addKeyword("INTO").addWhitespace().addIdentifier(insertPlan.getTargetRecordType());
    }

    @Override
    @Nonnull
    public ExplainTokens visitTableFunctionPlan(@Nonnull RecordQueryTableFunctionPlan tableFunctionPlan) {
        return this.addKeyword("TF").addWhitespace().addNested(tableFunctionPlan.getValue().explain().getExplainTokens());
    }

    @Override
    @Nonnull
    public ExplainTokens visitTempTableInsertPlan(@Nonnull TempTableInsertPlan tempTableInsertPlan) {
        this.visit(tempTableInsertPlan.getChild());
        return this.pipe().addKeyword("INSERT").addWhitespace().addKeyword("INTO").addWhitespace().addKeyword("TEMP").addWhitespace().addNested(tempTableInsertPlan.getTempTableReferenceValue().explain().getExplainTokens());
    }

    @Nonnull
    private ExplainTokens visitIntersectionPlan(@Nonnull RecordQueryIntersectionPlan intersectionPlan) {
        this.visitAndJoin(() -> new ExplainTokens().addWhitespace().addToString("\u2229").addWhitespace(), intersectionPlan.getChildren());
        ExplainTokens compareByExplainTokens = new ExplainTokens().addWhitespace().addKeyword("COMPARE").addWhitespace().addKeyword("BY").addWhitespace().addNested(intersectionPlan.getComparisonKeyFunction().explain().getExplainTokens());
        return this.addNested(1, compareByExplainTokens);
    }

    @Override
    @Nonnull
    public ExplainTokens visitIntersectionOnKeyExpressionPlan(@Nonnull RecordQueryIntersectionOnKeyExpressionPlan intersectionOnKeyExpressionPlan) {
        return this.visitIntersectionPlan(intersectionOnKeyExpressionPlan);
    }

    @Override
    @Nonnull
    public ExplainTokens visitIntersectionOnValuesPlan(@Nonnull RecordQueryIntersectionOnValuesPlan intersectionOnValuesPlan) {
        return this.visitIntersectionPlan(intersectionOnValuesPlan);
    }

    @Override
    @Nonnull
    public ExplainTokens visitLoadByKeysPlan(@Nonnull RecordQueryLoadByKeysPlan loadByKeysPlan) {
        return this.addKeyword("BYKEYS").addWhitespace().addToString(loadByKeysPlan.getKeysSource());
    }

    @Override
    @Nonnull
    public ExplainTokens visitMapPlan(@Nonnull RecordQueryMapPlan mapPlan) {
        this.visit(mapPlan.getChild());
        return this.pipe().addKeyword("MAP").addWhitespace().addPush().addCurrentAliasDefinition(mapPlan.getInner().getAlias()).addNested(mapPlan.getResultValue().explain().getExplainTokens()).addPop();
    }

    @Override
    @Nonnull
    public ExplainTokens visitPredicatesFilterPlan(@Nonnull RecordQueryPredicatesFilterPlan predicatesFilterPlan) {
        this.visit(predicatesFilterPlan.getChild());
        return this.pipe().addKeyword("FILTER").addWhitespace().addPush().addCurrentAliasDefinition(predicatesFilterPlan.getInner().getAlias()).addNested(predicatesFilterPlan.getConjunctedPredicate().explain().getExplainTokens()).addPop();
    }

    @Override
    @Nonnull
    public ExplainTokens visitRangePlan(@Nonnull RecordQueryRangePlan element) {
        return this.addKeyword("RANGE").addOptionalWhitespace().addOpeningParen().addOptionalWhitespace().addToString(element.getExclusiveLimitValue()).addOptionalWhitespace().addClosingParen();
    }

    @Override
    @Nonnull
    public ExplainTokens visitScanPlan(@Nonnull RecordQueryScanPlan scanPlan) {
        ScanComparisons scanComparisons = scanPlan.getScanComparisons();
        TupleRange tupleRange = scanComparisons.toTupleRangeWithoutContext();
        this.addKeyword("SCAN").addOptionalWhitespace().addOpeningParen().addOptionalWhitespace();
        if (tupleRange == null) {
            this.addNested(scanComparisons.explain().getExplainTokens());
        } else {
            this.addToString(tupleRange);
        }
        return this.addOptionalWhitespace().addClosingParen();
    }

    @Override
    @Nonnull
    public ExplainTokens visitScoreForRankPlan(@Nonnull RecordQueryScoreForRankPlan scoreForRankPlan) {
        this.addKeyword("SRANK").addWhitespace().addToStrings(scoreForRankPlan.getRanks());
        this.pipe();
        return this.visit(scoreForRankPlan.getChild());
    }

    @Override
    @Nonnull
    public ExplainPlanVisitor visitSelectorPlan(@Nonnull RecordQuerySelectorPlan selectorPlan) {
        this.addKeyword("SELECTOR").addWhitespace().addKeyword("OF").addWhitespace();
        return this.visitAndJoin(() -> new ExplainTokens().addCommaAndWhiteSpace(), selectorPlan.getChildren());
    }

    @Override
    @Nonnull
    public ExplainTokens visitStreamingAggregationPlan(@Nonnull RecordQueryStreamingAggregationPlan streamingAggregationPlan) {
        this.visit(streamingAggregationPlan.getChild());
        this.pipe().addKeyword("AGG").addWhitespace().addPush().addCurrentAliasDefinition(streamingAggregationPlan.getInner().getAlias()).addNested(streamingAggregationPlan.getAggregateValue().explain().getExplainTokens());
        Value groupingValue = streamingAggregationPlan.getGroupingValue();
        if (groupingValue != null) {
            return this.addWhitespace().addKeyword("GROUP").addWhitespace().addKeyword("BY").addWhitespace().addNested(groupingValue.explain().getExplainTokens());
        }
        this.addPop();
        return this;
    }

    @Override
    @Nonnull
    public ExplainTokens visitTextIndexPlan(@Nonnull RecordQueryTextIndexPlan textIndexPlan) {
        this.addKeyword("TISCAN").addOptionalWhitespace().addOpeningParen().addOptionalWhitespace();
        this.textIndexDetails(textIndexPlan);
        return this.addOptionalWhitespace().addClosingParen();
    }

    @Nonnull
    public ExplainTokens textIndexDetails(@Nonnull RecordQueryTextIndexPlan textIndexPlan) {
        TextScan textScan = textIndexPlan.getTextScan();
        this.addToString(textScan.getIndex().getName()).addCommaAndWhiteSpace();
        if (textScan.getGroupingComparisons() != null) {
            this.addNested(textScan.getGroupingComparisons().explain().getExplainTokens());
        } else {
            this.addToString("NULL");
        }
        this.addCommaAndWhiteSpace().addNested(textScan.getTextComparison().explain().getExplainTokens()).addCommaAndWhiteSpace();
        if (textScan.getSuffixComparisons() != null) {
            this.addNested(textScan.getSuffixComparisons().explain().getExplainTokens());
        } else {
            this.addToString("NULL");
        }
        return this;
    }

    @Override
    @Nonnull
    public ExplainTokens visitTypeFilterPlan(@Nonnull RecordQueryTypeFilterPlan typeFilterPlan) {
        this.visit(typeFilterPlan.getChild());
        return this.pipe().addKeyword("TFILTER").addWhitespace().addSequence(() -> new ExplainTokens().addCommaAndWhiteSpace(), () -> typeFilterPlan.getRecordTypes().stream().map(recordType -> new ExplainTokens().addIdentifier((String)recordType)).iterator());
    }

    @Override
    @Nonnull
    public ExplainTokens visitRecursiveDfsJoinPlan(@Nonnull RecordQueryRecursiveDfsJoinPlan recursiveDfsJoinPlan) {
        Verify.verify(recursiveDfsJoinPlan.getChildren().size() == 2);
        this.addKeyword("RUNION-DFS").addWhitespace();
        ExplainTokens priorValueCorrelation = new ExplainTokens().addAliasDefinition(recursiveDfsJoinPlan.getPriorValueCorrelation());
        this.addNested(0, priorValueCorrelation).addWhitespace();
        this.addOpeningBrace().addWhitespace();
        this.visit(recursiveDfsJoinPlan.getChildren().get(0)).addWhitespace();
        this.addClosingBrace().addLinebreakOrWhitespace();
        this.addOpeningBrace().addWhitespace();
        this.addKeyword("RECURSIVE").addWhitespace();
        return this.visit(recursiveDfsJoinPlan.getChildren().get(1)).addWhitespace().addOptionalWhitespace().addClosingBrace();
    }

    @Nonnull
    private ExplainTokens visitUnionPlan(@Nonnull RecordQueryUnionPlan unionPlan) {
        this.visitAndJoin(() -> new ExplainTokens().addWhitespace().addToString("\u222a").addWhitespace(), unionPlan.getChildren());
        ExplainTokens compareByExplainTokens = new ExplainTokens().addWhitespace().addKeyword("COMPARE").addWhitespace().addKeyword("BY").addWhitespace().addNested(unionPlan.getComparisonKeyFunction().explain().getExplainTokens());
        return this.addNested(1, compareByExplainTokens);
    }

    @Override
    @Nonnull
    public ExplainTokens visitUnionOnKeyExpressionPlan(@Nonnull RecordQueryUnionOnKeyExpressionPlan unionOnKeyExpressionPlan) {
        return this.visitUnionPlan(unionOnKeyExpressionPlan);
    }

    @Override
    @Nonnull
    public ExplainTokens visitUnionOnValuesPlan(@Nonnull RecordQueryUnionOnValuesPlan unionOnValuesPlan) {
        return this.visitUnionPlan(unionOnValuesPlan);
    }

    @Override
    @Nonnull
    public ExplainTokens visitUnorderedDistinctPlan(@Nonnull RecordQueryUnorderedDistinctPlan unorderedDistinctPlan) {
        this.visit(unorderedDistinctPlan.getChild());
        return this.pipe().addKeyword("DISTINCT").addWhitespace().addKeyword("BY").addWhitespace().addToString(1, unorderedDistinctPlan.getComparisonKey());
    }

    @Override
    @Nonnull
    public ExplainTokens visitUnorderedPrimaryKeyDistinctPlan(@Nonnull RecordQueryUnorderedPrimaryKeyDistinctPlan unorderedPrimaryKeyDistinctPlan) {
        this.visit(unorderedPrimaryKeyDistinctPlan.getChild());
        return this.pipe().addKeyword("DISTINCT").addWhitespace().addKeyword("BY").addWhitespace().addKeyword("PK");
    }

    @Override
    @Nonnull
    public ExplainTokens visitUnorderedUnionPlan(@Nonnull RecordQueryUnorderedUnionPlan unorderedUnionPlan) {
        return this.visitAndJoin(() -> new ExplainTokens().addWhitespace().addToString("\u228e").addWhitespace(), unorderedUnionPlan.getChildren());
    }

    @Override
    @Nonnull
    public ExplainTokens visitUpdatePlan(@Nonnull RecordQueryUpdatePlan updatePlan) {
        this.visit(updatePlan.getChild());
        return this.pipe().addKeyword("UPDATE").addWhitespace().addIdentifier(updatePlan.getTargetRecordType());
    }

    @Override
    @Nonnull
    public ExplainTokens visitDamPlan(@Nonnull RecordQueryDamPlan damPlan) {
        this.visit(damPlan.getChild());
        return this.pipe().addKeyword("DAM");
    }

    @Override
    @Nonnull
    public ExplainTokens visitSortPlan(@Nonnull RecordQuerySortPlan sortPlan) {
        this.visit(sortPlan.getChild());
        return this.pipe().addKeyword("SORT").addWhitespace().addKeyword("BY").addWhitespace().addToString(sortPlan.getKey());
    }

    @Override
    @Nonnull
    public ExplainTokens visitTempTableScanPlan(@Nonnull TempTableScanPlan tempTableScanPlan) {
        return this.addKeyword("TEMP").addWhitespace().addKeyword("SCAN").addWhitespace().addNested(tempTableScanPlan.getTempTableReferenceValue().explain().getExplainTokens());
    }

    @Override
    @Nonnull
    public ExplainTokens visit(@Nonnull RecordQueryPlan element) {
        if (this.done) {
            return this;
        }
        return (ExplainTokens)RecordQueryPlanVisitor.super.visit(element);
    }

    @Override
    @Nonnull
    public ExplainPlanVisitor visitDefault(@Nonnull RecordQueryPlan element) {
        if (element instanceof RecordQueryPlanWithExplain) {
            this.addNested(((RecordQueryPlanWithExplain)((Object)element)).explain().getExplainTokens());
            return this;
        }
        throw new RecordCoreException("no default implementation", new Object[0]);
    }

    @Nonnull
    public static ExplainTokens indexDetails(@Nonnull RecordQueryIndexPlan indexPlan) {
        ExplainTokens resultExplainTokens = new ExplainTokens();
        IndexScanParameters scanParameters = indexPlan.getScanParameters();
        resultExplainTokens.addIdentifier(indexPlan.getIndexName()).addWhitespace(1).addNested(1, scanParameters.explain().getExplainTokens());
        ExplainTokens scanPropertiesExplainTokens = new ExplainTokens();
        if (!IndexScanType.BY_VALUE.equals(scanParameters.getScanType())) {
            scanPropertiesExplainTokens.addWhitespace().addKeyword(scanParameters.getScanType().toString());
        }
        if (indexPlan.isReverse()) {
            scanPropertiesExplainTokens.addWhitespace().addKeyword("REVERSE");
        }
        resultExplainTokens.addNested(1, scanPropertiesExplainTokens);
        return resultExplainTokens;
    }

    @Nonnull
    public static String prettyExplain(@Nonnull RecordQueryPlan plan, int explainLevel) {
        ExplainPlanVisitor visitor = new ExplainPlanVisitor(Integer.MAX_VALUE);
        return visitor.visit(plan).render(explainLevel, new PrettyExplainFormatter(ExplainSelfContainedSymbolMap::new, true), Integer.MAX_VALUE).toString();
    }

    @Nonnull
    public static String toStringForDebugging(@Nonnull RecordQueryPlan plan) {
        return ExplainPlanVisitor.toStringForDebugging(plan, 0, Integer.MAX_VALUE);
    }

    @Nonnull
    public static String toStringForDebugging(@Nonnull RecordQueryPlan plan, int explainLevel, int maxSize) {
        ExplainPlanVisitor visitor = new ExplainPlanVisitor(maxSize);
        ExplainTokens explainTokens = visitor.visit(plan);
        return explainTokens.render(explainLevel, new DefaultExplainFormatter(DefaultExplainSymbolMap::new), maxSize).toString();
    }

    @Nonnull
    public static String toStringForExternalExplain(@Nonnull RecordQueryPlan plan) {
        return ExplainPlanVisitor.toStringForExternalExplain(plan, 0, Integer.MAX_VALUE);
    }

    @Nonnull
    public static String toStringForExternalExplain(@Nonnull RecordQueryPlan plan, int maxExplainLevel, int maxSize) {
        int level;
        ExplainPlanVisitor visitor = new ExplainPlanVisitor(maxSize);
        ExplainTokens explainTokens = visitor.visit(plan);
        if (maxSize < Integer.MAX_VALUE) {
            int i;
            for (i = 0; i < maxExplainLevel && explainTokens.getMaxLength(i) > maxSize; ++i) {
            }
            level = i;
        } else {
            level = 0;
        }
        return explainTokens.render(level, new DefaultExplainFormatter(ExplainSelfContainedSymbolMap::new), maxSize).toString();
    }

    @Nonnull
    public static String prettyExplain(@Nonnull RecordQueryPlan plan) {
        return ExplainPlanVisitor.prettyExplain(plan, 0);
    }
}

