/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.explain;

import com.apple.foundationdb.record.query.plan.cascades.explain.AbstractPlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.cascades.explain.GraphExporter;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.google.common.collect.ImmutableList;
import com.google.common.escape.Escaper;
import com.google.common.graph.ImmutableNetwork;
import com.google.common.html.HtmlEscapers;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class GmlExporter<N extends PlannerGraph.Node, E extends PlannerGraph.Edge>
extends GraphExporter<N, E> {
    private static final Pattern NUMBER = Pattern.compile("([0-9]+|[0-9]+([.][0-9]*)?)");
    private static final String INDENT = "  ";
    private static final String INDENT2 = "    ";
    private static final Escaper escaper = HtmlEscapers.htmlEscaper();

    public GmlExporter(@Nonnull GraphExporter.ComponentIdProvider<N> vertexIDProvider, @Nonnull GraphExporter.ComponentAttributeProvider<N> vertexAttributeProvider, @Nonnull GraphExporter.ComponentIdProvider<E> edgeIDProvider, @Nonnull GraphExporter.ComponentAttributeProvider<E> edgeAttributeProvider, @Nonnull Map<String, Attribute> graphAttributes) {
        super(vertexIDProvider, vertexAttributeProvider, edgeIDProvider, edgeAttributeProvider, graphAttributes, (network, nodes) -> ImmutableList.of());
    }

    @Override
    protected boolean isValidId(@Nonnull String idCandidate) {
        return NUMBER.matcher(idCandidate).matches();
    }

    @Override
    protected void renderHeader(@Nonnull GraphExporter.ExporterContext context, @Nonnull ImmutableNetwork<N, E> graph) {
        context.getPrintWriter().println("graph [");
    }

    @Override
    protected void renderGraphAttributes(@Nonnull GraphExporter.ExporterContext context, @Nonnull Map<String, Attribute> attributes) {
        PrintWriter out = context.getPrintWriter();
        for (Map.Entry<String, Attribute> entry : attributes.entrySet()) {
            out.print(INDENT);
            this.renderAttribute(context, INDENT, entry.getKey(), entry.getValue());
            out.println();
        }
        out.print(INDENT);
        this.renderAttribute(context, INDENT, "directed", Attribute.gml(1));
        out.println();
    }

    @Override
    protected void renderNode(@Nonnull GraphExporter.ExporterContext context, @Nonnull N node, @Nonnull Map<String, Attribute> attributes) {
        PrintWriter out = context.getPrintWriter();
        out.print(INDENT);
        out.println("node [");
        out.print(INDENT2);
        out.print("id ");
        out.println(this.getVertexID(node));
        if (attributes.get("label") == null) {
            if (attributes.containsKey("details")) {
                out.print(INDENT2);
                Attribute detailsAttribute = attributes.get("details");
                this.renderAttribute(context, INDENT2, "details", Attribute.gml(detailsAttribute.getReference()));
                out.println();
            }
        } else {
            out.print(INDENT2);
            Attribute nameAttribute = attributes.get("label");
            this.renderAttribute(context, INDENT2, "label", Attribute.gml(nameAttribute.getReference()));
            out.println();
        }
        this.renderAttributes(context, INDENT2, attributes);
        out.print(INDENT);
        out.println("]");
    }

    @Override
    protected void renderEdge(@Nonnull GraphExporter.ExporterContext context, boolean isDirected, @Nonnull N source, @Nonnull N target, @Nonnull Map<String, Attribute> attributes) {
        PrintWriter out = context.getPrintWriter();
        out.print(INDENT);
        out.println("edge [");
        ImmutableNetwork network = context.getNetwork();
        Optional edgeOptional = network.edgeConnecting(source, target);
        edgeOptional.ifPresent(edge -> {
            out.print(INDENT2);
            out.print("id ");
            out.println(this.getEdgeID(edge));
        });
        out.print(INDENT2);
        out.print("source ");
        out.println(this.getVertexID(source));
        out.print(INDENT2);
        out.print("target ");
        out.println(this.getVertexID(target));
        this.renderAttributes(context, INDENT2, attributes);
        out.print(INDENT);
        out.println("]");
    }

    @Override
    protected void renderClusters(@Nonnull GraphExporter.ExporterContext context, @Nonnull Collection<GraphExporter.Cluster<N, E>> clusters) {
    }

    @Override
    protected void renderFooter(@Nonnull GraphExporter.ExporterContext context) {
        context.getPrintWriter().print("]");
    }

    private void renderAttributes(@Nonnull GraphExporter.ExporterContext context, @Nonnull String indentation, @Nonnull Map<String, Attribute> attributes) {
        PrintWriter out = context.getPrintWriter();
        for (Map.Entry<String, Attribute> entry : attributes.entrySet()) {
            String key = entry.getKey();
            Attribute value = entry.getValue();
            if (!value.isVisible(context)) continue;
            out.print(indentation);
            this.renderAttribute(context, indentation, key, value);
            out.print("\n");
        }
    }

    private void renderAttribute(@Nonnull GraphExporter.ExporterContext context, @Nonnull String indentation, @Nonnull String attrName, @Nonnull Attribute attribute) {
        if (attribute.isVisible(context)) {
            PrintWriter out = context.getPrintWriter();
            Object reference = attribute.getReference();
            if (reference instanceof Map) {
                Map nestedAttributes = (Map)reference;
                out.print(attrName);
                if (nestedAttributes.isEmpty()) {
                    out.print(" [ ]");
                } else {
                    out.println(" [");
                    this.renderAttributes(context, indentation + INDENT, nestedAttributes);
                    out.print(indentation);
                    out.print("]");
                }
            } else if (reference instanceof Collection) {
                Collection nestedAttributes = (Collection)reference;
                out.print(attrName);
                if (nestedAttributes.isEmpty()) {
                    out.print(" [ ]");
                } else {
                    out.println(" [");
                    out.print(indentation);
                    for (Attribute nestedAttribute : nestedAttributes) {
                        out.print(INDENT);
                        this.renderAttribute(context, indentation + INDENT, "x", nestedAttribute);
                        out.println();
                        out.print(indentation);
                    }
                    out.print("]");
                }
            } else if (reference instanceof AbstractPlannerGraph.AbstractEdge) {
                PlannerGraph.Edge edge = (PlannerGraph.Edge)reference;
                this.renderAttribute(context, indentation, attrName, Attribute.gml(Integer.parseInt(this.getEdgeID(edge))));
            } else if (reference instanceof Number) {
                out.print(attrName);
                out.print(" ");
                out.print(reference);
            } else {
                out.print(attrName);
                out.print(" ");
                out.print("\"" + escaper.escape(reference.toString()) + "\"");
            }
        }
    }
}

