/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.explain;

import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.ImmutableNetwork;
import com.google.common.graph.Network;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;

public abstract class GraphExporter<N, E> {
    @Nonnull
    private final ComponentIdProvider<N> vertexIDProvider;
    @Nonnull
    private final ComponentAttributeProvider<N> vertexAttributeProvider;
    @Nonnull
    private final ComponentIdProvider<E> edgeIDProvider;
    @Nonnull
    private final ComponentAttributeProvider<E> edgeAttributeProvider;
    @Nonnull
    private final ImmutableMap<String, Attribute> graphAttributes;
    @Nonnull
    private final Map<N, String> vertexIds;
    @Nonnull
    private final Map<E, String> edgeIds;
    @Nonnull
    private final ClusterProvider<N, E> clusterProvider;

    protected GraphExporter(@Nonnull ComponentIdProvider<N> vertexIDProvider, @Nonnull ComponentAttributeProvider<N> vertexAttributeProvider, @Nonnull ComponentIdProvider<E> edgeIDProvider, @Nonnull ComponentAttributeProvider<E> edgeAttributeProvider, @Nonnull Map<String, Attribute> graphAttributes, @Nonnull ClusterProvider<N, E> clusterProvider) {
        this.vertexIDProvider = vertexIDProvider;
        this.vertexAttributeProvider = vertexAttributeProvider;
        this.edgeIDProvider = edgeIDProvider;
        this.edgeAttributeProvider = edgeAttributeProvider;
        this.graphAttributes = ImmutableMap.copyOf(graphAttributes);
        this.vertexIds = new HashMap<N, String>();
        this.edgeIds = new HashMap<E, String>();
        this.clusterProvider = clusterProvider;
    }

    @Nonnull
    protected ComponentIdProvider<N> getVertexIDProvider() {
        return this.vertexIDProvider;
    }

    @Nonnull
    protected ComponentAttributeProvider<N> getVertexAttributeProvider() {
        return this.vertexAttributeProvider;
    }

    @Nonnull
    public ComponentIdProvider<E> getEdgeIDProvider() {
        return this.edgeIDProvider;
    }

    @Nonnull
    protected ComponentAttributeProvider<E> getEdgeAttributeProvider() {
        return this.edgeAttributeProvider;
    }

    @Nonnull
    protected ImmutableMap<String, Attribute> getGraphAttributes() {
        return this.graphAttributes;
    }

    @Nonnull
    protected Map<N, String> getVertexIds() {
        return this.vertexIds;
    }

    @Nonnull
    protected ClusterProvider<N, E> getClusterProvider() {
        return this.clusterProvider;
    }

    public void exportGraph(@Nonnull ImmutableNetwork<N, E> network, @Nonnull Writer writer) {
        ExporterContext context = new ExporterContext(network, new PrintWriter(writer));
        this.renderHeader(context, network);
        this.renderGraphAttributes(context, this.graphAttributes);
        this.renderNodes(context);
        this.renderEdges(context);
        this.renderClusters(context, (Collection)this.clusterProvider.apply(network, network.nodes()));
        this.renderFooter(context);
        context.getPrintWriter().flush();
    }

    @Nonnull
    protected String getVertexID(@Nonnull N node) {
        return this.vertexIds.computeIfAbsent(node, n -> {
            String idCandidate = (String)this.vertexIDProvider.apply(node);
            if (!this.isValidId(idCandidate)) {
                throw new IllegalArgumentException("generated id '" + idCandidate + "'for vertex '" + String.valueOf(node) + "' is not valid");
            }
            return idCandidate;
        });
    }

    @Nonnull
    protected String getEdgeID(@Nonnull E edge) {
        return this.edgeIds.computeIfAbsent(edge, n -> {
            String idCandidate = (String)this.edgeIDProvider.apply(edge);
            if (!this.isValidId(idCandidate)) {
                throw new IllegalArgumentException("generated id '" + idCandidate + "'for edge '" + String.valueOf(edge) + "' is not valid");
            }
            return idCandidate;
        });
    }

    protected abstract boolean isValidId(@Nonnull String var1);

    protected abstract void renderHeader(@Nonnull ExporterContext var1, @Nonnull ImmutableNetwork<N, E> var2);

    protected abstract void renderGraphAttributes(@Nonnull ExporterContext var1, @Nonnull Map<String, Attribute> var2);

    protected void renderNodes(@Nonnull ExporterContext context) {
        ImmutableNetwork network = context.getNetwork();
        for (Object n : network.nodes()) {
            this.renderNode(context, n, (Map)this.vertexAttributeProvider.apply(n));
        }
    }

    protected abstract void renderNode(@Nonnull ExporterContext var1, @Nonnull N var2, @Nonnull Map<String, Attribute> var3);

    protected void renderEdges(@Nonnull ExporterContext context) {
        ImmutableNetwork network = context.getNetwork();
        for (Object e : network.edges()) {
            EndpointPair endpointPair = network.incidentNodes(e);
            Object u = endpointPair.nodeU();
            Object v = endpointPair.nodeV();
            this.renderEdge(context, network.isDirected(), u, v, (Map)this.edgeAttributeProvider.apply(e));
        }
    }

    protected abstract void renderEdge(@Nonnull ExporterContext var1, boolean var2, @Nonnull N var3, @Nonnull N var4, @Nonnull Map<String, Attribute> var5);

    protected abstract void renderClusters(@Nonnull ExporterContext var1, @Nonnull Collection<Cluster<N, E>> var2);

    protected abstract void renderFooter(@Nonnull ExporterContext var1);

    public static interface ComponentIdProvider<T>
    extends Function<T, String> {
    }

    public static interface ComponentAttributeProvider<T>
    extends Function<T, Map<String, Attribute>> {
    }

    public static interface ClusterProvider<N, E>
    extends BiFunction<Network<N, E>, Set<N>, Collection<Cluster<N, E>>> {
    }

    public class ExporterContext {
        @Nonnull
        private final ImmutableNetwork<N, E> network;
        @Nonnull
        private final PrintWriter printWriter;

        public ExporterContext(@Nonnull ImmutableNetwork<N, E> network, PrintWriter printWriter) {
            this.network = network;
            this.printWriter = printWriter;
        }

        @Nonnull
        public ImmutableNetwork<N, E> getNetwork() {
            return this.network;
        }

        @Nonnull
        public PrintWriter getPrintWriter() {
            return this.printWriter;
        }

        @Nonnull
        public GraphExporter<N, E> getExporter() {
            return GraphExporter.this;
        }
    }

    public static class Cluster<N, E> {
        @Nonnull
        private final ImmutableSet<N> nodes;
        @Nonnull
        final ComponentAttributeProvider<Cluster<N, E>> clusterAttributeProvider;
        @Nonnull
        private final ClusterProvider<N, E> nestedClusterProvider;

        public Cluster(@Nonnull Set<N> nodes, @Nonnull ComponentAttributeProvider<Cluster<N, E>> clusterAttributeProvider, @Nonnull ClusterProvider<N, E> nestedClusterProvider) {
            this.nodes = ImmutableSet.copyOf(nodes);
            this.clusterAttributeProvider = clusterAttributeProvider;
            this.nestedClusterProvider = nestedClusterProvider;
        }

        @Nonnull
        public ImmutableSet<N> getNodes() {
            return this.nodes;
        }

        @Nonnull
        public ComponentAttributeProvider<Cluster<N, E>> getClusterAttributeProvider() {
            return this.clusterAttributeProvider;
        }

        @Nonnull
        public ClusterProvider<N, E> getNestedClusterProvider() {
            return this.nestedClusterProvider;
        }
    }
}

