/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.explain;

import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifiers;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.apple.foundationdb.record.query.plan.cascades.explain.AbstractPlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.explain.DefaultExplainFormatter;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import com.google.common.graph.Network;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PlannerGraph
extends AbstractPlannerGraph<Node, Edge> {
    public static PlannerGraph fromNodeAndChildGraphs(@Nonnull Node node, @Nonnull List<? extends PlannerGraph> childGraphs) {
        List<? extends Quantifier> quantifiers = PlannerGraph.tryGetQuantifiers(node);
        if (quantifiers.isEmpty() || quantifiers.size() != childGraphs.size()) {
            return PlannerGraph.fromNodeAndChildGraphs(node, childGraphs, null);
        }
        List<? extends Quantifier> sortedQuantifiers = Quantifiers.anyTopologicalOrderPermutation(quantifiers);
        InternalPlannerGraphBuilder plannerGraphBuilder = PlannerGraph.builder(node);
        HashMap<CorrelationIdentifier, ExistentialQuantifierEdge> aliasToEdgeMap = Maps.newHashMap();
        for (Quantifier quantifier : sortedQuantifiers) {
            int index = Streams.mapWithIndex(quantifiers.stream(), (q, i) -> q == quantifier ? (int)i : -1).filter(i -> i >= 0).findFirst().orElseThrow(() -> new RecordCoreException("should have found the quantifier", new Object[0]));
            Set dependsOn = quantifier.getCorrelatedTo().stream().filter(aliasToEdgeMap::containsKey).map(aliasToEdgeMap::get).collect(ImmutableSet.toImmutableSet());
            PlannerGraph childGraph = childGraphs.get(index);
            String label = Debugger.mapDebugger(debugger -> quantifier.getAlias().getId()).orElse(null);
            ReferenceEdge edge = quantifier instanceof Quantifier.Existential ? new ExistentialQuantifierEdge(label, dependsOn) : (quantifier instanceof Quantifier.ForEach ? new ForEachQuantifierEdge(label, ((Quantifier.ForEach)quantifier).isNullOnEmpty(), dependsOn) : (quantifier instanceof Quantifier.Physical ? new PhysicalQuantifierEdge(label, dependsOn) : new ReferenceEdge(label, dependsOn)));
            plannerGraphBuilder.addGraph(childGraph).addEdge((Node)childGraph.getRoot(), (Node)plannerGraphBuilder.getRoot(), edge);
            aliasToEdgeMap.put(quantifier.getAlias(), (ExistentialQuantifierEdge)edge);
        }
        return plannerGraphBuilder.build();
    }

    public static PlannerGraph fromNodeAndChildGraphs(@Nonnull Node node, @Nonnull List<? extends PlannerGraph> sortedChildGraphs, @Nullable List<? extends Quantifier> sortedQuantifiers) {
        Preconditions.checkArgument(sortedQuantifiers == null || sortedQuantifiers.size() == sortedChildGraphs.size());
        InternalPlannerGraphBuilder plannerGraphBuilder = PlannerGraph.builder(node);
        ReferenceEdge previousEdge = null;
        for (int i = 0; i < sortedChildGraphs.size(); ++i) {
            String label;
            ImmutableSet<Object> dependsOn;
            PlannerGraph childGraph = sortedChildGraphs.get(i);
            ImmutableSet<Object> immutableSet = dependsOn = previousEdge == null ? ImmutableSet.of() : ImmutableSet.of(previousEdge);
            if (sortedQuantifiers != null) {
                Quantifier quantifier = sortedQuantifiers.get(i);
                label = Debugger.mapDebugger(debugger -> quantifier.getAlias().getId()).orElse(null);
            } else {
                label = null;
            }
            ReferenceEdge edge = new ReferenceEdge(label, dependsOn);
            plannerGraphBuilder.addGraph(childGraph).addEdge((Node)childGraph.getRoot(), (Node)plannerGraphBuilder.getRoot(), edge);
            previousEdge = edge;
        }
        return plannerGraphBuilder.build();
    }

    public static PlannerGraph fromNodeInnerAndTargetForModifications(@Nonnull Node node, @Nonnull PlannerGraph innerGraph, @Nonnull PlannerGraph targetGraph) {
        InternalPlannerGraphBuilder plannerGraphBuilder = PlannerGraph.builder(node);
        ReferenceEdge edge = new ReferenceEdge(null, ImmutableSet.of());
        plannerGraphBuilder.addGraph(innerGraph).addEdge((Node)innerGraph.getRoot(), (Node)plannerGraphBuilder.getRoot(), edge);
        edge = new ModificationTargetEdge(null, ImmutableSet.of(edge));
        plannerGraphBuilder.addGraph(targetGraph).addEdge((Node)targetGraph.getRoot(), (Node)plannerGraphBuilder.getRoot(), edge);
        return plannerGraphBuilder.build();
    }

    private static List<? extends Quantifier> tryGetQuantifiers(@Nonnull Node node) {
        RelationalExpression expression;
        if (node instanceof WithExpression && (expression = ((WithExpression)((Object)node)).getExpression()) != null) {
            return expression.getQuantifiers();
        }
        return ImmutableList.of();
    }

    public static InternalPlannerGraphBuilder builder(Node root) {
        return new InternalPlannerGraphBuilder(root);
    }

    protected PlannerGraph(Node root, Network<Node, Edge> network) {
        super(root, network);
    }

    public InternalPlannerGraphBuilder derived() {
        return new InternalPlannerGraphBuilder(this);
    }

    public static class Node
    extends AbstractPlannerGraph.AbstractNode {
        @Nonnull
        private final Map<String, Attribute> additionalAttributes;

        public Node(@Nonnull Object identity, @Nonnull String name) {
            this(identity, name, null);
        }

        public Node(@Nonnull Object identity, @Nonnull String name, @Nullable List<String> details) {
            this(identity, name, details, ImmutableMap.of());
        }

        public Node(@Nonnull Object identity, @Nonnull String name, @Nullable List<String> details, @Nonnull Map<String, Attribute> additionalAttributes) {
            super(identity, name, details);
            this.additionalAttributes = ImmutableMap.copyOf(additionalAttributes);
        }

        @Override
        @Nonnull
        public Map<String, Attribute> getAttributes() {
            ImmutableMap.Builder<String, Attribute> builder = ImmutableMap.builder();
            Optional.ofNullable(this.getDetails()).ifPresent(details -> builder.put("details", Attribute.invisible(this.getDetails().stream().map(Attribute::common).collect(Collectors.toList()))));
            builder.putAll(this.additionalAttributes);
            return builder.put("name", Attribute.invisible(this.getName())).put("color", (Attribute.InvisibleAttribute)Attribute.dot(this.getColor())).put("shape", (Attribute.InvisibleAttribute)Attribute.dot(this.getShape())).put("style", (Attribute.InvisibleAttribute)Attribute.dot(this.getStyle())).put("fillcolor", (Attribute.InvisibleAttribute)Attribute.dot(this.getFillColor())).put("fontname", (Attribute.InvisibleAttribute)Attribute.dot(this.getFontName())).put("fontsize", (Attribute.InvisibleAttribute)Attribute.dot(this.getFontSize())).put("tooltip", (Attribute.InvisibleAttribute)Attribute.dot(this.getToolTip())).build();
        }

        @Nonnull
        public String getColor() {
            return "black";
        }

        @Nonnull
        public String getShape() {
            return "plain";
        }

        @Nonnull
        public String getStyle() {
            return "solid";
        }

        @Nonnull
        public String getFillColor() {
            return "black";
        }

        @Nonnull
        public String getFontName() {
            return "courier";
        }

        @Nonnull
        public String getFontSize() {
            return this.getDetails() == null || this.getDetails().isEmpty() ? "12" : "8";
        }

        @Nonnull
        String getToolTip() {
            return this.getClass().getSimpleName();
        }
    }

    public static class InternalPlannerGraphBuilder
    extends AbstractPlannerGraph.PlannerGraphBuilder<Node, Edge, PlannerGraph> {
        public InternalPlannerGraphBuilder(Node root) {
            super(root);
        }

        public InternalPlannerGraphBuilder(@Nonnull AbstractPlannerGraph<Node, Edge> original) {
            super(original);
        }

        @Override
        @Nonnull
        public PlannerGraph build() {
            return new PlannerGraph((Node)this.getRoot(), (Network<Node, Edge>)this.getNetwork());
        }
    }

    public static class ExistentialQuantifierEdge
    extends ReferenceEdge {
        public ExistentialQuantifierEdge() {
            this(null, ImmutableSet.of());
        }

        public ExistentialQuantifierEdge(Set<? extends AbstractPlannerGraph.AbstractEdge> dependsOn) {
            super(null, dependsOn);
        }

        public ExistentialQuantifierEdge(@Nullable String label, Set<? extends AbstractPlannerGraph.AbstractEdge> dependsOn) {
            super(label, dependsOn);
        }

        @Override
        @Nonnull
        public String getColor() {
            return "gray70";
        }

        @Override
        @Nonnull
        public String getArrowHead() {
            return "diamond";
        }
    }

    public static class ForEachQuantifierEdge
    extends ReferenceEdge {
        private final boolean isNullIsEmpty;

        public ForEachQuantifierEdge() {
            this(null, ImmutableSet.of());
        }

        public ForEachQuantifierEdge(Set<? extends AbstractPlannerGraph.AbstractEdge> dependsOn) {
            this(null, dependsOn);
        }

        public ForEachQuantifierEdge(@Nullable String label, Set<? extends AbstractPlannerGraph.AbstractEdge> dependsOn) {
            this(label, false, dependsOn);
        }

        public ForEachQuantifierEdge(@Nullable String label, boolean isNullIfEmpty, Set<? extends AbstractPlannerGraph.AbstractEdge> dependsOn) {
            super(label, dependsOn);
            this.isNullIsEmpty = isNullIfEmpty;
        }

        @Override
        @Nonnull
        public String getColor() {
            return this.isNullIsEmpty ? "khaki3" : super.getColor();
        }
    }

    public static class PhysicalQuantifierEdge
    extends ReferenceEdge {
        public PhysicalQuantifierEdge() {
            this(null, ImmutableSet.of());
        }

        public PhysicalQuantifierEdge(Set<? extends AbstractPlannerGraph.AbstractEdge> dependsOn) {
            super(null, dependsOn);
        }

        public PhysicalQuantifierEdge(@Nullable String label, Set<? extends AbstractPlannerGraph.AbstractEdge> dependsOn) {
            super(label, dependsOn);
        }

        @Override
        @Nonnull
        public String getStyle() {
            return "bold";
        }
    }

    public static class ReferenceEdge
    extends Edge {
        public ReferenceEdge() {
            this(ImmutableSet.of());
        }

        public ReferenceEdge(Set<? extends AbstractPlannerGraph.AbstractEdge> dependsOn) {
            this(null, dependsOn);
        }

        public ReferenceEdge(@Nullable String label, Set<? extends AbstractPlannerGraph.AbstractEdge> dependsOn) {
            super(label, dependsOn);
        }

        @Override
        @Nonnull
        public String getColor() {
            return "gray20";
        }
    }

    public static class ModificationTargetEdge
    extends ReferenceEdge {
        public ModificationTargetEdge() {
            this(null, ImmutableSet.of());
        }

        public ModificationTargetEdge(Set<? extends AbstractPlannerGraph.AbstractEdge> dependsOn) {
            super(null, dependsOn);
        }

        public ModificationTargetEdge(@Nullable String label, Set<? extends AbstractPlannerGraph.AbstractEdge> dependsOn) {
            super(label, dependsOn);
        }

        @Override
        @Nonnull
        public String getArrowHead() {
            return "none";
        }

        @Override
        @Nonnull
        public String getArrowTail() {
            return "normal";
        }
    }

    public static interface WithExpression {
        @Nullable
        public RelationalExpression getExpression();
    }

    public static class PartialMatchEdge
    extends Edge {
        public PartialMatchEdge() {
            this((String)null);
        }

        public PartialMatchEdge(@Nullable String label) {
            super(label);
        }

        @Override
        @Nonnull
        public Map<String, Attribute> getAttributes() {
            Map<String, Attribute> attributes = super.getAttributes();
            return ImmutableMap.builder().putAll(attributes).put("constraint", Attribute.dot("false")).build();
        }

        @Override
        @Nonnull
        public String getStyle() {
            return "dashed";
        }
    }

    public static class ReferenceInternalEdge
    extends Edge {
        @Override
        @Nonnull
        public Map<String, Attribute> getAttributes() {
            Map<String, Attribute> attributes = super.getAttributes();
            return ImmutableMap.builder().putAll(attributes).put("constraint", Attribute.dot("false")).build();
        }

        @Override
        @Nonnull
        public String getStyle() {
            return "invis";
        }
    }

    public static class Edge
    extends AbstractPlannerGraph.AbstractEdge {
        public Edge() {
            this(null, ImmutableSet.of());
        }

        public Edge(@Nullable String label) {
            this(label, ImmutableSet.of());
        }

        public Edge(Set<? extends AbstractPlannerGraph.AbstractEdge> dependsOn) {
            this(null, dependsOn);
        }

        public Edge(@Nullable String label, @Nonnull Set<? extends AbstractPlannerGraph.AbstractEdge> dependsOn) {
            super(label, dependsOn);
        }

        @Override
        @Nonnull
        public Map<String, Attribute> getAttributes() {
            ImmutableMap.Builder<String, Attribute.GmlAttribute> builder = ImmutableMap.builder();
            Optional.ofNullable(this.getLabel()).ifPresent(label -> builder.put("label", Attribute.common(label)));
            return builder.put("dependsOn", Attribute.gml(this.getDependsOn().stream().map(Attribute::common).collect(Collectors.toList()))).put("color", (Attribute.GmlAttribute)((Object)Attribute.dot(this.getColor()))).put("style", (Attribute.GmlAttribute)((Object)Attribute.dot(this.getStyle()))).put("fontname", (Attribute.GmlAttribute)((Object)Attribute.dot(this.getFontName()))).put("fontsize", (Attribute.GmlAttribute)((Object)Attribute.dot(this.getFontSize()))).put("arrowhead", (Attribute.GmlAttribute)((Object)Attribute.dot(this.getArrowHead()))).put("arrowtail", (Attribute.GmlAttribute)((Object)Attribute.dot(this.getArrowTail()))).put("dir", (Attribute.GmlAttribute)((Object)Attribute.dot("both"))).build();
        }

        @Nonnull
        public String getColor() {
            return "black";
        }

        @Nonnull
        public String getStyle() {
            return "solid";
        }

        @Nonnull
        public String getFontName() {
            return "courier";
        }

        @Nonnull
        public String getFontSize() {
            return "8";
        }

        @Nonnull
        public String getArrowHead() {
            return "normal";
        }

        @Nonnull
        public String getArrowTail() {
            return "none";
        }
    }

    public static class ReferenceMemberNode
    extends Node {
        public ReferenceMemberNode(String name) {
            super(new Object(), name);
        }

        public ReferenceMemberNode() {
            super(new Object(), "m");
        }

        @Override
        @Nonnull
        public Map<String, Attribute> getAttributes() {
            Map<String, Attribute> attributes = super.getAttributes();
            return ImmutableMap.builder().putAll(attributes).put("label", Attribute.common(this.getName())).put("margin", Attribute.dot("0")).put("height", Attribute.dot("0")).put("width", Attribute.dot("0")).build();
        }

        @Override
        @Nonnull
        public String getShape() {
            return "circle";
        }

        @Override
        @Nonnull
        public String getStyle() {
            return "filled";
        }

        @Override
        @Nonnull
        public String getFillColor() {
            return "white";
        }

        @Override
        @Nonnull
        public String getFontSize() {
            return "6";
        }
    }

    public static class ReferenceHeadNode
    extends Node {
        public ReferenceHeadNode(Reference ref) {
            super(ref, Reference.class.getSimpleName());
        }

        @Override
        @Nonnull
        public Map<String, Attribute> getAttributes() {
            Map<String, Attribute> attributes = super.getAttributes();
            return ImmutableMap.builder().putAll(attributes).put("label", Attribute.common(this.getName())).put("margin", Attribute.dot("0")).put("height", Attribute.dot("0")).put("width", Attribute.dot("0")).build();
        }

        @Override
        @Nonnull
        public String getName() {
            return "r";
        }

        @Override
        @Nonnull
        public String getShape() {
            return "circle";
        }

        @Override
        @Nonnull
        public String getStyle() {
            return "filled";
        }

        @Override
        @Nonnull
        public String getFillColor() {
            return "white";
        }

        @Override
        @Nonnull
        public String getFontSize() {
            return "6";
        }
    }

    public static class ModificationLogicalOperatorNode
    extends LogicalOperatorNodeWithInfo {
        public ModificationLogicalOperatorNode(@Nullable RelationalExpression expression, NodeInfo nodeInfo, @Nullable List<String> details, Map<String, Attribute> additionalAttributes) {
            super(expression, nodeInfo, details, additionalAttributes);
        }

        @Override
        @Nonnull
        public String getFillColor() {
            return "darkseagreen4";
        }
    }

    public static class LogicalOperatorNodeWithInfo
    extends NodeWithInfo
    implements WithExpression {
        @Nullable
        private final RelationalExpression expression;

        public LogicalOperatorNodeWithInfo(@Nullable RelationalExpression expression, NodeInfo nodeInfo, @Nullable List<String> details, Map<String, Attribute> additionalAttributes) {
            super(new Object(), nodeInfo, details, additionalAttributes);
            this.expression = expression;
        }

        @Override
        @Nonnull
        public Map<String, Attribute> getAttributes() {
            Map<String, Attribute> attributes = super.getAttributes();
            return ImmutableMap.builder().putAll(attributes).put("classifier", Attribute.gml("operator")).build();
        }

        @Override
        @Nonnull
        public String getStyle() {
            return "filled";
        }

        @Override
        @Nonnull
        public String getFillColor() {
            return "darkseagreen2";
        }

        @Override
        @Nonnull
        String getToolTip() {
            return this.expression == null ? "no expression" : this.expression.getResultType().describe().render(DefaultExplainFormatter.forDebugging()).toString();
        }

        @Override
        @Nullable
        public RelationalExpression getExpression() {
            return this.expression;
        }
    }

    public static class LogicalOperatorNode
    extends Node
    implements WithExpression {
        @Nullable
        private final RelationalExpression expression;

        public LogicalOperatorNode(@Nullable RelationalExpression expression, String name, @Nullable List<String> details, Map<String, Attribute> additionalAttributes) {
            super(new Object(), name, details, additionalAttributes);
            this.expression = expression;
        }

        @Override
        @Nonnull
        public Map<String, Attribute> getAttributes() {
            Map<String, Attribute> attributes = super.getAttributes();
            return ImmutableMap.builder().putAll(attributes).put("classifier", Attribute.gml("operator")).build();
        }

        @Override
        @Nonnull
        public String getStyle() {
            return "filled";
        }

        @Override
        @Nonnull
        public String getFillColor() {
            return "darkseagreen2";
        }

        @Override
        @Nonnull
        String getToolTip() {
            return this.expression == null ? "no expression" : this.expression.getResultType().describe().render(DefaultExplainFormatter.forDebugging()).toString();
        }

        @Override
        @Nullable
        public RelationalExpression getExpression() {
            return this.expression;
        }
    }

    public static class ModificationOperatorNodeWithInfo
    extends OperatorNodeWithInfo {
        public ModificationOperatorNodeWithInfo(@Nonnull RecordQueryPlan recordQueryPlan, @Nonnull NodeInfo nodeInfo) {
            this(recordQueryPlan, nodeInfo, null);
        }

        public ModificationOperatorNodeWithInfo(@Nonnull RecordQueryPlan recordQueryPlan, @Nonnull NodeInfo nodeInfo, @Nullable List<String> details) {
            this(recordQueryPlan, nodeInfo, details, ImmutableMap.of());
        }

        public ModificationOperatorNodeWithInfo(@Nonnull RecordQueryPlan recordQueryPlan, @Nonnull NodeInfo nodeInfo, @Nullable List<String> details, @Nonnull Map<String, Attribute> additionalAttributes) {
            super(recordQueryPlan, nodeInfo, details, additionalAttributes);
        }

        @Override
        @Nonnull
        public String getStyle() {
            return "filled";
        }

        @Override
        @Nonnull
        public String getFillColor() {
            return "lightcoral";
        }
    }

    public static class OperatorNodeWithInfo
    extends NodeWithInfo
    implements WithExpression {
        @Nullable
        private final RecordQueryPlan expression;

        public OperatorNodeWithInfo(@Nonnull RecordQueryPlan recordQueryPlan, @Nonnull NodeInfo nodeInfo) {
            this(recordQueryPlan, nodeInfo, null);
        }

        public OperatorNodeWithInfo(@Nonnull RecordQueryPlan recordQueryPlan, @Nonnull NodeInfo nodeInfo, @Nullable List<String> details) {
            this(recordQueryPlan, nodeInfo, details, ImmutableMap.of());
        }

        public OperatorNodeWithInfo(@Nonnull RecordQueryPlan recordQueryPlan, @Nonnull NodeInfo nodeInfo, @Nullable List<String> details, @Nonnull Map<String, Attribute> additionalAttributes) {
            super(new Object(), nodeInfo, details, additionalAttributes);
            this.expression = recordQueryPlan;
        }

        @Override
        @Nonnull
        public Map<String, Attribute> getAttributes() {
            Map<String, Attribute> attributes = super.getAttributes();
            return ImmutableMap.builder().putAll(attributes).put("classifier", Attribute.gml("operator")).build();
        }

        @Override
        @Nonnull
        String getToolTip() {
            return this.expression == null ? "no plan" : this.expression.getResultType().describe().render(DefaultExplainFormatter.forDebugging()).toString();
        }

        @Override
        @Nullable
        public RecordQueryPlan getExpression() {
            return this.expression;
        }
    }

    public static class TemporaryDataNodeWithInfo
    extends DataNodeWithInfo {
        public TemporaryDataNodeWithInfo(@Nonnull Type type, @Nullable List<String> sources) {
            super(NodeInfo.TEMPORARY_BUFFER_DATA, type, sources);
        }

        public TemporaryDataNodeWithInfo(@Nonnull Type type, @Nullable List<String> sources, @Nonnull Map<String, Attribute> additionalAttributes) {
            super(NodeInfo.TEMPORARY_BUFFER_DATA, type, sources, additionalAttributes);
        }

        @Override
        @Nonnull
        public String getFillColor() {
            return "goldenrod2";
        }
    }

    public static class DataNodeWithInfo
    extends NodeWithInfo {
        @Nonnull
        private final Type type;

        public DataNodeWithInfo(@Nonnull NodeInfo nodeInfo, @Nonnull Type type, @Nullable List<String> sources) {
            this(nodeInfo, type, sources, ImmutableMap.of());
        }

        public DataNodeWithInfo(@Nonnull NodeInfo nodeInfo, @Nonnull Type type, @Nullable List<String> sources, @Nonnull Map<String, Attribute> additionalAttributes) {
            super(new Object(), nodeInfo, sources, additionalAttributes);
            this.type = type;
        }

        @Override
        @Nonnull
        public Map<String, Attribute> getAttributes() {
            Map<String, Attribute> attributes = super.getAttributes();
            return ImmutableMap.builder().putAll(attributes).put("classifier", Attribute.gml("data")).build();
        }

        @Override
        @Nonnull
        public String getColor() {
            return "black";
        }

        @Override
        @Nonnull
        public String getStyle() {
            return "filled";
        }

        @Override
        @Nonnull
        public String getFillColor() {
            return "lightblue";
        }

        @Override
        @Nonnull
        String getToolTip() {
            return this.type.describe().render(DefaultExplainFormatter.forDebugging()).toString();
        }
    }

    public static class NodeWithInfo
    extends Node
    implements WithInfoId {
        @Nonnull
        private final NodeInfo nodeInfo;

        public NodeWithInfo(@Nonnull Object identity, @Nonnull NodeInfo nodeInfo) {
            this(identity, nodeInfo, null);
        }

        public NodeWithInfo(@Nonnull Object identity, @Nonnull NodeInfo nodeInfo, @Nullable List<String> details) {
            this(identity, nodeInfo, details, ImmutableMap.of());
        }

        public NodeWithInfo(@Nonnull Object identity, @Nonnull NodeInfo nodeInfo, @Nullable List<String> details, @Nonnull Map<String, Attribute> additionalAttributes) {
            super(identity, nodeInfo.getName(), details, additionalAttributes);
            this.nodeInfo = nodeInfo;
        }

        @Nonnull
        public NodeInfo getNodeInfo() {
            return this.nodeInfo;
        }

        @Override
        @Nonnull
        public String getInfoId() {
            return this.getNodeInfo().getId();
        }

        @Override
        @Nonnull
        public Map<String, Attribute> getAttributes() {
            Map<String, Attribute> attributes = super.getAttributes();
            return ImmutableMap.builder().putAll(attributes).put("infoId", Attribute.gml(this.nodeInfo.getId())).build();
        }
    }

    public static interface WithInfoId {
        @Nonnull
        public String getInfoId();
    }
}

