/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.explain;

import com.apple.foundationdb.record.query.plan.cascades.MatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.PartialMatch;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.SimpleExpressionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.Traversal;
import com.apple.foundationdb.record.query.plan.cascades.debug.BrowserHelper;
import com.apple.foundationdb.record.query.plan.cascades.debug.Debugger;
import com.apple.foundationdb.record.query.plan.cascades.explain.AbstractPlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.cascades.explain.DotExporter;
import com.apple.foundationdb.record.query.plan.cascades.explain.ExplainPlannerGraphRewritable;
import com.apple.foundationdb.record.query.plan.cascades.explain.GmlExporter;
import com.apple.foundationdb.record.query.plan.cascades.explain.GraphExporter;
import com.apple.foundationdb.record.query.plan.cascades.explain.InternalPlannerGraphRewritable;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraphRewritable;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.graph.ImmutableNetwork;
import com.google.common.graph.Network;
import java.io.StringWriter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class PlannerGraphVisitor
implements SimpleExpressionVisitor<PlannerGraph> {
    public static final int EMPTY_FLAGS = 0;
    public static final int FOR_EXPLAIN = 1;
    public static final int RENDER_SINGLE_GROUPS = 2;
    public static final int REMOVE_FINAL_EXPRESSIONS = 4;
    public static final int REMOVE_EXPLORATORY_EXPRESSIONS = 8;
    private final int flags;

    private static boolean validateFlags(int flags) {
        return (flags & 4) == 0 || (flags & 8) == 0;
    }

    @Nonnull
    public static String show(boolean renderSingleGroups, @Nonnull RelationalExpression relationalExpression) {
        return PlannerGraphVisitor.show(renderSingleGroups ? 2 : 0, relationalExpression);
    }

    @Nonnull
    public static String show(boolean renderSingleGroups, @Nonnull Reference rootReference) {
        return PlannerGraphVisitor.show(renderSingleGroups ? 2 : 0, rootReference);
    }

    @Nonnull
    public static String show(int flags, @Nonnull RelationalExpression relationalExpression) {
        PlannerGraph plannerGraph = Objects.requireNonNull(relationalExpression.acceptVisitor(new PlannerGraphVisitor(flags)));
        String dotString = PlannerGraphVisitor.exportToDot(plannerGraph);
        return PlannerGraphVisitor.show(dotString);
    }

    @Nonnull
    public static String show(int flags, @Nonnull Reference rootReference) {
        PlannerGraph plannerGraph = Objects.requireNonNull(rootReference.acceptVisitor(new PlannerGraphVisitor(flags)));
        String dotString = PlannerGraphVisitor.exportToDot(plannerGraph);
        return PlannerGraphVisitor.show(dotString);
    }

    @Nonnull
    public static String show(boolean renderSingleGroups, @Nonnull Reference queryPlanRootReference, @Nonnull Set<MatchCandidate> matchCandidates) {
        PlannerGraph queryPlannerGraph = Objects.requireNonNull(queryPlanRootReference.acceptVisitor(PlannerGraphVisitor.forInternalShow(renderSingleGroups, true)));
        PlannerGraph.InternalPlannerGraphBuilder graphBuilder = queryPlannerGraph.derived();
        Map matchCandidateMap = matchCandidates.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), matchCandidate -> Objects.requireNonNull(matchCandidate.getTraversal().getRootReference().acceptVisitor(PlannerGraphVisitor.forInternalShow(renderSingleGroups)))));
        matchCandidateMap.forEach((matchCandidate, matchCandidateGraph) -> graphBuilder.addGraph(matchCandidateGraph));
        Traversal queryGraphTraversal = Traversal.withRoot(queryPlanRootReference);
        Set<Reference> queryGraphRefs = queryGraphTraversal.getRefs();
        queryGraphRefs.forEach(queryGraphRef -> {
            for (MatchCandidate matchCandidate : Sets.intersection(matchCandidates, queryGraphRef.getMatchCandidates())) {
                Set<PartialMatch> partialMatchesForCandidate = queryGraphRef.getPartialMatchesForCandidate(matchCandidate);
                PlannerGraph matchCandidatePlannerGraph = Objects.requireNonNull((PlannerGraph)matchCandidateMap.get(matchCandidate));
                PlannerGraph.Node queryRefNode = Objects.requireNonNull((PlannerGraph.Node)queryPlannerGraph.getNodeForIdentity(queryGraphRef));
                for (PartialMatch partialMatchForCandidate : partialMatchesForCandidate) {
                    PlannerGraph.Node matchCandidateNode = (PlannerGraph.Node)matchCandidatePlannerGraph.getNodeForIdentity(partialMatchForCandidate.getCandidateRef());
                    if (matchCandidateNode == null) continue;
                    graphBuilder.addEdge(queryRefNode, matchCandidateNode, new PlannerGraph.PartialMatchEdge());
                }
            }
        });
        String dotString = PlannerGraphVisitor.exportToDot(graphBuilder.build(), queryPlannerGraph.getNetwork().nodes(), nestedClusterProvider -> matchCandidateMap.entrySet().stream().map(entry -> new NamedCluster(((MatchCandidate)entry.getKey()).getName(), ((PlannerGraph)entry.getValue()).getNetwork().nodes(), (GraphExporter.ClusterProvider<PlannerGraph.Node, PlannerGraph.Edge>)nestedClusterProvider)).collect(Collectors.toList()));
        return PlannerGraphVisitor.show(dotString);
    }

    @Nonnull
    private static String show(String dotString) {
        return BrowserHelper.browse("/showPlannerExpression.html", ImmutableMap.of("$DOT", dotString));
    }

    @Nonnull
    public static String exportToDot(@Nonnull AbstractPlannerGraph<PlannerGraph.Node, PlannerGraph.Edge> plannerGraph) {
        ImmutableNetwork<PlannerGraph.Node, PlannerGraph.Edge> network = plannerGraph.getNetwork();
        return PlannerGraphVisitor.exportToDot(plannerGraph, network.nodes(), clusterProvider -> ImmutableList.of());
    }

    @Nonnull
    public static String exportToDot(@Nonnull AbstractPlannerGraph<PlannerGraph.Node, PlannerGraph.Edge> plannerGraph, @Nonnull Set<PlannerGraph.Node> queryPlannerNodes, @Nonnull Function<GraphExporter.ClusterProvider<PlannerGraph.Node, PlannerGraph.Edge>, Collection<GraphExporter.Cluster<PlannerGraph.Node, PlannerGraph.Edge>>> clusteringFunction) {
        DotExporter exporter = new DotExporter(new CountingIdProvider(), PlannerGraph.Node::getAttributes, PlannerGraph.Edge::getAttributes, ImmutableMap.of("fontname", Attribute.dot("courier"), "rankdir", Attribute.dot("BT"), "splines", Attribute.dot("polyline")), (network, nodes) -> {
            ImmutableList.Builder clusterBuilder = ImmutableList.builder();
            clusterBuilder.addAll(PlannerGraphVisitor.clustersForGroups(plannerGraph.getNetwork(), queryPlannerNodes));
            clusterBuilder.addAll((Iterable)clusteringFunction.apply(PlannerGraphVisitor::clustersForGroups));
            return clusterBuilder.build();
        });
        StringWriter writer = new StringWriter();
        exporter.exportGraph(plannerGraph.getNetwork(), writer);
        return ((Object)writer).toString();
    }

    private static Collection<GraphExporter.Cluster<PlannerGraph.Node, PlannerGraph.Edge>> clustersForGroups(Network<PlannerGraph.Node, PlannerGraph.Edge> network, Set<PlannerGraph.Node> nodes) {
        Map clusterMap = nodes.stream().filter(node -> node instanceof PlannerGraph.ReferenceHeadNode || node instanceof PlannerGraph.ReferenceMemberNode).collect(Collectors.groupingBy(node -> {
            if (node instanceof PlannerGraph.ReferenceHeadNode) {
                return (PlannerGraph.ReferenceHeadNode)node;
            }
            if (node instanceof PlannerGraph.ReferenceMemberNode) {
                PlannerGraph.Node head = (PlannerGraph.Node)network.incidentNodes((PlannerGraph.Edge)Iterables.getOnlyElement(network.outEdges((PlannerGraph.Node)node))).nodeV();
                Verify.verify(head instanceof PlannerGraph.ReferenceHeadNode);
                return (PlannerGraph.ReferenceHeadNode)head;
            }
            throw new IllegalArgumentException("impossible case");
        }, Collectors.toSet()));
        return clusterMap.entrySet().stream().map(entry -> {
            String label = Debugger.mapDebugger(debugger -> debugger.nameForObject(((PlannerGraph.ReferenceHeadNode)entry.getKey()).getIdentity())).orElse("group");
            return new GroupCluster(label, (Set)entry.getValue());
        }).collect(Collectors.toList());
    }

    @Nonnull
    public static String explain(@Nonnull RelationalExpression relationalExpression) {
        return PlannerGraphVisitor.explain(relationalExpression, ImmutableMap.of());
    }

    @Nonnull
    public static String explain(@Nonnull RelationalExpression relationalExpression, @Nonnull Map<String, Attribute> additionalDescriptionMap) {
        try {
            PlannerGraph plannerGraph = Objects.requireNonNull(relationalExpression.acceptVisitor(PlannerGraphVisitor.forExplain()));
            return PlannerGraphVisitor.exportToGml(plannerGraph, additionalDescriptionMap);
        }
        catch (Exception ex) {
            Throwables.throwIfUnchecked(ex);
            throw new RuntimeException(ex);
        }
    }

    @Nonnull
    public static String exportToGml(@Nonnull PlannerGraph plannerGraph, @Nonnull Map<String, Attribute> additionalInfoMap) {
        ImmutableSet usedInfoIds = plannerGraph.getNetwork().nodes().stream().filter(n -> n instanceof PlannerGraph.WithInfoId).map(n -> (PlannerGraph.WithInfoId)((Object)n)).map(PlannerGraph.WithInfoId::getInfoId).collect(ImmutableSet.toImmutableSet());
        ImmutableMap.Builder<String, Attribute> infoMapBuilder = ImmutableMap.builder();
        infoMapBuilder.putAll(Maps.filterEntries(NodeInfo.getInfoAttributeMap(NodeInfo.getNodeInfos()), e -> usedInfoIds.contains(Objects.requireNonNull(e).getKey())));
        infoMapBuilder.putAll(Maps.filterEntries(additionalInfoMap, e -> usedInfoIds.contains(Objects.requireNonNull(e).getKey())));
        ImmutableMap<String, Attribute> infoMap = infoMapBuilder.build();
        GraphExporter<PlannerGraph.Node, PlannerGraph.Edge> exporter = PlannerGraphVisitor.createGmlExporter(infoMap);
        StringWriter writer = new StringWriter();
        exporter.exportGraph(plannerGraph.getNetwork(), writer);
        return ((Object)writer).toString();
    }

    @Nonnull
    private static GraphExporter<PlannerGraph.Node, PlannerGraph.Edge> createGmlExporter(@Nonnull Map<String, Attribute> infoMap) {
        return new GmlExporter<PlannerGraph.Node, PlannerGraph.Edge>(new CountingIdProvider(), PlannerGraph.Node::getAttributes, new CountingIdProvider(), PlannerGraph.Edge::getAttributes, ImmutableMap.of("infos", Attribute.gml(infoMap)));
    }

    public static PlannerGraphVisitor forExplain() {
        return new PlannerGraphVisitor(1);
    }

    public static PlannerGraphVisitor forInternalShow(boolean renderSingleGroups) {
        return PlannerGraphVisitor.forInternalShow(renderSingleGroups, false);
    }

    public static PlannerGraphVisitor forInternalShow(boolean renderSingleGroups, boolean removePlans) {
        return new PlannerGraphVisitor((renderSingleGroups ? 2 : 0) | (removePlans ? 4 : 0));
    }

    private PlannerGraphVisitor(int flags) {
        Preconditions.checkArgument(PlannerGraphVisitor.validateFlags(flags));
        this.flags = flags;
    }

    public boolean isForExplain() {
        return (this.flags & 1) != 0;
    }

    public boolean renderSingleGroups() {
        return (this.flags & 2) != 0;
    }

    public boolean removeFinalExpressionsIfPossible() {
        return (this.flags & 4) != 0;
    }

    public boolean removeExploratoryExpressions() {
        return (this.flags & 8) != 0;
    }

    @Override
    @Nonnull
    public PlannerGraph evaluateAtExpression(@Nonnull RelationalExpression expression, @Nonnull List<PlannerGraph> childGraphs) {
        if (expression instanceof PlannerGraphRewritable) {
            return ((PlannerGraphRewritable)((Object)expression)).rewritePlannerGraph(childGraphs);
        }
        if (this.isForExplain() && expression instanceof ExplainPlannerGraphRewritable) {
            return ((ExplainPlannerGraphRewritable)((Object)expression)).rewriteExplainPlannerGraph(childGraphs);
        }
        if (!this.isForExplain() && expression instanceof InternalPlannerGraphRewritable) {
            return ((InternalPlannerGraphRewritable)((Object)expression)).rewriteInternalPlannerGraph(childGraphs);
        }
        return PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.LogicalOperatorNode(expression, expression.getClass().getSimpleName(), ImmutableList.of(), ImmutableMap.of()), childGraphs);
    }

    @Override
    @Nonnull
    public PlannerGraph evaluateAtRef(@Nonnull Reference ref, @Nonnull List<PlannerGraph> memberResults) {
        List filteredMemberResults;
        if (memberResults.isEmpty()) {
            return PlannerGraph.builder(new PlannerGraph.ReferenceHeadNode(ref)).build();
        }
        if (this.removeFinalExpressionsIfPossible()) {
            filteredMemberResults = memberResults.stream().filter(graph -> graph.getRoot() instanceof PlannerGraph.WithExpression).filter(graph -> {
                RelationalExpression expression = ((PlannerGraph.WithExpression)graph.getRoot()).getExpression();
                return expression != null && ref.isExploratory(expression);
            }).collect(Collectors.toList());
            if (!filteredMemberResults.isEmpty()) {
                memberResults = filteredMemberResults;
            }
        } else if (this.removeExploratoryExpressions() && !(filteredMemberResults = memberResults.stream().filter(graph -> graph.getRoot() instanceof PlannerGraph.WithExpression).filter(graph -> {
            RelationalExpression expression = ((PlannerGraph.WithExpression)graph.getRoot()).getExpression();
            return expression != null && ref.isFinal(expression);
        }).collect(Collectors.toList())).isEmpty()) {
            memberResults = filteredMemberResults;
        }
        if (this.renderSingleGroups() || memberResults.size() > 1) {
            PlannerGraph.ReferenceHeadNode head = new PlannerGraph.ReferenceHeadNode(ref);
            PlannerGraph.InternalPlannerGraphBuilder plannerGraphBuilder = PlannerGraph.builder(head);
            List<PlannerGraph> memberGraphs = memberResults.stream().map(childGraph -> {
                PlannerGraph.Node root = (PlannerGraph.Node)childGraph.getRoot();
                Optional<String> debugNameOptional = Debugger.mapDebugger(debugger -> {
                    if (root instanceof PlannerGraph.WithExpression) {
                        PlannerGraph.WithExpression withExpression = (PlannerGraph.WithExpression)((Object)root);
                        RelationalExpression expression = withExpression.getExpression();
                        return expression == null ? null : debugger.nameForObject(expression);
                    }
                    return null;
                });
                PlannerGraph.Node member = debugNameOptional.map(PlannerGraph.ReferenceMemberNode::new).orElse(new PlannerGraph.ReferenceMemberNode());
                return (PlannerGraph)PlannerGraph.builder(member).addGraph(childGraph).addEdge(root, member, new PlannerGraph.ReferenceEdge()).build();
            }).collect(Collectors.toList());
            memberGraphs.forEach(memberGraph -> {
                plannerGraphBuilder.addGraph(memberGraph);
                plannerGraphBuilder.addEdge((PlannerGraph.Node)memberGraph.getRoot(), head, new PlannerGraph.ReferenceInternalEdge());
            });
            return plannerGraphBuilder.build();
        }
        return Iterables.getOnlyElement(memberResults);
    }

    private static class CountingIdProvider<T>
    implements GraphExporter.ComponentIdProvider<T> {
        int counter = 0;

        private CountingIdProvider() {
        }

        @Override
        public String apply(@Nonnull T t2) {
            ++this.counter;
            return String.valueOf(this.counter);
        }
    }

    private static class GroupCluster
    extends GraphExporter.Cluster<PlannerGraph.Node, PlannerGraph.Edge> {
        public GroupCluster(@Nonnull String label, @Nonnull Set<PlannerGraph.Node> nodes) {
            super(nodes, node -> ImmutableMap.builder().put("style", Attribute.dot("filled")).put("fillcolor", Attribute.dot("lightgrey")).put("fontsize", Attribute.dot("6")).put("rank", Attribute.dot("same")).put("label", Attribute.dot(label)).build(), (network, nestedNodes) -> ImmutableList.of());
        }
    }

    public static class NamedCluster
    extends GraphExporter.Cluster<PlannerGraph.Node, PlannerGraph.Edge> {
        public NamedCluster(@Nonnull String label, @Nonnull Set<PlannerGraph.Node> nodes, @Nonnull GraphExporter.ClusterProvider<PlannerGraph.Node, PlannerGraph.Edge> nestedClusterProvider) {
            super(nodes, node -> ImmutableMap.builder().put("style", Attribute.dot("filled")).put("fillcolor", Attribute.dot("gray95")).put("pencolor", Attribute.dot("gray95")).put("rank", Attribute.dot("same")).put("label", Attribute.dot(label)).build(), nestedClusterProvider);
        }
    }
}

