/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifiers;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpressionWithChildren;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public abstract class AbstractRelationalExpressionWithChildren
extends AbstractRelationalExpression
implements RelationalExpressionWithChildren {
    @Nonnull
    private final Supplier<Set<CorrelationIdentifier>> correlatedToSupplier = Suppliers.memoize(this::computeCorrelatedTo);

    protected AbstractRelationalExpressionWithChildren() {
    }

    @Override
    @Nonnull
    public final Set<CorrelationIdentifier> getCorrelatedTo() {
        return this.correlatedToSupplier.get();
    }

    @Nonnull
    protected Set<CorrelationIdentifier> computeCorrelatedTo() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        List<? extends Quantifier> quantifiers = this.getQuantifiers();
        Map<CorrelationIdentifier, Quantifier> aliasToQuantifierMap = Quantifiers.aliasToQuantifierMap(quantifiers);
        this.getCorrelatedToWithoutChildren().stream().filter(correlationIdentifier -> !aliasToQuantifierMap.containsKey(correlationIdentifier)).forEach(builder::add);
        for (Quantifier quantifier : quantifiers) {
            quantifier.getCorrelatedTo().stream().filter(correlationIdentifier -> !this.canCorrelate() || !aliasToQuantifierMap.containsKey(correlationIdentifier)).forEach(builder::add);
        }
        return builder.build();
    }
}

