/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.ComparisonRange;
import com.apple.foundationdb.record.query.plan.cascades.Compensation;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.IdentityBiMap;
import com.apple.foundationdb.record.query.plan.cascades.MatchInfo;
import com.apple.foundationdb.record.query.plan.cascades.PartialMatch;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.explain.InternalPlannerGraphRewritable;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithoutChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.FieldValue;
import com.apple.foundationdb.record.query.plan.cascades.values.QueriedValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.PullUp;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class ExplodeExpression
extends AbstractRelationalExpressionWithoutChildren
implements InternalPlannerGraphRewritable {
    @Nonnull
    private final Value collectionValue;

    public ExplodeExpression(@Nonnull Value collectionValue) {
        this.collectionValue = collectionValue;
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        Verify.verify(this.collectionValue.getResultType().isArray());
        return new QueriedValue(Objects.requireNonNull(((Type.Array)this.collectionValue.getResultType()).getElementType()));
    }

    @Override
    @Nonnull
    public Set<Type> getDynamicTypes() {
        return this.collectionValue.getDynamicTypes();
    }

    @Nonnull
    public Value getCollectionValue() {
        return this.collectionValue;
    }

    @Override
    @Nonnull
    public List<? extends Quantifier> getQuantifiers() {
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return this.collectionValue.getCorrelatedTo();
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap equivalencesMap) {
        if (this == otherExpression) {
            return true;
        }
        if (!(otherExpression instanceof ExplodeExpression)) {
            return false;
        }
        ExplodeExpression otherExplodeExpression = (ExplodeExpression)otherExpression;
        return this.collectionValue.semanticEquals((Object)otherExplodeExpression.getCollectionValue(), equivalencesMap) && this.semanticEqualsForResults(otherExpression, equivalencesMap);
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(this.collectionValue);
    }

    @Override
    @Nonnull
    public ExplodeExpression translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        Verify.verify(translatedQuantifiers.isEmpty());
        Value translatedCollectionValue = this.collectionValue.translateCorrelations(translationMap, shouldSimplifyValues);
        if (translatedCollectionValue != this.collectionValue) {
            return new ExplodeExpression(translatedCollectionValue);
        }
        return this;
    }

    @Override
    @Nonnull
    public Iterable<MatchInfo> subsumedBy(@Nonnull RelationalExpression candidateExpression, @Nonnull AliasMap bindingAliasMap, @Nonnull IdentityBiMap<Quantifier, PartialMatch> partialMatchMap, @Nonnull EvaluationContext evaluationContext) {
        if (!this.isCompatiblyAndCompletelyBound(bindingAliasMap, candidateExpression.getQuantifiers())) {
            return ImmutableList.of();
        }
        return this.exactlySubsumedBy(candidateExpression, bindingAliasMap, partialMatchMap, TranslationMap.empty());
    }

    @Override
    @Nonnull
    public Compensation compensate(@Nonnull PartialMatch partialMatch, @Nonnull Map<CorrelationIdentifier, ComparisonRange> boundParameterPrefixMap, @Nullable PullUp pullUp, @Nonnull CorrelationIdentifier candidateAlias) {
        return Compensation.noCompensation();
    }

    @Override
    @Nonnull
    public PlannerGraph rewriteInternalPlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        return PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.LogicalOperatorNode(this, "Explode", ImmutableList.of(this.toString()), ImmutableMap.of()), childGraphs);
    }

    public String toString() {
        return this.collectionValue.toString();
    }

    public static ExplodeExpression explodeField(@Nonnull Quantifier.ForEach baseQuantifier, @Nonnull List<String> fieldNames) {
        return new ExplodeExpression(FieldValue.ofFieldNames(baseQuantifier.getFlowedObjectValue(), fieldNames));
    }
}

