/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.query.plan.cascades.AccessHints;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.ComparisonRange;
import com.apple.foundationdb.record.query.plan.cascades.Compensation;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.IdentityBiMap;
import com.apple.foundationdb.record.query.plan.cascades.MatchInfo;
import com.apple.foundationdb.record.query.plan.cascades.PartialMatch;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraphRewritable;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithoutChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.QueriedValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.PullUp;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class FullUnorderedScanExpression
extends AbstractRelationalExpressionWithoutChildren
implements PlannerGraphRewritable {
    @Nonnull
    private final Set<String> recordTypes;
    @Nonnull
    private final Type flowedType;
    @Nonnull
    final AccessHints accessHints;

    public FullUnorderedScanExpression(@Nonnull Set<String> recordTypes, @Nonnull Type flowedType, @Nonnull AccessHints accessHints) {
        this.recordTypes = ImmutableSet.copyOf(recordTypes);
        this.flowedType = flowedType;
        this.accessHints = accessHints;
    }

    @Nonnull
    public Set<String> getRecordTypes() {
        return this.recordTypes;
    }

    @Nonnull
    public AccessHints getAccessHints() {
        return this.accessHints;
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return new QueriedValue(this.flowedType);
    }

    @Override
    @Nonnull
    public List<? extends Quantifier> getQuantifiers() {
        return ImmutableList.of();
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return ImmutableSet.of();
    }

    @Override
    @Nonnull
    public FullUnorderedScanExpression translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        Verify.verify(translatedQuantifiers.isEmpty());
        return this;
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap equivalencesMap) {
        if (this == otherExpression) {
            return true;
        }
        if (this.getClass() != otherExpression.getClass()) {
            return false;
        }
        if (!this.recordTypes.equals(((FullUnorderedScanExpression)otherExpression).getRecordTypes())) {
            return false;
        }
        return this.flowedType.equals(otherExpression.getResultValue().getResultType());
    }

    public boolean equals(Object other) {
        return this.semanticEquals(other);
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(this.recordTypes, this.flowedType);
    }

    public String toString() {
        return "FullUnorderedScan";
    }

    @Override
    @Nonnull
    public Iterable<MatchInfo> subsumedBy(@Nonnull RelationalExpression candidateExpression, @Nonnull AliasMap bindingAliasMap, @Nonnull IdentityBiMap<Quantifier, PartialMatch> partialMatchMap, @Nonnull EvaluationContext evaluationContext) {
        if (this.getClass() != candidateExpression.getClass()) {
            return ImmutableList.of();
        }
        if (!bindingAliasMap.isEmpty()) {
            return ImmutableList.of();
        }
        if (this.getAccessHints().satisfies(((FullUnorderedScanExpression)candidateExpression).getAccessHints())) {
            return this.exactlySubsumedBy(candidateExpression, bindingAliasMap, partialMatchMap, TranslationMap.empty());
        }
        return ImmutableList.of();
    }

    @Override
    @Nonnull
    public Compensation compensate(@Nonnull PartialMatch partialMatch, @Nonnull Map<CorrelationIdentifier, ComparisonRange> boundParameterPrefixMap, @Nullable PullUp pullUp, @Nonnull CorrelationIdentifier candidateAlias) {
        return Compensation.noCompensation();
    }

    @Override
    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        Verify.verify(childGraphs.isEmpty());
        PlannerGraph.DataNodeWithInfo dataNodeWithInfo = new PlannerGraph.DataNodeWithInfo(NodeInfo.BASE_DATA, this.getResultType(), ImmutableList.of("record types: {{types}}"), ImmutableMap.of("types", Attribute.gml(this.getRecordTypes().stream().map(Attribute::gml).collect(ImmutableList.toImmutableList()))));
        return PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.LogicalOperatorNodeWithInfo(this, NodeInfo.SCAN_OPERATOR, ImmutableList.of(), ImmutableMap.of()), ImmutableList.of(PlannerGraph.fromNodeAndChildGraphs(dataNodeWithInfo, childGraphs)));
    }
}

