/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.PlanSerializationContext;
import com.apple.foundationdb.record.planprotos.PValue;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.QueryPlanConstraint;
import com.apple.foundationdb.record.query.plan.cascades.AggregateIndexExpansionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.Column;
import com.apple.foundationdb.record.query.plan.cascades.ComparisonRange;
import com.apple.foundationdb.record.query.plan.cascades.Compensation;
import com.apple.foundationdb.record.query.plan.cascades.ConstrainedBoolean;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.GroupByMappings;
import com.apple.foundationdb.record.query.plan.cascades.IdentityBiMap;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentityMap;
import com.apple.foundationdb.record.query.plan.cascades.MatchInfo;
import com.apple.foundationdb.record.query.plan.cascades.OrderingPart;
import com.apple.foundationdb.record.query.plan.cascades.PartialMatch;
import com.apple.foundationdb.record.query.plan.cascades.PredicateMap;
import com.apple.foundationdb.record.query.plan.cascades.PredicateMultiMap;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifiers;
import com.apple.foundationdb.record.query.plan.cascades.RequestedOrdering;
import com.apple.foundationdb.record.query.plan.cascades.ValueEquivalence;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.cascades.explain.InternalPlannerGraphRewritable;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.predicates.PredicateWithComparisons;
import com.apple.foundationdb.record.query.plan.cascades.predicates.PredicateWithValue;
import com.apple.foundationdb.record.query.plan.cascades.predicates.PredicateWithValueAndRanges;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.RangeConstraints;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.AbstractValue;
import com.apple.foundationdb.record.query.plan.cascades.values.AggregateValue;
import com.apple.foundationdb.record.query.plan.cascades.values.FieldValue;
import com.apple.foundationdb.record.query.plan.cascades.values.IndexableAggregateValue;
import com.apple.foundationdb.record.query.plan.cascades.values.RecordConstructorValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.Values;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.MaxMatchMap;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.PullUp;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokens;
import com.apple.foundationdb.record.query.plan.explain.ExplainTokensWithPrecedence;
import com.apple.foundationdb.record.util.pair.Pair;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.protobuf.Message;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class GroupByExpression
extends AbstractRelationalExpressionWithChildren
implements InternalPlannerGraphRewritable {
    @Nullable
    private final Value groupingValue;
    @Nonnull
    private final AggregateValue aggregateValue;
    @Nonnull
    private final BiFunction<Value, Value, Value> resultValueFunction;
    @Nonnull
    private final Supplier<Value> computeResultSupplier;
    @Nonnull
    private final Supplier<RequestedOrdering> computeRequestedOrderingSupplier;
    @Nonnull
    private final Quantifier innerQuantifier;

    public GroupByExpression(@Nullable Value groupingValue, @Nonnull AggregateValue aggregateValue, @Nonnull BiFunction<Value, Value, Value> resultValueFunction, @Nonnull Quantifier innerQuantifier) {
        this.groupingValue = groupingValue;
        this.aggregateValue = aggregateValue;
        this.resultValueFunction = resultValueFunction;
        this.computeResultSupplier = Suppliers.memoize(() -> (Value)resultValueFunction.apply(groupingValue, aggregateValue));
        this.computeRequestedOrderingSupplier = Suppliers.memoize(this::computeRequestedOrdering);
        this.innerQuantifier = innerQuantifier;
    }

    @Override
    public int getRelationalChildCount() {
        return 1;
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return this.getResultValue().getCorrelatedTo();
    }

    @Nonnull
    public BiFunction<Value, Value, Value> getResultValueFunction() {
        return this.resultValueFunction;
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return this.computeResultSupplier.get();
    }

    @Override
    @Nonnull
    public List<? extends Quantifier> getQuantifiers() {
        return ImmutableList.of(this.innerQuantifier);
    }

    @Nonnull
    public Quantifier getInnerQuantifier() {
        return this.innerQuantifier;
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression other, @Nonnull AliasMap equivalences) {
        if (this == other) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        GroupByExpression otherGroupByExpr = (GroupByExpression)other;
        if (otherGroupByExpr.getGroupingValue() == null ^ this.getGroupingValue() == null) {
            return false;
        }
        if (otherGroupByExpr.getGroupingValue() != null) {
            return Objects.requireNonNull(this.getGroupingValue()).semanticEquals((Object)otherGroupByExpr.getGroupingValue(), equivalences) && this.getAggregateValue().semanticEquals((Object)otherGroupByExpr.getAggregateValue(), equivalences);
        }
        return this.getAggregateValue().semanticEquals((Object)otherGroupByExpr.getAggregateValue(), equivalences);
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(this.getResultValue());
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    public boolean equals(Object other) {
        return this.semanticEquals(other);
    }

    @Override
    @Nonnull
    public RelationalExpression translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        Verify.verify(translatedQuantifiers.size() == 1);
        AggregateValue translatedAggregateValue = (AggregateValue)this.getAggregateValue().translateCorrelations(translationMap, shouldSimplifyValues);
        Value translatedGroupingValue = this.getGroupingValue() == null ? null : this.getGroupingValue().translateCorrelations(translationMap, shouldSimplifyValues);
        return new GroupByExpression(translatedGroupingValue, translatedAggregateValue, this.resultValueFunction, Iterables.getOnlyElement(translatedQuantifiers));
    }

    public String toString() {
        if (this.getGroupingValue() != null) {
            return "GroupBy(" + String.valueOf(this.getGroupingValue()) + "), aggregationValue: " + String.valueOf(this.getAggregateValue()) + ", resultValue: " + String.valueOf(this.computeResultSupplier.get());
        }
        return "GroupBy(NULL), aggregationValue: " + String.valueOf(this.getAggregateValue()) + ", resultValue: " + String.valueOf(this.computeResultSupplier.get());
    }

    @Override
    @Nonnull
    public PlannerGraph rewriteInternalPlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        if (this.getGroupingValue() == null) {
            return PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.LogicalOperatorNode(this, "GROUP BY", List.of("AGG {{agg}}"), ImmutableMap.of("agg", Attribute.gml(this.getAggregateValue().toString()))), childGraphs);
        }
        return PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.LogicalOperatorNode(this, "GROUP BY", List.of("AGG {{agg}}", "GROUP BY {{grouping}}"), ImmutableMap.of("agg", Attribute.gml(this.getAggregateValue().toString()), "grouping", Attribute.gml(this.getGroupingValue().toString()))), childGraphs);
    }

    @Nullable
    public Value getGroupingValue() {
        return this.groupingValue;
    }

    @Nonnull
    public AggregateValue getAggregateValue() {
        return this.aggregateValue;
    }

    @Nonnull
    public RequestedOrdering getRequestedOrdering() {
        return this.computeRequestedOrderingSupplier.get();
    }

    @Override
    @Nonnull
    public Iterable<MatchInfo> subsumedBy(@Nonnull RelationalExpression candidateExpression, @Nonnull AliasMap bindingAliasMap, @Nonnull IdentityBiMap<Quantifier, PartialMatch> partialMatchMap, @Nonnull EvaluationContext evaluationContext) {
        if (candidateExpression.getClass() != this.getClass()) {
            return ImmutableList.of();
        }
        GroupByExpression candidateGroupByExpression = (GroupByExpression)candidateExpression;
        Quantifier candidateInnerQuantifier = candidateGroupByExpression.getInnerQuantifier();
        if (!(this.innerQuantifier instanceof Quantifier.ForEach)) {
            return ImmutableList.of();
        }
        CorrelationIdentifier candidateAlias = bindingAliasMap.getTarget(this.innerQuantifier.getAlias());
        if (candidateAlias == null) {
            return ImmutableList.of();
        }
        Verify.verify(candidateAlias.equals(candidateInnerQuantifier.getAlias()));
        if (!(candidateInnerQuantifier instanceof Quantifier.ForEach)) {
            return ImmutableList.of();
        }
        if (((Quantifier.ForEach)this.innerQuantifier).isNullOnEmpty() != ((Quantifier.ForEach)candidateInnerQuantifier).isNullOnEmpty()) {
            return ImmutableList.of();
        }
        Optional<TranslationMap> translationMapOptional = RelationalExpression.pullUpAndComposeTranslationMapsMaybe(candidateExpression, bindingAliasMap, partialMatchMap);
        if (translationMapOptional.isEmpty()) {
            return ImmutableList.of();
        }
        TranslationMap translationMap = translationMapOptional.get();
        AggregateValue otherAggregateValue = candidateGroupByExpression.getAggregateValue();
        Value candidateGroupingValue = candidateGroupByExpression.getGroupingValue();
        ValueEquivalence valueEquivalence = ValueEquivalence.fromAliasMap(bindingAliasMap).then(ValueEquivalence.constantEquivalenceWithEvaluationContext(evaluationContext));
        ImmutableSet aggregateValues = Values.primitiveAccessorsForType(this.aggregateValue.getResultType(), () -> this.aggregateValue).stream().map(primitiveAggregateValue -> primitiveAggregateValue.simplify(evaluationContext, AliasMap.emptyMap(), ImmutableSet.of())).collect(ImmutableSet.toImmutableSet());
        if (aggregateValues.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableSet otherAggregateValues = Values.primitiveAccessorsForType(otherAggregateValue.getResultType(), () -> otherAggregateValue).stream().map(primitiveAggregateValue -> primitiveAggregateValue.simplify(evaluationContext, AliasMap.emptyMap(), ImmutableSet.of())).collect(ImmutableSet.toImmutableSet());
        if (otherAggregateValues.size() != 1) {
            return ImmutableList.of();
        }
        IndexableAggregateValue otherPrimitiveAggregateValue = (IndexableAggregateValue)Iterables.getOnlyElement(otherAggregateValues);
        ImmutableBiMap.Builder matchedAggregatesMapBuilder = ImmutableBiMap.builder();
        ImmutableBiMap.Builder unmatchedAggregatesMapBuilder = ImmutableBiMap.builder();
        ImmutableMap.Builder<Value, CorrelationIdentifier> unmatchedTranslatedAggregatesValueMapBuilder = ImmutableMap.builder();
        ConstrainedBoolean subsumedAggregations = ConstrainedBoolean.falseValue();
        for (Value primitiveAggregateValue2 : aggregateValues) {
            Value translatedPrimitiveAggregateValue = primitiveAggregateValue2.translateCorrelations(translationMap, true);
            ConstrainedBoolean semanticEquals = translatedPrimitiveAggregateValue.semanticEquals((Object)otherPrimitiveAggregateValue, valueEquivalence);
            if (semanticEquals.isTrue()) {
                matchedAggregatesMapBuilder.put(primitiveAggregateValue2, otherPrimitiveAggregateValue);
                subsumedAggregations = semanticEquals;
                continue;
            }
            CorrelationIdentifier unmatchedId = UnmatchedAggregateValue.uniqueId();
            unmatchedAggregatesMapBuilder.put(unmatchedId, primitiveAggregateValue2);
            unmatchedTranslatedAggregatesValueMapBuilder.put(translatedPrimitiveAggregateValue, unmatchedId);
        }
        if (subsumedAggregations.isFalse()) {
            return ImmutableList.of();
        }
        SubsumedGroupingsResult subsumedGroupingsResult = this.groupingSubsumedBy(candidateInnerQuantifier, Objects.requireNonNull(partialMatchMap.getUnwrapped(this.innerQuantifier)), candidateGroupingValue, translationMap, valueEquivalence, evaluationContext);
        ConstrainedBoolean subsumedGroupings = Objects.requireNonNull(subsumedGroupingsResult.getSubsumedGroups());
        if (subsumedGroupings.isFalse()) {
            return ImmutableList.of();
        }
        BiMap<Value, Value> matchedGroupingsMap = subsumedGroupingsResult.getMatchedGroupingsMap();
        List<Value> rollUpToGroupingValues = subsumedGroupingsResult.getRollUpToValues();
        if (rollUpToGroupingValues != null && !AggregateIndexExpansionVisitor.canBeRolledUp(otherPrimitiveAggregateValue.getIndexTypeName())) {
            return ImmutableList.of();
        }
        ImmutableMap unmatchedTranslatedAggregateValueMap = unmatchedTranslatedAggregatesValueMapBuilder.buildKeepingLast();
        Value translatedResultValue = this.getResultValue().translateCorrelations(translationMap, true);
        MaxMatchMap maxMatchMap = MaxMatchMap.compute(translatedResultValue, candidateExpression.getResultValue(), Quantifiers.aliases(candidateExpression.getQuantifiers()), valueEquivalence, translatedUnmatchedValue -> this.onUnmatchedValue(unmatchedTranslatedAggregateValueMap, (Value)translatedUnmatchedValue));
        QueryPlanConstraint queryPlanConstraint = subsumedGroupings.getConstraint().compose(maxMatchMap.getQueryPlanConstraint());
        return MatchInfo.RegularMatchInfo.tryMerge(bindingAliasMap, partialMatchMap, ImmutableMap.of(), PredicateMap.empty(), maxMatchMap, GroupByMappings.of(matchedGroupingsMap, (BiMap<Value, Value>)((Object)matchedAggregatesMapBuilder.build()), (BiMap<CorrelationIdentifier, Value>)((Object)unmatchedAggregatesMapBuilder.build())), rollUpToGroupingValues, queryPlanConstraint).map(ImmutableList::of).orElse(ImmutableList.of());
    }

    @Nonnull
    private Optional<Value> onUnmatchedValue(@Nonnull Map<Value, CorrelationIdentifier> unmatchedTranslatedAggregateValueMap, @Nonnull Value translatedUnmatchedValue) {
        CorrelationIdentifier unmatchedId = unmatchedTranslatedAggregateValueMap.get(translatedUnmatchedValue);
        if (unmatchedId == null) {
            return Optional.empty();
        }
        return Optional.of(new UnmatchedAggregateValue(unmatchedId));
    }

    @Nonnull
    private SubsumedGroupingsResult groupingSubsumedBy(@Nonnull Quantifier candidateInnerQuantifier, @Nonnull PartialMatch childMatch, @Nullable Value candidateGroupingValue, @Nonnull TranslationMap translationMap, @Nonnull ValueEquivalence valueEquivalence, @Nonnull EvaluationContext evaluationContext) {
        ImmutableBiMap<Value, Value> matchedGroupingsMap;
        ImmutableList<Value> translatedGroupingValues;
        if (this.groupingValue == null && candidateGroupingValue == null) {
            return SubsumedGroupingsResult.withoutRollUp(ConstrainedBoolean.alwaysTrue(), ImmutableBiMap.of());
        }
        if (candidateGroupingValue == null) {
            return SubsumedGroupingsResult.noSubsumption();
        }
        if (this.groupingValue != null) {
            ImmutableList.Builder translatedGroupingsValuesBuilder = ImmutableList.builder();
            ImmutableMap.Builder<Object, Value> matchedGroupingsMapBuilder = ImmutableMap.builder();
            ImmutableList groupingValues = Values.primitiveAccessorsForType(this.groupingValue.getResultType(), () -> this.groupingValue).stream().map(primitiveGroupingValue -> primitiveGroupingValue.simplify(evaluationContext, AliasMap.emptyMap(), ImmutableSet.of())).collect(ImmutableList.toImmutableList());
            for (Object primitiveGroupingValue2 : groupingValues) {
                Value translatedPrimitiveGroupingValue = primitiveGroupingValue2.translateCorrelations(translationMap, true);
                translatedGroupingsValuesBuilder.add(translatedPrimitiveGroupingValue);
                matchedGroupingsMapBuilder.put(primitiveGroupingValue2, translatedPrimitiveGroupingValue);
            }
            translatedGroupingValues = translatedGroupingsValuesBuilder.build();
            matchedGroupingsMap = ImmutableBiMap.copyOf(matchedGroupingsMapBuilder.buildKeepingLast());
        } else {
            translatedGroupingValues = ImmutableList.of();
            matchedGroupingsMap = ImmutableBiMap.of();
        }
        ImmutableSet<Value> translatedGroupingValuesSet = ImmutableSet.copyOf(translatedGroupingValues);
        ImmutableList candidateGroupingValues = Values.primitiveAccessorsForType(candidateGroupingValue.getResultType(), () -> candidateGroupingValue).stream().map(primitiveGroupingValue -> primitiveGroupingValue.simplify(evaluationContext, AliasMap.emptyMap(), ImmutableSet.of())).collect(ImmutableList.toImmutableList());
        LinkedHashSet unmatchedCandidateValues = new LinkedHashSet(candidateGroupingValues);
        if (translatedGroupingValuesSet.size() > unmatchedCandidateValues.size()) {
            return SubsumedGroupingsResult.noSubsumption();
        }
        ConstrainedBoolean booleanWithConstraint = ConstrainedBoolean.alwaysTrue();
        for (Value translatedGroupingValue : translatedGroupingValuesSet) {
            boolean found = false;
            Iterator iterator = unmatchedCandidateValues.iterator();
            while (iterator.hasNext()) {
                Value candidateGroupingPartValue = (Value)iterator.next();
                ConstrainedBoolean semanticEquals = translatedGroupingValue.semanticEquals((Object)candidateGroupingPartValue, valueEquivalence);
                if (!semanticEquals.isTrue()) continue;
                found = true;
                booleanWithConstraint = booleanWithConstraint.composeWithOther(semanticEquals);
                iterator.remove();
                if (!unmatchedCandidateValues.isEmpty()) continue;
                break;
            }
            if (!found) {
                return SubsumedGroupingsResult.noSubsumption();
            }
            if (!unmatchedCandidateValues.isEmpty()) continue;
            break;
        }
        if (unmatchedCandidateValues.isEmpty()) {
            return SubsumedGroupingsResult.withoutRollUp(booleanWithConstraint, matchedGroupingsMap);
        }
        Map<QueryPredicate, PredicateMultiMap.PredicateMapping> equalityPredicates = childMatch.pullUpToParent(candidateInnerQuantifier.getAlias(), predicate -> {
            List<Comparisons.Comparison> comparisons;
            if (!(predicate instanceof PredicateWithValue)) {
                return false;
            }
            if (!(predicate instanceof PredicateWithComparisons)) return false;
            if (predicate instanceof PredicateWithValueAndRanges) {
                Set<RangeConstraints> ranges = ((PredicateWithValueAndRanges)predicate).getRanges();
                if (ranges.size() != 1) return false;
                RangeConstraints range = Iterables.getOnlyElement(ranges);
                comparisons = range.getComparisons();
                return comparisons.stream().anyMatch(comparison -> comparison.getType().isEquality());
            } else {
                comparisons = ((PredicateWithComparisons)((Object)predicate)).getComparisons();
            }
            return comparisons.stream().anyMatch(comparison -> comparison.getType().isEquality());
        });
        for (PredicateMultiMap.PredicateMapping predicateMapping : equalityPredicates.values()) {
            QueryPredicate translatedPredicate = predicateMapping.getTranslatedQueryPredicate();
            if (!(translatedPredicate instanceof PredicateWithValue)) continue;
            Value comparedValue = Objects.requireNonNull(((PredicateWithValue)translatedPredicate).getValue());
            Iterator iterator = unmatchedCandidateValues.iterator();
            while (iterator.hasNext()) {
                Value candidateGroupingPartValue = (Value)iterator.next();
                ConstrainedBoolean semanticEquals = comparedValue.semanticEquals((Object)candidateGroupingPartValue, valueEquivalence);
                if (!semanticEquals.isTrue()) continue;
                booleanWithConstraint = booleanWithConstraint.composeWithOther(semanticEquals);
                iterator.remove();
                if (!unmatchedCandidateValues.isEmpty()) continue;
                break;
            }
            if (!unmatchedCandidateValues.isEmpty()) continue;
            break;
        }
        if (!unmatchedCandidateValues.isEmpty()) {
            Verify.verify(candidateGroupingValues.size() > translatedGroupingValuesSet.size());
            for (Value translatedGroupingValue : translatedGroupingValuesSet) {
                if (!unmatchedCandidateValues.contains(translatedGroupingValue)) continue;
                return SubsumedGroupingsResult.noSubsumption();
            }
            return SubsumedGroupingsResult.of(booleanWithConstraint, matchedGroupingsMap, translatedGroupingValues);
        }
        return SubsumedGroupingsResult.withoutRollUp(booleanWithConstraint, matchedGroupingsMap);
    }

    @Nonnull
    private RequestedOrdering computeRequestedOrdering() {
        if (this.groupingValue == null || this.groupingValue.isConstant()) {
            return RequestedOrdering.preserve();
        }
        Type groupingValueType = this.groupingValue.getResultType();
        Verify.verify(groupingValueType.isRecord());
        Value currentGroupingValue = this.groupingValue.rebase(AliasMap.ofAliases(this.innerQuantifier.getAlias(), Quantifier.current()));
        return RequestedOrdering.ofParts(ImmutableList.of(new OrderingPart.RequestedOrderingPart(currentGroupingValue, OrderingPart.RequestedSortOrder.ANY)), RequestedOrdering.Distinctness.PRESERVE_DISTINCTNESS, false, this.innerQuantifier.getCorrelatedTo());
    }

    @Override
    @Nonnull
    public Compensation compensate(@Nonnull PartialMatch partialMatch, @Nonnull Map<CorrelationIdentifier, ComparisonRange> boundParameterPrefixMap, @Nullable PullUp pullUp, @Nonnull CorrelationIdentifier candidateAlias) {
        MatchInfo.RegularMatchInfo regularMatchInfo = partialMatch.getRegularMatchInfo();
        Quantifier quantifier = Iterables.getOnlyElement(this.getQuantifiers());
        Pair<PullUp, PullUp> nestedPullUpPair = partialMatch.nestPullUp(pullUp, candidateAlias);
        PullUp rootOfMatchPullUp = nestedPullUpPair.getKey();
        PullUp adjustedPullUp = Objects.requireNonNull(nestedPullUpPair.getRight());
        Optional<Compensation> childCompensationOptional = regularMatchInfo.getChildPartialMatchMaybe(quantifier).map(childPartialMatch -> {
            AliasMap bindingAliasMap = regularMatchInfo.getBindingAliasMap();
            return childPartialMatch.compensate(boundParameterPrefixMap, adjustedPullUp, Objects.requireNonNull(bindingAliasMap.getTarget(quantifier.getAlias())));
        });
        if (childCompensationOptional.isEmpty()) {
            return Compensation.impossibleCompensation();
        }
        Compensation childCompensation = childCompensationOptional.get();
        if (childCompensation.isImpossible()) {
            return Compensation.impossibleCompensation();
        }
        Optional<Compensation.CompensatedResult> compensatedResultOptional = Compensation.computeResultCompensation(partialMatch, rootOfMatchPullUp);
        if (compensatedResultOptional.isEmpty()) {
            return Compensation.impossibleCompensation();
        }
        Compensation.CompensatedResult compensatedResult = compensatedResultOptional.get();
        if (!childCompensation.isNeeded() && !compensatedResult.getResultCompensationFunction().isNeeded()) {
            return Compensation.noCompensation();
        }
        Set<Quantifier> unmatchedQuantifiers = partialMatch.getUnmatchedQuantifiers();
        Verify.verify(unmatchedQuantifiers.isEmpty());
        return childCompensation.derived(compensatedResult.isCompensationImpossible(), new LinkedIdentityMap<QueryPredicate, PredicateMultiMap.PredicateCompensationFunction>(), this.getMatchedQuantifiers(partialMatch), unmatchedQuantifiers, partialMatch.getCompensatedAliases(), compensatedResult.getResultCompensationFunction(), compensatedResult.getGroupByMappings());
    }

    @Nonnull
    public static Value nestedResults(@Nullable Value groupingValue, @Nonnull Value aggregateValue) {
        Column<Value> aggregateColumn = Column.unnamedOf(aggregateValue);
        if (groupingValue == null) {
            return RecordConstructorValue.ofColumns(ImmutableList.of(aggregateColumn));
        }
        Column<Value> groupingColumn = Column.unnamedOf(groupingValue);
        return RecordConstructorValue.ofColumns(ImmutableList.of(groupingColumn, aggregateColumn));
    }

    @Nonnull
    public static Value flattenedResults(@Nullable Value groupingKeyValue, @Nonnull Value aggregateValue) {
        Type aggregateResultType;
        int i;
        List<Type.Record.Field> fields;
        ImmutableList.Builder valuesBuilder = ImmutableList.builder();
        if (groupingKeyValue != null) {
            Type groupingResultType = groupingKeyValue.getResultType();
            if (groupingResultType.isRecord()) {
                Verify.verify(groupingResultType instanceof Type.Record);
                Type.Record groupingResultRecordType = (Type.Record)groupingResultType;
                fields = groupingResultRecordType.getFields();
                for (i = 0; i < fields.size(); ++i) {
                    valuesBuilder.add(FieldValue.ofOrdinalNumber(groupingKeyValue, i));
                }
            } else {
                valuesBuilder.add(groupingKeyValue);
            }
        }
        if ((aggregateResultType = aggregateValue.getResultType()).isRecord()) {
            Verify.verify(aggregateResultType instanceof Type.Record);
            Type.Record aggregateResultRecordType = (Type.Record)aggregateResultType;
            fields = aggregateResultRecordType.getFields();
            for (i = 0; i < fields.size(); ++i) {
                valuesBuilder.add(FieldValue.ofOrdinalNumber(aggregateValue, i));
            }
        } else {
            valuesBuilder.add(aggregateValue);
        }
        RecordConstructorValue rcv = RecordConstructorValue.ofUnnamed(valuesBuilder.build());
        return rcv.simplify(EvaluationContext.empty(), AliasMap.identitiesFor(rcv.getCorrelatedTo()), ImmutableSet.of());
    }

    public static class UnmatchedAggregateValue
    extends AbstractValue
    implements Value.NonEvaluableValue {
        @Nonnull
        private final CorrelationIdentifier unmatchedId;

        public UnmatchedAggregateValue(@Nonnull CorrelationIdentifier unmatchedId) {
            this.unmatchedId = unmatchedId;
        }

        @Nonnull
        public CorrelationIdentifier getUnmatchedId() {
            return this.unmatchedId;
        }

        @Override
        @Nonnull
        protected Iterable<? extends Value> computeChildren() {
            return ImmutableList.of();
        }

        @Override
        @Nonnull
        public ExplainTokensWithPrecedence explain(@Nonnull Iterable<Supplier<ExplainTokensWithPrecedence>> explainSuppliers) {
            Verify.verify(Iterables.isEmpty(explainSuppliers));
            return ExplainTokensWithPrecedence.of(new ExplainTokens().addFunctionCall("unmatched", new ExplainTokens().addIdentifier(this.unmatchedId.getId())));
        }

        @Override
        public int hashCodeWithoutChildren() {
            return this.unmatchedId.hashCode();
        }

        @Override
        @Nonnull
        public PValue toValueProto(@Nonnull PlanSerializationContext serializationContext) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int planHash(@Nonnull PlanHashable.PlanHashMode hashMode) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nonnull
        public Message toProto(@Nonnull PlanSerializationContext serializationContext) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nonnull
        public Value withChildren(Iterable<? extends Value> newChildren) {
            Verify.verify(Iterables.isEmpty(newChildren));
            return this;
        }

        @Nonnull
        public static CorrelationIdentifier uniqueId() {
            return CorrelationIdentifier.uniqueId(UnmatchedAggregateValue.class);
        }
    }

    private static class SubsumedGroupingsResult {
        @Nonnull
        private final ConstrainedBoolean subsumedGroups;
        @Nonnull
        private final BiMap<Value, Value> matchedGroupingsMap;
        @Nullable
        private final List<Value> rollUpToValues;

        private SubsumedGroupingsResult(@Nonnull ConstrainedBoolean subsumedGroups, @Nonnull BiMap<Value, Value> matchedGroupingsMap, @Nullable List<Value> rollUpToValues) {
            this.subsumedGroups = subsumedGroups;
            this.matchedGroupingsMap = matchedGroupingsMap;
            this.rollUpToValues = rollUpToValues;
        }

        @Nonnull
        public ConstrainedBoolean getSubsumedGroups() {
            return this.subsumedGroups;
        }

        @Nonnull
        public BiMap<Value, Value> getMatchedGroupingsMap() {
            return this.matchedGroupingsMap;
        }

        @Nullable
        public List<Value> getRollUpToValues() {
            return this.rollUpToValues;
        }

        @Nonnull
        public static SubsumedGroupingsResult noSubsumption() {
            return SubsumedGroupingsResult.of(ConstrainedBoolean.falseValue(), ImmutableBiMap.of(), null);
        }

        @Nonnull
        public static SubsumedGroupingsResult withoutRollUp(@Nonnull ConstrainedBoolean subsumedGroups, @Nonnull BiMap<Value, Value> matchedGroupingsMap) {
            return SubsumedGroupingsResult.of(subsumedGroups, matchedGroupingsMap, null);
        }

        @Nonnull
        public static SubsumedGroupingsResult of(@Nonnull ConstrainedBoolean subsumedGroups, @Nonnull BiMap<Value, Value> matchedGroupingsMap, @Nullable List<Value> rollUpToValues) {
            return new SubsumedGroupingsResult(subsumedGroups, ImmutableBiMap.copyOf(matchedGroupingsMap), rollUpToValues == null ? null : ImmutableList.copyOf(rollUpToValues));
        }
    }
}

