/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraphRewritable;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpressionWithPredicates;
import com.apple.foundationdb.record.query.plan.cascades.predicates.AndPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class LogicalFilterExpression
extends AbstractRelationalExpressionWithChildren
implements RelationalExpressionWithPredicates,
PlannerGraphRewritable {
    @Nonnull
    private final List<QueryPredicate> queryPredicates;
    @Nonnull
    private final Quantifier inner;

    public LogicalFilterExpression(@Nonnull Iterable<? extends QueryPredicate> queryPredicates, @Nonnull Quantifier inner) {
        this.queryPredicates = ImmutableList.copyOf(queryPredicates);
        this.inner = inner;
    }

    @Override
    @Nonnull
    public List<? extends Quantifier> getQuantifiers() {
        return ImmutableList.of(this.inner);
    }

    @Override
    public int getRelationalChildCount() {
        return 1;
    }

    @Override
    @Nonnull
    public List<? extends QueryPredicate> getPredicates() {
        return this.queryPredicates;
    }

    @Nonnull
    @VisibleForTesting
    public Quantifier getInner() {
        return this.inner;
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return this.queryPredicates.stream().flatMap(queryPredicate -> queryPredicate.getCorrelatedTo().stream()).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    @Nonnull
    public LogicalFilterExpression translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        List rebasedQueryPredicates = this.queryPredicates.stream().map(queryPredicate -> queryPredicate.translateCorrelations(translationMap, shouldSimplifyValues)).collect(ImmutableList.toImmutableList());
        return new LogicalFilterExpression(rebasedQueryPredicates, Iterables.getOnlyElement(translatedQuantifiers));
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return this.inner.getFlowedObjectValue();
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap equivalencesMap) {
        if (this == otherExpression) {
            return true;
        }
        if (this.getClass() != otherExpression.getClass()) {
            return false;
        }
        LogicalFilterExpression otherLogicalFilterExpression = (LogicalFilterExpression)otherExpression;
        List<? extends QueryPredicate> otherQueryPredicates = otherLogicalFilterExpression.getPredicates();
        if (this.queryPredicates.size() != otherQueryPredicates.size()) {
            return false;
        }
        return Streams.zip(this.queryPredicates.stream(), otherQueryPredicates.stream(), (queryPredicate, otherQueryPredicate) -> queryPredicate.semanticEquals(otherQueryPredicate, equivalencesMap)).allMatch(isSame -> isSame);
    }

    public boolean equals(Object other) {
        return this.semanticEquals(other);
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(this.getPredicates());
    }

    @Override
    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        return PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.LogicalOperatorNodeWithInfo(this, NodeInfo.PREDICATE_FILTER_OPERATOR, ImmutableList.of("WHERE {{pred}}"), ImmutableMap.of("pred", Attribute.gml(AndPredicate.and(this.getPredicates()).toString()))), childGraphs);
    }
}

