/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.OrderingPart;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifiers;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.cascades.explain.InternalPlannerGraphRewritable;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpressionWithChildren;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.RecordQuerySetPlan;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.INTERNAL)
public class LogicalIntersectionExpression
extends AbstractRelationalExpressionWithChildren
implements RelationalExpressionWithChildren.ChildrenAsSet,
InternalPlannerGraphRewritable {
    public static final Logger LOGGER = LoggerFactory.getLogger(LogicalIntersectionExpression.class);
    private static final String INTERSECT = "\u2229";
    @Nonnull
    private final List<Quantifier.ForEach> quantifiers;
    @Nonnull
    private final List<OrderingPart.ProvidedOrderingPart> comparisonKeyProvidedOrderingParts;
    @Nonnull
    private final Value resultValue;

    private LogicalIntersectionExpression(@Nonnull List<Quantifier.ForEach> quantifiers, @Nonnull List<OrderingPart.ProvidedOrderingPart> comparisonKeyProvidedOrderingParts) {
        this.quantifiers = ImmutableList.copyOf(quantifiers);
        this.comparisonKeyProvidedOrderingParts = ImmutableList.copyOf(comparisonKeyProvidedOrderingParts);
        this.resultValue = RecordQuerySetPlan.mergeValues(quantifiers);
    }

    @Nonnull
    public List<OrderingPart.ProvidedOrderingPart> getComparisonKeyProvidedOrderingParts() {
        return this.comparisonKeyProvidedOrderingParts;
    }

    @Override
    @Nonnull
    public List<? extends Quantifier> getQuantifiers() {
        return this.quantifiers;
    }

    @Nonnull
    public String toString() {
        return this.quantifiers.stream().map(Quantifier::toString).collect(Collectors.joining(" \u2229 "));
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return ImmutableSet.of();
    }

    @Override
    @Nonnull
    public LogicalIntersectionExpression translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        return new LogicalIntersectionExpression(Quantifiers.narrow(Quantifier.ForEach.class, translatedQuantifiers), this.getComparisonKeyProvidedOrderingParts());
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return this.resultValue;
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap equivalencesMap) {
        if (this == otherExpression) {
            return true;
        }
        if (this.getClass() != otherExpression.getClass()) {
            return false;
        }
        LogicalIntersectionExpression other = (LogicalIntersectionExpression)otherExpression;
        return this.comparisonKeyProvidedOrderingParts.equals(other.comparisonKeyProvidedOrderingParts);
    }

    public boolean equals(Object other) {
        return this.semanticEquals(other);
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return this.getComparisonKeyProvidedOrderingParts().hashCode();
    }

    @Override
    public int getRelationalChildCount() {
        return this.quantifiers.size();
    }

    @Nonnull
    public static LogicalIntersectionExpression from(@Nonnull List<? extends Reference> children, @Nonnull List<OrderingPart.ProvidedOrderingPart> comparisonKeyProvidedOrderingParts) {
        if (children.size() < 2) {
            throw new RecordCoreArgumentException("fewer than two children given to intersection expression", new Object[0]);
        }
        ImmutableList.Builder childRefsBuilder = ImmutableList.builder();
        for (Reference reference : children) {
            childRefsBuilder.add(Quantifier.forEach(reference));
        }
        return new LogicalIntersectionExpression((List<Quantifier.ForEach>)((Object)childRefsBuilder.build()), comparisonKeyProvidedOrderingParts);
    }

    @Override
    @Nonnull
    public PlannerGraph rewriteInternalPlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        return PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.LogicalOperatorNodeWithInfo(this, NodeInfo.INTERSECTION_OPERATOR, ImmutableList.of("COMPARE BY {{comparisonKey}}"), ImmutableMap.of("comparisonKey", Attribute.gml(this.comparisonKeyProvidedOrderingParts.toString()))), childGraphs);
    }
}

