/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraphRewritable;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class LogicalProjectionExpression
extends AbstractRelationalExpressionWithChildren
implements PlannerGraphRewritable {
    @Nonnull
    private final List<? extends Value> projectedValues;
    @Nonnull
    private final Quantifier inner;

    public LogicalProjectionExpression(@Nonnull List<? extends Value> projectedValues, @Nonnull Quantifier inner) {
        this.projectedValues = ImmutableList.copyOf(projectedValues);
        this.inner = inner;
    }

    @Override
    @Nonnull
    public List<? extends Quantifier> getQuantifiers() {
        return ImmutableList.of(this.inner);
    }

    @Override
    public int getRelationalChildCount() {
        return 1;
    }

    @Nonnull
    @VisibleForTesting
    public Quantifier getInner() {
        return this.inner;
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return this.projectedValues.stream().flatMap(projectedValue -> projectedValue.getCorrelatedTo().stream()).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    @Nonnull
    public LogicalProjectionExpression translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        List rebasedValue = this.getProjectedValues().stream().map(projectedValue -> projectedValue.translateCorrelations(translationMap, shouldSimplifyValues)).collect(ImmutableList.toImmutableList());
        return new LogicalProjectionExpression(rebasedValue, Iterables.getOnlyElement(translatedQuantifiers));
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return this.inner.getFlowedObjectValue();
    }

    @Nonnull
    public List<? extends Value> getProjectedValues() {
        return this.projectedValues;
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap equivalencesMap) {
        if (this == otherExpression) {
            return true;
        }
        if (this.getClass() != otherExpression.getClass()) {
            return false;
        }
        LogicalProjectionExpression otherLogicalProjectionExpression = (LogicalProjectionExpression)otherExpression;
        List<? extends Value> otherProjectedValues = otherLogicalProjectionExpression.getProjectedValues();
        if (this.projectedValues.size() != otherProjectedValues.size()) {
            return false;
        }
        return Streams.zip(this.projectedValues.stream(), otherProjectedValues.stream(), (value, otherValue) -> value.semanticEquals(otherValue, equivalencesMap)).allMatch(isSame -> isSame);
    }

    public boolean equals(Object other) {
        return this.semanticEquals(other);
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(this.getResultValue());
    }

    @Override
    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        return PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.LogicalOperatorNodeWithInfo(this, NodeInfo.VALUE_COMPUTATION_OPERATOR, ImmutableList.of("COMPUTE {{values}}"), ImmutableMap.of("values", Attribute.gml(this.getProjectedValues().toString()))), childGraphs);
    }
}

