/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.OrderingPart;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.RequestedOrdering;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.cascades.explain.InternalPlannerGraphRewritable;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class LogicalSortExpression
extends AbstractRelationalExpressionWithChildren
implements InternalPlannerGraphRewritable {
    @Nonnull
    private final RequestedOrdering ordering;
    @Nonnull
    private final Quantifier inner;

    public LogicalSortExpression(@Nonnull RequestedOrdering ordering, @Nonnull Quantifier inner) {
        this.ordering = ordering;
        this.inner = inner;
    }

    @Deprecated
    public LogicalSortExpression(@Nonnull List<Value> sortValues, boolean reverse, @Nonnull Quantifier inner) {
        this(LogicalSortExpression.buildRequestedOrdering(sortValues, reverse, inner), inner);
    }

    @Nonnull
    public static RequestedOrdering buildRequestedOrdering(@Nonnull List<Value> sortValues, boolean reverse, @Nonnull Quantifier inner) {
        OrderingPart.RequestedSortOrder order = OrderingPart.RequestedSortOrder.fromIsReverse(reverse);
        RequestedOrdering.Distinctness distinctness = RequestedOrdering.Distinctness.PRESERVE_DISTINCTNESS;
        List<OrderingPart.RequestedOrderingPart> requestedOrderingParts = sortValues.stream().map(value -> new OrderingPart.RequestedOrderingPart((Value)value, order)).collect(Collectors.toList());
        return RequestedOrdering.ofParts(requestedOrderingParts, distinctness, false, inner.getCorrelatedTo());
    }

    @Nonnull
    public static LogicalSortExpression unsorted(@Nonnull Quantifier inner) {
        return new LogicalSortExpression(RequestedOrdering.preserve(), inner);
    }

    @Override
    @Nonnull
    public List<? extends Quantifier> getQuantifiers() {
        return ImmutableList.of(this.getInner());
    }

    @Override
    public int getRelationalChildCount() {
        return 1;
    }

    @Nonnull
    public RequestedOrdering getOrdering() {
        return this.ordering;
    }

    @Nonnull
    private Quantifier getInner() {
        return this.inner;
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return ImmutableSet.of();
    }

    @Override
    @Nonnull
    public LogicalSortExpression translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        return new LogicalSortExpression(this.getOrdering(), Iterables.getOnlyElement(translatedQuantifiers));
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return this.inner.getFlowedObjectValue();
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap equivalencesMap) {
        if (this == otherExpression) {
            return true;
        }
        if (this.getClass() != otherExpression.getClass()) {
            return false;
        }
        LogicalSortExpression other = (LogicalSortExpression)otherExpression;
        return this.ordering.equals(other.ordering);
    }

    public boolean equals(Object other) {
        return this.semanticEquals(other);
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return this.ordering.hashCode();
    }

    @Override
    @Nonnull
    public PlannerGraph rewriteInternalPlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        if (this.ordering.isPreserve()) {
            return PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.LogicalOperatorNodeWithInfo(this, NodeInfo.SORT_OPERATOR, ImmutableList.of("PRESERVE ORDER"), ImmutableMap.of()), childGraphs);
        }
        return PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.LogicalOperatorNodeWithInfo(this, NodeInfo.SORT_OPERATOR, ImmutableList.of("BY {{expression}}"), ImmutableMap.of("expression", Attribute.gml(this.ordering.toString()))), childGraphs);
    }
}

