/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.ComparisonRange;
import com.apple.foundationdb.record.query.plan.cascades.Compensation;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.IdentityBiMap;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentityMap;
import com.apple.foundationdb.record.query.plan.cascades.MatchInfo;
import com.apple.foundationdb.record.query.plan.cascades.PartialMatch;
import com.apple.foundationdb.record.query.plan.cascades.PredicateMultiMap;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraphRewritable;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.TypeFilterExpression;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.QuantifiedObjectValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.PullUp;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.util.pair.Pair;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class LogicalTypeFilterExpression
extends AbstractRelationalExpressionWithChildren
implements TypeFilterExpression,
PlannerGraphRewritable {
    @Nonnull
    private final Set<String> recordTypes;
    @Nonnull
    private final Quantifier innerQuantifier;
    @Nonnull
    private final Type resultType;

    public LogicalTypeFilterExpression(@Nonnull Set<String> recordTypes, @Nonnull Quantifier innerQuantifier, @Nonnull Type resultType) {
        this.recordTypes = recordTypes;
        this.innerQuantifier = innerQuantifier;
        this.resultType = resultType;
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return QuantifiedObjectValue.of(this.innerQuantifier.getAlias(), this.resultType);
    }

    @Override
    @Nonnull
    public List<? extends Quantifier> getQuantifiers() {
        return ImmutableList.of(this.getInnerQuantifier());
    }

    @Nonnull
    public Set<String> getRecordTypes() {
        return this.recordTypes;
    }

    @Override
    public int getRelationalChildCount() {
        return 1;
    }

    @Nonnull
    public Quantifier getInnerQuantifier() {
        return this.innerQuantifier;
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return ImmutableSet.of();
    }

    @Override
    @Nonnull
    public LogicalTypeFilterExpression translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        return new LogicalTypeFilterExpression((Set<String>)this.getRecordTypes(), Iterables.getOnlyElement(translatedQuantifiers), this.resultType);
    }

    public boolean equals(Object other) {
        return this.semanticEquals(other);
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return TypeFilterExpression.super.computeHashCodeWithoutChildren();
    }

    @Override
    @Nonnull
    public Iterable<MatchInfo> subsumedBy(@Nonnull RelationalExpression candidateExpression, @Nonnull AliasMap bindingAliasMap, @Nonnull IdentityBiMap<Quantifier, PartialMatch> partialMatchMap, @Nonnull EvaluationContext evaluationContext) {
        if (candidateExpression.getClass() != this.getClass()) {
            return ImmutableList.of();
        }
        if (!this.isCompatiblyAndCompletelyBound(bindingAliasMap, candidateExpression.getQuantifiers())) {
            return ImmutableList.of();
        }
        LogicalTypeFilterExpression candidateTypeFilterExpression = (LogicalTypeFilterExpression)candidateExpression;
        Quantifier candidateInnerQuantifier = candidateTypeFilterExpression.getInnerQuantifier();
        if (!(this.innerQuantifier instanceof Quantifier.ForEach)) {
            return ImmutableList.of();
        }
        CorrelationIdentifier candidateAlias = bindingAliasMap.getTarget(this.innerQuantifier.getAlias());
        if (candidateAlias == null) {
            return ImmutableList.of();
        }
        Verify.verify(candidateAlias.equals(candidateInnerQuantifier.getAlias()));
        if (!(candidateInnerQuantifier instanceof Quantifier.ForEach)) {
            return ImmutableList.of();
        }
        if (((Quantifier.ForEach)this.innerQuantifier).isNullOnEmpty() != ((Quantifier.ForEach)candidateInnerQuantifier).isNullOnEmpty()) {
            return ImmutableList.of();
        }
        Optional<TranslationMap> translationMapOptional = RelationalExpression.pullUpAndComposeTranslationMapsMaybe(candidateExpression, bindingAliasMap, partialMatchMap);
        if (translationMapOptional.isEmpty()) {
            return ImmutableList.of();
        }
        return this.exactlySubsumedBy(candidateExpression, bindingAliasMap, partialMatchMap, translationMapOptional.get());
    }

    @Override
    @Nonnull
    public Compensation compensate(@Nonnull PartialMatch partialMatch, @Nonnull Map<CorrelationIdentifier, ComparisonRange> boundParameterPrefixMap, @Nullable PullUp pullUp, @Nonnull CorrelationIdentifier candidateAlias) {
        MatchInfo.RegularMatchInfo regularMatchInfo = partialMatch.getRegularMatchInfo();
        Pair<PullUp, PullUp> nestedPullUpPair = partialMatch.nestPullUp(pullUp, candidateAlias);
        PullUp rootOfMatchPullUp = nestedPullUpPair.getKey();
        PullUp adjustedPullUp = Objects.requireNonNull(nestedPullUpPair.getRight());
        AliasMap bindingAliasMap = regularMatchInfo.getBindingAliasMap();
        PartialMatch childPartialMatch = Objects.requireNonNull(regularMatchInfo.getChildPartialMatchMaybe(this.innerQuantifier).orElseThrow(() -> new RecordCoreException("expected a match child", new Object[0])));
        Compensation childCompensation = childPartialMatch.compensate(boundParameterPrefixMap, adjustedPullUp, Objects.requireNonNull(bindingAliasMap.getTarget(this.innerQuantifier.getAlias())));
        if (childCompensation.isImpossible()) {
            return Compensation.impossibleCompensation();
        }
        Optional<Compensation.CompensatedResult> compensatedResultOptional = Compensation.computeResultCompensation(partialMatch, rootOfMatchPullUp);
        if (compensatedResultOptional.isEmpty()) {
            return Compensation.impossibleCompensation();
        }
        Compensation.CompensatedResult compensatedResult = compensatedResultOptional.get();
        if (!childCompensation.isNeeded() && !compensatedResult.getResultCompensationFunction().isNeeded()) {
            return Compensation.noCompensation();
        }
        Set<Quantifier> unmatchedQuantifiers = partialMatch.getUnmatchedQuantifiers();
        Verify.verify(unmatchedQuantifiers.isEmpty());
        return childCompensation.derived(compensatedResult.isCompensationImpossible(), new LinkedIdentityMap<QueryPredicate, PredicateMultiMap.PredicateCompensationFunction>(), this.getMatchedQuantifiers(partialMatch), unmatchedQuantifiers, partialMatch.getCompensatedAliases(), compensatedResult.getResultCompensationFunction(), compensatedResult.getGroupByMappings());
    }

    @Override
    @Nonnull
    public PlannerGraph rewritePlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        return PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.LogicalOperatorNodeWithInfo(this, NodeInfo.TYPE_FILTER_OPERATOR, ImmutableList.of("WHERE record IS {{types}}"), ImmutableMap.of("types", Attribute.gml(this.getRecordTypes().stream().map(Attribute::gml).collect(ImmutableList.toImmutableList())))), childGraphs);
    }
}

