/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpressionWithChildren;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.RecordQuerySetPlan;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class LogicalUnionExpression
extends AbstractRelationalExpressionWithChildren
implements RelationalExpressionWithChildren.ChildrenAsSet {
    @Nonnull
    private final List<? extends Quantifier> quantifiers;
    @Nonnull
    private final Value resultValue;

    public LogicalUnionExpression(@Nonnull List<? extends Quantifier> quantifiers) {
        this.quantifiers = quantifiers;
        this.resultValue = RecordQuerySetPlan.mergeValues(quantifiers);
    }

    @Override
    public int getRelationalChildCount() {
        return this.quantifiers.size();
    }

    @Override
    @Nonnull
    public List<? extends Quantifier> getQuantifiers() {
        return this.quantifiers;
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return ImmutableSet.of();
    }

    @Override
    @Nonnull
    public LogicalUnionExpression translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        return new LogicalUnionExpression(translatedQuantifiers);
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return this.resultValue;
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap equivalences) {
        if (this == otherExpression) {
            return true;
        }
        return this.getClass() == otherExpression.getClass();
    }

    public boolean equals(Object other) {
        return this.semanticEquals(other);
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(this.resultValue);
    }
}

