/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.MatchCandidate;
import com.apple.foundationdb.record.query.plan.cascades.MatchInfo;
import com.apple.foundationdb.record.query.plan.cascades.OrderingPart;
import com.apple.foundationdb.record.query.plan.cascades.PartialMatch;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.apple.foundationdb.record.query.plan.cascades.explain.InternalPlannerGraphRewritable;
import com.apple.foundationdb.record.query.plan.cascades.explain.NodeInfo;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.MaxMatchMap;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class MatchableSortExpression
extends AbstractRelationalExpressionWithChildren
implements InternalPlannerGraphRewritable {
    @Nonnull
    private final List<CorrelationIdentifier> sortParameterIds;
    private final boolean isReverse;
    @Nonnull
    private final Quantifier inner;

    public MatchableSortExpression(@Nonnull List<CorrelationIdentifier> sortParameterIds, boolean isReverse, @Nonnull RelationalExpression innerExpression) {
        this(sortParameterIds, isReverse, Quantifier.forEach(Reference.initialOf(innerExpression)));
    }

    public MatchableSortExpression(@Nonnull List<CorrelationIdentifier> sortParameterIds, boolean isReverse, @Nonnull Quantifier inner) {
        this.sortParameterIds = ImmutableList.copyOf(sortParameterIds);
        this.isReverse = isReverse;
        this.inner = inner;
    }

    @Override
    @Nonnull
    public List<? extends Quantifier> getQuantifiers() {
        return ImmutableList.of(this.getInner());
    }

    @Override
    public int getRelationalChildCount() {
        return 1;
    }

    @Nonnull
    public List<CorrelationIdentifier> getSortParameterIds() {
        return this.sortParameterIds;
    }

    public boolean isReverse() {
        return this.isReverse;
    }

    @Nonnull
    private Quantifier getInner() {
        return this.inner;
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return ImmutableSet.of();
    }

    @Override
    @Nonnull
    public MatchableSortExpression translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        return new MatchableSortExpression(this.getSortParameterIds(), this.isReverse(), Iterables.getOnlyElement(translatedQuantifiers));
    }

    @Override
    @Nonnull
    public Optional<MatchInfo> adjustMatch(@Nonnull PartialMatch partialMatch) {
        MatchInfo childMatchInfo = partialMatch.getMatchInfo();
        MaxMatchMap maxMatchMap = childMatchInfo.getMaxMatchMap();
        Optional<MaxMatchMap> adjustedMaxMatchMapOptional = maxMatchMap.adjustMaybe(this.inner.getAlias(), this.getResultValue(), ImmutableSet.of(this.inner.getAlias()));
        return adjustedMaxMatchMapOptional.map(adjustedMaxMatchMap -> childMatchInfo.adjustedBuilder().setMaxMatchMap((MaxMatchMap)adjustedMaxMatchMap).setMatchedOrderingParts(this.forPartialMatch(partialMatch)).setGroupByMappings(childMatchInfo.adjustGroupByMappings(this.inner)).build());
    }

    @Nonnull
    private List<OrderingPart.MatchedOrderingPart> forPartialMatch(@Nonnull PartialMatch partialMatch) {
        MatchCandidate matchCandidate = partialMatch.getMatchCandidate();
        return matchCandidate.computeMatchedOrderingParts(partialMatch.getMatchInfo(), this.getSortParameterIds(), this.isReverse());
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return this.inner.getFlowedObjectValue();
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap equivalencesMap) {
        if (this == otherExpression) {
            return true;
        }
        if (this.getClass() != otherExpression.getClass()) {
            return false;
        }
        MatchableSortExpression other = (MatchableSortExpression)otherExpression;
        return this.isReverse == other.isReverse && !this.sortParameterIds.equals(other.sortParameterIds);
    }

    public boolean equals(Object other) {
        return this.semanticEquals(other);
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(this.getSortParameterIds(), this.isReverse());
    }

    @Override
    @Nonnull
    public PlannerGraph rewriteInternalPlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        return PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.LogicalOperatorNodeWithInfo(this, NodeInfo.SORT_OPERATOR, ImmutableList.of("BY {{expression}}"), ImmutableMap.of("expression", Attribute.gml(this.sortParameterIds.toString()))), childGraphs);
    }
}

