/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.expressions;

import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.query.plan.plans.RecordQuerySetPlan;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

public class RecursiveUnionExpression
extends AbstractRelationalExpressionWithChildren {
    @Nonnull
    private final Quantifier initialStateQuantifier;
    @Nonnull
    private final Quantifier recursiveStateQuantifier;
    @Nonnull
    private final CorrelationIdentifier tempTableScanAlias;
    @Nonnull
    private final CorrelationIdentifier tempTableInsertAlias;
    @Nonnull
    private final TraversalStrategy traversalStrategy;
    @Nonnull
    private final Value resultValue;

    public RecursiveUnionExpression(@Nonnull Quantifier initialState, @Nonnull Quantifier recursiveState, @Nonnull CorrelationIdentifier tempTableScanAlias, @Nonnull CorrelationIdentifier tempTableInsertAlias, @Nonnull TraversalStrategy traversalStrategy) {
        this.initialStateQuantifier = initialState;
        this.recursiveStateQuantifier = recursiveState;
        this.tempTableScanAlias = tempTableScanAlias;
        this.tempTableInsertAlias = tempTableInsertAlias;
        this.traversalStrategy = traversalStrategy;
        this.resultValue = RecordQuerySetPlan.mergeValues(ImmutableList.of(this.initialStateQuantifier, this.recursiveStateQuantifier));
    }

    @Override
    public int getRelationalChildCount() {
        return 2;
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedTo() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Streams.concat(this.initialStateQuantifier.getCorrelatedTo().stream(), this.recursiveStateQuantifier.getCorrelatedTo().stream()).filter(alias -> !alias.equals(this.tempTableInsertAlias) && !alias.equals(this.tempTableScanAlias)).forEach(builder::add);
        return builder.build();
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return ImmutableSet.of();
    }

    @Override
    public boolean canCorrelate() {
        return true;
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return this.resultValue;
    }

    @Override
    @Nonnull
    public List<? extends Quantifier> getQuantifiers() {
        return ImmutableList.of(this.initialStateQuantifier, this.recursiveStateQuantifier);
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap equivalences) {
        if (this == otherExpression) {
            return true;
        }
        if (!(otherExpression instanceof RecursiveUnionExpression)) {
            return false;
        }
        RecursiveUnionExpression otherRecursiveUnionExpression = (RecursiveUnionExpression)otherExpression;
        return !(this.traversalStrategy != otherRecursiveUnionExpression.traversalStrategy || !this.tempTableScanAlias.equals(otherRecursiveUnionExpression.tempTableScanAlias) && !equivalences.containsMapping(this.tempTableScanAlias, otherRecursiveUnionExpression.tempTableScanAlias) || !this.tempTableInsertAlias.equals(otherRecursiveUnionExpression.tempTableInsertAlias) && !equivalences.containsMapping(this.tempTableInsertAlias, otherRecursiveUnionExpression.tempTableInsertAlias));
    }

    public boolean equals(Object other) {
        return this.semanticEquals(other);
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(new Object[]{this.getTempTableScanAlias(), this.getTempTableInsertAlias(), this.traversalStrategy});
    }

    @Override
    @Nonnull
    public RelationalExpression translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        Verify.verify(translatedQuantifiers.size() == 2);
        Verify.verify(!translationMap.containsSourceAlias(this.tempTableScanAlias) && !translationMap.containsSourceAlias(this.tempTableInsertAlias));
        Quantifier translatedInitialStateQun = translatedQuantifiers.get(0);
        Quantifier translatedRecursiveStateQun = translatedQuantifiers.get(1);
        return new RecursiveUnionExpression(translatedInitialStateQun, translatedRecursiveStateQun, this.tempTableScanAlias, this.tempTableInsertAlias, this.traversalStrategy);
    }

    @Nonnull
    public CorrelationIdentifier getTempTableScanAlias() {
        return this.tempTableScanAlias;
    }

    @Nonnull
    public CorrelationIdentifier getTempTableInsertAlias() {
        return this.tempTableInsertAlias;
    }

    @Nonnull
    public Quantifier getInitialStateQuantifier() {
        return this.initialStateQuantifier;
    }

    @Nonnull
    public Quantifier getRecursiveStateQuantifier() {
        return this.recursiveStateQuantifier;
    }

    public boolean preOrderTraversalAllowed() {
        return this.traversalStrategy == TraversalStrategy.ANY || this.traversalStrategy == TraversalStrategy.PREORDER;
    }

    public boolean levelTraversalAllowed() {
        return this.traversalStrategy == TraversalStrategy.ANY || this.traversalStrategy == TraversalStrategy.LEVEL;
    }

    public static enum TraversalStrategy {
        ANY,
        PREORDER,
        LEVEL;

    }
}

