/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.GenerateVisitor;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.query.RecordQuery;
import com.apple.foundationdb.record.query.combinatorics.EnumeratingIterable;
import com.apple.foundationdb.record.query.combinatorics.PartiallyOrderedSet;
import com.apple.foundationdb.record.query.plan.cascades.AccessHint;
import com.apple.foundationdb.record.query.plan.cascades.AccessHints;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.ComparisonRange;
import com.apple.foundationdb.record.query.plan.cascades.Compensation;
import com.apple.foundationdb.record.query.plan.cascades.Correlated;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.GraphExpansion;
import com.apple.foundationdb.record.query.plan.cascades.IdentityBiMap;
import com.apple.foundationdb.record.query.plan.cascades.IterableHelpers;
import com.apple.foundationdb.record.query.plan.cascades.MatchInfo;
import com.apple.foundationdb.record.query.plan.cascades.Narrowable;
import com.apple.foundationdb.record.query.plan.cascades.PartialMatch;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifiers;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.ScalarTranslationVisitor;
import com.apple.foundationdb.record.query.plan.cascades.SimpleExpressionVisitor;
import com.apple.foundationdb.record.query.plan.cascades.ValueEquivalence;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraphVisitor;
import com.apple.foundationdb.record.query.plan.cascades.expressions.FullUnorderedScanExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalDistinctExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalProjectionExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalSortExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.LogicalTypeFilterExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.SelectExpression;
import com.apple.foundationdb.record.query.plan.cascades.matching.graph.BoundMatch;
import com.apple.foundationdb.record.query.plan.cascades.matching.graph.MatchFunction;
import com.apple.foundationdb.record.query.plan.cascades.matching.graph.MatchPredicate;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.typing.Typed;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.MaxMatchMap;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.PullUp;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.RegularTranslationMap;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.google.common.base.Equivalence;
import com.google.common.base.Verify;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
@GenerateVisitor
public interface RelationalExpression
extends Correlated<RelationalExpression>,
Typed,
Narrowable<RelationalExpression> {
    @Nonnull
    public static RelationalExpression fromRecordQuery(@Nonnull RecordMetaData recordMetaData, @Nonnull RecordQuery query) {
        Quantifier.ForEach quantifier;
        Reference baseRef;
        Collection<String> queriedRecordTypes;
        query.validate(recordMetaData);
        Set<String> allRecordTypes = recordMetaData.getRecordTypes().keySet();
        Collection<String> recordTypesFromQuery = query.getRecordTypes();
        Collection<String> collection = queriedRecordTypes = recordTypesFromQuery.isEmpty() ? allRecordTypes : recordTypesFromQuery;
        if (queriedRecordTypes.isEmpty()) {
            baseRef = Reference.initialOf((RelationalExpression)new FullUnorderedScanExpression(allRecordTypes, new Type.AnyRecord(false), new AccessHints(new AccessHint[0])));
            quantifier = Quantifier.forEach(baseRef);
        } else {
            Reference fuseRef = Reference.initialOf((RelationalExpression)new FullUnorderedScanExpression(allRecordTypes, new Type.AnyRecord(false), new AccessHints(new AccessHint[0])));
            baseRef = Reference.initialOf((RelationalExpression)new LogicalTypeFilterExpression(new HashSet<String>(queriedRecordTypes), Quantifier.forEach(fuseRef), Type.Record.fromFieldDescriptorsMap(recordMetaData.getFieldDescriptorMapFromNames(queriedRecordTypes))));
            quantifier = Quantifier.forEach(baseRef);
        }
        SelectExpression selectExpression = query.getFilter() != null ? GraphExpansion.ofOthers(GraphExpansion.builder().addQuantifier(quantifier).build(), query.getFilter().expand(quantifier, () -> Quantifier.forEach(baseRef))).buildSimpleSelectOverQuantifier(quantifier) : GraphExpansion.builder().addQuantifier(quantifier).build().buildSimpleSelectOverQuantifier(quantifier);
        quantifier = Quantifier.forEach(Reference.initialOf((RelationalExpression)selectExpression));
        if (query.removesDuplicates()) {
            quantifier = Quantifier.forEach(Reference.initialOf((RelationalExpression)new LogicalDistinctExpression(quantifier)));
        }
        if (query.getSort() != null) {
            List<Value> sortValues = ScalarTranslationVisitor.translateKeyExpression(query.getSort(), quantifier.getFlowedObjectType());
            quantifier = Quantifier.forEach(Reference.initialOf((RelationalExpression)new LogicalSortExpression(LogicalSortExpression.buildRequestedOrdering(sortValues, query.isSortReverse(), quantifier), quantifier)));
        } else {
            quantifier = Quantifier.forEach(Reference.initialOf((RelationalExpression)LogicalSortExpression.unsorted(quantifier)));
        }
        if (query.getRequiredResults() != null) {
            List<Value> projectedValues = Value.fromKeyExpressions(query.getRequiredResults().stream().flatMap(keyExpression -> keyExpression.normalizeKeyForPositions().stream()).collect(ImmutableList.toImmutableList()), quantifier);
            quantifier = Quantifier.forEach(Reference.initialOf((RelationalExpression)new LogicalProjectionExpression(projectedValues, quantifier)));
        }
        return quantifier.getRangesOver().get();
    }

    @Override
    @Nonnull
    default public Type.Relation getResultType() {
        return new Type.Relation(this.getResultValue().getResultType());
    }

    @Nonnull
    public Value getResultValue();

    @Nonnull
    default public Set<Type> getDynamicTypes() {
        return this.getResultValue().getDynamicTypes();
    }

    default public boolean semanticEqualsForResults(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap aliasMap) {
        return this.getResultValue().semanticEquals((Object)otherExpression.getResultValue(), aliasMap);
    }

    @Nonnull
    public List<? extends Quantifier> getQuantifiers();

    default public boolean canCorrelate() {
        return false;
    }

    @Nonnull
    public Set<CorrelationIdentifier> getCorrelatedToWithoutChildren();

    @Nonnull
    default public PartiallyOrderedSet<CorrelationIdentifier> getCorrelationOrder() {
        return PartiallyOrderedSet.empty();
    }

    public boolean equalsWithoutChildren(@Nonnull RelationalExpression var1, @Nonnull AliasMap var2);

    public int hashCodeWithoutChildren();

    default public boolean semanticEquals(@Nullable Object other) {
        return this.semanticEquals(other, AliasMap.emptyMap());
    }

    @Override
    default public boolean semanticEquals(@Nullable Object other, @Nonnull AliasMap aliasMap) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof RelationalExpression)) {
            return false;
        }
        RelationalExpression otherExpression = (RelationalExpression)other;
        if (this.hashCodeWithoutChildren() != otherExpression.hashCodeWithoutChildren()) {
            return false;
        }
        Iterable<AliasMap> boundMatchIterable = this.findMatches(otherExpression, aliasMap, (quantifier, otherQuantifier, nestedEquivalenceMap) -> {
            if (quantifier.semanticHashCode() != otherQuantifier.semanticHashCode()) {
                return false;
            }
            return quantifier.semanticEquals(otherQuantifier, nestedEquivalenceMap);
        }, (boundCorrelatedToMap, boundMapIterable) -> {
            if (this.getQuantifiers().isEmpty()) {
                return this.equalsWithoutChildren(otherExpression, boundCorrelatedToMap);
            }
            return StreamSupport.stream(boundMapIterable.spliterator(), false).anyMatch(boundMap -> this.equalsWithoutChildren(otherExpression, (AliasMap)boundMap));
        });
        return !Iterables.isEmpty(boundMatchIterable);
    }

    @Nonnull
    default public Iterable<AliasMap> findMatches(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap aliasMap, @Nonnull MatchPredicate<Quantifier> matchPredicate, @Nonnull CombinePredicate combinePredicate) {
        if (this.getClass() != otherExpression.getClass()) {
            return ImmutableList.of();
        }
        Verify.verify(this.canCorrelate() == otherExpression.canCorrelate());
        Iterable<AliasMap> boundCorrelatedToIterable = this.enumerateUnboundCorrelatedTo(aliasMap, otherExpression);
        return () -> StreamSupport.stream(boundCorrelatedToIterable.spliterator(), false).filter(boundCorrelatedToMap -> {
            Iterable<AliasMap> boundMapIterable = Quantifiers.findMatches(boundCorrelatedToMap, this.getQuantifiers(), otherExpression.getQuantifiers(), matchPredicate);
            return combinePredicate.combine((AliasMap)boundCorrelatedToMap, boundMapIterable);
        }).iterator();
    }

    @Nonnull
    default public <M, S> Iterable<S> match(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap boundAliasMap, @Nonnull Function<Quantifier, Collection<AliasMap>> constraintsFunction, @Nonnull MatchFunction<Quantifier, M> matchFunction, @Nonnull CombineFunction<M, S> combineFunction) {
        List<? extends Quantifier> quantifiers = this.getQuantifiers();
        List<? extends Quantifier> otherQuantifiers = otherExpression.getQuantifiers();
        return this.match(otherExpression, boundAliasMap, quantifiers, otherQuantifiers, constraintsFunction, matchFunction, combineFunction);
    }

    @Nonnull
    default public <M, S> Iterable<S> match(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap boundAliasMap, @Nonnull List<? extends Quantifier> quantifiers, @Nonnull List<? extends Quantifier> otherQuantifiers, @Nonnull Function<Quantifier, Collection<AliasMap>> constraintsFunction, @Nonnull MatchFunction<Quantifier, M> matchFunction, @Nonnull CombineFunction<M, S> combineFunction) {
        if (this.getClass() != otherExpression.getClass()) {
            return ImmutableList.of();
        }
        Verify.verify(this.canCorrelate() == otherExpression.canCorrelate());
        Iterable<AliasMap> boundConstraintIterable = Quantifiers.enumerateConstraintAliases(boundAliasMap, quantifiers, constraintsFunction, this.getCorrelatedTo(), otherExpression.getCorrelatedTo());
        Iterable boundCorrelatedToIterable = IterableHelpers.flatMap(boundConstraintIterable, boundConstraintMap -> this.enumerateUnboundCorrelatedTo((AliasMap)boundConstraintMap, otherExpression));
        return IterableHelpers.flatMap(boundCorrelatedToIterable, boundCorrelatedToMap -> {
            Iterable boundMatchIterable = Quantifiers.match(boundCorrelatedToMap, this.getQuantifiers(), otherQuantifiers, matchFunction);
            return combineFunction.combine((AliasMap)boundCorrelatedToMap, boundMatchIterable);
        });
    }

    @Nonnull
    default public Iterable<AliasMap> enumerateUnboundCorrelatedTo(@Nonnull AliasMap boundAliasMap, @Nonnull RelationalExpression otherExpression) {
        Set<CorrelationIdentifier> correlatedTo = this.getCorrelatedTo();
        Set<CorrelationIdentifier> otherCorrelatedTo = otherExpression.getCorrelatedTo();
        AliasMap identitiesMap = this.bindIdentities(otherExpression, boundAliasMap);
        AliasMap aliasMapWithIdentities = boundAliasMap.combine(identitiesMap);
        Sets.SetView<CorrelationIdentifier> unboundCorrelatedTo = Sets.difference(correlatedTo, aliasMapWithIdentities.sources());
        Sets.SetView<CorrelationIdentifier> unboundOtherCorrelatedTo = Sets.difference(otherCorrelatedTo, aliasMapWithIdentities.targets());
        return aliasMapWithIdentities.findMatches(unboundCorrelatedTo, alias -> ImmutableSet.of(), unboundOtherCorrelatedTo, otherAlias -> ImmutableSet.of(), (alias, otherAlias, nestedEquivalencesMap) -> true);
    }

    @Nonnull
    default public AliasMap bindIdentities(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap boundAliasMap) {
        Set<CorrelationIdentifier> correlatedTo = this.getCorrelatedTo();
        Set<CorrelationIdentifier> otherCorrelatedTo = otherExpression.getCorrelatedTo();
        Sets.SetView<CorrelationIdentifier> unboundCorrelatedTo = Sets.difference(correlatedTo, boundAliasMap.sources());
        Sets.SetView<CorrelationIdentifier> unboundOtherCorrelatedTo = Sets.difference(otherCorrelatedTo, boundAliasMap.targets());
        Sets.SetView<CorrelationIdentifier> commonUnbound = Sets.intersection(unboundCorrelatedTo, unboundOtherCorrelatedTo);
        return AliasMap.identitiesFor(commonUnbound);
    }

    @Nonnull
    default public Iterable<MatchInfo> subsumedBy(@Nonnull RelationalExpression candidateExpression, @Nonnull AliasMap bindingAliasMap, @Nonnull IdentityBiMap<Quantifier, PartialMatch> partialMatchMap, @Nonnull EvaluationContext evaluationContext) {
        return ImmutableList.of();
    }

    @Nonnull
    default public Iterable<MatchInfo> exactlySubsumedBy(@Nonnull RelationalExpression candidateExpression, @Nonnull AliasMap bindingAliasMap, @Nonnull IdentityBiMap<Quantifier, PartialMatch> partialMatchMap, @Nonnull TranslationMap translationMap) {
        Verify.verify(!candidateExpression.canCorrelate());
        Verify.verify(candidateExpression.getQuantifiers().size() <= 1);
        Value translatedResultValue = this.getResultValue().translateCorrelations(translationMap, true);
        MaxMatchMap maxMatchMap = MaxMatchMap.compute(translatedResultValue, candidateExpression.getResultValue(), Quantifiers.aliases(candidateExpression.getQuantifiers()), ValueEquivalence.fromAliasMap(bindingAliasMap));
        if (this.equalsWithoutChildren(candidateExpression, bindingAliasMap)) {
            return MatchInfo.RegularMatchInfo.tryFromMatchMap(bindingAliasMap, partialMatchMap, maxMatchMap).map(ImmutableList::of).orElse(ImmutableList.of());
        }
        return ImmutableList.of();
    }

    @Nonnull
    public static Optional<TranslationMap> pullUpAndComposeTranslationMapsMaybe(@Nonnull RelationalExpression candidateExpression, @Nonnull AliasMap bindingAliasMap, @Nonnull IdentityBiMap<Quantifier, PartialMatch> partialMatchMap) {
        Map<CorrelationIdentifier, Quantifier> candidateAliasesToQuantifierMap = Quantifiers.aliasToQuantifierMap(candidateExpression.getQuantifiers());
        RegularTranslationMap.Builder translationMapBuilder = TranslationMap.regularBuilder();
        for (Map.Entry<Equivalence.Wrapper<Quantifier>, Equivalence.Wrapper<PartialMatch>> entry : partialMatchMap.entrySet()) {
            Quantifier quantifier = entry.getKey().get();
            PartialMatch partialMatch = entry.getValue().get();
            MatchInfo matchInfo = partialMatch.getMatchInfo();
            CorrelationIdentifier candidateAlias = Objects.requireNonNull(bindingAliasMap.getTarget(quantifier.getAlias()));
            MaxMatchMap maxMatchMap = matchInfo.getMaxMatchMap();
            Optional<RegularTranslationMap> quantifierTranslationMapOptional = quantifier.pullUpMaxMatchMapMaybe(maxMatchMap, candidateAlias);
            if (quantifierTranslationMapOptional.isEmpty()) {
                return Optional.empty();
            }
            Quantifier candidateQuantifier = candidateAliasesToQuantifierMap.get(candidateAlias);
            if (candidateQuantifier instanceof Quantifier.Existential) continue;
            translationMapBuilder = translationMapBuilder.compose(quantifierTranslationMapOptional.get());
        }
        return Optional.of(translationMapBuilder.build());
    }

    @Nonnull
    default public Optional<MatchInfo> adjustMatch(@Nonnull PartialMatch partialMatch) {
        return Optional.empty();
    }

    default public boolean isCompatiblyAndCompletelyBound(@Nonnull AliasMap bindingAliasMap, @Nonnull List<? extends Quantifier> candidateQuantifiers) {
        return !this.hasUnboundQuantifiers(bindingAliasMap) && !this.hasIncompatibleBoundQuantifiers(bindingAliasMap, candidateQuantifiers);
    }

    default public boolean hasUnboundQuantifiers(AliasMap aliasMap) {
        return this.getQuantifiers().stream().map(Quantifier::getAlias).anyMatch(alias -> !aliasMap.containsSource((CorrelationIdentifier)alias));
    }

    default public boolean hasIncompatibleBoundQuantifiers(AliasMap aliasMap, Collection<? extends Quantifier> otherQuantifiers) {
        BiMap<CorrelationIdentifier, Quantifier> otherAliasToQuantifierMap = Quantifiers.toBiMap(otherQuantifiers);
        return this.getQuantifiers().stream().filter(quantifier -> aliasMap.containsSource(quantifier.getAlias())).anyMatch(quantifier -> {
            Quantifier otherQuantifier = Objects.requireNonNull((Quantifier)otherAliasToQuantifierMap.get(aliasMap.getTarget(quantifier.getAlias())));
            return !quantifier.semanticEqualsWithoutChildren(otherQuantifier);
        });
    }

    @Nonnull
    default public Compensation compensate(@Nonnull PartialMatch partialMatch, @Nonnull Map<CorrelationIdentifier, ComparisonRange> boundParameterPrefixMap, @Nullable PullUp pullUp, @Nonnull CorrelationIdentifier candidateAlias) {
        throw new RecordCoreException("expression matched but no compensation logic implemented", new Object[0]);
    }

    @Override
    @Nonnull
    default public RelationalExpression rebase(@Nonnull AliasMap aliasMap) {
        throw new UnsupportedOperationException("rebase unsupported on relational expression");
    }

    @Nonnull
    default public RelationalExpression withQuantifiers(@Nonnull List<? extends Quantifier> newQuantifiers) {
        return this.translateCorrelations(TranslationMap.empty(), false, newQuantifiers);
    }

    @Nonnull
    public RelationalExpression translateCorrelations(@Nonnull TranslationMap var1, boolean var2, @Nonnull List<? extends Quantifier> var3);

    @Nonnull
    default public Set<Quantifier> getMatchedQuantifiers(@Nonnull PartialMatch partialMatch) {
        return ImmutableSet.of();
    }

    @Override
    default public int semanticHashCode() {
        return Objects.hash(this.getQuantifiers().stream().map(Quantifier::semanticHashCode).collect(ImmutableSet.toImmutableSet()), this.hashCodeWithoutChildren());
    }

    @Nullable
    default public <U> U acceptVisitor(@Nonnull SimpleExpressionVisitor<U> simpleExpressionVisitor) {
        if (simpleExpressionVisitor.shouldVisit(this)) {
            return (U)simpleExpressionVisitor.visit(this);
        }
        return null;
    }

    @Nonnull
    default public String show(boolean renderSingleGroups) {
        return PlannerGraphVisitor.show(renderSingleGroups, this);
    }

    @Nonnull
    default public String showExploratory() {
        return PlannerGraphVisitor.show(6, this);
    }

    @FunctionalInterface
    public static interface CombinePredicate {
        public boolean combine(@Nonnull AliasMap var1, @Nonnull Iterable<AliasMap> var2);
    }

    @FunctionalInterface
    public static interface CombineFunction<R, S> {
        @Nonnull
        public Iterable<S> combine(@Nonnull AliasMap var1, @Nonnull Iterable<BoundMatch<EnumeratingIterable<R>>> var2);
    }
}

