/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.combinatorics.PartiallyOrderedSet;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.PartialMatch;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifiers;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public interface RelationalExpressionWithChildren
extends RelationalExpression {
    public int getRelationalChildCount();

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> getCorrelatedToWithoutChildren();

    @Override
    @Nonnull
    default public Set<Quantifier> getMatchedQuantifiers(@Nonnull PartialMatch partialMatch) {
        return partialMatch.getMatchedQuantifiers();
    }

    @Override
    @Nonnull
    default public PartiallyOrderedSet<CorrelationIdentifier> getCorrelationOrder() {
        if (this.canCorrelate()) {
            Map<CorrelationIdentifier, Quantifier> aliasToQuantifierMap = Quantifiers.aliasToQuantifierMap(this.getQuantifiers());
            return PartiallyOrderedSet.of((Set)this.getQuantifiers().stream().map(Quantifier::getAlias).collect(ImmutableSet.toImmutableSet()), alias -> Objects.requireNonNull((Quantifier)aliasToQuantifierMap.get(alias)).getCorrelatedTo());
        }
        return PartiallyOrderedSet.empty();
    }

    public static interface ChildrenAsSet
    extends RelationalExpressionWithChildren {
    }
}

