/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.expressions;

import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.predicates.PredicateWithComparisons;
import com.apple.foundationdb.record.query.plan.cascades.predicates.PredicateWithValue;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.FieldValue;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public interface RelationalExpressionWithPredicates
extends RelationalExpression {
    @Nonnull
    public List<? extends QueryPredicate> getPredicates();

    @Override
    @Nonnull
    default public Set<Type> getDynamicTypes() {
        ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
        resultBuilder.addAll(RelationalExpression.super.getDynamicTypes());
        for (QueryPredicate queryPredicate : this.getPredicates()) {
            Set typesForPredicate = queryPredicate.fold(p -> {
                ImmutableSet.Builder typesBuilder = ImmutableSet.builder();
                if (p instanceof PredicateWithValue) {
                    typesBuilder.addAll(Objects.requireNonNull(((PredicateWithValue)p).getValue()).getDynamicTypes());
                }
                if (p instanceof PredicateWithComparisons) {
                    List<Comparisons.Comparison> comparisons = ((PredicateWithComparisons)((Object)p)).getComparisons();
                    for (Comparisons.Comparison comparison : comparisons) {
                        if (!(comparison instanceof Comparisons.ValueComparison)) continue;
                        typesBuilder.addAll(comparison.getValue().getDynamicTypes());
                    }
                }
                return typesBuilder.build();
            }, (thisTypes, childTypeSets) -> {
                ImmutableSet.Builder nestedBuilder = ImmutableSet.builder();
                for (Set childTypes : childTypeSets) {
                    nestedBuilder.addAll((Iterable)childTypes);
                }
                nestedBuilder.addAll((Iterable)thisTypes);
                return nestedBuilder.build();
            });
            resultBuilder.addAll((Iterable)typesForPredicate);
        }
        return resultBuilder.build();
    }

    @Nonnull
    default public ImmutableSet<FieldValue> fieldValuesFromPredicates() {
        return RelationalExpressionWithPredicates.fieldValuesFromPredicates(this.getPredicates());
    }

    @Nonnull
    public static ImmutableSet<FieldValue> fieldValuesFromPredicates(@Nonnull Collection<? extends QueryPredicate> predicates) {
        return RelationalExpressionWithPredicates.fieldValuesFromPredicates(predicates, queryPredicate -> true);
    }

    @Nonnull
    public static ImmutableSet<FieldValue> fieldValuesFromPredicates(@Nonnull Collection<? extends QueryPredicate> predicates, @Nonnull Predicate<PredicateWithValue> filteringPredicate) {
        return predicates.stream().flatMap(predicate -> predicate.preOrderStream().filter(p -> p instanceof PredicateWithValue && filteringPredicate.test((PredicateWithValue)p)).map(p -> (PredicateWithValue)p).flatMap(predicateWithValue -> predicateWithValue.getValue().preOrderStream().filter(FieldValue.class::isInstance)).map(value -> (FieldValue)value)).map(fieldValue -> {
            Set<CorrelationIdentifier> fieldCorrelatedTo = fieldValue.getChild().getCorrelatedTo();
            CorrelationIdentifier alias = Iterables.getOnlyElement(fieldCorrelatedTo);
            return (FieldValue)fieldValue.rebase(AliasMap.ofAliases(alias, Quantifier.current()));
        }).collect(ImmutableSet.toImmutableSet());
    }
}

