/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.query.combinatorics.CrossProduct;
import com.apple.foundationdb.record.query.combinatorics.EnumeratingIterable;
import com.apple.foundationdb.record.query.combinatorics.PartiallyOrderedSet;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.ComparisonRange;
import com.apple.foundationdb.record.query.plan.cascades.Compensation;
import com.apple.foundationdb.record.query.plan.cascades.Correlated;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.GroupByMappings;
import com.apple.foundationdb.record.query.plan.cascades.IdentityBiMap;
import com.apple.foundationdb.record.query.plan.cascades.IterableHelpers;
import com.apple.foundationdb.record.query.plan.cascades.LinkedIdentityMap;
import com.apple.foundationdb.record.query.plan.cascades.MatchInfo;
import com.apple.foundationdb.record.query.plan.cascades.PartialMatch;
import com.apple.foundationdb.record.query.plan.cascades.PredicateMap;
import com.apple.foundationdb.record.query.plan.cascades.PredicateMultiMap;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.Quantifiers;
import com.apple.foundationdb.record.query.plan.cascades.UsesValueEquivalence;
import com.apple.foundationdb.record.query.plan.cascades.ValueEquivalence;
import com.apple.foundationdb.record.query.plan.cascades.explain.InternalPlannerGraphRewritable;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpressionWithChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpressionWithPredicates;
import com.apple.foundationdb.record.query.plan.cascades.predicates.AndOrPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.AndPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.ExistsPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.OrPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.Placeholder;
import com.apple.foundationdb.record.query.plan.cascades.predicates.PredicateWithValue;
import com.apple.foundationdb.record.query.plan.cascades.predicates.PredicateWithValueAndRanges;
import com.apple.foundationdb.record.query.plan.cascades.predicates.QueryPredicate;
import com.apple.foundationdb.record.query.plan.cascades.predicates.RangeConstraints;
import com.apple.foundationdb.record.query.plan.cascades.predicates.ValuePredicate;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.Values;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.MaxMatchMap;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.PullUp;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.apple.foundationdb.record.util.pair.Pair;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class SelectExpression
extends AbstractRelationalExpressionWithChildren
implements RelationalExpressionWithChildren.ChildrenAsSet,
RelationalExpressionWithPredicates,
InternalPlannerGraphRewritable {
    @Nonnull
    private final Value resultValue;
    @Nonnull
    private final List<Quantifier> children;
    @Nonnull
    private final List<? extends QueryPredicate> predicates;
    @Nonnull
    private final Supplier<Map<CorrelationIdentifier, ? extends Quantifier>> aliasToQuantifierMapSupplier;
    @Nonnull
    private final Supplier<PartiallyOrderedSet<CorrelationIdentifier>> correlationOrderSupplier;
    @Nonnull
    private final Supplier<Set<Set<CorrelationIdentifier>>> independentQuantifiersPartitioningSupplier;

    public SelectExpression(@Nonnull Value resultValue, @Nonnull List<? extends Quantifier> children, @Nonnull List<? extends QueryPredicate> predicates) {
        this.resultValue = resultValue;
        this.children = ImmutableList.copyOf(children);
        this.predicates = predicates.isEmpty() ? ImmutableList.of() : SelectExpression.partitionPredicates(predicates);
        this.aliasToQuantifierMapSupplier = Suppliers.memoize(() -> Quantifiers.aliasToQuantifierMap(children));
        this.correlationOrderSupplier = Suppliers.memoize(this::computeCorrelationOrder);
        this.independentQuantifiersPartitioningSupplier = Suppliers.memoize(this::computeIndependentQuantifiersPartitioning);
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return this.resultValue;
    }

    @Nonnull
    public List<? extends Value> getResultValues() {
        return Values.deconstructRecord(this.getResultValue());
    }

    @Override
    @Nonnull
    public List<? extends QueryPredicate> getPredicates() {
        return this.predicates;
    }

    public boolean hasPredicates() {
        return !this.predicates.isEmpty();
    }

    @Override
    @Nonnull
    public List<? extends Quantifier> getQuantifiers() {
        return this.children;
    }

    @Override
    public int getRelationalChildCount() {
        return this.children.size();
    }

    @Override
    public boolean canCorrelate() {
        return true;
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return Streams.concat(this.predicates.stream().flatMap(queryPredicate -> queryPredicate.getCorrelatedTo().stream()), this.resultValue.getCorrelatedTo().stream()).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    @Nonnull
    public SelectExpression translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        List translatedPredicates = this.predicates.stream().map(p -> p.translateCorrelations(translationMap, shouldSimplifyValues)).collect(Collectors.toList());
        Value translatedResultValue = this.resultValue.translateCorrelations(translationMap, shouldSimplifyValues);
        return new SelectExpression(translatedResultValue, translatedQuantifiers, translatedPredicates);
    }

    public boolean equals(Object other) {
        return this.semanticEquals(other);
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap aliasMap) {
        if (this == otherExpression) {
            return true;
        }
        if (this.getClass() != otherExpression.getClass()) {
            return false;
        }
        List<? extends QueryPredicate> otherPredicates = ((SelectExpression)otherExpression).getPredicates();
        return this.semanticEqualsForResults(otherExpression, aliasMap) && this.predicates.size() == otherPredicates.size() && Streams.zip(this.predicates.stream(), otherPredicates.stream(), (queryPredicate, otherQueryPredicate) -> queryPredicate.semanticEquals(otherQueryPredicate, aliasMap)).allMatch(isSame -> isSame);
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(this.getPredicates(), this.getResultValue());
    }

    @Nonnull
    public Map<CorrelationIdentifier, ? extends Quantifier> getAliasToQuantifierMap() {
        return this.aliasToQuantifierMapSupplier.get();
    }

    @Override
    @Nonnull
    public PartiallyOrderedSet<CorrelationIdentifier> getCorrelationOrder() {
        return this.correlationOrderSupplier.get();
    }

    @Nonnull
    private PartiallyOrderedSet<CorrelationIdentifier> computeCorrelationOrder() {
        return RelationalExpressionWithChildren.ChildrenAsSet.super.getCorrelationOrder();
    }

    @Nonnull
    public Set<Set<CorrelationIdentifier>> getIndependentQuantifiersPartitioning() {
        return this.independentQuantifiersPartitioningSupplier.get();
    }

    @Nonnull
    private Set<Set<CorrelationIdentifier>> computeIndependentQuantifiersPartitioning() {
        ImmutableSetMultimap<CorrelationIdentifier, CorrelationIdentifier> fullCorrelationOrder = this.getCorrelationOrder().getTransitiveClosure();
        HashSet<Set<CorrelationIdentifier>> partitioning = Sets.newHashSet();
        List<? extends Quantifier> quantifiers = this.getQuantifiers();
        quantifiers.forEach(quantifier -> partitioning.add(Sets.newHashSet(quantifier.getAlias())));
        IdentityHashMap<QueryPredicate, Set> predicateTransitivelyCorrelatedToMap = new IdentityHashMap<QueryPredicate, Set>();
        for (QueryPredicate queryPredicate : this.getPredicates()) {
            ImmutableSet transitivelyCorrelatedTo2 = queryPredicate.getCorrelatedTo().stream().flatMap(alias -> fullCorrelationOrder.get(alias).stream()).collect(ImmutableSet.toImmutableSet());
            predicateTransitivelyCorrelatedToMap.put(queryPredicate, transitivelyCorrelatedTo2);
        }
        for (Quantifier quantifier2 : this.getQuantifiers()) {
            CorrelationIdentifier alias2 = quantifier2.getAlias();
            ImmutableSet.Builder connectedAliasesBuilder = ImmutableSet.builder();
            connectedAliasesBuilder.add(alias2);
            connectedAliasesBuilder.addAll((Iterable)fullCorrelationOrder.get((Object)alias2));
            predicateTransitivelyCorrelatedToMap.forEach((predicate, transitivelyCorrelatedTo) -> {
                if (transitivelyCorrelatedTo.contains(alias2)) {
                    connectedAliasesBuilder.addAll((Iterable)transitivelyCorrelatedTo);
                }
            });
            ImmutableCollection connectedAliases = connectedAliasesBuilder.build();
            HashSet<CorrelationIdentifier> newPartition = Sets.newHashSet();
            Iterator<Set<CorrelationIdentifier>> partitioningIterator = partitioning.iterator();
            while (partitioningIterator.hasNext()) {
                Set<CorrelationIdentifier> partition = partitioningIterator.next();
                if (!connectedAliases.stream().anyMatch(partition::contains)) continue;
                newPartition.addAll(partition);
                partitioningIterator.remove();
            }
            partitioning.add(newPartition);
            if (partitioning.size() != 1) continue;
            return partitioning;
        }
        return partitioning;
    }

    @Override
    @Nonnull
    public Iterable<MatchInfo> subsumedBy(@Nonnull RelationalExpression candidateExpression, @Nonnull AliasMap bindingAliasMap, @Nonnull IdentityBiMap<Quantifier, PartialMatch> partialMatchMap, @Nonnull EvaluationContext evaluationContext) {
        Verify.verify(this != candidateExpression);
        if (this.getClass() != candidateExpression.getClass()) {
            return ImmutableList.of();
        }
        SelectExpression candidateSelectExpression = (SelectExpression)candidateExpression;
        Collection<MatchInfo> matchInfos = PartialMatch.matchInfosFromMap(partialMatchMap);
        ImmutableList<Map<CorrelationIdentifier, ComparisonRange>> parameterBindingMaps = matchInfos.stream().map(MatchInfo::getRegularMatchInfo).map(MatchInfo.RegularMatchInfo::getParameterBindingMap).collect(ImmutableList.toImmutableList());
        Optional<Map<CorrelationIdentifier, ComparisonRange>> mergedParameterBindingMapOptional = MatchInfo.RegularMatchInfo.tryMergeParameterBindings(parameterBindingMaps);
        if (mergedParameterBindingMapOptional.isEmpty()) {
            return ImmutableList.of();
        }
        Map<CorrelationIdentifier, ComparisonRange> mergedParameterBindingMap = mergedParameterBindingMapOptional.get();
        ImmutableSet.Builder matchedCorrelatedToBuilder = ImmutableSet.builder();
        for (Quantifier quantifier2 : this.getQuantifiers()) {
            PartialMatch partialMatch;
            if (!partialMatchMap.containsKeyUnwrapped(quantifier2)) continue;
            if (quantifier2 instanceof Quantifier.ForEach && !(partialMatch = Objects.requireNonNull(partialMatchMap.getUnwrapped(quantifier2))).compensationCanBeDeferred()) {
                return ImmutableList.of();
            }
            matchedCorrelatedToBuilder.addAll(quantifier2.getCorrelatedTo());
        }
        Map<CorrelationIdentifier, Quantifier> candidateQuantifierMap = Quantifiers.aliasToQuantifierMap(candidateExpression.getQuantifiers());
        for (Quantifier quantifier3 : this.getQuantifiers()) {
            if (!(quantifier3 instanceof Quantifier.ForEach)) continue;
            CorrelationIdentifier candidateAlias = bindingAliasMap.getTarget(quantifier3.getAlias());
            if (candidateAlias == null) {
                return ImmutableList.of();
            }
            Quantifier candidateQuantifier = Objects.requireNonNull(candidateQuantifierMap.get(candidateAlias));
            if (!(candidateQuantifier instanceof Quantifier.ForEach)) {
                return ImmutableList.of();
            }
            if (((Quantifier.ForEach)quantifier3).isNullOnEmpty() == ((Quantifier.ForEach)candidateQuantifier).isNullOnEmpty()) continue;
            return ImmutableList.of();
        }
        boolean bl = candidateSelectExpression.getQuantifiers().stream().filter(quantifier -> quantifier instanceof Quantifier.ForEach).allMatch(quantifier -> bindingAliasMap.containsTarget(quantifier.getAlias()));
        if (!bl) {
            return ImmutableList.of();
        }
        if (this.getQuantifiers().stream().filter(quantifier -> quantifier instanceof Quantifier.Existential && bindingAliasMap.containsSource(quantifier.getAlias())).anyMatch(quantifier -> this.getPredicates().stream().noneMatch(predicate -> predicate instanceof ExistsPredicate && ((ExistsPredicate)predicate).getExistentialAlias().equals(quantifier.getAlias())))) {
            return ImmutableList.of();
        }
        Optional<TranslationMap> optional = RelationalExpression.pullUpAndComposeTranslationMapsMaybe(candidateExpression, bindingAliasMap, partialMatchMap);
        if (optional.isEmpty()) {
            return ImmutableList.of();
        }
        TranslationMap translationMap = optional.get();
        Value translatedResultValue = this.getResultValue().translateCorrelations(translationMap, true);
        ValueEquivalence bindingValueEquivalence = ValueEquivalence.fromAliasMap(bindingAliasMap).then(ValueEquivalence.constantEquivalenceWithEvaluationContext(evaluationContext));
        LinkedIdentityMap<QueryPredicate, List> predicateMappingsMap = new LinkedIdentityMap<QueryPredicate, List>();
        if (this.getPredicates().isEmpty()) {
            boolean allNonFiltering = candidateSelectExpression.getPredicates().stream().allMatch(QueryPredicate::isTautology);
            if (allNonFiltering) {
                MaxMatchMap maxMatchMap = MaxMatchMap.compute(translatedResultValue, candidateExpression.getResultValue(), Quantifiers.aliases(candidateExpression.getQuantifiers()), bindingValueEquivalence);
                return MatchInfo.RegularMatchInfo.tryMerge(bindingAliasMap, partialMatchMap, mergedParameterBindingMap, PredicateMap.empty(), maxMatchMap, GroupByMappings.empty(), null, maxMatchMap.getQueryPlanConstraint()).map(ImmutableList::of).orElse(ImmutableList.of());
            }
            return ImmutableList.of();
        }
        PartiallyOrderedSet<CorrelationIdentifier> correlationOrder = this.getCorrelationOrder();
        ImmutableSet<CorrelationIdentifier> localAliases = correlationOrder.getSet();
        ImmutableSetMultimap<CorrelationIdentifier, CorrelationIdentifier> dependsOnMap = correlationOrder.getTransitiveClosure();
        Map<CorrelationIdentifier, Quantifier> quantifierMap = Quantifiers.aliasToQuantifierMap(this.getQuantifiers());
        for (QueryPredicate queryPredicate : this.getPredicates()) {
            ImmutableSet predicateCorrelatedTo = queryPredicate.getCorrelatedTo().stream().filter(localAliases::contains).collect(ImmutableSet.toImmutableSet());
            for (CorrelationIdentifier correlatedAlias : predicateCorrelatedTo) {
                if (bindingAliasMap.containsSource(correlatedAlias)) continue;
                if (quantifierMap.get(correlatedAlias) instanceof Quantifier.Existential) {
                    ImmutableCollection correlatedDependsOn = dependsOnMap.get((Object)correlatedAlias);
                    for (CorrelationIdentifier dependsOnAlias : correlatedDependsOn) {
                        if (bindingAliasMap.containsSource(dependsOnAlias)) continue;
                        return ImmutableList.of();
                    }
                    continue;
                }
                return ImmutableList.of();
            }
            QueryPredicate translatedPredicate = queryPredicate.translateCorrelations(translationMap, true);
            Collection<PredicateMultiMap.PredicateMapping> impliedMappingsForPredicate = translatedPredicate.findImpliedMappings(bindingValueEquivalence, queryPredicate, candidateSelectExpression.getPredicates(), evaluationContext);
            for (PredicateMultiMap.PredicateMapping predicateMapping : impliedMappingsForPredicate) {
                List currentPredicateMappings = predicateMappingsMap.computeIfAbsent(predicateMapping.getCandidatePredicate(), k -> Lists.newArrayList());
                currentPredicateMappings.add(predicateMapping);
            }
        }
        EnumeratingIterable crossedMappings = CrossProduct.crossProduct(predicateMappingsMap.values());
        return IterableHelpers.flatMap(crossedMappings, predicateMappings -> {
            Set<? extends QueryPredicate> remainingUnmappedCandidatePredicates = Sets.newIdentityHashSet();
            remainingUnmappedCandidatePredicates.addAll(candidateSelectExpression.getPredicates());
            HashMap<CorrelationIdentifier, ComparisonRange> parameterBindingMap = Maps.newHashMap();
            PredicateMultiMap.Builder predicateMapBuilder = PredicateMultiMap.builder();
            for (PredicateMultiMap.PredicateMapping predicateMapping : predicateMappings) {
                QueryPredicate originalQueryPredicate = predicateMapping.getOriginalQueryPredicate();
                QueryPredicate candidatePredicate = predicateMapping.getCandidatePredicate();
                predicateMapBuilder.put(originalQueryPredicate, predicateMapping);
                remainingUnmappedCandidatePredicates.remove(candidatePredicate);
                Optional<CorrelationIdentifier> parameterAliasOptional = predicateMapping.getParameterAliasOptional();
                Optional<ComparisonRange> comparisonRangeOptional = predicateMapping.getComparisonRangeOptional();
                if (!parameterAliasOptional.isPresent() || !comparisonRangeOptional.isPresent()) continue;
                parameterBindingMap.put(parameterAliasOptional.get(), comparisonRangeOptional.get());
            }
            remainingUnmappedCandidatePredicates.removeIf(QueryPredicate::isTautology);
            if (!remainingUnmappedCandidatePredicates.isEmpty()) {
                return ImmutableList.of();
            }
            Optional<? extends PredicateMultiMap> predicateMapOptional = predicateMapBuilder.buildMaybe();
            return predicateMapOptional.map(predicateMap -> {
                Optional<Map<CorrelationIdentifier, ComparisonRange>> allParameterBindingMapOptional = MatchInfo.RegularMatchInfo.tryMergeParameterBindings(ImmutableList.of(mergedParameterBindingMap, parameterBindingMap));
                return allParameterBindingMapOptional.flatMap(allParameterBindingMap -> {
                    MaxMatchMap maxMatchMap = MaxMatchMap.compute(translatedResultValue, candidateExpression.getResultValue(), Quantifiers.aliases(candidateExpression.getQuantifiers()), bindingValueEquivalence);
                    return MatchInfo.RegularMatchInfo.tryMerge(bindingAliasMap, partialMatchMap, allParameterBindingMap, predicateMap, maxMatchMap, GroupByMappings.empty(), null, maxMatchMap.getQueryPlanConstraint());
                }).map(ImmutableList::of).orElse(ImmutableList.of());
            }).orElse(ImmutableList.of());
        });
    }

    @Override
    @Nonnull
    public Optional<MatchInfo> adjustMatch(@Nonnull PartialMatch partialMatch) {
        MatchInfo childMatchInfo = partialMatch.getMatchInfo();
        for (QueryPredicate queryPredicate : this.getPredicates()) {
            if (!(queryPredicate instanceof Placeholder ? !((Placeholder)queryPredicate).getRanges().isEmpty() : !queryPredicate.isTautology())) continue;
            return Optional.empty();
        }
        MaxMatchMap maxMatchMap = childMatchInfo.getMaxMatchMap();
        Quantifier quantifier = Iterables.getOnlyElement(this.getQuantifiers());
        Optional<MaxMatchMap> adjustedMaxMatchMapOptional = maxMatchMap.adjustMaybe(quantifier.getAlias(), this.getResultValue(), Quantifiers.aliases(this.getQuantifiers()));
        return adjustedMaxMatchMapOptional.map(adjustedMaxMatchMap -> childMatchInfo.adjustedBuilder().setMaxMatchMap((MaxMatchMap)adjustedMaxMatchMap).setGroupByMappings(childMatchInfo.adjustGroupByMappings(Iterables.getOnlyElement(this.getQuantifiers()))).build());
    }

    @Override
    @Nonnull
    public PlannerGraph rewriteInternalPlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        String predicateString = "WHERE " + this.getPredicates().stream().map(Object::toString).collect(Collectors.joining(" AND "));
        String abbreviatedPredicateString = predicateString.length() > 30 ? String.format(Locale.ROOT, "%02x", predicateString.hashCode()) : predicateString;
        return PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.LogicalOperatorNode(this, "SELECT " + String.valueOf(this.resultValue), this.getPredicates().isEmpty() ? ImmutableList.of() : ImmutableList.of(abbreviatedPredicateString), ImmutableMap.of()), childGraphs);
    }

    public String toString() {
        String selectFrom = "SELECT " + String.valueOf(this.resultValue) + " FROM " + Quantifiers.aliases(this.getQuantifiers()).stream().map(CorrelationIdentifier::toString).collect(Collectors.joining(", "));
        if (!this.getPredicates().isEmpty()) {
            return selectFrom + " WHERE " + String.valueOf(AndPredicate.and(this.getPredicates()));
        }
        return selectFrom;
    }

    private static List<? extends QueryPredicate> partitionPredicates(@Nonnull List<? extends QueryPredicate> predicates) {
        ImmutableList flattenedAndPredicates = predicates.stream().flatMap(predicate -> SelectExpression.flattenPredicate(AndPredicate.class, predicate).stream()).collect(ImmutableList.toImmutableList());
        ImmutableList.Builder predicateWithValuesBuilder = ImmutableList.builder();
        ImmutableList.Builder resultPredicatesBuilder = ImmutableList.builder();
        for (QueryPredicate flattenedAndPredicate : flattenedAndPredicates) {
            if (flattenedAndPredicate instanceof PredicateWithValue) {
                predicateWithValuesBuilder.add((PredicateWithValue)flattenedAndPredicate);
                continue;
            }
            resultPredicatesBuilder.add(flattenedAndPredicate);
        }
        ImmutableCollection predicateWithValues = predicateWithValuesBuilder.build();
        AliasMap boundIdentitiesMap = AliasMap.identitiesFor(flattenedAndPredicates.stream().flatMap(predicate -> predicate.getCorrelatedTo().stream()).collect(ImmutableSet.toImmutableSet()));
        Correlated.BoundEquivalence boundEquivalence = new Correlated.BoundEquivalence(boundIdentitiesMap);
        LinkedHashMultimap partitionedPredicatesWithValues = predicateWithValues.stream().collect(Multimaps.toMultimap(predicate -> boundEquivalence.wrap(predicate.getValue()), Function.identity(), LinkedHashMultimap::create));
        partitionedPredicatesWithValues.asMap().forEach((valueWrapper, predicatesOnValue) -> {
            Value value = Objects.requireNonNull((Value)valueWrapper.get());
            List<QueryPredicate> simplifiedConjunction = SelectExpression.simplifyConjunction(value, predicatesOnValue);
            resultPredicatesBuilder.addAll(simplifiedConjunction);
        });
        return resultPredicatesBuilder.build();
    }

    @Nonnull
    private static List<QueryPredicate> simplifyConjunction(@Nonnull Value value, @Nonnull Collection<PredicateWithValue> predicates) {
        ImmutableList.Builder result = ImmutableList.builder();
        RangeConstraints.Builder rangeBuilder = RangeConstraints.newBuilder();
        for (PredicateWithValue predicate : predicates) {
            UsesValueEquivalence<Comparisons.Comparison> predicateRange;
            if (predicate instanceof ValuePredicate) {
                predicateRange = ((ValuePredicate)predicate).getComparison();
                if (rangeBuilder.addComparisonMaybe((Comparisons.Comparison)predicateRange)) continue;
                result.add(value.withComparison((Comparisons.Comparison)predicateRange));
                continue;
            }
            if (predicate instanceof PredicateWithValueAndRanges && ((PredicateWithValueAndRanges)predicate).isSargable()) {
                predicateRange = Iterables.getOnlyElement(((PredicateWithValueAndRanges)predicate).getRanges());
                rangeBuilder.add((RangeConstraints)predicateRange);
                continue;
            }
            result.add(predicate);
        }
        Optional<RangeConstraints> rangeMaybe = rangeBuilder.build();
        rangeMaybe.ifPresent(range -> result.add(PredicateWithValueAndRanges.sargable(value, range)));
        return result.build();
    }

    @Nonnull
    private static List<QueryPredicate> flattenPredicate(@Nonnull Class<? extends AndOrPredicate> classToLift, @Nonnull QueryPredicate predicate) {
        ImmutableList.Builder result = ImmutableList.builder();
        if (predicate.isAtomic()) {
            result.add(predicate);
        } else if (classToLift.isInstance(predicate)) {
            for (QueryPredicate child : ((AndOrPredicate)predicate).getChildren()) {
                result.addAll(SelectExpression.flattenPredicate(classToLift, child));
            }
        } else {
            QueryPredicate flattenedChildPredicate = predicate instanceof AndPredicate ? AndPredicate.and(SelectExpression.flattenPredicate(AndPredicate.class, predicate)) : (predicate instanceof OrPredicate ? OrPredicate.or(SelectExpression.flattenPredicate(OrPredicate.class, predicate)) : predicate);
            result.add(flattenedChildPredicate);
        }
        return result.build();
    }

    @Override
    @Nonnull
    public Compensation compensate(@Nonnull PartialMatch partialMatch, @Nonnull Map<CorrelationIdentifier, ComparisonRange> boundParameterPrefixMap, @Nullable PullUp pullUp, @Nonnull CorrelationIdentifier candidateAlias) {
        boolean isCompensationNeeded;
        LinkedIdentityMap<QueryPredicate, PredicateMultiMap.PredicateCompensationFunction> predicateCompensationMap = new LinkedIdentityMap<QueryPredicate, PredicateMultiMap.PredicateCompensationFunction>();
        MatchInfo.RegularMatchInfo regularMatchInfo = partialMatch.getRegularMatchInfo();
        List<? extends Quantifier> quantifiers = this.getQuantifiers();
        Pair<PullUp, PullUp> nestedPullUpPair = partialMatch.nestPullUp(pullUp, candidateAlias);
        PullUp rootOfMatchPullUp = nestedPullUpPair.getKey();
        PullUp adjustedPullUp = Objects.requireNonNull(nestedPullUpPair.getRight());
        Compensation childCompensation = quantifiers.stream().filter(quantifier -> quantifier instanceof Quantifier.ForEach).flatMap(quantifier -> regularMatchInfo.getChildPartialMatchMaybe((Quantifier)quantifier).map(childPartialMatch -> {
            AliasMap bindingAliasMap = regularMatchInfo.getBindingAliasMap();
            return childPartialMatch.compensate(boundParameterPrefixMap, adjustedPullUp, Objects.requireNonNull(bindingAliasMap.getTarget(quantifier.getAlias())));
        }).stream()).reduce(Compensation.noCompensation(), Compensation::union);
        if (childCompensation.isImpossible() || !childCompensation.canBeDeferred()) {
            return Compensation.impossibleCompensation();
        }
        PredicateMultiMap predicateMap = regularMatchInfo.getPredicateMap();
        Set<Quantifier> unmatchedQuantifiers = partialMatch.getUnmatchedQuantifiers();
        ImmutableList unmatchedQuantifierAliases = unmatchedQuantifiers.stream().map(Quantifier::getAlias).collect(ImmutableList.toImmutableList());
        boolean isAnyCompensationFunctionImpossible = false;
        boolean isAnyCompensationFunctionNeeded = false;
        for (QueryPredicate queryPredicate : this.getPredicates()) {
            Set<PredicateMultiMap.PredicateMapping> predicateMappings = predicateMap.get(queryPredicate);
            if (predicateMappings.isEmpty()) continue;
            if (queryPredicate.getCorrelatedTo().stream().anyMatch(unmatchedQuantifierAliases::contains)) {
                isAnyCompensationFunctionImpossible = true;
            }
            PredicateMultiMap.PredicateCompensationFunction compensationFunction = null;
            boolean isCompensationFunctionNeeded = true;
            boolean isCompensationFunctionImpossible = true;
            for (PredicateMultiMap.PredicateMapping predicateMapping : predicateMappings) {
                PredicateMultiMap.PredicateCompensationFunction compensationFunctionForCandidatePredicate = predicateMapping.getPredicateCompensation().computeCompensationFunction(partialMatch, boundParameterPrefixMap, adjustedPullUp);
                if (!compensationFunctionForCandidatePredicate.isNeeded()) {
                    isCompensationFunctionNeeded = false;
                    break;
                }
                if (compensationFunction == null) {
                    compensationFunction = compensationFunctionForCandidatePredicate;
                }
                if (compensationFunctionForCandidatePredicate.isImpossible()) continue;
                isCompensationFunctionImpossible = false;
            }
            if (!isCompensationFunctionNeeded) continue;
            isAnyCompensationFunctionNeeded = true;
            if (isCompensationFunctionImpossible) {
                isAnyCompensationFunctionImpossible = true;
            }
            predicateCompensationMap.put(queryPredicate, Objects.requireNonNull(compensationFunction));
        }
        Optional<Compensation.CompensatedResult> compensatedResultOptional = Compensation.computeResultCompensation(partialMatch, rootOfMatchPullUp);
        if (compensatedResultOptional.isEmpty()) {
            return Compensation.impossibleCompensation();
        }
        Compensation.CompensatedResult compensatedResult = compensatedResultOptional.get();
        isAnyCompensationFunctionImpossible |= compensatedResult.isCompensationImpossible();
        boolean bl = isCompensationNeeded = childCompensation.isNeeded() || !unmatchedQuantifiers.isEmpty() || isAnyCompensationFunctionNeeded || compensatedResult.getResultCompensationFunction().isNeeded();
        if (!isCompensationNeeded) {
            return Compensation.noCompensation();
        }
        IdentityBiMap<Quantifier, PartialMatch> partialMatchMap = regularMatchInfo.getPartialMatchMap();
        if (quantifiers.stream().filter(quantifier -> quantifier instanceof Quantifier.ForEach && partialMatchMap.containsKeyUnwrapped(quantifier)).count() > 1L) {
            return Compensation.impossibleCompensation();
        }
        return childCompensation.derived(isAnyCompensationFunctionImpossible, predicateCompensationMap, this.getMatchedQuantifiers(partialMatch), partialMatch.getUnmatchedQuantifiers(), partialMatch.getCompensatedAliases(), compensatedResult.getResultCompensationFunction(), compensatedResult.getGroupByMappings());
    }
}

