/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.cascades.expressions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.query.plan.cascades.AliasMap;
import com.apple.foundationdb.record.query.plan.cascades.ComparisonRange;
import com.apple.foundationdb.record.query.plan.cascades.Compensation;
import com.apple.foundationdb.record.query.plan.cascades.CorrelationIdentifier;
import com.apple.foundationdb.record.query.plan.cascades.IdentityBiMap;
import com.apple.foundationdb.record.query.plan.cascades.MatchInfo;
import com.apple.foundationdb.record.query.plan.cascades.PartialMatch;
import com.apple.foundationdb.record.query.plan.cascades.Quantifier;
import com.apple.foundationdb.record.query.plan.cascades.explain.InternalPlannerGraphRewritable;
import com.apple.foundationdb.record.query.plan.cascades.explain.PlannerGraph;
import com.apple.foundationdb.record.query.plan.cascades.expressions.AbstractRelationalExpressionWithoutChildren;
import com.apple.foundationdb.record.query.plan.cascades.expressions.RelationalExpression;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.cascades.values.QueriedValue;
import com.apple.foundationdb.record.query.plan.cascades.values.StreamingValue;
import com.apple.foundationdb.record.query.plan.cascades.values.Value;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.PullUp;
import com.apple.foundationdb.record.query.plan.cascades.values.translation.TranslationMap;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class TableFunctionExpression
extends AbstractRelationalExpressionWithoutChildren
implements InternalPlannerGraphRewritable {
    @Nonnull
    private final StreamingValue value;

    public TableFunctionExpression(@Nonnull StreamingValue value) {
        this.value = value;
    }

    @Override
    @Nonnull
    public Value getResultValue() {
        return new QueriedValue(this.value.getResultType());
    }

    @Override
    @Nonnull
    public Set<Type> getDynamicTypes() {
        return this.value.getDynamicTypes();
    }

    @Nonnull
    public StreamingValue getValue() {
        return this.value;
    }

    @Override
    @Nonnull
    public List<? extends Quantifier> getQuantifiers() {
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public Set<CorrelationIdentifier> computeCorrelatedToWithoutChildren() {
        return this.value.getCorrelatedTo();
    }

    @Override
    public boolean equalsWithoutChildren(@Nonnull RelationalExpression otherExpression, @Nonnull AliasMap equivalencesMap) {
        if (this == otherExpression) {
            return true;
        }
        if (!(otherExpression instanceof TableFunctionExpression)) {
            return false;
        }
        TableFunctionExpression otherTableFunctionExpression = (TableFunctionExpression)otherExpression;
        return this.value.semanticEquals((Object)otherTableFunctionExpression.getValue(), equivalencesMap);
    }

    @Override
    public int computeHashCodeWithoutChildren() {
        return Objects.hash(this.value);
    }

    @SpotBugsSuppressWarnings(value={"EQ_UNUSUAL"})
    public boolean equals(Object other) {
        return this.semanticEquals(other);
    }

    public int hashCode() {
        return this.semanticHashCode();
    }

    @Override
    @Nonnull
    public TableFunctionExpression translateCorrelations(@Nonnull TranslationMap translationMap, boolean shouldSimplifyValues, @Nonnull List<? extends Quantifier> translatedQuantifiers) {
        Verify.verify(translatedQuantifiers.isEmpty());
        if (translationMap.definesOnlyIdentities()) {
            return this;
        }
        Value translatedCollectionValue = this.value.translateCorrelations(translationMap, shouldSimplifyValues);
        if (translatedCollectionValue != this.value) {
            return new TableFunctionExpression((StreamingValue)translatedCollectionValue);
        }
        return this;
    }

    @Override
    @Nonnull
    public Iterable<MatchInfo> subsumedBy(@Nonnull RelationalExpression candidateExpression, @Nonnull AliasMap bindingAliasMap, @Nonnull IdentityBiMap<Quantifier, PartialMatch> partialMatchMap, @Nonnull EvaluationContext evaluationContext) {
        if (!this.isCompatiblyAndCompletelyBound(bindingAliasMap, candidateExpression.getQuantifiers())) {
            return ImmutableList.of();
        }
        return this.exactlySubsumedBy(candidateExpression, bindingAliasMap, partialMatchMap, TranslationMap.empty());
    }

    @Override
    @Nonnull
    public Compensation compensate(@Nonnull PartialMatch partialMatch, @Nonnull Map<CorrelationIdentifier, ComparisonRange> boundParameterPrefixMap, @Nullable PullUp pullUp, @Nonnull CorrelationIdentifier nestingAlias) {
        return Compensation.noCompensation();
    }

    @Override
    @Nonnull
    public PlannerGraph rewriteInternalPlannerGraph(@Nonnull List<? extends PlannerGraph> childGraphs) {
        return PlannerGraph.fromNodeAndChildGraphs(new PlannerGraph.LogicalOperatorNode(this, "TFunc", ImmutableList.of(this.toString()), ImmutableMap.of()), childGraphs);
    }

    public String toString() {
        return this.value.toString();
    }
}

